/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attperiod;

import java.util.Date;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtp.business.attperiod.PerAttPeriodDataService;

public class PerAttPeriodParamMsgConsumer
implements MessageConsumer {
    private static final Log LOG = LogFactory.getLog(PerAttPeriodParamMsgConsumer.class);

    public void onMessage(Object message, String messageId, boolean retryFlag, MessageAcker messageAcker) {
        boolean hasChange;
        Long orgId;
        LOG.info("PerAttPeriodParamMsgConsumer.onMessage message={}, messageId{}, retryFlag={}", new Object[]{message, messageId, retryFlag});
        try {
            Map map = (Map)message;
            String data = (String)map.get("data");
            Map sysParam = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            orgId = (Long)map.get("orgId");
            hasChange = this.judgeSysParamHasChange(sysParam, orgId);
            messageAcker.ack(messageId);
        }
        catch (Exception exp) {
            LOG.warn("PerAttPeriodParamMsgConsumer consumer error:", (Throwable)exp);
            messageAcker.deny(messageId);
            throw new KDBizException((Throwable)exp, new ErrorCode("PerAttPeriodParamMsgConsumer.onMessage error", "PerAttPeriodParamMsgConsumer.onMessage error"), new Object[0]);
        }
        if (hasChange && orgId != null) {
            LOG.info("PerAttPeriodParamMsgConsumer start syncPerAttPeriod, orgI{}", (Object)orgId);
            PerAttPeriodDataService.getInstance().processPerAttPeriodFromJobData();
        }
    }

    private boolean judgeSysParamHasChange(Map<String, Object> sysParam, Long orgId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_sysparamrecord");
        DynamicObject sysParamRecord = helper.loadDynamicObject(new QFilter[]{new QFilter("orgid", "=", (Object)orgId)});
        if (sysParamRecord == null) {
            sysParamRecord = helper.generateEmptyDynamicObject();
            sysParamRecord.set("orgid", (Object)orgId);
            sysParamRecord.set("data", (Object)SerializationUtils.toJsonString(sysParam));
            sysParamRecord.set("createtime", (Object)new Date());
            sysParamRecord.set("modifytime", (Object)new Date());
            helper.saveOne(sysParamRecord);
            return false;
        }
        String oldData = sysParamRecord.getString("data");
        Map oldSysParam = (Map)SerializationUtils.fromJsonString((String)oldData, Map.class);
        Object isCultNewValue = sysParam.get("iscult");
        Object belongNewValue = sysParam.get("belong");
        Object customDayNewValue = sysParam.get("customday");
        Object isCultOldValue = oldSysParam.get("iscult");
        Object belongOldValue = oldSysParam.get("belong");
        Object customDayOldValue = oldSysParam.get("customday");
        sysParamRecord.set("data", (Object)SerializationUtils.toJsonString(sysParam));
        sysParamRecord.set("modifytime", (Object)new Date());
        helper.updateDataOne(sysParamRecord);
        return !Objects.equals(isCultNewValue, isCultOldValue) || !Objects.equals(belongNewValue, belongOldValue) || !Objects.equals(customDayNewValue, customDayOldValue);
    }
}

