/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attperiod;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.task.common.WTCTaskBusinessStatusEnum;
import kd.wtc.wtbs.business.util.BaseDataUtils;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.Page;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtp.business.attconfirm.AttConfirmHelper;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmQueryServiceImpl;
import kd.wtc.wtp.business.attperiod.PerAttPeriodDataService;
import kd.wtc.wtp.business.attperiod.task.model.PerPeriodEntity;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmDataStatusEnum;
import kd.wtc.wtp.enums.attperiod.PeriodCutTypeEnum;

public class PeriodServiceHelper {
    private static final Log LOG = LogFactory.getLog(PeriodServiceHelper.class);

    public static PeriodServiceHelper getInstance() {
        return (PeriodServiceHelper)WTCAppContextHelper.getBean(PeriodServiceHelper.class);
    }

    public void savePerPeriodDynData(List<PerPeriodEntity> perPeriodEntityList, Map<PeriodCutTypeEnum, Set<Long>> periodCutTypeEnumSetMap) {
        PeriodServiceHelper instance = PeriodServiceHelper.getInstance();
        if (!CollectionUtils.isEmpty(perPeriodEntityList)) {
            instance.savePerPeriodData(perPeriodEntityList);
        }
        if (!CollectionUtils.isEmpty(periodCutTypeEnumSetMap)) {
            instance.savePeriodCutData(periodCutTypeEnumSetMap);
        }
    }

    private void savePeriodCutData(Map<PeriodCutTypeEnum, Set<Long>> periodCutTypeEnumSetMap) {
        for (Map.Entry<PeriodCutTypeEnum, Set<Long>> mapEntry : periodCutTypeEnumSetMap.entrySet()) {
            PeriodCutTypeEnum key = mapEntry.getKey();
            PerAttPeriodDataService.getInstance().saveAndDeleteCutData(mapEntry, key);
        }
    }

    public void savePerPeriodData(List<PerPeriodEntity> successDataList) {
        Set perPeriodIdSet = successDataList.stream().filter(d -> "0".equals(d.getBusinessStatus())).map(PerAttPeriod::getPrimaryId).collect(Collectors.toSet());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_perattperiod");
        DynamicObject[] perAttPeriodDys = helper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", perPeriodIdSet)});
        Map<Long, DynamicObject> perPeriodMap = Arrays.stream(perAttPeriodDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (a, b) -> a));
        DynamicObject[] perPeriodDyArray = (DynamicObject[])successDataList.stream().map(perPeriodEntity -> {
            Long primaryId = perPeriodEntity.getPrimaryId();
            DynamicObject perPeriodDy = (DynamicObject)perPeriodMap.get(primaryId);
            if (perPeriodDy != null) {
                if (perPeriodEntity.isUpdate()) {
                    perPeriodDy.set("firstnotstorage", (Object)perPeriodEntity.isFirstNotStorage());
                    perPeriodDy.set("laststorage", (Object)perPeriodEntity.isLastStorage());
                } else {
                    perPeriodDy.set("busistatus", (Object)perPeriodEntity.getBusinessStatus());
                }
            } else {
                perPeriodDy = helper.generateEmptyDynamicObject();
                perPeriodDy.set("attfileid", (Object)perPeriodEntity.getFileBoId());
                perPeriodDy.set("attfilevid", (Object)perPeriodEntity.getFileId());
                perPeriodDy.set("attperson", (Object)perPeriodEntity.getPersonId());
                perPeriodDy.set("periodentry", (Object)perPeriodEntity.getAttPeriodId());
                perPeriodDy.set("startdate", (Object)perPeriodEntity.getPerAttBeginDate());
                perPeriodDy.set("enddate", (Object)perPeriodEntity.getPerAttEndDate());
                perPeriodDy.set("totaldays", (Object)perPeriodEntity.getTotalDays());
                perPeriodDy.set("busistatus", (Object)perPeriodEntity.getBusinessStatus());
                perPeriodDy.set("firstnotstorage", (Object)perPeriodEntity.isFirstNotStorage());
                perPeriodDy.set("laststorage", (Object)perPeriodEntity.isLastStorage());
                perPeriodDy.set("number", (Object)perPeriodEntity.getNumber());
                perPeriodDy.set("period", (Object)perPeriodEntity.getPeriodId());
                perPeriodDy.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            }
            return perPeriodDy;
        }).toArray(DynamicObject[]::new);
        helper.save(perPeriodDyArray);
        Set invalidAttConfirmDataAttPerIdSet = Arrays.stream(perPeriodDyArray).filter(d -> d.getLong("id") != 0L && "0".equals(d.getString("busistatus"))).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        QFilter cusQFilter = new QFilter("type", "=", (Object)AttConRecordTypeEnum.BY_PERIOD.getCode()).and(new QFilter("perattperiod", "in", invalidAttConfirmDataAttPerIdSet)).and(new QFilter("datastatus", "=", (Object)AttConfirmDataStatusEnum.EFFECT.getCode()));
        List<Long> attConRecordIds = AttConfirmQueryServiceImpl.getInstance().updateDataStatusAttConfirmRecord(cusQFilter, AttConfirmDataStatusEnum.INVALID);
        AttConfirmHelper.getInstance().sendMessageWhenAttConRecordInvalidity(attConRecordIds, null);
    }

    public DynamicObject getPeriodSynTaskByTaskId(Object pkValue, String queryFields) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_periodsynresult");
        return helper.queryOriginalOne(queryFields, pkValue);
    }

    public Set<Long> getReRunFileVidByTaskId(Object taskId, Set<Long> attFileBoIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_periodtaskdetail");
        Set<Long> fileBoIdSet = attFileBoIds;
        if (CollectionUtils.isEmpty(attFileBoIds)) {
            DynamicObject[] taskDetailDys = helper.queryOriginalArray("attFileBoId", new QFilter[]{new QFilter("taskid", "=", taskId)});
            fileBoIdSet = Arrays.stream(taskDetailDys).map(taskDetailDy -> taskDetailDy.getLong("attFileBoId")).collect(Collectors.toSet());
        }
        AttFileF7QueryParam queryParam = new AttFileF7QueryParam();
        queryParam.setSetBoIds(fileBoIdSet);
        queryParam.setProperties("id");
        queryParam.setPermField("attfile");
        queryParam.setFormId("wtp_periodtaskdetail");
        queryParam.setAppId("wtp");
        Page attFileDys = AttFileQueryServiceImpl.getInstance().queryAttFileF7WithPerm(queryParam, 0, 1000000);
        return attFileDys.getListRecords().stream().map(fileDy -> fileDy.getLong("id")).collect(Collectors.toSet());
    }

    public void updatePeriodSynStatus(String category, Long bizTaskId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_periodsynresult");
        DynamicObject periodSynDy = serviceHelper.loadDynamicObject(new QFilter[]{new QFilter("periodsyntask", "=", (Object)bizTaskId)});
        if (periodSynDy != null) {
            WTCTaskBusinessStatusEnum wtcTaskBusinessStatusEnum = WTCTaskServiceHelper.getWTCTaskBusinessStatusEnumByTaskId((String)category, (long)bizTaskId);
            periodSynDy.set("synstatus", (Object)wtcTaskBusinessStatusEnum.getSign());
            serviceHelper.updateOne(periodSynDy);
        } else {
            LOG.info("PeriodServiceHelper.updatePeriodSynStatus err, periodSynDy not exist");
        }
    }

    public DynamicObject getPeriodSynTask(QFilter qFilter, String queryFields) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_periodsynresult");
        return helper.queryOriginalOne(queryFields, qFilter);
    }

    public void updatePeriodSynResultDate(Long taskId, Date startDate, Date endDate) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_periodsynresult");
        DynamicObject dy = helper.loadDynamicObject(new QFilter("periodsyntask", "=", (Object)taskId));
        if (dy != null) {
            dy.set("startdate", (Object)startDate);
            dy.set("enddate", (Object)endDate);
            helper.updateOne(dy);
        }
    }

    public List<Object> checkPerAttPeriodReferences(Object[] perAttPeriodIds, boolean isExists) {
        Map map = BaseDataUtils.existReferences((String)"wtp_perattperiod", (Object[])perAttPeriodIds);
        List<Object> list = map.entrySet().stream().filter(mapEntry -> ((BaseDataCheckRefrenceResult)mapEntry.getValue()).isRefence()).map(Map.Entry::getKey).collect(Collectors.toList());
        if (isExists) {
            return list;
        }
        return Arrays.stream(perAttPeriodIds).filter(id -> !list.contains(id)).collect(Collectors.toList());
    }

    public Object[] updatePerAttPeriodBuSiStatus(List<Long> boIdList) {
        if (CollectionUtils.isEmpty(boIdList)) {
            return new Object[0];
        }
        PerAttPeriodQueryParam req = new PerAttPeriodQueryParam();
        req.setProperties("id,busistatus,attfileid");
        HashSet<Long> boIdSet = new HashSet<Long>(boIdList);
        req.setAttFileBoIdSet(boIdSet);
        req.setBusiStatus("1");
        List tempPerAttPeriodList = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodDy(req);
        boIdSet.clear();
        tempPerAttPeriodList.stream().map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"id")).forEach(boIdSet::add);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_perattperiod");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", boIdSet)};
        DynamicObject[] perAttPeriodDys = helper.query(req.getProperties(), qFilters);
        List<DynamicObject> perAttPeriodList = Arrays.stream(perAttPeriodDys).collect(Collectors.toList());
        perAttPeriodList.forEach(file -> file.set("busistatus", (Object)"0"));
        Object[] update = helper.update(perAttPeriodList.toArray(new DynamicObject[0]));
        return update;
    }
}

