/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attperiod;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.monitor.log.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.task.enums.TaskCategoryEnum;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCOrgUnitServiceHelper;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtp.business.attfile.AttFileSyncService;
import kd.wtc.wtp.business.attperiod.PeriodServiceHelper;
import kd.wtc.wtp.business.attperiod.task.PeriodSyncTaskParamService;
import kd.wtc.wtp.constants.attperiod.PerAttPeriodKDString;

public class PeriodSyncFormService {
    private static final Map<String, String> FIELD_MAPPING = new HashMap<String, String>(4);

    public static PeriodSyncFormService getInstance() {
        return (PeriodSyncFormService)WTCAppContextHelper.getBean(PeriodSyncFormService.class);
    }

    public void periodTaskEndCloseBack(IPageCache pageCache, IFormView view, IFormPlugin plugin, boolean isList) {
        String errMsg = pageCache.get("errMsg");
        if (HRStringUtils.isNotEmpty((String)errMsg)) {
            view.showTipNotification(errMsg);
            return;
        }
        String taskIdStr = pageCache.get("taskId");
        if (HRStringUtils.isEmpty((String)taskIdStr)) {
            return;
        }
        long taskId = Long.parseLong(taskIdStr);
        HRBaseServiceHelper settleHRBaseServiceHelper = new HRBaseServiceHelper("wtp_periodtask");
        String[] taskStatusArr = new String[]{WTCTaskStatus.TERMINATED.code, WTCTaskStatus.ALL_FINISHED.code, WTCTaskStatus.PARTIALLY_FINISHED.code, WTCTaskStatus.ALL_ERROR.code};
        QFilter qFilter = new QFilter("taskstatus", "in", (Object)taskStatusArr);
        qFilter.and(new QFilter("id", "=", (Object)taskId));
        DynamicObject settleTaskDy = settleHRBaseServiceHelper.queryOne("id", new QFilter[]{qFilter});
        if (settleTaskDy != null) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("wtbs_taskresult");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack(plugin, "showdetailcallback"));
            formShowParameter.setCustomParam("taskId", (Object)taskId);
            formShowParameter.setCustomParam("category", (Object)"wtp_period");
            formShowParameter.setShowTitle(false);
            view.showForm(formShowParameter);
        } else if (isList) {
            ((IListView)view).refresh();
        } else {
            view.close();
        }
    }

    public void showViewPeriodByTaskId(Long taskId, String fieldName, IFormView view) {
        String queryFields = String.join((CharSequence)",", "periodsyntask.id", "periodsyntask.taskstatus", "number", "id");
        DynamicObject resultDy = PeriodServiceHelper.getInstance().getPeriodSynTask(new QFilter("periodsyntask", "=", (Object)taskId), queryFields);
        this.showTaskDetail(resultDy, fieldName, view);
    }

    public List<Long> checkPeriodSynFile(Set<Long> fileVidSet) {
        return fileVidSet == null ? new ArrayList<Long>() : new ArrayList<Long>(fileVidSet);
    }

    public void saveUnDoExistsFileVid(Set<Long> existsFileVIds) {
        this.savePeriodJobData(existsFileVIds, "6");
    }

    public void savePeriodJobData(Set<Long> fileBoIdSet, String type) {
        if (CollectionUtils.isEmpty(fileBoIdSet) || WTCStringUtils.isEmpty((String)type)) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_perattperiodjobdata");
        ArrayList dyList = Lists.newArrayListWithExpectedSize((int)fileBoIdSet.size());
        for (Long attFileBoId : fileBoIdSet) {
            DynamicObject dy = helper.generateEmptyDynamicObject();
            dy.set("type", (Object)type);
            dy.set("attfileid", (Object)attFileBoId);
            dyList.add(dy);
        }
        helper.save(dyList.toArray(new DynamicObject[0]));
    }

    public void removeFileBoIdInRedis(List<Long> fileBoIdList) {
        AttFileSyncService.getInstance().unLockFileBoIds(new HashSet<Long>(fileBoIdList));
    }

    public boolean reRunAndStopValidate(Object taskId, IFormView view, List<String> statusList, String statusTips, boolean checkOpUser) {
        DynamicObject taskDy = PeriodServiceHelper.getInstance().getPeriodSynTaskByTaskId(taskId, String.join((CharSequence)",", "periodsyntask.taskstatus", "periodsyntask.creator.id"));
        if (taskDy != null) {
            String taskStatus = taskDy.getString("periodsyntask.taskstatus");
            if (!statusList.contains(taskStatus)) {
                view.showErrorNotification(statusTips);
                return true;
            }
            long creatorId = taskDy.getLong("periodsyntask.creator.id");
            if (checkOpUser && UserServiceHelper.getCurrentUserId() != creatorId) {
                view.showErrorNotification(PerAttPeriodKDString.onlyReRunYouHaveCreatedTips());
                return true;
            }
        } else {
            throw new KDException(PerAttPeriodKDString.taskNotCreate());
        }
        return false;
    }

    public void showTaskDetail(DynamicObject resultDy, String fieldName, IFormView view) {
        long taskId = resultDy.getLong("periodsyntask.id");
        if (HRObjectUtils.isEmpty((Object)taskId) || taskId == 0L) {
            view.showTipNotification(PerAttPeriodKDString.taskNotCreate(), Integer.valueOf(3000));
            return;
        }
        String status = resultDy.getString("periodsyntask.taskstatus");
        if (HRStringUtils.equalsIgnoreCase((String)WTCTaskStatus.NEW.getCode(), (String)status) || HRStringUtils.equalsIgnoreCase((String)WTCTaskStatus.RUNNING.getCode(), (String)status) || HRStringUtils.equalsIgnoreCase((String)WTCTaskStatus.TERMINATING.getCode(), (String)status)) {
            view.showTipNotification(PerAttPeriodKDString.taskNotFinish(), Integer.valueOf(3000));
            return;
        }
        String number = resultDy.getString("number");
        String caption = PerAttPeriodKDString.taskViewCaption() + number;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setAppId("wtam");
        parameter.setPageId(view.getPageId() + "wtp_periodtask" + taskId);
        parameter.setCaption(caption);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("wtp_periodsyndetail");
        parameter.setCustomParam("tabKey", (Object)FIELD_MAPPING.get(fieldName));
        parameter.setCustomParam("id", (Object)resultDy.getLong("id"));
        parameter.setCustomParam("task", (Object)taskId);
        view.showForm(parameter);
    }

    public void runPeriodSynTaskBackground(Set<Long> attFileBoIdSet, String description) {
        if (CollectionUtils.isEmpty(attFileBoIdSet)) {
            return;
        }
        WTCTaskForm wtcTaskForm = PeriodSyncTaskParamService.getInstance().genWTCTaskForm(attFileBoIdSet, null, null, description, WTCOrgUnitServiceHelper.getHRDefaultRootOrgId(), null);
        Map customParams = wtcTaskForm.getCustomParams();
        customParams.put("fromJob", true);
        WTCDistributeTaskHelper.runTaskBackground((String)TaskCategoryEnum.WTP_PERIOD.getCode(), (Object)wtcTaskForm);
    }

    public void deleteDiscardJobData() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_perattperiodjobdata");
        Set fileBoIsSet = Arrays.stream(helper.query("id,attfileid", new QFilter[]{new QFilter("attfileid", "!=", (Object)0L)})).map(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"attfileid")).collect(Collectors.toSet());
        if (WTCCollections.isNotEmpty(fileBoIsSet)) {
            AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
            attFileQueryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"-1"}));
            attFileQueryParam.setBeCurrent(Boolean.TRUE);
            attFileQueryParam.setProperties("boid");
            attFileQueryParam.setSetBoIds(fileBoIsSet);
            Set discardFileIdSet = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().map(d -> d.getLong("boid")).collect(Collectors.toSet());
            if (WTCCollections.isNotEmpty(discardFileIdSet)) {
                helper.deleteByFilter(new QFilter[]{new QFilter("attfileid", "in", discardFileIdSet)});
            }
        }
    }

    static {
        FIELD_MAPPING.put("number", "runtab");
        FIELD_MAPPING.put("periodsyntask_runattperson", "runtab");
        FIELD_MAPPING.put("periodsyntask_succeedattperson", "successtab");
        FIELD_MAPPING.put("periodsyntask_failedattperson", "failtab");
        FIELD_MAPPING.put("periodsyntask_notrunattperson", "noruntab");
    }
}

