/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attperiod.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.wtp.model.perattperiod.PerAttPeriodSysParamVo;
import kd.wtc.wtp.business.attperiod.perperiod.model.AttFileVersionEntity;
import kd.wtc.wtp.business.attperiod.perperiod.model.PerPeriodGenPreEntity;
import kd.wtc.wtp.business.attperiod.perperiod.model.PeriodEntryEntity;
import kd.wtc.wtp.business.attperiod.perperiod.model.PeriodFileSchEntity;
import kd.wtc.wtp.business.attperiod.perperiod.model.TimeSeqPartitionEntity;
import kd.wtc.wtp.business.attperiod.perperiod.model.TimeSeqPointEntity;
import kd.wtc.wtp.business.attperiod.task.model.PerPeriodEntity;
import kd.wtc.wtp.business.attperiod.task.model.PeriodSubTaskDataEntity;
import kd.wtc.wtp.business.attperiod.task.model.PeriodTaskDetail;
import kd.wtc.wtp.common.enums.AttFileTaskCacheInfoEnum;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;
import kd.wtc.wtp.constants.attperiod.PerAttPeriodKDString;
import kd.wtc.wtp.enums.attperiod.PeriodCutTypeEnum;
import kd.wtc.wtp.enums.attperiod.PeriodTimePointTypeEnum;

public class PerAttPeriodGenService {
    private static final Log LOGGER = LogFactory.getLog(PerAttPeriodGenService.class);
    private static final String SET_STORAGE = "setStorage";

    public static PerAttPeriodGenService getInstance() {
        return (PerAttPeriodGenService)WTCAppContextHelper.getBean(PerAttPeriodGenService.class);
    }

    public void taskSynPerAttPeriod(PeriodSubTaskDataEntity periodSubTaskDataEntity, PeriodTaskDetail periodTaskDetail) {
        long fileBoId = periodTaskDetail.getAttFileBoId();
        List<PerPeriodEntity> perPeriodEntityList = periodSubTaskDataEntity.getPerPeriodEntityList();
        Map<PeriodCutTypeEnum, Set<Long>> periodCutTypeEnumSetMap = periodSubTaskDataEntity.getPeriodCutTypeEnumSetMap();
        PerPeriodGenPreEntity perPeriodGenPreEntity = periodSubTaskDataEntity.getPerPeriodGenPreEntity();
        this.synPerAttPeriod(periodTaskDetail, periodTaskDetail.getAttPersonId(), fileBoId, perPeriodEntityList, periodCutTypeEnumSetMap, perPeriodGenPreEntity);
    }

    public void synPerAttPeriod(long personId, long fileBoId, List<PerPeriodEntity> perPeriodEntityList, Map<PeriodCutTypeEnum, Set<Long>> periodCutTypeEnumSetMap, PerPeriodGenPreEntity perPeriodGenPreEntity) {
        this.synPerAttPeriod(null, personId, fileBoId, perPeriodEntityList, periodCutTypeEnumSetMap, perPeriodGenPreEntity);
    }

    public void synPerAttPeriod(long personId, long fileBoId, List<PerPeriodEntity> perPeriodEntityList, Map<PeriodCutTypeEnum, Set<Long>> periodCutTypeEnumSetMap, PerPeriodGenPreEntity perPeriodGenPreEntity, Map<Long, AttStateInfoBO> attStateInfoMap) {
        if (WTCCollections.isNotEmpty(attStateInfoMap)) {
            perPeriodGenPreEntity.setAttStateInfoMap(attStateInfoMap);
        }
        this.synPerAttPeriod(null, personId, fileBoId, perPeriodEntityList, periodCutTypeEnumSetMap, perPeriodGenPreEntity);
    }

    private void synPerAttPeriod(PeriodTaskDetail periodTaskDetail, long personId, long fileBoId, List<PerPeriodEntity> perPeriodResultList, Map<PeriodCutTypeEnum, Set<Long>> periodCutTypeEnumSetMap, PerPeriodGenPreEntity perPeriodGenPreEntity) {
        String code;
        if (WTCCollections.isNotEmpty(perPeriodGenPreEntity.getExistsAttFileMap()) && HRStringUtils.isNotEmpty((String)(code = perPeriodGenPreEntity.getExistsAttFileMap().get(fileBoId))) && periodTaskDetail != null) {
            periodTaskDetail.setTaskDetailState(WTCTaskDetailStatus.FAIL);
            AttFileTaskCacheInfoEnum infoEnum = AttFileTaskCacheInfoEnum.valueOf((String)code);
            periodTaskDetail.setExInfo(infoEnum.getMsg().loadKDString());
            return;
        }
        Map<Long, AttStateInfoBO> attStateInfoMap = perPeriodGenPreEntity.getAttStateInfoMap();
        AttStateInfoBO attStateInfoBO = attStateInfoMap.get(fileBoId);
        if (attStateInfoBO == null) {
            if (periodTaskDetail != null) {
                periodTaskDetail.setTaskDetailState(WTCTaskDetailStatus.FAIL);
                periodTaskDetail.setExInfo(ResManager.loadKDString((String)"\u6838\u7b97\u4fe1\u606f\u4e0d\u5b8c\u6574\u3002", (String)"PerAttPeriodGenService_3", (String)"wtc-wtp-business", (Object[])new Object[0]));
            }
            LOGGER.info("synPerAttPeriod attStateInfoBO is null");
            return;
        }
        List<TimeSeqPointEntity<PeriodTimePointTypeEnum>> timeSeqPointResultData = this.genPeriodTimeSeqPoint(fileBoId, perPeriodGenPreEntity);
        ArrayList perPeriodSubList = Lists.newArrayListWithExpectedSize((int)timeSeqPointResultData.size());
        this.periodTimePointTransToPerPeriodEntity(personId, fileBoId, perPeriodSubList, periodCutTypeEnumSetMap, timeSeqPointResultData, perPeriodGenPreEntity);
        Set<Long> hasPerFileId = perPeriodGenPreEntity.getHasPerFileId();
        Date lockTo = attStateInfoBO.getLockTo();
        Map<String, PerPeriodEntity> existPeriodEntryMap = perPeriodGenPreEntity.getExistPeriodEntryListMap().get(fileBoId);
        ArrayList<PerPeriodEntity> allhandleDataList = new ArrayList<PerPeriodEntity>();
        if (WTCCollections.isNotEmpty(existPeriodEntryMap) && WTCCollections.isNotEmpty(existPeriodEntryMap.values())) {
            allhandleDataList.addAll(existPeriodEntryMap.values());
        }
        ArrayList<PerPeriodEntity> handleData = new ArrayList<PerPeriodEntity>();
        Date endDate = null;
        for (PerPeriodEntity perPeriodEntity : perPeriodSubList) {
            if (endDate != null && endDate.compareTo(WTCDateUtils.addDays((Date)perPeriodEntity.getPerAttBeginDate(), (int)-1)) != 0) break;
            handleData.add(perPeriodEntity);
            endDate = perPeriodEntity.getPerAttEndDate();
        }
        perPeriodSubList.clear();
        this.handleStorageData(handleData, attStateInfoBO);
        boolean hasNotAuth = false;
        boolean hasFail = false;
        int perPeriodEntitySizeTotal = handleData.size();
        String attPeriodName = "";
        boolean ignoreCheck = perPeriodGenPreEntity.isIgnoreCheck();
        for (PerPeriodEntity perPeriodEntity : handleData) {
            PerPeriodEntity existPerPeriodEntity;
            Long fileId = perPeriodEntity.getFileId();
            String uniqueKey = this.getLockUniqueKey(perPeriodEntity);
            if (existPeriodEntryMap != null && (existPerPeriodEntity = existPeriodEntryMap.get(uniqueKey)) != null) {
                boolean lastStorage = perPeriodEntity.isLastStorage();
                boolean firstNotStorage = perPeriodEntity.isFirstNotStorage();
                boolean existLastStorage = existPerPeriodEntity.isLastStorage();
                boolean existFirstNotStorage = existPerPeriodEntity.isFirstNotStorage();
                if (lastStorage != existLastStorage || firstNotStorage != existFirstNotStorage) {
                    existPerPeriodEntity.setUpdate(true);
                    existPerPeriodEntity.setFirstNotStorage(firstNotStorage);
                    existPerPeriodEntity.setLastStorage(lastStorage);
                    continue;
                }
                existPeriodEntryMap.remove(uniqueKey);
                continue;
            }
            if (!ignoreCheck) {
                boolean contains;
                if (hasPerFileId != null && !hasPerFileId.contains(fileId)) {
                    hasNotAuth = true;
                    break;
                }
                boolean bl = contains = lockTo != null && perPeriodEntity.getPerAttBeginDate().compareTo(lockTo) <= 0 && perPeriodEntity.getPerAttEndDate().compareTo(lockTo) >= 0;
                if (contains) {
                    hasFail = true;
                    Map<Long, String> periodEntryNameMap = perPeriodGenPreEntity.getPeriodEntryNameMap();
                    if (CollectionUtils.isEmpty(periodEntryNameMap)) break;
                    attPeriodName = periodEntryNameMap.get(perPeriodEntity.getAttPeriodId());
                    break;
                }
            }
            perPeriodSubList.add(perPeriodEntity);
        }
        handleData.clear();
        this.handlePeriodTaskDetail(perPeriodEntitySizeTotal, periodTaskDetail, perPeriodSubList, existPeriodEntryMap, hasNotAuth, hasFail, attPeriodName);
        String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"wtp_perattperiod", (DynamicObject)new HRBaseServiceHelper("wtp_perattperiod").generateEmptyDynamicObject(), null, (int)perPeriodSubList.size());
        if (batchNumber == null || batchNumber.length == 0 && !perPeriodSubList.isEmpty()) {
            if (periodTaskDetail != null) {
                periodTaskDetail.setTaskDetailState(WTCTaskDetailStatus.FAIL);
                periodTaskDetail.setExInfo(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6b63\u786e\u7684\u7f16\u7801\u89c4\u5219\u3002", (String)"PerAttPeriodGenService_0", (String)"wtc-wtp-business", (Object[])new Object[0]));
            }
            perPeriodSubList.clear();
            if (existPeriodEntryMap != null) {
                existPeriodEntryMap.clear();
            }
            return;
        }
        for (int i = 0; i < perPeriodSubList.size(); ++i) {
            ((PerPeriodEntity)perPeriodSubList.get(i)).setNumber(batchNumber[i]);
        }
        this.addUpdateExistPerAttPeriod(perPeriodSubList, existPeriodEntryMap);
        if (!perPeriodSubList.isEmpty()) {
            perPeriodResultList.addAll(perPeriodSubList);
            Set<Long> cutSet = periodCutTypeEnumSetMap.get(PeriodCutTypeEnum.CUT);
            if (!cutSet.contains(fileBoId)) {
                periodCutTypeEnumSetMap.get(PeriodCutTypeEnum.NOT_CUT).add(fileBoId);
            }
        } else {
            periodCutTypeEnumSetMap.get(PeriodCutTypeEnum.CUT).remove(fileBoId);
        }
        if (null == periodTaskDetail) {
            return;
        }
        if (WTCCollections.isNotEmpty((Collection)perPeriodSubList)) {
            allhandleDataList.addAll(perPeriodSubList);
        }
        this.checkDepEmpJob(periodTaskDetail, perPeriodGenPreEntity, allhandleDataList);
    }

    private void checkDepEmpJob(PeriodTaskDetail periodTaskDetail, PerPeriodGenPreEntity perPeriodGenPreEntity, List<PerPeriodEntity> perPeriodSubList) {
        if (!WTCTaskDetailStatus.SUCCESS.equals((Object)periodTaskDetail.getTaskDetailState())) {
            return;
        }
        Map<Long, List<AttFileVersionEntity>> attFileVersionMap = perPeriodGenPreEntity.getAttFileVersionMap();
        Long attFileBoId = periodTaskDetail.getAttFileBoId();
        List<AttFileVersionEntity> attFileVersionEntities = attFileVersionMap.get(attFileBoId);
        for (PerPeriodEntity periodEntity : perPeriodSubList) {
            Long fVid = periodEntity.getFileId();
            for (AttFileVersionEntity attFileVersionEntity : attFileVersionEntities) {
                if (!fVid.equals(attFileVersionEntity.getId()) || !"-1".equals(attFileVersionEntity.getDataStatus())) continue;
                periodTaskDetail.setExInfo(PerAttPeriodKDString.empDeletedTips());
                LOGGER.info("synPerAttPeriod wtpDepEmpJob tips");
            }
        }
    }

    public void handleStorageData(List<? extends PerAttPeriod> perPeriodEntityList, AttStateInfoBO attStateInfoBO) {
        Date storageTo = attStateInfoBO.getStorageTo();
        Date allowReAccountTime = attStateInfoBO.getAllowReaccountTime();
        HashMap hasSetStorage = Maps.newHashMap();
        hasSetStorage.put(SET_STORAGE, Boolean.FALSE);
        for (int i = 0; i < perPeriodEntityList.size() && !Boolean.TRUE.equals(hasSetStorage.get(SET_STORAGE)); ++i) {
            PerAttPeriod perPeriodEntity = perPeriodEntityList.get(i);
            this.setStorageEarliestAndLast(storageTo, perPeriodEntityList, i, perPeriodEntity, hasSetStorage, allowReAccountTime);
        }
    }

    private void addUpdateExistPerAttPeriod(List<PerPeriodEntity> perPeriodEntityList, Map<String, PerPeriodEntity> existPeriodEntryMap) {
        if (existPeriodEntryMap != null) {
            for (PerPeriodEntity value : existPeriodEntryMap.values()) {
                value.setBusinessStatus("0");
                perPeriodEntityList.add(value);
            }
        }
    }

    private void setStorageEarliestAndLast(Date storageDate, List<? extends PerAttPeriod> perPeriodEntityList, int index, PerAttPeriod perPeriodEntity, Map<String, Boolean> setStorageAttPeriod, Date reAccountDate) {
        Date perAttBeginDate = perPeriodEntity.getPerAttBeginDate();
        Date perAttEndDate = perPeriodEntity.getPerAttEndDate();
        if (storageDate == null) {
            if (index == 0) {
                this.storagePeriodCoreHandler(perPeriodEntityList, index, perPeriodEntity, reAccountDate, setStorageAttPeriod);
            }
            return;
        }
        if (index == 0 && perAttBeginDate.compareTo(storageDate) > 0) {
            this.storagePeriodCoreHandler(perPeriodEntityList, index, perPeriodEntity, reAccountDate, setStorageAttPeriod);
            return;
        }
        if (perAttBeginDate.compareTo(storageDate) <= 0) {
            if (perAttEndDate.compareTo(storageDate) > 0) {
                this.storagePeriodCoreHandler(perPeriodEntityList, index, perPeriodEntity, reAccountDate, setStorageAttPeriod);
                return;
            }
            if (perAttEndDate.compareTo(storageDate) == 0 && index < perPeriodEntityList.size() - 1) {
                PerAttPeriod nextReport = perPeriodEntityList.get(index + 1);
                this.storagePeriodCoreHandler(perPeriodEntityList, index + 1, nextReport, reAccountDate, setStorageAttPeriod);
                return;
            }
        }
        if (index == perPeriodEntityList.size() - 1 && perAttEndDate.compareTo(storageDate) <= 0) {
            perPeriodEntity.setLastStorage(true);
        }
    }

    private void storagePeriodCoreHandler(List<? extends PerAttPeriod> perPeriodEntityList, int index, PerAttPeriod perPeriodEntity, Date reAccountDate, Map<String, Boolean> setStorageAttPeriod) {
        Date perAttEndDate = perPeriodEntity.getPerAttEndDate();
        if (reAccountDate.after(perAttEndDate)) {
            Integer otherIndex = null;
            for (int i = 0; i < perPeriodEntityList.size(); ++i) {
                PerAttPeriod other = perPeriodEntityList.get(i);
                if (other.getPerAttBeginDate().compareTo(reAccountDate) > 0 || other.getPerAttEndDate().compareTo(reAccountDate) < 0) continue;
                otherIndex = i;
            }
            if (otherIndex != null) {
                if (otherIndex != index) {
                    PerAttPeriod perAttPeriodReport = perPeriodEntityList.get(otherIndex);
                    perAttPeriodReport.setFirstNotStorage(true);
                } else {
                    this.originalStoragePeriodSet(perPeriodEntityList, index, perPeriodEntity);
                }
            } else {
                this.originalStoragePeriodSet(perPeriodEntityList, index, perPeriodEntity);
            }
        } else {
            this.originalStoragePeriodSet(perPeriodEntityList, index, perPeriodEntity);
        }
        setStorageAttPeriod.put(SET_STORAGE, Boolean.TRUE);
    }

    private void originalStoragePeriodSet(List<? extends PerAttPeriod> perPeriodEntityList, int index, PerAttPeriod perPeriodEntity) {
        perPeriodEntity.setFirstNotStorage(true);
        if (index >= 1) {
            PerAttPeriod perReport = perPeriodEntityList.get(index - 1);
            perReport.setLastStorage(true);
        }
    }

    private void handlePeriodTaskDetail(int perPeriodEntitySizeTotal, PeriodTaskDetail periodTaskDetail, List<PerPeriodEntity> perPeriodEntityList, Map<String, PerPeriodEntity> existPeriodEntryMap, boolean hasNotAuth, boolean hasFail, String attPeriodName) {
        if (hasFail || hasNotAuth) {
            perPeriodEntityList.clear();
            if (existPeriodEntryMap != null) {
                existPeriodEntryMap.clear();
            }
        }
        if (periodTaskDetail == null) {
            return;
        }
        periodTaskDetail.setPerAttPeriodTotal(perPeriodEntitySizeTotal);
        periodTaskDetail.setPerAttPeriodNotExecute(0L);
        periodTaskDetail.setPerAttPeriodSuccess(0L);
        periodTaskDetail.setPerAttPeriodFail(0L);
        if (hasFail) {
            periodTaskDetail.setTaskDetailState(WTCTaskDetailStatus.FAIL);
            periodTaskDetail.setExInfo(ResManager.loadKDString((String)"\u671f\u95f4%s\u5df2\u9501\u5b9a\u3002", (String)"PerAttPeriodGenService_1", (String)"wtc-wtp-business", (Object[])new Object[]{attPeriodName}));
            periodTaskDetail.setPerAttPeriodFail(perPeriodEntitySizeTotal);
            if (existPeriodEntryMap != null) {
                existPeriodEntryMap.clear();
            }
        } else if (hasNotAuth) {
            periodTaskDetail.setTaskDetailState(WTCTaskDetailStatus.NOT_ACCOUNT);
            periodTaskDetail.setExInfo(ResManager.loadKDString((String)"\u65e0\u8be5\u4eba\u5458\u8003\u52e4\u671f\u95f4\u7684\u7ba1\u7406\u6743\u9650\u3002", (String)"PerAttPeriodGenService_2", (String)"wtc-wtp-business", (Object[])new Object[0]));
            periodTaskDetail.setPerAttPeriodNotExecute(perPeriodEntitySizeTotal);
            if (existPeriodEntryMap != null) {
                existPeriodEntryMap.clear();
            }
        } else {
            periodTaskDetail.setTaskDetailState(WTCTaskDetailStatus.SUCCESS);
            periodTaskDetail.setPerAttPeriodTotal(perPeriodEntitySizeTotal);
            periodTaskDetail.setPerAttPeriodSuccess(perPeriodEntityList.size());
            periodTaskDetail.setPerAttPeriodNotExecute(perPeriodEntitySizeTotal - perPeriodEntityList.size());
        }
    }

    private List<TimeSeqPointEntity<PeriodTimePointTypeEnum>> genPeriodTimeSeqPoint(long fileBoId, PerPeriodGenPreEntity perPeriodGenPreEntity) {
        int i;
        List<AttFileVersionEntity> attFileVersionEntities = perPeriodGenPreEntity.getAttFileVersionMap().get(fileBoId);
        List<PeriodFileSchEntity> periodFileSchEntities = perPeriodGenPreEntity.getPeriodFileSchListMap().get(fileBoId);
        Map<Long, List<PeriodEntryEntity>> periodEntryListMap = perPeriodGenPreEntity.getPeriodEntryListMap();
        if (CollectionUtils.isEmpty(attFileVersionEntities) || CollectionUtils.isEmpty(periodFileSchEntities) || CollectionUtils.isEmpty(periodEntryListMap)) {
            return Collections.emptyList();
        }
        ArrayList timeSeqPointResultData = Lists.newArrayListWithExpectedSize((int)attFileVersionEntities.size());
        TimeSeqPointEntity<PeriodTimePointTypeEnum> lastFileTimeSeqPointEntity = null;
        Date maxEndDate = WTCHisServiceHelper.getMaxEndDate();
        Date fileMaxEndDate = null;
        for (i = 0; i < attFileVersionEntities.size(); ++i) {
            AttFileVersionEntity attFileVersionEntity = attFileVersionEntities.get(i);
            if (attFileVersionEntity == null) continue;
            this.addTimePoint(timeSeqPointResultData, attFileVersionEntity, true, PeriodTimePointTypeEnum.FILE);
            if (i == attFileVersionEntities.size() - 1 && attFileVersionEntity.getEndDate().before(maxEndDate)) {
                lastFileTimeSeqPointEntity = new TimeSeqPointEntity<PeriodTimePointTypeEnum>(attFileVersionEntity.getId(), attFileVersionEntity.getHigherLevelId(), attFileVersionEntity.getEndDate(), false);
                lastFileTimeSeqPointEntity.setTimePointType(PeriodTimePointTypeEnum.FILE);
                fileMaxEndDate = attFileVersionEntity.getEndDate();
                continue;
            }
            this.addTimePoint(timeSeqPointResultData, attFileVersionEntity, false, PeriodTimePointTypeEnum.FILE);
        }
        for (i = 0; i < periodFileSchEntities.size(); ++i) {
            PeriodFileSchEntity nextPeriodFileSchEntity;
            PeriodFileSchEntity periodFileSchEntity = periodFileSchEntities.get(i);
            Date fileSchStartDate = periodFileSchEntity.getStartDate();
            Date fileSchEndDate = periodFileSchEntity.getEndDate();
            Long periodId = periodFileSchEntity.getPeriodId();
            if (i < periodFileSchEntities.size() - 1 && (nextPeriodFileSchEntity = periodFileSchEntities.get(i + 1)) != null && nextPeriodFileSchEntity.getPeriodId().equals(periodId)) {
                periodFileSchEntity.setEqNext(true);
            }
            boolean fileBtSch = fileMaxEndDate != null && fileSchStartDate != null && fileSchEndDate != null && fileMaxEndDate.compareTo(fileSchStartDate) >= 0 && fileMaxEndDate.compareTo(fileSchEndDate) <= 0;
            List<PeriodEntryEntity> periodEntryEntities = periodEntryListMap.get(periodFileSchEntity.getId());
            if (CollectionUtils.isEmpty(periodEntryEntities)) {
                return Collections.emptyList();
            }
            for (PeriodEntryEntity periodEntryEntity : periodEntryEntities) {
                Date periodEntryEntityStartDate = periodEntryEntity.getStartDate();
                Date periodEntryEntityEndDate = periodEntryEntity.getEndDate();
                if (periodEntryEntityStartDate == null || periodEntryEntityEndDate == null) continue;
                if (periodEntryEntityStartDate.compareTo(fileSchStartDate) >= 0 && periodEntryEntityStartDate.compareTo(fileSchEndDate) <= 0) {
                    this.addTimePoint(timeSeqPointResultData, periodEntryEntity, true, PeriodTimePointTypeEnum.PERIOD_ENTRY);
                }
                if (periodEntryEntityEndDate.compareTo(fileSchStartDate) >= 0 && periodEntryEntityEndDate.compareTo(fileSchEndDate) <= 0) {
                    this.addTimePoint(timeSeqPointResultData, periodEntryEntity, false, PeriodTimePointTypeEnum.PERIOD_ENTRY);
                }
                if (fileSchStartDate.compareTo(periodEntryEntityStartDate) >= 0 && fileSchStartDate.compareTo(periodEntryEntityEndDate) <= 0) {
                    periodFileSchEntity.setStartPeriodEntryId(periodEntryEntity.getId());
                }
                if (fileSchEndDate.compareTo(periodEntryEntityStartDate) >= 0 && fileSchEndDate.compareTo(periodEntryEntityEndDate) <= 0) {
                    periodFileSchEntity.setEndPeriodEntryId(periodEntryEntity.getId());
                }
                if (fileMaxEndDate == null || !fileBtSch || fileMaxEndDate.compareTo(periodEntryEntityStartDate) < 0 || fileMaxEndDate.compareTo(periodEntryEntityEndDate) > 0 || lastFileTimeSeqPointEntity == null) continue;
                lastFileTimeSeqPointEntity.setLowerLevelId(periodEntryEntity.getId());
            }
            this.addTimePoint(timeSeqPointResultData, periodFileSchEntity, true, PeriodTimePointTypeEnum.FILE_SCH);
            this.addTimePoint(timeSeqPointResultData, periodFileSchEntity, false, PeriodTimePointTypeEnum.FILE_SCH);
        }
        if (lastFileTimeSeqPointEntity != null) {
            timeSeqPointResultData.add(lastFileTimeSeqPointEntity);
        }
        return timeSeqPointResultData;
    }

    private void periodTimePointTransToPerPeriodEntity(long personId, long fileBoId, List<PerPeriodEntity> perPeriodSubList, Map<PeriodCutTypeEnum, Set<Long>> periodCutTypeEnumSetMap, List<TimeSeqPointEntity<PeriodTimePointTypeEnum>> timeSeqPointResultData, PerPeriodGenPreEntity perPeriodGenPreEntity) {
        Date fileEnd = null;
        List<AttFileVersionEntity> attFileVersionEntities = perPeriodGenPreEntity.getAttFileVersionMap().get(fileBoId);
        if (!CollectionUtils.isEmpty(attFileVersionEntities)) {
            Comparator<TimeSeqPartitionEntity> reversed = Comparator.comparing(TimeSeqPartitionEntity::getEndDate).reversed();
            Optional<TimeSeqPartitionEntity> first = attFileVersionEntities.stream().sorted(reversed).findFirst();
            if (first.isPresent()) {
                fileEnd = ((AttFileVersionEntity)first.get()).getEndDate();
            }
        }
        PerAttPeriodSysParamVo perAttPeriodSysParams = perPeriodGenPreEntity.getPerAttPeriodSysParams();
        TimeSeqPointEntity<PeriodTimePointTypeEnum> currentFileStartPoint = null;
        TimeSeqPointEntity<PeriodTimePointTypeEnum> currentFileSchStartPoint = null;
        PerPeriodEntity perPeriodEntity = new PerPeriodEntity();
        Comparator<TimeSeqPointEntity> comparingTimeSeqPoint = Comparator.comparing(TimeSeqPointEntity::getDatePoint);
        Comparator<TimeSeqPointEntity> comparingStart = Comparator.comparing(d -> !d.isStart());
        Comparator<TimeSeqPointEntity> timeSeqPointEntityComparator = comparingTimeSeqPoint.thenComparing(comparingStart).thenComparing(TimeSeqPointEntity::getTimePointType);
        timeSeqPointResultData.sort(timeSeqPointEntityComparator);
        for (TimeSeqPointEntity<PeriodTimePointTypeEnum> timeSeqPointEntity : timeSeqPointResultData) {
            PeriodTimePointTypeEnum timePointType = timeSeqPointEntity.getTimePointType();
            if (fileEnd != null && timeSeqPointEntity.getDatePoint().after(fileEnd)) {
                return;
            }
            if (PeriodTimePointTypeEnum.FILE == timePointType) {
                if (timeSeqPointEntity.isStart()) {
                    currentFileStartPoint = timeSeqPointEntity;
                    if (perPeriodEntity.getPerAttBeginDate() != null) continue;
                    this.setPerAttPeriodBeginDate(perPeriodEntity, timeSeqPointEntity);
                    continue;
                }
                if (fileEnd != null && timeSeqPointEntity.getDatePoint().compareTo(fileEnd) == 0) {
                    if (currentFileSchStartPoint == null) continue;
                    currentFileSchStartPoint.setDatePoint(timeSeqPointEntity.getDatePoint());
                    currentFileSchStartPoint.setLowerLevelId(timeSeqPointEntity.getLowerLevelId());
                    perPeriodEntity = this.addPerPeriodResult(personId, perPeriodSubList, periodCutTypeEnumSetMap, perPeriodEntity, currentFileSchStartPoint, currentFileStartPoint, perAttPeriodSysParams, fileBoId);
                    continue;
                }
                perPeriodEntity.setFileTimeSeqPoint(timeSeqPointEntity);
                continue;
            }
            if (PeriodTimePointTypeEnum.FILE_SCH == timePointType) {
                if (timeSeqPointEntity.isStart()) {
                    if (currentFileSchStartPoint == null) {
                        currentFileSchStartPoint = timeSeqPointEntity;
                        if (perPeriodEntity.getPerAttBeginDate() != null && PeriodTimePointTypeEnum.FILE != perPeriodEntity.getStartTimeResourceEnum()) continue;
                        this.setPerAttPeriodBeginDate(perPeriodEntity, timeSeqPointEntity);
                        continue;
                    }
                    if (currentFileSchStartPoint.getDataId().equals(timeSeqPointEntity.getDataId())) continue;
                    currentFileSchStartPoint = timeSeqPointEntity;
                    if (perPeriodEntity.getPerAttBeginDate() != null && PeriodTimePointTypeEnum.FILE != perPeriodEntity.getStartTimeResourceEnum()) continue;
                    this.setPerAttPeriodBeginDate(perPeriodEntity, timeSeqPointEntity);
                    continue;
                }
                if (timeSeqPointEntity.isEqNext() || perPeriodEntity.getPerAttEndDate() != null) continue;
                perPeriodEntity = this.addPerPeriodResult(personId, perPeriodSubList, periodCutTypeEnumSetMap, perPeriodEntity, timeSeqPointEntity, currentFileStartPoint, perAttPeriodSysParams, fileBoId);
                continue;
            }
            if (PeriodTimePointTypeEnum.PERIOD_ENTRY != timePointType) continue;
            if (timeSeqPointEntity.isStart()) {
                this.setPerAttPeriodBeginDate(perPeriodEntity, timeSeqPointEntity);
                continue;
            }
            perPeriodEntity = this.addPerPeriodResult(personId, perPeriodSubList, periodCutTypeEnumSetMap, perPeriodEntity, timeSeqPointEntity, currentFileStartPoint, perAttPeriodSysParams, fileBoId);
        }
    }

    private void setPerAttPeriodBeginDate(PerPeriodEntity perPeriodEntity, TimeSeqPointEntity<PeriodTimePointTypeEnum> timeSeqPointEntity) {
        perPeriodEntity.setPerAttBeginDate(timeSeqPointEntity.getDatePoint());
        perPeriodEntity.setStartTimeResourceEnum(timeSeqPointEntity.getTimePointType());
    }

    private PerPeriodEntity addPerPeriodResult(long personId, List<PerPeriodEntity> perPeriodSubList, Map<PeriodCutTypeEnum, Set<Long>> periodCutTypeEnumSetMap, PerPeriodEntity perPeriodEntity, TimeSeqPointEntity<PeriodTimePointTypeEnum> timeSeqPointEndEntity, TimeSeqPointEntity<PeriodTimePointTypeEnum> currentFileStartPoint, PerAttPeriodSysParamVo perAttPeriodSysParams, long fileBoId) {
        if (perPeriodSubList == null || perPeriodEntity == null || perPeriodEntity.getPerAttBeginDate() == null) {
            return new PerPeriodEntity();
        }
        if (currentFileStartPoint == null) {
            throw new KDBizException("attFile period config error");
        }
        if (PeriodTimePointTypeEnum.FILE_SCH == timeSeqPointEndEntity.getTimePointType()) {
            perPeriodEntity.setPeriodId(timeSeqPointEndEntity.getDataId());
            if (timeSeqPointEndEntity.getLowerLevelId() == null || timeSeqPointEndEntity.getLowerLevelId() == 0L) {
                return new PerPeriodEntity();
            }
            perPeriodEntity.setAttPeriodId(timeSeqPointEndEntity.getLowerLevelId());
        } else {
            perPeriodEntity.setPeriodId(timeSeqPointEndEntity.getHigherLevelId());
            perPeriodEntity.setAttPeriodId(timeSeqPointEndEntity.getId());
        }
        List<TimeSeqPointEntity<PeriodTimePointTypeEnum>> fileTimeSeqPointList = perPeriodEntity.getFileTimeSeqPointList();
        if (!CollectionUtils.isEmpty(fileTimeSeqPointList)) {
            fileTimeSeqPointList.add(currentFileStartPoint);
        }
        List cutFileData = fileTimeSeqPointList.stream().filter(d -> !d.isStart()).collect(Collectors.toList());
        Date datePoint = timeSeqPointEndEntity.getDatePoint();
        if (!CollectionUtils.isEmpty(cutFileData) && !cutFileData.isEmpty()) {
            if (perAttPeriodSysParams.isCult()) {
                Date startDate = null;
                for (int i = 0; i < cutFileData.size(); ++i) {
                    if (i == 0) {
                        startDate = perPeriodEntity.getPerAttBeginDate();
                    }
                    TimeSeqPointEntity cutFileTimeSeqPoint = (TimeSeqPointEntity)cutFileData.get(i);
                    this.addOneCutPerPeriodEntity(personId, perPeriodSubList, perPeriodEntity, startDate, cutFileTimeSeqPoint.getId(), cutFileTimeSeqPoint.getDatePoint(), fileBoId);
                    startDate = WTCDateUtils.addDays((Date)cutFileTimeSeqPoint.getDatePoint(), (int)1);
                    if (i != cutFileData.size() - 1) continue;
                    this.addOneCutPerPeriodEntity(personId, perPeriodSubList, perPeriodEntity, startDate, fileTimeSeqPointList.get(fileTimeSeqPointList.size() - 1).getId(), datePoint, fileBoId);
                }
            } else {
                Long relateFileVersionId = this.getRelateFileVersionId(perAttPeriodSysParams, fileTimeSeqPointList);
                this.setPerPeriodEntityProp(personId, perPeriodEntity, datePoint, relateFileVersionId, fileBoId);
                perPeriodSubList.add(perPeriodEntity);
            }
            periodCutTypeEnumSetMap.get(PeriodCutTypeEnum.CUT).add(fileBoId);
        } else {
            Long relateFileVersionId = currentFileStartPoint.getId();
            this.setPerPeriodEntityProp(personId, perPeriodEntity, datePoint, relateFileVersionId, fileBoId);
            perPeriodSubList.add(perPeriodEntity);
        }
        return new PerPeriodEntity();
    }

    private void setPerPeriodEntityProp(long personId, PerPeriodEntity perPeriodEntity, Date datePoint, Long relateFileVersionId, Long fileBoId) {
        perPeriodEntity.setBusinessStatus("1");
        perPeriodEntity.setFileBoId(fileBoId);
        perPeriodEntity.setPersonId(personId);
        perPeriodEntity.setPerAttEndDate(datePoint);
        perPeriodEntity.setFileId(relateFileVersionId);
    }

    public String getLockUniqueKey(PerPeriodEntity perPeriodEntity) {
        if (perPeriodEntity.getFileId() == null || perPeriodEntity.getAttPeriodId() == null || perPeriodEntity.getPerAttBeginDate() == null || perPeriodEntity.getPerAttEndDate() == null) {
            throw new IllegalArgumentException("perAttPeriod  unique param error");
        }
        return WTCStringUtils.joinStr((String[])new String[]{String.valueOf(perPeriodEntity.getFileId()), "_", String.valueOf(perPeriodEntity.getAttPeriodId()), "_", HRDateTimeUtils.format((Date)perPeriodEntity.getPerAttBeginDate(), (String)"yyyy-MM-dd"), "_", HRDateTimeUtils.format((Date)perPeriodEntity.getPerAttEndDate(), (String)"yyyy-MM-dd")});
    }

    private Long getRelateFileVersionId(PerAttPeriodSysParamVo perAttPeriodSysParams, List<TimeSeqPointEntity<PeriodTimePointTypeEnum>> fileTimeSeqPointList) {
        String belongType = perAttPeriodSysParams.getBelongType();
        TimeSeqPointEntity<PeriodTimePointTypeEnum> leastFileTimeSeqPoint = fileTimeSeqPointList.get(fileTimeSeqPointList.size() - 1);
        if ("1".equals(belongType)) {
            return leastFileTimeSeqPoint.getId();
        }
        if ("2".equals(belongType)) {
            return fileTimeSeqPointList.get(0).getId();
        }
        if ("3".equals(belongType)) {
            int belongCustomDay = perAttPeriodSysParams.getBelongCustomDay();
            Date datePoint = leastFileTimeSeqPoint.getDatePoint();
            int day = WTCDateUtils.getDay((Date)datePoint);
            if (day > belongCustomDay) {
                return leastFileTimeSeqPoint.getId();
            }
            return fileTimeSeqPointList.get(0).getId();
        }
        throw new IllegalArgumentException("perAttPeriodSysParams error");
    }

    private void addOneCutPerPeriodEntity(long personId, List<PerPeriodEntity> perPeriodResultList, PerPeriodEntity perPeriodEntity, Date startDate, long fileVersionId, Date datePoint, long fileBoId) {
        if (datePoint.before(startDate)) {
            return;
        }
        PerPeriodEntity addPerPeriodEntity = new PerPeriodEntity();
        addPerPeriodEntity.setPeriodId(perPeriodEntity.getPeriodId());
        addPerPeriodEntity.setAttPeriodId(perPeriodEntity.getAttPeriodId());
        addPerPeriodEntity.setPerAttBeginDate(startDate);
        this.setPerPeriodEntityProp(personId, addPerPeriodEntity, datePoint, fileVersionId, fileBoId);
        perPeriodResultList.add(addPerPeriodEntity);
    }

    private void addTimePoint(List<TimeSeqPointEntity<PeriodTimePointTypeEnum>> resultData, TimeSeqPartitionEntity timeSeqPartitionEntity, boolean start, PeriodTimePointTypeEnum periodTimePointTypeEnum) {
        if (timeSeqPartitionEntity == null) {
            return;
        }
        TimeSeqPointEntity<PeriodTimePointTypeEnum> timeSeqPointEntity = new TimeSeqPointEntity<PeriodTimePointTypeEnum>(timeSeqPartitionEntity.getId(), timeSeqPartitionEntity.getHigherLevelId(), this.getTimePointDate(timeSeqPartitionEntity, start), start);
        timeSeqPointEntity.setTimePointType(periodTimePointTypeEnum);
        if (PeriodTimePointTypeEnum.FILE_SCH == periodTimePointTypeEnum && timeSeqPartitionEntity instanceof PeriodFileSchEntity) {
            timeSeqPointEntity.setDataId(((PeriodFileSchEntity)timeSeqPartitionEntity).getPeriodId());
            timeSeqPointEntity.setEqNext(((PeriodFileSchEntity)timeSeqPartitionEntity).isEqNext());
            if (start) {
                timeSeqPointEntity.setLowerLevelId(((PeriodFileSchEntity)timeSeqPartitionEntity).getStartPeriodEntryId());
            } else {
                timeSeqPointEntity.setLowerLevelId(((PeriodFileSchEntity)timeSeqPartitionEntity).getEndPeriodEntryId());
            }
        }
        resultData.add(timeSeqPointEntity);
    }

    private Date getTimePointDate(TimeSeqPartitionEntity timeSeqPartitionEntity, boolean start) {
        if (start) {
            return timeSeqPartitionEntity.getStartDate();
        }
        return timeSeqPartitionEntity.getEndDate();
    }
}

