/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attperiod.task;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.wtc.wtbs.business.auth.HRAuthUtil;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.task.common.WTCSource;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.helper.WTCValidatorHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attperiod.task.model.PeriodTaskRepVo;
import kd.wtc.wtp.constants.attperiod.PerAttPeriodKDString;

public class PeriodSyncTaskParamService {
    public static PeriodSyncTaskParamService getInstance() {
        return (PeriodSyncTaskParamService)WTCAppContextHelper.getBean(PeriodSyncTaskParamService.class);
    }

    public PeriodTaskRepVo getPeriodSyncTaskReqVo(Map<String, Object> customParams) {
        if (customParams == null || customParams.get("PerPeriodTaskRepVo") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u6570\u636e\u5f02\u5e38\uff0c\u65e0\u6cd5\u6267\u884c\u8003\u52e4\u671f\u95f4\u540c\u6b65\u4efb\u52a1\u3002", (String)"PeriodSyncTaskParamService_0", (String)"wtc-wtp-business", (Object[])new Object[0]));
        }
        Object settleTaskReqVoData = customParams.get("PerPeriodTaskRepVo");
        return (PeriodTaskRepVo)SerializationUtils.deSerializeFromBase64((String)((String)settleTaskReqVoData));
    }

    public WTCTaskRequestStd genPeriodTaskRequest(PeriodTaskRepVo periodTaskRepVo) {
        WTCValidatorHelper.verify((Object)periodTaskRepVo);
        WTCTaskRequestStd request = new WTCTaskRequestStd();
        request.setTaskId(periodTaskRepVo.getTaskId().longValue());
        request.setVersion(periodTaskRepVo.getVersion());
        request.setCategory("wtp_period");
        request.setCreatorId(RequestContext.get().getCurrUserId());
        WTCSource source = periodTaskRepVo.getSource();
        if (source != null) {
            request.setSource(source.getCode());
        } else {
            request.setSource(WTCSource.MANUAL.getCode());
        }
        request.setTrial(false);
        request.setStartDate(periodTaskRepVo.getStartDate());
        request.setEndDate(periodTaskRepVo.getEndDate());
        request.setAppId("wtp");
        request.setParams(Collections.emptyMap());
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setqFilter(new QFilter("id", "in", periodTaskRepVo.getAttFileVidSet()));
        List dyList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        request.setDetail(HRAuthUtil.getAuthFieldByAttFileDynBatch((List)dyList));
        request.setDesc(periodTaskRepVo.getDescription());
        return request;
    }

    public WTCTaskForm genWTCTaskForm(Set<Long> attFileVidSet, Date startDate, Date endDate, String description, Long orgId, IFormPlugin plugin) {
        return this.genWTCTaskForm(attFileVidSet, startDate, endDate, description, orgId, plugin, null);
    }

    public WTCTaskForm genWTCTaskForm(Set<Long> attFileVidSet, Date startDate, Date endDate, String description, Long orgId, IFormPlugin plugin, String version) {
        if (attFileVidSet == null || attFileVidSet.size() == 0) {
            throw new KDBizException(PerAttPeriodKDString.periodSynFileNotNull());
        }
        PeriodTaskRepVo periodTaskRepVo = this.getPerPeriodTaskRepVo(attFileVidSet, startDate, endDate, description, orgId, version);
        WTCTaskForm taskForm = new WTCTaskForm();
        taskForm.setType("wtp_period");
        taskForm.setCaption(WTCStringUtils.joinStr((String[])new String[]{PerAttPeriodKDString.periodSynTaskName(), "-", periodTaskRepVo.getVersion()}));
        taskForm.setCanStop(true);
        taskForm.setCanBackground(true);
        if (plugin != null) {
            CloseCallBack closeCallBack = new CloseCallBack(plugin, "task");
            taskForm.setCloseCallBack(closeCallBack);
        } else {
            periodTaskRepVo.setSource(WTCSource.SCHEDULE);
        }
        taskForm.setClickClassName("kd.wtc.wtp.formplugin.web.attperiod.PeriodTaskClick");
        HashMap params = Maps.newHashMapWithExpectedSize((int)10);
        params.put("PerPeriodTaskRepVo", SerializationUtils.serializeToBase64((Object)periodTaskRepVo));
        taskForm.setCustomParams((Map)params);
        return taskForm;
    }

    private PeriodTaskRepVo getPerPeriodTaskRepVo(Set<Long> attFileVidSet, Date startDate, Date endDate, String description, Long orgId, String version) {
        PeriodTaskRepVo periodTaskRepVo = new PeriodTaskRepVo();
        periodTaskRepVo.setAttFileVidSet(attFileVidSet);
        periodTaskRepVo.setStartDate(startDate);
        periodTaskRepVo.setEndDate(endDate);
        periodTaskRepVo.setDescription(description);
        periodTaskRepVo.setOrgId(orgId);
        String number = version;
        if (version == null) {
            number = CodeRuleServiceHelper.getNumber((String)"wtp_periodtask", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"wtp_periodtask"), null);
        }
        periodTaskRepVo.setVersion(number);
        long taskId = DB.genGlobalLongId();
        periodTaskRepVo.setTaskId(taskId);
        return periodTaskRepVo;
    }
}

