/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attperiod.task;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.monitor.log.KDException;
import kd.wtc.wtbs.business.caltask.common.WTCCalSubTaskEntity;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.helper.WTCTaskInstanceHelper;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.task.WTCTaskObjectFactory;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.executor.WTCShardingAbleTask;
import kd.wtc.wtbs.business.task.executor.WTCTaskParam;
import kd.wtc.wtbs.business.task.repository.std.WTCCalTaskRepository;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtp.business.attperiod.PeriodSyncFormService;
import kd.wtc.wtp.business.attperiod.task.PeriodTaskHandleService;
import kd.wtc.wtp.business.attperiod.task.model.PeriodTaskDetail;
import kd.wtc.wtp.business.attperiod.task.model.PeriodTaskRepVo;

public class PeriodTaskConsumer
extends WTCShardingAbleTask {
    private static final Log LOG = WTCLogFactory.getLog(PeriodTaskConsumer.class);

    protected void execute(RequestContext requestContext, WTCTaskParam taskParams) {
        try {
            PeriodTaskHandleService.getInstance().executePerPeriodTask(requestContext, taskParams);
        }
        catch (Exception ex) {
            LOG.error("PerPeriodTaskConsumer.execute error:", (Throwable)ex);
            this.subTaskExceptionOrTerminated(taskParams, WTCSubTaskStatus.ERROR);
            throw new KDException(ex);
        }
        finally {
            List taskShardingDetails = taskParams.getTaskShardingDetails();
            List periodTaskDetails = taskShardingDetails.stream().map(PeriodTaskDetail.class::cast).collect(Collectors.toList());
            List fileBoIdList = periodTaskDetails.stream().map(WTCCalTaskDetailEntity::getAttFileBoId).collect(Collectors.toList());
            Map<Long, String> existsFileBoIdMap = ((PeriodTaskRepVo)SerializationUtils.deSerializeFromBase64((String)String.valueOf(taskParams.getParams().get("PerPeriodTaskRepVo")))).getExistsFileBoIdMap();
            List<Long> fileBoIds = fileBoIdList.stream().filter(fileBoId -> existsFileBoIdMap == null || !existsFileBoIdMap.containsKey(fileBoId)).collect(Collectors.toList());
            PeriodSyncFormService.getInstance().removeFileBoIdInRedis(fileBoIds);
        }
    }

    protected boolean onSubTaskTerminatedBeforeExecute(WTCTaskParam taskParam) {
        this.subTaskExceptionOrTerminated(taskParam, WTCSubTaskStatus.TERMINATED);
        return false;
    }

    protected List<Object> doGetShardingDetailList(long mainTaskId, long subTaskId, String category) {
        WTCTaskObjectFactory objectFactory = WTCTaskInstanceHelper.getObjectFactory((String)category);
        WTCCalTaskRepository repository = (WTCCalTaskRepository)objectFactory.getRepository();
        List detailList = repository.batchLoadTaskDetailByTaskIdAndSubTaskId(mainTaskId, subTaskId, null);
        return detailList.stream().filter(Objects::nonNull).map(this::genPeriodTaskDetail).collect(Collectors.toList());
    }

    private PeriodTaskDetail genPeriodTaskDetail(WTCCalTaskDetailEntity wtcCalTaskDetailEntity) {
        return (PeriodTaskDetail)JSON.parseObject((String)JSON.toJSONString((Object)wtcCalTaskDetailEntity), PeriodTaskDetail.class);
    }

    private void subTaskExceptionOrTerminated(WTCTaskParam taskParams, WTCSubTaskStatus wtcSubTaskStatus) {
        long taskId = taskParams.getTaskId();
        WTCCalSubTaskEntity wtcCalSubTaskEntity = WTCTaskServiceHelper.loadSubTaskById((String)"wtp_period", (long)taskId);
        wtcCalSubTaskEntity.setSubTaskStatus(wtcSubTaskStatus);
        wtcCalSubTaskEntity.setNotRunAttFile(wtcCalSubTaskEntity.getTotalAttFile());
        wtcCalSubTaskEntity.setNotRunAttPerson(wtcCalSubTaskEntity.getTotalAttPerson());
        wtcCalSubTaskEntity.setRunAttFile(0);
        wtcCalSubTaskEntity.setFailedAttFile(0);
        wtcCalSubTaskEntity.setSucceedAttFile(0);
        wtcCalSubTaskEntity.setRunAttPerson(0);
        wtcCalSubTaskEntity.setFailedAttPerson(0);
        wtcCalSubTaskEntity.setSucceedAttPerson(0);
        WTCTaskServiceHelper.updateTaskSub((String)"wtp_period", (WTCSubTaskEntity)wtcCalSubTaskEntity);
        List wtcCalTaskDetailEntities = WTCTaskServiceHelper.batchLoadTaskDetailByTaskIdAndSubTaskId((String)"wtp_period", (long)taskParams.getMainTaskId(), (long)taskParams.getTaskId(), null);
        wtcCalTaskDetailEntities.forEach(d -> d.setTaskDetailState(WTCTaskDetailStatus.NOT_ACCOUNT));
        WTCTaskServiceHelper.batchUpdateTaskDetailInfoBySubTaskIdAndAttFileId((List)wtcCalTaskDetailEntities, (String)"wtp_period");
    }
}

