/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attperiod.task;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.caltask.common.WTCCalSubTaskEntity;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskEntity;
import kd.wtc.wtbs.business.helper.WTCTaskInstanceHelper;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskEntity;
import kd.wtc.wtbs.business.task.executor.WTCShardingAbleTask;
import kd.wtc.wtbs.business.task.executor.WTCTaskParam;
import kd.wtc.wtbs.business.task.repository.std.WTCCalTaskRepository;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.helper.WTCValidatorHelper;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtp.business.attperiod.PerAttPeriodDataService;
import kd.wtc.wtp.business.attperiod.PeriodServiceHelper;
import kd.wtc.wtp.business.attperiod.perperiod.model.PerPeriodGenPreEntity;
import kd.wtc.wtp.business.attperiod.task.PerAttPeriodGenService;
import kd.wtc.wtp.business.attperiod.task.model.PerPeriodEntity;
import kd.wtc.wtp.business.attperiod.task.model.PeriodSubTaskDataEntity;
import kd.wtc.wtp.business.attperiod.task.model.PeriodTaskDetail;
import kd.wtc.wtp.business.attperiod.task.model.PeriodTaskRepVo;

public class PeriodTaskHandleService {
    private static final Log LOG = WTCLogFactory.getLog(PeriodTaskHandleService.class);

    public static PeriodTaskHandleService getInstance() {
        return (PeriodTaskHandleService)WTCAppContextHelper.getBean(PeriodTaskHandleService.class);
    }

    public void executePerPeriodTask(RequestContext requestContext, WTCTaskParam taskParams) {
        LOG.info("PeriodTaskHandleService start,subTaskId[{}]", (Object)taskParams.getTaskId());
        long paramInit = new Date().getTime();
        PeriodSubTaskDataEntity entity = this.initPerPeriodSubTaskDataEntity(requestContext, taskParams);
        this.costLog("paramInit", paramInit);
        long execute = new Date().getTime();
        this.executePerPeriodTask(entity);
        this.costLog("execute", execute);
        long statistics = new Date().getTime();
        this.sumAndGenSubTask(entity);
        this.costLog("statistics", statistics);
        long saveData = new Date().getTime();
        this.savePerPeriodData(entity);
        this.costLog("saveData", saveData);
    }

    private void executePerPeriodTask(PeriodSubTaskDataEntity entity) {
        WTCValidatorHelper.verify((Object)entity);
        WTCValidatorHelper.verify((Object)entity.getPerPeriodGenPreEntity());
        List<PeriodTaskDetail> periodTaskDetails = entity.getPeriodTaskDetails();
        for (PeriodTaskDetail periodTaskDetail : periodTaskDetails) {
            try {
                PerAttPeriodGenService.getInstance().taskSynPerAttPeriod(entity, periodTaskDetail);
            }
            catch (Exception exception) {
                periodTaskDetail.setTaskDetailState(WTCTaskDetailStatus.NOT_ACCOUNT);
                LOG.info("executePerPeriodTaskDetail error");
            }
        }
    }

    private Map<Long, Long> checkDepEmpJob(List<Long> vids) {
        if (WTCCollections.isEmpty(vids)) {
            return new HashMap<Long, Long>();
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_depempjob");
        QFilter filter0 = new QFilter("id", "in", vids);
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setProperties("id,empposorgrel,attperson");
        attFileQueryParam.setqFilter(filter0);
        attFileQueryParam.setAuthCheck(Boolean.valueOf(false));
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        HashMap<Long, Long> empposorgrelsMaps = new HashMap<Long, Long>(16);
        for (DynamicObject attFile : attFiles) {
            Long empposorgrel = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)attFile, (String)"empposorgrel");
            empposorgrelsMaps.put(empposorgrel, WTCDynamicObjectUtils.getBaseDataId((DynamicObject)attFile, (String)"id"));
        }
        QFilter filter = new QFilter("id", "in", empposorgrelsMaps.keySet());
        filter.and("datastatus", "=", (Object)"-1");
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] dys = serviceHelper.queryOriginalArray("id,attperson", filters);
        HashMap<Long, Long> restMap = new HashMap<Long, Long>(16);
        for (DynamicObject dy : dys) {
            Long dempFid = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"id");
            Long vid = (Long)empposorgrelsMaps.get(dempFid);
            restMap.put(vid, dempFid);
        }
        return restMap;
    }

    private void sumAndGenSubTask(PeriodSubTaskDataEntity entity) {
        WTCCalSubTaskEntity wtcCalSubTaskEntity = entity.getWtcCalSubTaskEntity();
        WTCTaskServiceHelper.sumAttPersonCalSubTask(entity.getPeriodTaskDetails(), (WTCCalSubTaskEntity)entity.getWtcCalSubTaskEntity());
        wtcCalSubTaskEntity.setSubTaskStatus(WTCSubTaskStatus.FINISHED);
    }

    private void savePerPeriodData(PeriodSubTaskDataEntity entity) {
        boolean stop = WTCShardingAbleTask.WTCShardingTaskHelper.isStop((long)entity.getSubTaskId());
        if (stop) {
            this.periodSubTaskStop(entity);
            return;
        }
        List wtcCalTaskDetailEntityList = entity.getPeriodTaskDetails().stream().map(WTCCalTaskDetailEntity.class::cast).collect(Collectors.toList());
        Date currentDate = new Date();
        WTCCalSubTaskEntity wtcCalSubTaskEntity = entity.getWtcCalSubTaskEntity();
        wtcCalSubTaskEntity.setRefreshTime(currentDate);
        wtcCalSubTaskEntity.setEndDate(currentDate);
        try (TXHandle tx = TX.required();){
            try {
                this.handleMainTaskDate(entity);
                WTCTaskServiceHelper.batchUpdateTaskDetailInfoBySubTaskIdAndAttFileId(wtcCalTaskDetailEntityList, (String)"wtp_period");
                WTCTaskServiceHelper.updateTaskSub((String)"wtp_period", (WTCSubTaskEntity)wtcCalSubTaskEntity);
                PeriodServiceHelper.getInstance().savePerPeriodDynData(entity.getPerPeriodEntityList(), entity.getPeriodCutTypeEnumSetMap());
                Set<Long> successFileBoIdSet = wtcCalTaskDetailEntityList.stream().filter(taskDetailEntity -> WTCTaskDetailStatus.SUCCESS == taskDetailEntity.getTaskDetailState()).map(WTCCalTaskDetailEntity::getAttFileBoId).collect(Collectors.toSet());
                PerAttPeriodDataService.getInstance().clearDataForTaskEnd(successFileBoIdSet);
            }
            catch (Exception exception) {
                tx.markRollback();
                LOG.error("savePerPeriodData error", (Throwable)exception);
                throw new KDBizException(exception.getMessage());
            }
        }
    }

    private void handleMainTaskDate(PeriodSubTaskDataEntity entity) {
        List<PerPeriodEntity> perPeriodEntityList = entity.getPerPeriodEntityList();
        if (perPeriodEntityList == null || perPeriodEntityList.size() == 0) {
            return;
        }
        perPeriodEntityList.sort(Comparator.comparing(PerAttPeriod::getPerAttBeginDate));
        Date startDate = perPeriodEntityList.get(0).getPerAttBeginDate();
        perPeriodEntityList.sort(Comparator.comparing(PerAttPeriod::getPerAttEndDate));
        Date endDate = perPeriodEntityList.get(perPeriodEntityList.size() - 1).getPerAttEndDate();
        PeriodServiceHelper.getInstance().updatePeriodSynResultDate(entity.getTaskId(), startDate, endDate);
        Long bizTaskId = entity.getTaskId();
        WTCCalTaskRepository repository = (WTCCalTaskRepository)WTCTaskInstanceHelper.getRepository((String)"wtp_period");
        WTCCalTaskEntity task = (WTCCalTaskEntity)repository.loadTaskByTaskId(bizTaskId.longValue(), null);
        task.setCalStartDate(startDate);
        task.setCalEndDate(endDate);
        repository.updateTask((WTCTaskEntity)task);
    }

    private PeriodSubTaskDataEntity initPerPeriodSubTaskDataEntity(RequestContext requestContext, WTCTaskParam taskParams) {
        Date subTaskStartDate = new Date();
        long taskId = taskParams.getTaskId();
        List taskShardingDetails = taskParams.getTaskShardingDetails();
        List<PeriodTaskDetail> periodTaskDetails = taskShardingDetails.stream().map(PeriodTaskDetail.class::cast).collect(Collectors.toList());
        List<Long> fileBoIdList = periodTaskDetails.stream().map(WTCCalTaskDetailEntity::getAttFileBoId).collect(Collectors.toList());
        PerPeriodGenPreEntity perPeriodGenPreEntity = PerAttPeriodDataService.getInstance().getPerPeriodGenPreEntity(fileBoIdList, null, null);
        PeriodTaskRepVo periodTaskRepVo = (PeriodTaskRepVo)SerializationUtils.deSerializeFromBase64((String)String.valueOf(taskParams.getParams().get("PerPeriodTaskRepVo")));
        periodTaskRepVo.setExistsFileBoIdMap(perPeriodGenPreEntity.getExistsAttFileMap());
        taskParams.getParams().put("PerPeriodTaskRepVo", SerializationUtils.serializeToBase64((Object)periodTaskRepVo));
        WTCCalSubTaskEntity wtcCalSubTaskEntity = new WTCCalSubTaskEntity();
        wtcCalSubTaskEntity.setStartDate(subTaskStartDate);
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setSetBoIds(new HashSet<Long>(fileBoIdList));
        attFileQueryParam.setProperties("id");
        Set<Long> fileVersionAuthIdSet = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
        perPeriodGenPreEntity.setHasPerFileId(fileVersionAuthIdSet);
        return new PeriodSubTaskDataEntity(taskParams.getMainTaskId(), taskId, periodTaskDetails, new ArrayList<PerPeriodEntity>(), wtcCalSubTaskEntity, perPeriodGenPreEntity);
    }

    private void periodSubTaskStop(PeriodSubTaskDataEntity entity) {
        Date currentDate = new Date();
        List<PeriodTaskDetail> periodTaskDetails = entity.getPeriodTaskDetails();
        WTCCalSubTaskEntity wtcCalSubTaskEntity = entity.getWtcCalSubTaskEntity();
        Set personCollect = periodTaskDetails.stream().map(WTCCalTaskDetailEntity::getAttPersonId).collect(Collectors.toSet());
        int attPersonSize = personCollect.size();
        Set fileCollect = periodTaskDetails.stream().map(WTCCalTaskDetailEntity::getAttFileId).collect(Collectors.toSet());
        int attFileSize = fileCollect.size();
        wtcCalSubTaskEntity.setTotalAttPerson(attPersonSize);
        wtcCalSubTaskEntity.setNotRunAttPerson(attPersonSize);
        wtcCalSubTaskEntity.setTotalAttFile(attFileSize);
        wtcCalSubTaskEntity.setNotRunAttFile(attFileSize);
        wtcCalSubTaskEntity.setRunAttFile(0);
        wtcCalSubTaskEntity.setFailedAttFile(0);
        wtcCalSubTaskEntity.setSucceedAttFile(0);
        wtcCalSubTaskEntity.setRunAttPerson(0);
        wtcCalSubTaskEntity.setFailedAttPerson(0);
        wtcCalSubTaskEntity.setSucceedAttPerson(0);
        wtcCalSubTaskEntity.setSubTaskStatus(WTCSubTaskStatus.TERMINATED);
        this.setSubTaskDate(wtcCalSubTaskEntity, currentDate);
        for (PeriodTaskDetail periodTaskDetail : periodTaskDetails) {
            if (periodTaskDetail.getRealCalStartDate() == null) {
                periodTaskDetail.setRealCalStartDate(currentDate);
            }
            periodTaskDetail.setTaskDetailState(WTCTaskDetailStatus.NOT_ACCOUNT);
            periodTaskDetail.setRealCalEndDate(currentDate);
        }
        List wtcCalTaskDetailEntityList = periodTaskDetails.stream().map(PeriodTaskDetail::getWTCCalTaskDetailEntity).collect(Collectors.toList());
        try (TXHandle tx = TX.required();){
            try {
                WTCTaskServiceHelper.batchUpdateTaskDetailInfoBySubTaskIdAndAttFileId(wtcCalTaskDetailEntityList, (String)"wtp_period");
                WTCTaskServiceHelper.updateTaskSub((String)"wtp_period", (WTCSubTaskEntity)wtcCalSubTaskEntity);
            }
            catch (Exception exception) {
                tx.markRollback();
                throw new KDBizException(exception.getMessage());
            }
        }
    }

    private void setSubTaskDate(WTCCalSubTaskEntity wtcCalSubTaskEntity, Date currentDate) {
        wtcCalSubTaskEntity.setRefreshTime(currentDate);
        wtcCalSubTaskEntity.setEndDate(currentDate);
    }

    private void costLog(String message, long start) {
        long now = new Date().getTime();
        LOG.warn("PeriodTaskHandleService, step[{}], cost[{}]ms", (Object)message, (Object)(now - start));
    }
}

