/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attperson;

import com.alibaba.fastjson.JSONObject;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class AttPersonCheckService {
    public static AttPersonCheckService getInstance() {
        return (AttPersonCheckService)WTCAppContextHelper.getBean(AttPersonCheckService.class);
    }

    public Map<Integer, String> checkQTFirstEffectDate(Map<Integer, Map<String, String>> otherInfoMap) {
        Set<Long> attPersonIds = otherInfoMap.values().stream().map(map -> (Long)JSONObject.parseObject((String)((String)map.get("person")), Long.class)).collect(Collectors.toSet());
        Map<Long, List<DynamicObject>> existsFileMap = this.getAttFileMap(attPersonIds);
        HashMap errMap = Maps.newHashMapWithExpectedSize((int)otherInfoMap.size());
        for (int i = 0; i < otherInfoMap.size(); ++i) {
            Map<String, String> map2 = otherInfoMap.get(i);
            String currentSaveDateStr = map2.get("qtfirsteffectdate");
            if (HRStringUtils.isEmpty((String)currentSaveDateStr)) continue;
            Date currentSaveDate = (Date)JSONObject.parseObject((String)currentSaveDateStr, Date.class);
            Date currentFileStartDate = (Date)JSONObject.parseObject((String)map2.get("startdate"), Date.class);
            Long personId = (Long)JSONObject.parseObject((String)map2.get("person"), Long.class);
            List<DynamicObject> existsFileDyList = existsFileMap.get(personId);
            if (!CollectionUtils.isEmpty(existsFileDyList) && existsFileDyList.size() == 1) {
                currentFileStartDate = existsFileDyList.get(0).getDate("startdate");
            }
            if (currentSaveDate == null) {
                errMap.put(i, null);
                continue;
            }
            if (!CollectionUtils.isEmpty(existsFileDyList) && existsFileDyList.size() > 1) {
                existsFileDyList.sort(Comparator.comparing(dynamicObject -> dynamicObject.getDate("startdate")));
                Date firstFileStartDate = existsFileDyList.get(0).getDate("startdate");
                if (firstFileStartDate == null || firstFileStartDate.compareTo(currentSaveDate) <= 0) continue;
                String tips = ResManager.loadKDString((String)"\u7cfb\u7edf\u6700\u65e9\u5b9a\u989d\u751f\u6210\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5458\u5de5\u9996\u4efd\u6863\u6848\u7684\u5f00\u59cb\u65e5\u671f %s\u3002", (String)"AttPersonCheckService_1", (String)"wtc-wtp-business", (Object[])new Object[0]);
                errMap.put(i, String.format(tips, WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)firstFileStartDate)));
                continue;
            }
            if (currentFileStartDate != null && currentSaveDate.compareTo(currentFileStartDate) < 0) {
                errMap.put(i, ResManager.loadKDString((String)"\u7cfb\u7edf\u6700\u65e9\u5b9a\u989d\u751f\u6210\u65e5\u671f\u5e94\u665a\u4e8e\u6863\u6848\u5f00\u59cb\u65e5\u671f\u3002", (String)"AttPersonCheckService_2", (String)"wtc-wtp-business", (Object[])new Object[0]));
                continue;
            }
            errMap.put(i, null);
        }
        return errMap;
    }

    private Map<Long, List<DynamicObject>> getAttFileMap(Set<Long> attPersonIds) {
        AttFileQueryParam queryParam = new AttFileQueryParam(false);
        queryParam.setPersonSetIds(attPersonIds);
        queryParam.setBeCurrent(Boolean.valueOf(true));
        queryParam.setProperties("attperson.id, startdate");
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        return attFiles.stream().collect(Collectors.groupingBy(dy -> dy.getLong("attperson.id")));
    }
}

