/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attperson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.license.CertControlType;
import kd.wtc.wtbs.business.license.CertService;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attperson.AttPersonOperate;
import kd.wtc.wtp.business.attperson.AttPersonValidateService;
import kd.wtc.wtp.business.attperson.impl.onbrd.AttCalDataRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.AttCalDetailRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.AttCalSumRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.AttDataRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.AttDataRollBackValidateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.AttFileRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.AttPersonRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.AttRecordCountMsgRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.AttRecordRollBackValidateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.AttRecordTrimRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.BizTripBillRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.BizTripBillValidateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.CardLackRecordRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.CardMatchTaskRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.ExRecordRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.OtBillRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.OtBillRollBackValidateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.PersonPeriodRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.PersonPeriodTaskRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.QuotaRecordRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.QuotaTaskRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.RosterRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.SettleRecordRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.SettleTaskRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.SignCardApplyRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.SignCardRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.SupSignRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.VaBillRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.VaBillRollBackValidateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.ValidCardRollBackOperateImpl;
import kd.wtc.wtp.business.attperson.impl.onbrd.ValidCardRollBackValidateImpl;
import kd.wtc.wtp.common.model.attperson.WTCPersonContext;
import kd.wtc.wtp.common.model.attperson.WTCPersonOperationResult;
import kd.wtc.wtp.common.model.attperson.WTCPersonValidateResult;

public class AttPersonOpService {
    private static final Log LOG = LogFactory.getLog(AttPersonOpService.class);
    private List<AttPersonValidateService> deleteValidateServices = new ArrayList<AttPersonValidateService>();
    private List<List<AttPersonOperate>> deleteOperateServiceGroups = new ArrayList<List<AttPersonOperate>>();

    public static AttPersonOpService getInstance() {
        return (AttPersonOpService)WTCAppContextHelper.getBean(AttPersonOpService.class);
    }

    public AttPersonOpService() {
        this.deleteValidateServices.add(new AttDataRollBackValidateImpl());
        this.deleteValidateServices.add(new AttRecordRollBackValidateImpl());
        this.deleteValidateServices.add(new BizTripBillValidateImpl());
        this.deleteValidateServices.add(new OtBillRollBackValidateImpl());
        this.deleteValidateServices.add(new VaBillRollBackValidateImpl());
        this.deleteValidateServices.add(new ValidCardRollBackValidateImpl());
        this.deleteValidateServices.sort(Comparator.comparing(AttPersonValidateService::getValidateIndex));
        ArrayList deleteOperateServices = Lists.newArrayListWithExpectedSize((int)25);
        deleteOperateServices.add(new AttCalDataRollBackOperateImpl());
        deleteOperateServices.add(new AttCalDetailRollBackOperateImpl());
        deleteOperateServices.add(new AttCalSumRollBackOperateImpl());
        deleteOperateServices.add(new AttDataRollBackOperateImpl());
        deleteOperateServices.add(new AttFileRollBackOperateImpl());
        deleteOperateServices.add(new AttPersonRollBackOperateImpl());
        deleteOperateServices.add(new AttRecordCountMsgRollBackOperateImpl());
        deleteOperateServices.add(new AttRecordTrimRollBackOperateImpl());
        deleteOperateServices.add(new BizTripBillRollBackOperateImpl());
        deleteOperateServices.add(new CardLackRecordRollBackOperateImpl());
        deleteOperateServices.add(new CardMatchTaskRollBackOperateImpl());
        deleteOperateServices.add(new ExRecordRollBackOperateImpl());
        deleteOperateServices.add(new OtBillRollBackOperateImpl());
        deleteOperateServices.add(new PersonPeriodRollBackOperateImpl());
        deleteOperateServices.add(new PersonPeriodTaskRollBackOperateImpl());
        deleteOperateServices.add(new QuotaRecordRollBackOperateImpl());
        deleteOperateServices.add(new QuotaTaskRollBackOperateImpl());
        deleteOperateServices.add(new RosterRollBackOperateImpl());
        deleteOperateServices.add(new SettleRecordRollBackOperateImpl());
        deleteOperateServices.add(new SettleTaskRollBackOperateImpl());
        deleteOperateServices.add(new SignCardApplyRollBackOperateImpl());
        deleteOperateServices.add(new SignCardRollBackOperateImpl());
        deleteOperateServices.add(new SupSignRollBackOperateImpl());
        deleteOperateServices.add(new VaBillRollBackOperateImpl());
        deleteOperateServices.add(new ValidCardRollBackOperateImpl());
        deleteOperateServices.sort(Comparator.comparing(AttPersonOperate::getExeIndex));
        if (!deleteOperateServices.isEmpty()) {
            this.deleteOperateServiceGroups.add(Lists.newArrayList((Object[])new AttPersonOperate[]{(AttPersonOperate)deleteOperateServices.get(0)}));
            for (int i = 1; i < deleteOperateServices.size(); ++i) {
                if (HRStringUtils.equals((String)((AttPersonOperate)deleteOperateServices.get(i)).getDBRouteKey(), (String)((AttPersonOperate)deleteOperateServices.get(i - 1)).getDBRouteKey())) {
                    this.deleteOperateServiceGroups.get(this.deleteOperateServiceGroups.size() - 1).add((AttPersonOperate)deleteOperateServices.get(i));
                    continue;
                }
                this.deleteOperateServiceGroups.add(Lists.newArrayList((Object[])new AttPersonOperate[]{(AttPersonOperate)deleteOperateServices.get(i)}));
            }
        }
    }

    public void synOpAttPersonData(DynamicObject[] dataEntities, String entityName) {
        if (dataEntities != null && dataEntities.length > 0) {
            HRBaseServiceHelper attPersonHelper = new HRBaseServiceHelper(entityName);
            Set pendingIdSet = Arrays.stream(dataEntities).filter(data -> data.getLong("id") != 0L).map(data -> data.getLong("id")).collect(Collectors.toSet());
            DynamicObject[] existDys = attPersonHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", pendingIdSet)});
            Map existMap = Arrays.stream(existDys).collect(Collectors.toMap(ex -> ex.getLong("id"), Function.identity(), (a, b) -> a));
            ArrayList insertDyData = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
            ArrayList updateDyData = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
            HashSet ignoreProperties = Sets.newHashSetWithExpectedSize((int)16);
            ignoreProperties.add("id");
            ignoreProperties.add("earliestattenddate");
            ignoreProperties.add("latestattenddate");
            for (DynamicObject dataEntity : dataEntities) {
                long id = dataEntity.getLong("id");
                if (existMap.get(id) != null) {
                    DynamicObject dynamicObject = (DynamicObject)existMap.get(id);
                    HRDynamicObjectUtils.copy((DynamicObject)dataEntity, (DynamicObject)dynamicObject, (Set)ignoreProperties);
                    updateDyData.add(dynamicObject);
                    continue;
                }
                insertDyData.add(dataEntity);
            }
            if (!CollectionUtils.isEmpty((Collection)insertDyData)) {
                attPersonHelper.save(insertDyData.toArray(new DynamicObject[0]));
            }
            if (!CollectionUtils.isEmpty((Collection)updateDyData)) {
                attPersonHelper.update(updateDyData.toArray(new DynamicObject[0]));
            }
        }
    }

    public WTCPersonOperationResult deletePersons(List<Long> personIds) {
        try {
            return this.handleDeletePersons(personIds);
        }
        catch (Exception ex) {
            LOG.warn("deletePersons.error", (Throwable)ex);
            return WTCPersonOperationResult.fail((String)ex.getMessage());
        }
    }

    private WTCPersonOperationResult handleDeletePersons(List<Long> personIds) {
        WTCPersonContext wtcPersonContext = this.getWTCPersonContext(personIds);
        WTCPersonValidateResult deleteValidateResult = new WTCPersonValidateResult();
        for (AttPersonValidateService deleteValidateService : this.deleteValidateServices) {
            deleteValidateResult.merge(deleteValidateService.validate(wtcPersonContext));
        }
        if (deleteValidateResult.isSuccess()) {
            WTCPersonOperationResult wtcPersonOperationResult = WTCPersonOperationResult.success();
            for (List<AttPersonOperate> group : this.deleteOperateServiceGroups) {
                if (!WTCCollections.isNotEmpty(group)) continue;
                try (TXHandle txHandle = TX.requiresNew();){
                    for (AttPersonOperate deleteOperateService : group) {
                        LOG.info("handleDeletePersons.{}.start", (Object)deleteOperateService.getClass().getSimpleName());
                        wtcPersonOperationResult.merge(deleteOperateService.execute(wtcPersonContext));
                        LOG.info("handleDeletePersons.{}.end", (Object)deleteOperateService.getClass().getSimpleName());
                    }
                }
            }
            if (wtcPersonOperationResult.isSuccess()) {
                CertService.certControl((String)"wtp", (String)"wtp_attfilebase", (List)wtcPersonContext.getAttPersonIdList(), (CertControlType)CertControlType.VALIDATORANDRELEASE);
            }
            return wtcPersonOperationResult;
        }
        return WTCPersonOperationResult.fail((WTCPersonValidateResult)deleteValidateResult);
    }

    private WTCPersonContext getWTCPersonContext(List<Long> personIds) {
        HashSet<Long> personIdSet = new HashSet<Long>(personIds);
        WTCPersonContext wtcPersonContext = new WTCPersonContext();
        wtcPersonContext.setAttPersonIdList(personIds);
        AttFileQueryParam fileQueryParam = new AttFileQueryParam();
        fileQueryParam.setAttPersonSetIds(personIdSet);
        fileQueryParam.setAttStatus(null);
        fileQueryParam.setAuthCheck(Boolean.FALSE);
        fileQueryParam.setBeCurrent(Boolean.TRUE);
        List attFileDys = AttFileQueryServiceImpl.getInstance().queryAttFiles(fileQueryParam);
        Map<Long, Long> fileBoIdPersonIdMap = attFileDys.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attperson")));
        wtcPersonContext.setFileBoIdPersonIdMap(fileBoIdPersonIdMap);
        wtcPersonContext.setAttFileDyMap(attFileDys.stream().collect(Collectors.groupingBy(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attperson"))));
        DynamicObject[] personDys = AttendPersonServiceImpl.getInstance().batchQueryAttendPersonByPersonIds(personIdSet, null);
        wtcPersonContext.setAttPersonDyMap(Arrays.stream(personDys).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity())));
        fileQueryParam.setBeCurrent(Boolean.FALSE);
        return wtcPersonContext;
    }
}

