/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attstateinfo;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.history.service.WTCSnapService;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.bean.annotations.SingletonBean;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtp.business.attperiod.AttPeriodService;
import kd.wtc.wtp.common.enums.AttStateInfoOpEnum;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoInitModel;
import kd.wtc.wtp.common.model.attstateinfo.FrozenBO;

@SingletonBean
public class AttStateInfoService {
    private static final Log LOGGER = LogFactory.getLog(AttStateInfoService.class);
    private static final HRBaseServiceHelper ATTSTATEINFOHELPER = new HRBaseServiceHelper("wtp_attstateinfo");
    private static final HRBaseServiceHelper ATTINFOCONFIGHELPER = new HRBaseServiceHelper("wtp_attinfoconf");
    public static final AttStateInfoService INSTANCE = (AttStateInfoService)WTCAppContextHelper.getBean(AttStateInfoService.class);

    public static AttStateInfoService getInstance() {
        return INSTANCE;
    }

    public void initAttStateInfo(List<AttStateInfoInitModel> infoInitModelList) {
        if (CollectionUtils.isEmpty(infoInitModelList)) {
            LOGGER.info("AttStateInfoService.initAttStateInfo infoInitModelList is empty ");
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("AttStateInfoService.initAttStateInfo map={}", infoInitModelList.size() > 50 ? Integer.valueOf(infoInitModelList.size()) : JSON.toJSONString(infoInitModelList));
        }
        long[] attInfoConfigIds = DB.genGlobalLongIds((int)infoInitModelList.size());
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        DynamicObjectCollection attStateInfoCollection = new DynamicObjectCollection();
        DynamicObjectCollection attInfoConfigCollection = new DynamicObjectCollection();
        int index = 0;
        for (AttStateInfoInitModel model : infoInitModelList) {
            Long fileBoId = model.getFileBoId();
            Long personId = model.getPersonId();
            Date allowReAccountTime = model.getAllowReAccountTime();
            DynamicObject attStateInfoDy = ATTSTATEINFOHELPER.generateEmptyDynamicObject();
            attStateInfoDy.set("id", (Object)model.getId());
            attStateInfoDy.set("fileboid", (Object)fileBoId);
            attStateInfoDy.set("personid", (Object)personId);
            attStateInfoDy.set("allowreaccounttime", (Object)allowReAccountTime);
            attStateInfoDy.set("creator", (Object)currUserId);
            attStateInfoDy.set("createtime", (Object)now);
            attStateInfoCollection.add((Object)attStateInfoDy);
            DynamicObject attInfoConfigDy = ATTINFOCONFIGHELPER.generateEmptyDynamicObject();
            attInfoConfigDy.set("id", (Object)attInfoConfigIds[index]);
            attInfoConfigDy.set("fileboid", (Object)fileBoId);
            attInfoConfigDy.set("allowreaccounttime", (Object)allowReAccountTime);
            attInfoConfigDy.set("createtime", (Object)now);
            attInfoConfigDy.set("creator", (Object)currUserId);
            attInfoConfigDy.set("status", (Object)"C");
            attInfoConfigDy.set("enable", (Object)"1");
            attInfoConfigCollection.add((Object)attInfoConfigDy);
            ++index;
        }
        this.updateAttStateInfoData((DynamicObject[])attStateInfoCollection.toArray((Object[])new DynamicObject[0]), attInfoConfigCollection);
    }

    public void frozen(List<FrozenBO> frozenBOList) {
        this.frozenOrUnfrozen(frozenBOList, AttStateInfoOpEnum.OP_FROZEN);
    }

    public void unfrozen(List<FrozenBO> unfrozenBOList) {
        this.frozenOrUnfrozen(unfrozenBOList, AttStateInfoOpEnum.OP_UNFROZEN);
    }

    private void frozenOrUnfrozen(List<FrozenBO> list, AttStateInfoOpEnum opEnum) {
        if (CollectionUtils.isEmpty(list)) {
            LOGGER.info("AttStateInfoService.{} list is empty", (Object)opEnum.getOpType());
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("AttStateInfoService.{}...start, list={}", (Object)opEnum.getOpType(), (Object)JSON.toJSONString(list));
        }
        List attFileBoIdList = list.stream().map(FrozenBO::getFileBoid).distinct().collect(Collectors.toList());
        Map<Long, FrozenBO> frozenBOMap = list.stream().collect(Collectors.toMap(FrozenBO::getFileBoid, dy -> dy));
        DynamicObject[] dyArr = ATTSTATEINFOHELPER.query("id,fileboid,frozenstartdate,frozenenddate", new QFilter[]{new QFilter("fileboid", "in", attFileBoIdList)});
        if (opEnum == AttStateInfoOpEnum.OP_UNFROZEN) {
            for (DynamicObject dy2 : dyArr) {
                dy2.set("frozenstartdate", null);
                dy2.set("frozenenddate", null);
            }
        } else {
            for (DynamicObject dy3 : dyArr) {
                FrozenBO frozenBO = frozenBOMap.get(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy3, (String)"fileboid"));
                dy3.set("frozenstartdate", (Object)frozenBO.getStart());
                dy3.set("frozenenddate", (Object)frozenBO.getEnd());
            }
        }
        this.updateAttStateInfoData(dyArr, null);
    }

    public void lockTo(Map<Long, Date> lockToMap) {
        this.lockOrUnlock(lockToMap, AttStateInfoOpEnum.OP_LOCK_TO);
    }

    public void unlockTo(Map<Long, Date> unlockToMap) {
        this.lockOrUnlock(unlockToMap, AttStateInfoOpEnum.OP_UNLOCK_TO);
    }

    private void lockOrUnlock(Map<Long, Date> map, AttStateInfoOpEnum opEnum) {
        DynamicObject[] dyArr;
        if (CollectionUtils.isEmpty(map)) {
            LOGGER.info("AttStateInfoService.{}...start, map is empty", (Object)opEnum.getOpType());
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("AttStateInfoService.{}...start, map={}", (Object)opEnum.getOpType(), (Object)JSON.toJSONString(map));
        }
        for (DynamicObject dy : dyArr = ATTSTATEINFOHELPER.query("id,fileboid,lockto", new QFilter[]{new QFilter("fileboid", "in", map.keySet())})) {
            dy.set("lockto", (Object)map.get(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"fileboid")));
        }
        this.updateAttStateInfoData(dyArr, null);
        if (AttStateInfoOpEnum.OP_LOCK_TO == opEnum) {
            new AttPeriodService().lockAttPeriod(map);
        } else if (AttStateInfoOpEnum.OP_UNLOCK_TO == opEnum) {
            new AttPeriodService().unLockAttPeriod(map);
        }
    }

    public void storageTo(Map<Long, Date> map) {
        DynamicObject[] dyArr;
        if (CollectionUtils.isEmpty(map)) {
            LOGGER.info("AttStateInfoService.storageTo...start, storageToMap is empty}");
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("AttStateInfoService.storageTo...start, storageToMap={}", (Object)JSON.toJSONString(map));
        }
        for (DynamicObject dy : dyArr = ATTSTATEINFOHELPER.query("id,fileboid,storageto,frozenstartdate,frozenenddate,lockto", new QFilter[]{new QFilter("fileboid", "in", map.keySet())})) {
            long fileBoId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"fileboid");
            Date storageTo = map.get(fileBoId);
            dy.set("storageto", (Object)storageTo);
            if (storageTo == null) continue;
            if (dy.getDate("frozenstartdate") != null || dy.getDate("frozenenddate") != null) {
                dy.set("frozenstartdate", null);
                dy.set("frozenenddate", null);
            }
            if (dy.getDate("lockto") == null || !dy.getDate("lockto").before(storageTo)) continue;
            dy.set("lockto", (Object)storageTo);
        }
        this.updateAttStateInfoData(dyArr, null);
    }

    public void unstorageTo(Map<Long, Date> map) {
        DynamicObject[] dyArr;
        if (CollectionUtils.isEmpty(map)) {
            LOGGER.info("AttStateInfoService.unstorageTo...start, map is empty}");
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("AttStateInfoService.unstorageTo...start, map={}", (Object)JSON.toJSONString(map));
        }
        for (DynamicObject dy : dyArr = ATTSTATEINFOHELPER.query("id,fileboid,storageto,frozenstartdate,frozenenddate,lockto", new QFilter[]{new QFilter("fileboid", "in", map.keySet())})) {
            long fileBoId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"fileboid");
            Date unstorageTo = map.get(fileBoId);
            dy.set("storageto", (Object)unstorageTo);
        }
        this.updateAttStateInfoData(dyArr, null);
    }

    public void accountTo(Map<Long, Date> map) {
        if (CollectionUtils.isEmpty(map)) {
            LOGGER.info("AttStateInfoService.accountTo...start, map is empty");
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("AttStateInfoService.accountTo...start, map={}", (Object)JSON.toJSONString(map));
        }
        DynamicObject[] dyArr = ATTSTATEINFOHELPER.query("id,fileboid,accountto", new QFilter[]{new QFilter("fileboid", "in", map.keySet())});
        DynamicObjectCollection attStateInfoCollection = new DynamicObjectCollection();
        for (DynamicObject dy : dyArr) {
            long fileBoId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"fileboid");
            Date accountTo = map.get(fileBoId);
            dy.set("accountto", (Object)accountTo);
            attStateInfoCollection.add((Object)dy);
        }
        this.updateAttStateInfoData((DynamicObject[])attStateInfoCollection.toArray((Object[])new DynamicObject[0]), null);
    }

    public void updateExcInfo(Map<Long, Map<String, Object>> attStateInfoMap, List<Long> fileBoIds) {
        DynamicObject[] dyArr = ATTSTATEINFOHELPER.query("id,fileboid,isinfoexc,excstartdate,excenddate", new QFilter[]{new QFilter("fileboid", "in", fileBoIds)});
        Arrays.stream(dyArr).forEach(dy -> {
            Map attMap = (Map)attStateInfoMap.get(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"fileboid"));
            dy.set("isinfoexc", attMap.get("isinfoexc"));
            dy.set("excstartdate", attMap.get("excstartdate"));
            dy.set("excenddate", attMap.get("excenddate"));
        });
        this.updateAttStateInfoData(dyArr, null);
    }

    public void updateExcInfoAndAccountTo(Map<Long, Map<String, Object>> attStateInfoMap, List<Long> fileBoIds) {
        DynamicObject[] dyArr = ATTSTATEINFOHELPER.query("id,fileboid,isinfoexc,excstartdate,excenddate,accountto", new QFilter[]{new QFilter("fileboid", "in", fileBoIds)});
        Arrays.stream(dyArr).forEach(dy -> {
            Map attMap = (Map)attStateInfoMap.get(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"fileboid"));
            dy.set("isinfoexc", attMap.get("isinfoexc"));
            dy.set("excstartdate", attMap.get("excstartdate"));
            dy.set("excenddate", attMap.get("excenddate"));
            dy.set("accountto", attMap.get("accountto"));
        });
        this.updateAttStateInfoData(dyArr, null);
    }

    public Map<Long, FrozenBO> queryFrozenRange(List<Long> boids) {
        HashMap<Long, FrozenBO> map = new HashMap<Long, FrozenBO>(16);
        if (CollectionUtils.isEmpty(boids)) {
            LOGGER.info("AttStateInfoService.queryFrozenRange...start, boids is empty");
            return map;
        }
        DynamicObjectCollection dyCollection = ATTSTATEINFOHELPER.queryOriginalCollection("id,fileboid,frozenstartdate,frozenenddate", new QFilter[]{new QFilter("fileboid", "in", boids)});
        dyCollection.forEach(dy -> {
            FrozenBO frozenBO = new FrozenBO();
            long fileBoID = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"fileboid");
            frozenBO.setFileBoid(Long.valueOf(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"fileboid")));
            frozenBO.setStart(dy.getDate("frozenstartdate"));
            frozenBO.setEnd(dy.getDate("frozenenddate"));
            map.put(fileBoID, frozenBO);
        });
        return map;
    }

    public List<DynamicObject> queryAttStateInfo(Set<Long> boIds) {
        if (CollectionUtils.isEmpty(boIds)) {
            LOGGER.info("AttStateInfoService.queryAttstateinfo...start, boids is empty");
            return Collections.emptyList();
        }
        DynamicObjectCollection dyCollection = ATTSTATEINFOHELPER.queryOriginalCollection("id,fileboid,personid,accountto,lockto,frozenstartdate,frozenenddate,storageto,isinfoexc,excstartdate,excenddate,allowreaccounttime", new QFilter[]{new QFilter("fileboid", "in", boIds)});
        ArrayList<DynamicObject> dys = new ArrayList<DynamicObject>(16);
        int dyCollectionSize = dyCollection.size();
        for (int i = 0; i < dyCollectionSize; ++i) {
            DynamicObject dy = (DynamicObject)dyCollection.get(i);
            dys.add(dy);
        }
        return dys;
    }

    public List<AttStateInfoBO> queryAttStateInfoById(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            LOGGER.info("AttStateInfoService.queryAttStateInfoById...start, idList is empty");
            return Lists.newArrayList();
        }
        DynamicObject[] dyArr = ATTSTATEINFOHELPER.queryOriginalArray("id,fileboid,personid,accountto,lockto,frozenstartdate,frozenenddate,storageto,isinfoexc,excstartdate,excenddate,allowreaccounttime", new QFilter[]{new QFilter("id", "in", idList)});
        return this.getAttStateInfo(dyArr);
    }

    public List<AttStateInfoBO> queryAttStateInfoByBoid(List<Long> fileBoidList) {
        if (CollectionUtils.isEmpty(fileBoidList)) {
            LOGGER.info("AttStateInfoService.queryAttStateInfoByBoid...start, fileBoidList is empty");
            return Lists.newArrayList();
        }
        DynamicObject[] dyArr = ATTSTATEINFOHELPER.queryOriginalArray("id,fileboid,personid,accountto,lockto,frozenstartdate,frozenenddate,storageto,isinfoexc,excstartdate,excenddate,allowreaccounttime", new QFilter[]{new QFilter("fileboid", "in", fileBoidList)});
        return this.getAttStateInfo(dyArr);
    }

    private List<AttStateInfoBO> getAttStateInfo(DynamicObject[] dyArr) {
        if (dyArr == null || dyArr.length == 0) {
            return Lists.newArrayList();
        }
        ArrayList<AttStateInfoBO> list = new ArrayList<AttStateInfoBO>(dyArr.length);
        for (DynamicObject dy : dyArr) {
            AttStateInfoBO attStateInfoBO = new AttStateInfoBO();
            attStateInfoBO.setId(Long.valueOf(dy.getLong("id")));
            attStateInfoBO.setFileBoid(Long.valueOf(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"fileboid")));
            attStateInfoBO.setPersonId(Long.valueOf(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"personid")));
            attStateInfoBO.setAccountTo(dy.getDate("accountto"));
            attStateInfoBO.setLockTo(dy.getDate("lockto"));
            attStateInfoBO.setStorageTo(dy.getDate("storageto"));
            attStateInfoBO.setAllowReaccountTime(dy.getDate("allowreaccounttime"));
            attStateInfoBO.setFrozenStartDate(dy.getDate("frozenstartdate"));
            attStateInfoBO.setFronzenEnDate(dy.getDate("frozenenddate"));
            attStateInfoBO.setInfoExc(Boolean.valueOf(dy.getBoolean("isinfoexc")));
            attStateInfoBO.setExcStartDate(dy.getDate("excstartdate"));
            attStateInfoBO.setExcEndDate(dy.getDate("excenddate"));
            list.add(attStateInfoBO);
        }
        return list;
    }

    private void updateAttStateInfoData(DynamicObject[] attStateInfoDyArr, DynamicObjectCollection attInfoConfigCollection) {
        try (TXHandle txHandle = TX.required();){
            ATTSTATEINFOHELPER.save(attStateInfoDyArr);
            if (!CollectionUtils.isEmpty((Collection)attInfoConfigCollection)) {
                ATTINFOCONFIGHELPER.save(attInfoConfigCollection);
                MainEntityType hisEntityType = MetadataServiceHelper.getDataEntityType((String)"wtp_attinfoconfhis");
                HRBaseServiceHelper hisHelper = new HRBaseServiceHelper("wtp_attinfoconfhis");
                WTCSnapService.snapHisSave((MainEntityType)hisEntityType, (HRBaseServiceHelper)hisHelper, (DynamicObjectCollection)attInfoConfigCollection);
            }
        }
    }

    public boolean hasAnyOneFrozen() {
        QFilter filter = new QFilter("frozenenddate", "is not null", null);
        int count = ATTSTATEINFOHELPER.count("wtp_attstateinfo", new QFilter[]{filter});
        return count != 0;
    }
}

