/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.coordination;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.wtc.wtbs.common.util.WTCGrayscaleUtils;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.enums.coordination.CoordinationConfTypeEnums;

public class CoordinationConfTreeService {
    public static List<TreeNode> getTreeNodes(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String treeNodeJson = pageCache.get("cache_coordination_tree_node_data");
        if (WTCStringUtils.isEmpty((String)treeNodeJson)) {
            return Collections.emptyList();
        }
        return WTCSerializationUtils.fromJsonStringToList((String)treeNodeJson, TreeNode.class);
    }

    public static TreeNode matchNodeText(String searchText, List<TreeNode> treeNodes) {
        TreeNode rootNode = treeNodes.get(0);
        String text = rootNode.getText();
        if (text.contains(searchText)) {
            return rootNode;
        }
        List children = rootNode.getChildren();
        for (TreeNode child : children) {
            String childText = child.getText();
            if (!childText.contains(searchText)) continue;
            return child;
        }
        for (TreeNode child : children) {
            List childrenList = child.getChildren();
            for (TreeNode treeNode : childrenList) {
                String treeNodeText = treeNode.getText();
                if (!treeNodeText.contains(searchText)) continue;
                return treeNode;
            }
        }
        return null;
    }

    public static void saveTreeNodesCache(List<TreeNode> treeNodes, IFormView view) {
        String json = SerializationUtils.toJsonString(treeNodes);
        view.getPageCache().put("cache_coordination_tree_node_data", json);
    }

    public static void reloadApiTreeData(IFormView view, TreeView treeView) {
        TreeNode rootNode = new TreeNode();
        rootNode.setId("root");
        rootNode.setText(ResManager.loadKDString((String)"\u65b0\u589e/\u53d8\u66f4\u8003\u52e4\u6863\u6848", (String)"CoordinationConfTreeService_0", (String)"wtc-wtp-business", (Object[])new Object[0]));
        rootNode.setIsOpened(Boolean.TRUE.booleanValue());
        rootNode.setDisabled(true);
        rootNode.setColor("#000000");
        TreeNode basicNode = CoordinationConfTreeService.buildNode("basic", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"CoordinationConfTreeService_1", (String)"wtc-wtp-business", (Object[])new Object[0]), Boolean.TRUE, true);
        TreeNode basicNode1 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.EMPGROUP.getCode(), CoordinationConfTypeEnums.EMPGROUP.getName(), Boolean.TRUE, false);
        TreeNode basicNode2 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.DEPENDENC.getCode(), CoordinationConfTypeEnums.DEPENDENC.getName(), Boolean.TRUE, false);
        TreeNode basicNode3 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.WORKPLACE.getCode(), CoordinationConfTypeEnums.WORKPLACE.getName(), Boolean.TRUE, false);
        TreeNode basicNode4 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.ATTTAG.getCode(), CoordinationConfTypeEnums.ATTTAG.getName(), Boolean.TRUE, false);
        basicNode.addChild(basicNode1);
        basicNode.addChild(basicNode2);
        basicNode.addChild(basicNode3);
        basicNode.addChild(basicNode4);
        TreeNode basicPlanNode = CoordinationConfTreeService.buildNode("basicPlan", ResManager.loadKDString((String)"\u57fa\u7840\u65b9\u6848", (String)"CoordinationConfTreeService_2", (String)"wtc-wtp-business", (Object[])new Object[0]), Boolean.TRUE, true);
        TreeNode basicPlanNode1 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.WS.getCode(), CoordinationConfTypeEnums.WS.getName(), Boolean.TRUE, false);
        TreeNode basicPlanNode2 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.PERIOD.getCode(), CoordinationConfTypeEnums.PERIOD.getName(), Boolean.TRUE, false);
        TreeNode basicPlanNode3 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.CARD.getCode(), CoordinationConfTypeEnums.CARD.getName(), Boolean.TRUE, false);
        TreeNode basicPlanNode4 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.MODE.getCode(), CoordinationConfTypeEnums.MODE.getName(), Boolean.TRUE, false);
        TreeNode basicPlanNode5 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.TZ.getCode(), CoordinationConfTypeEnums.TZ.getName(), Boolean.TRUE, false);
        basicPlanNode.addChild(basicPlanNode1);
        basicPlanNode.addChild(basicPlanNode2);
        basicPlanNode.addChild(basicPlanNode3);
        basicPlanNode.addChild(basicPlanNode4);
        basicPlanNode.addChild(basicPlanNode5);
        TreeNode rulePlanNode = CoordinationConfTreeService.buildNode("rulePlan", ResManager.loadKDString((String)"\u89c4\u5219\u65b9\u6848", (String)"CoordinationConfTreeService_3", (String)"wtc-wtp-business", (Object[])new Object[0]), Boolean.TRUE, true);
        TreeNode rulePlanNode1 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.VP.getCode(), CoordinationConfTypeEnums.VP.getName(), Boolean.TRUE, false);
        TreeNode rulePlanNode2 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.QT.getCode(), CoordinationConfTypeEnums.QT.getName(), Boolean.TRUE, false);
        TreeNode rulePlanNode3 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.TP.getCode(), CoordinationConfTypeEnums.TP.getName(), Boolean.TRUE, false);
        TreeNode rulePlanNode4 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.OTP.getCode(), CoordinationConfTypeEnums.OTP.getName(), Boolean.TRUE, false);
        TreeNode rulePlanNode5 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.EX.getCode(), CoordinationConfTypeEnums.EX.getName(), Boolean.TRUE, false);
        TreeNode rulePlanNode6 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.AD.getCode(), CoordinationConfTypeEnums.AD.getName(), Boolean.TRUE, false);
        TreeNode rulePlanNode7 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.IDP.getCode(), CoordinationConfTypeEnums.IDP.getName(), Boolean.TRUE, false);
        TreeNode rulePlanNode8 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.ATT.getCode(), CoordinationConfTypeEnums.ATT.getName(), Boolean.TRUE, false);
        TreeNode rulePlanNode10 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.SWSHIFT.getCode(), CoordinationConfTypeEnums.SWSHIFT.getName(), Boolean.TRUE, false);
        rulePlanNode.addChild(rulePlanNode1);
        rulePlanNode.addChild(rulePlanNode2);
        rulePlanNode.addChild(rulePlanNode3);
        rulePlanNode.addChild(rulePlanNode4);
        rulePlanNode.addChild(rulePlanNode5);
        rulePlanNode.addChild(rulePlanNode6);
        rulePlanNode.addChild(rulePlanNode7);
        rulePlanNode.addChild(rulePlanNode8);
        rulePlanNode.addChild(rulePlanNode10);
        if (WTCGrayscaleUtils.isFormulaOpen().booleanValue()) {
            TreeNode rulePlanNode9 = CoordinationConfTreeService.buildNode(CoordinationConfTypeEnums.FM.getCode(), CoordinationConfTypeEnums.FM.getName(), Boolean.TRUE, false);
            rulePlanNode.addChild(rulePlanNode9);
        }
        rootNode.addChild(basicNode);
        rootNode.addChild(basicPlanNode);
        rootNode.addChild(rulePlanNode);
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(1);
        nodes.add(rootNode);
        CoordinationConfTreeService.saveTreeNodesCache(nodes, view);
        treeView.addNodes(nodes);
        TreeNode firstTreeNode = (TreeNode)nodes.get(0);
        treeView.treeNodeClick(null, firstTreeNode.getId());
    }

    public static TreeNode buildNode(String id, String text, Boolean isOpen, boolean disabled) {
        TreeNode node = new TreeNode();
        node.setId(id);
        node.setText(text);
        node.setIsOpened(isOpen.booleanValue());
        node.setDisabled(disabled);
        node.setColor("#000000");
        return node;
    }
}

