/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.coordination;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCGrayscaleUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.coordination.wrapper.TranChangeWrapper;
import kd.wtc.wtp.common.kdstring.CoordinationKDString;
import kd.wtc.wtp.common.model.coordination.CoordinationConfigModel;
import kd.wtc.wtp.enums.coordination.CoordinationConfTypeEnums;

public class CoordinationService {
    private static final CoordinationService cs = new CoordinationService();
    private static final int SCENENUM = 17;
    private static final Log LOG = LogFactory.getLog(CoordinationService.class);
    private static Map<String, String> outParam2fileColumn = new HashMap<String, String>();
    private static HRBaseServiceHelper CONF_HELPER = new HRBaseServiceHelper("wtp_coordinationconf");
    private static List<Long> sceneIds = Arrays.stream(CoordinationConfTypeEnums.values()).filter(typeEnum -> WTCGrayscaleUtils.isFormulaOpen() != false || CoordinationConfTypeEnums.FM != typeEnum).map(CoordinationConfTypeEnums::getSceneId).collect(Collectors.toList());

    public static CoordinationService getInstance() {
        return cs;
    }

    public Map<String, Object> getCoordinationMatchRes(Long configId, Map<String, Object> paramMap, DynamicObject newAttFile) {
        HRBaseServiceHelper orgHelper = new HRBaseServiceHelper("bos_org");
        Object currentLogOrgId = paramMap.get("currentLogOrgId");
        DynamicObject dy = orgHelper.queryOne("number", currentLogOrgId);
        String orgNumber = dy == null ? "" : dy.getString("number");
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        DynamicObject configDynCheck = CONF_HELPER.queryOne("id", new QFilter[]{new QFilter("id", "=", (Object)configId)});
        if (configDynCheck == null) {
            throw new KDBizException(CoordinationKDString.coordinationConfDeleted());
        }
        DynamicObject configDyn = CONF_HELPER.loadSingle((Object)configId);
        DynamicObjectCollection entryentity = configDyn.getDynamicObjectCollection("entryentity");
        HashMap policyId2ColumnType = new HashMap(17);
        entryentity.forEach(dyn -> {
            if (WTCGrayscaleUtils.isFormulaOpen().booleanValue() || !CoordinationConfTypeEnums.FM.getCode().equals(dyn.getString("type"))) {
                policyId2ColumnType.put(dyn.getLong("policy"), dyn.getString("type"));
            }
        });
        HRBaseServiceHelper helperOfScene = new HRBaseServiceHelper("brm_scene");
        DynamicObject[] sceneDyns = helperOfScene.query("id,number", new QFilter[]{new QFilter("id", "in", sceneIds)});
        Map<Long, String> sceneId2Number = Arrays.stream(sceneDyns).collect(Collectors.groupingBy(dyn -> dyn.getLong("id"), Collectors.collectingAndThen(Collectors.toList(), value -> ((DynamicObject)value.get(0)).getString("number"))));
        HashMap<String, Object> column2Value = new HashMap<String, Object>();
        for (Map.Entry next : policyId2ColumnType.entrySet()) {
            Long policyId = (Long)next.getKey();
            if (policyId == 0L) continue;
            String sceneNumber = sceneId2Number.get(Objects.requireNonNull(CoordinationConfTypeEnums.getEnumByCode((String)((String)next.getValue()))).getSceneId());
            HashMap<String, Object> requestMap = new HashMap<String, Object>(5);
            requestMap.put("bizApp", "wtp");
            requestMap.put("sceneNumber", sceneNumber);
            requestMap.put("buNumber", orgNumber);
            ArrayList<Long> policyIds = new ArrayList<Long>(1);
            policyIds.add(policyId);
            requestMap.put("executePolicyIds", policyIds);
            requestMap.put("inputParams", paramMap);
            this.callRuleEngine(column2Value, requestMap, result);
        }
        column2Value.forEach((k, v) -> {
            if (k != null) {
                newAttFile.set(k, v);
            }
        });
        result.put("data", newAttFile);
        return result;
    }

    public void callRuleEngine(Map<String, Object> column2Value, Map<String, Object> requestMap, Map<String, Object> result) {
        Map responseMap = (Map)WTCServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"callRuleEngine", (Object[])new Object[]{requestMap});
        if (HRStringUtils.equals((String)String.valueOf(responseMap.get("responseCode")), (String)"200")) {
            List policyResults = (List)responseMap.get("policyResults");
            LOG.info("CoordinationService.callRuleEngine:sceneNumber={},policyId={},policyResults.size={}", new Object[]{requestMap.get("sceneNumber"), ((List)requestMap.get("executePolicyIds")).get(0), policyResults.size()});
            if (WTCCollections.isNotEmpty((Collection)policyResults)) {
                List ruleResults = (List)((Map)policyResults.get(0)).get("ruleResults");
                if (ruleResults != null && ruleResults.size() > 0) {
                    Map stringObjectMap = (Map)ruleResults.get(0);
                    this.putRes(column2Value, stringObjectMap);
                } else {
                    Map defaultResults = (Map)((Map)policyResults.get(0)).get("defaultResults");
                    defaultResults.forEach((key, value) -> column2Value.put(outParam2fileColumn.get(key), value));
                }
            }
        } else {
            throw new KDBizException(CoordinationKDString.callRuleEngineFailTips());
        }
        if (HRStringUtils.equals((String)"200", (String)String.valueOf(responseMap.get("responseCode")))) {
            result.put("responseCode", "200");
        }
        result.put("responseDesc", responseMap.get("responseDesc"));
    }

    private void putRes(Map<String, Object> column2Value, Map<String, Object> stringObjectMap) {
        Map matchResults = (Map)stringObjectMap.get("matchResults");
        matchResults.forEach((key, value) -> column2Value.put(outParam2fileColumn.get(key), value));
    }

    public Map<String, Set<String>> getSceneInputParam() {
        List sceneIds = Arrays.stream(CoordinationConfTypeEnums.values()).map(CoordinationConfTypeEnums::getSceneId).collect(Collectors.toList());
        sceneIds.removeIf(sceneId -> WTCGrayscaleUtils.isFormulaOpen() == false && CoordinationConfTypeEnums.FM.getSceneId().equals(sceneId));
        HashMap<String, Set<String>> res = new HashMap<String, Set<String>>(17);
        for (Long sceneId2 : sceneIds) {
            List response = (List)WTCServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMSceneParamService", (String)"getSceneInputParams", (Object[])new Object[]{sceneId2});
            for (Map map : response) {
                String number = (String)map.get("number");
                if (map.get("inputobject") != null && map.get("inputobject") instanceof DynamicObject) {
                    List inputdynprop = (List)map.get("inputdynprop");
                    Set propColumns = res.computeIfAbsent(number, e -> new HashSet());
                    for (Map prop : inputdynprop) {
                        propColumns.add(prop.get("number"));
                    }
                    res.put(number, propColumns);
                    continue;
                }
                res.put(number, new HashSet());
            }
        }
        LOG.info("CoordinationService.getSceneInputParam:{}", (Object)JSON.toJSONString(res));
        return res;
    }

    public Map<String, String> checkSchedule(long orgId, Map<String, Set<Long>> scheduleIdMap) {
        return Maps.newHashMapWithExpectedSize((int)0);
    }

    public void initNoMatchRules(DynamicObject newAttFile, TranChangeWrapper tranChangeWrapper) {
        DynamicObject dynamicObject = CONF_HELPER.loadSingle((Object)tranChangeWrapper.getConfigId());
        DynamicObjectCollection entryDys = dynamicObject.getDynamicObjectCollection("entryentity");
        Map<String, DynamicObject> map = entryDys.stream().collect(Collectors.toMap(entryDy -> entryDy.getString("type"), entryDy -> entryDy, (a, b) -> a));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("brm_policy_edit");
        Object[] array = entryDys.stream().map(entryDy -> entryDy.getLong("policy")).distinct().toArray();
        DynamicObject[] policyDys = helper.queryOriginalArray("id, retrundefault", new QFilter[]{new QFilter("id", "in", (Object)array)});
        Map<Long, Boolean> policyMap = Arrays.stream(policyDys).collect(Collectors.toMap(policyDy -> policyDy.getLong("id"), policyDy -> policyDy.getBoolean("retrundefault"), (a, b) -> a));
        ArrayList list = Lists.newArrayListWithExpectedSize((int)10);
        for (CoordinationConfTypeEnums typeEnums : CoordinationConfTypeEnums.values()) {
            CoordinationConfigModel model = new CoordinationConfigModel();
            model.setCoordinationConfTypeEnums(typeEnums);
            DynamicObject scheduleDy = map.get(typeEnums.getCode());
            if (scheduleDy != null) {
                String policyJson = scheduleDy.getString("policyjson");
                long policyId = scheduleDy.getLong("policy");
                if (HRStringUtils.isEmpty((String)policyJson) && policyId == 0L) {
                    if ("B".equals(scheduleDy.getString("nomatchrules"))) {
                        model.setSetEmpty(Boolean.TRUE);
                    } else {
                        model.setSetEmpty(Boolean.FALSE);
                    }
                } else {
                    Boolean defaultResultAp = HRStringUtils.isNotEmpty((String)policyJson) ? ((Map)JSON.parseObject((String)policyJson, Map.class)).get("defaultresultap") : policyMap.get(policyId);
                    String fieldStr = CoordinationConfTypeEnums.getRightDependencyFieldStr((String)typeEnums.getCode());
                    if (Boolean.TRUE.equals(defaultResultAp) || !ObjectUtils.isEmpty((Object)newAttFile.get(fieldStr))) {
                        model.setSetEmpty(null);
                    } else if ("B".equals(scheduleDy.getString("nomatchrules"))) {
                        model.setSetEmpty(Boolean.TRUE);
                    } else {
                        model.setSetEmpty(Boolean.FALSE);
                    }
                }
            } else {
                model.setSetEmpty(Boolean.FALSE);
            }
            list.add(model);
        }
        tranChangeWrapper.setCoordinationConfigModelList(list);
    }

    static {
        outParam2fileColumn.put("hbss_empgroup", "empgroup");
        outParam2fileColumn.put("bd_country", "dependency");
        outParam2fileColumn.put("hbss_workplace", "workplace");
        outParam2fileColumn.put("wtbd_attendtag", "atttag");
        outParam2fileColumn.put("wtbd_workschedule", AttFileScheduleEnum.WS.getKey());
        outParam2fileColumn.put("wtp_attperiod", "period");
        outParam2fileColumn.put("card", "card");
        outParam2fileColumn.put("mode", "mode");
        outParam2fileColumn.put("inte_timezone", AttFileScheduleEnum.TZ.getKey());
        outParam2fileColumn.put("wtp_vacationplan", AttFileScheduleEnum.VP.getKey());
        outParam2fileColumn.put("wtp_taplan", AttFileScheduleEnum.TP.getKey());
        outParam2fileColumn.put("wtp_otplan", AttFileScheduleEnum.OTP.getKey());
        outParam2fileColumn.put("wtp_suppleplan", AttFileScheduleEnum.AD.getKey());
        outParam2fileColumn.put("wtp_incdecplan", AttFileScheduleEnum.IDP.getKey());
        outParam2fileColumn.put("wtp_attendplan", AttFileScheduleEnum.ATT.getKey());
        outParam2fileColumn.put("wtp_qtscheme", AttFileScheduleEnum.QT.getKey());
        outParam2fileColumn.put("wtp_exscheme", AttFileScheduleEnum.EX.getKey());
        outParam2fileColumn.put("wtp_formulaplan", AttFileScheduleEnum.FM.getKey());
        outParam2fileColumn.put("wtp_swshiftplan", AttFileScheduleEnum.SWSHIFT.getKey());
    }
}

