/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.coordination;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.log.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtp.business.coordination.AfterCoordinationEvent;
import kd.sdk.wtc.wtp.business.coordination.BeforeCoordinationEvent;
import kd.sdk.wtc.wtp.business.coordination.CoordinationExecuteExtPlugin;
import kd.sdk.wtc.wtp.business.coordination.CoreCoordinationParam;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.web.DataBaseEditService;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.coordination.ICoordinationTask;
import kd.wtc.wtp.business.coordination.helper.CoordinationHelper;
import kd.wtc.wtp.business.coordination.wrapper.TranChangeWrapper;
import kd.wtc.wtp.common.kdstring.AttFileKDString;
import kd.wtc.wtp.common.kdstring.CoordinationKDString;
import kd.wtc.wtp.common.model.ResultMap;
import kd.wtc.wtp.common.model.coordination.CoordinationTaskResponse;
import kd.wtc.wtp.enums.coordination.CoordinationExecutionModeEnum;
import kd.wtc.wtp.enums.coordination.CoordinationExecutionStatusEnum;
import kd.wtc.wtp.enums.coordination.CoordinationTaskStatusEnum;
import kd.wtc.wtp.enums.coordination.SubscribeEnum;
import kd.wtc.wtp.enums.coordination.TaskCreateStatusEnum;

public class CoordinationTask
implements ICoordinationTask {
    private static final Log log = LogFactory.getLog(CoordinationTask.class);

    public static CoordinationTask getInstance() {
        return (CoordinationTask)WTCAppContextHelper.getBean(CoordinationTask.class);
    }

    @Override
    public CoordinationTaskResponse createTask(DynamicObject coordinationDy, boolean ifManual) {
        String executeMode;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_coordinationtask");
        CoordinationTaskResponse taskResponse = new CoordinationTaskResponse();
        QFilter qFilter = new QFilter("coordinationlog", "=", (Object)coordinationDy.getLong("id"));
        DynamicObject taskDy = helper.loadDynamicObject(qFilter);
        String string = executeMode = ifManual ? CoordinationExecutionModeEnum.MANUAL.getCode() : CoordinationExecutionModeEnum.AUTOMATIC.getCode();
        if (taskDy != null) {
            taskResponse.setTaskId(taskDy.getLong("id"));
            taskDy.set("executionstatus", (Object)CoordinationExecutionStatusEnum.EXECUTING.getCode());
            taskDy.set("taskstatus", (Object)CoordinationTaskStatusEnum.AVAILABLE.getCode());
            Date date = new Date();
            taskDy.set("executiondate", (Object)date);
            taskDy.set("taskrunmsg", null);
            taskDy.set("executionmode", (Object)executeMode);
            taskDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
            taskDy.set("modifytime", (Object)date);
            helper.updateOne(taskDy);
        } else {
            taskDy = helper.generateEmptyDynamicObject();
            this.genCoordinationTaskDy(taskDy, coordinationDy, taskResponse);
            taskDy.set("executionmode", (Object)executeMode);
            helper.saveOne(taskDy);
        }
        return taskResponse;
    }

    private void genCoordinationTaskDy(DynamicObject dy, DynamicObject coordinationDy, CoordinationTaskResponse taskResponse) {
        DynamicObject[] logDyArray;
        dy.set("number", (Object)taskResponse.getNumber());
        dy.set("coordinationlog", (Object)coordinationDy.getLong("id"));
        long orgId = coordinationDy.getLong("org");
        if (orgId == 0L) {
            throw new KDException(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e8b\u4ef6\u65e5\u5fd7\u4e2d\u672a\u83b7\u53d6\u5230\u8003\u52e4\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u751f\u6210\u4efb\u52a1\u3002", (String)"CoordinationTask_2", (String)"wtc-wtp-business", (Object[])new Object[0]));
        }
        dy.set("org", (Object)coordinationDy.getLong("org"));
        dy.set("name", (Object)ResManager.loadKDString((String)"%s\u4efb\u52a1", (String)"CoordinationTask_0", (String)"wtc-wtp-business", (Object[])new Object[]{coordinationDy.getLocaleString("name").getLocaleValue()}));
        dy.set("coordinationlogname", (Object)coordinationDy.getLocaleString("name"));
        String msgActionName = coordinationDy.getString("msgaction.name");
        if (HRStringUtils.isEmpty((String)msgActionName) && (logDyArray = (DynamicObject[])DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtis", (String)"ICoordinationService", (String)"load", (Object[])new Object[]{Collections.singletonList(coordinationDy.getLong("id"))})) != null && logDyArray.length > 0) {
            msgActionName = logDyArray[0].getString("msgaction.name");
        }
        dy.set("msgactionname", (Object)msgActionName);
        dy.set("executionstatus", (Object)CoordinationExecutionStatusEnum.EXECUTING.getCode());
        dy.set("executionmode", (Object)taskResponse.getExecutionMode());
        dy.set("taskstatus", (Object)CoordinationTaskStatusEnum.AVAILABLE.getCode());
        Date date = new Date();
        dy.set("executiondate", (Object)date);
        DataBaseEditService.setSysField((DynamicObject)dy, (Date)date);
        dy.set("id", (Object)taskResponse.getTaskId());
    }

    @Override
    public void beforeExecute(CoordinationTaskResponse taskResponse, DynamicObject logDynamicObject) {
        taskResponse.setMsgSubNo(logDynamicObject.getString("msgsubno"));
    }

    @Override
    public void execute(CoordinationTaskResponse taskResponse, DynamicObject logDynamicObject) {
        try {
            WTCPluginProxy coordinationExecuteExtPlugin;
            block24: {
                long msgCenterBoId = logDynamicObject.getLong("msgcenterbo_id");
                TranChangeWrapper tranChangeWrapper = (TranChangeWrapper)SerializationUtils.fromJsonString((String)logDynamicObject.getString("contextobject"), TranChangeWrapper.class);
                coordinationExecuteExtPlugin = WTCPluginProxyFactory.create(CoordinationExecuteExtPlugin.class, (String)"kd.sdk.wtc.wtp.business.coordination.CoordinationExecuteExtPlugin");
                if (coordinationExecuteExtPlugin.hasPlugin()) {
                    CoreCoordinationParam coreCoordinationParam = new CoreCoordinationParam(tranChangeWrapper.getConfigId(), tranChangeWrapper.getMsgSubNo(), tranChangeWrapper.getPersonId(), tranChangeWrapper.getEffectTime());
                    BeforeCoordinationEvent beforeCoordinationEvent = new BeforeCoordinationEvent(coreCoordinationParam, logDynamicObject, false);
                    coordinationExecuteExtPlugin.invokeReplace(plugin -> plugin.beforeExecuteCoordination(beforeCoordinationEvent));
                    if (beforeCoordinationEvent.isStopCoordination()) {
                        return;
                    }
                }
                try (DLock lock = DLock.create((String)("CoordinationTaskExecute" + msgCenterBoId));){
                    if (lock.tryLock()) {
                        ResultMap resultMap;
                        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_coordinationtask");
                        DynamicObject taskDy = helper.loadSingle((Object)taskResponse.getTaskId());
                        if (taskDy != null) {
                            String executionStatus = taskDy.getString("executionstatus");
                            if (!CoordinationExecutionStatusEnum.EXECUTING.getCode().equals(executionStatus) && !CoordinationExecutionStatusEnum.UNEXECUTED.getCode().equals(executionStatus)) {
                                log.warn("CoordinationTaskExecute Task has ended");
                                throw new KDBizException("Task has ended");
                            }
                        }
                        this.beforeExecute(taskResponse, logDynamicObject);
                        try {
                            resultMap = CoordinationHelper.getInstance().callCoordination(taskResponse, logDynamicObject);
                        }
                        catch (KDBizException kdBizException) {
                            resultMap = new ResultMap();
                            resultMap.setData((Object)CoordinationExecutionStatusEnum.EXEFAILED);
                            resultMap.setMessage(kdBizException.getMessage());
                        }
                        catch (Exception e) {
                            log.error("CoordinationTask execute error :", (Throwable)e);
                            resultMap = new ResultMap();
                            resultMap.setData((Object)CoordinationExecutionStatusEnum.EXEFAILED);
                            resultMap.setMessage(CoordinationKDString.sysUnKnowError());
                        }
                        this.afterExecute(taskResponse, (ResultMap<CoordinationExecutionStatusEnum>)resultMap);
                        break block24;
                    }
                    log.warn("CoordinationTaskExecute Task is running");
                    throw new KDBizException("Task is running");
                }
            }
            if (coordinationExecuteExtPlugin.hasPlugin()) {
                coordinationExecuteExtPlugin.invokeReplace(plugin -> plugin.afterExecuteCoordination(new AfterCoordinationEvent(taskResponse.getCoreCoordinationParam(), logDynamicObject, taskResponse.getSuccessPkIdMap())));
            }
        }
        catch (Exception exception) {
            log.warn("kd.wtc.wtp.business.coordination.CoordinationTask.execute error", (Throwable)exception);
            HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_coordinationtask");
            DynamicObject taskDy = helper.loadSingle((Object)taskResponse.getTaskId());
            if (CoordinationExecutionStatusEnum.EXECUTING.getCode().equals(taskDy.getString("executionstatus"))) {
                taskDy.set("executionstatus", (Object)CoordinationExecutionStatusEnum.EXEFAILED.getCode());
                taskDy.set("taskrunmsg", (Object)CoordinationKDString.sysUnKnowError());
                helper.updateOne(taskDy);
            }
            throw new KDBizException(CoordinationKDString.sysUnKnowError());
        }
    }

    @Override
    public void afterExecute(CoordinationTaskResponse taskResponse, ResultMap<CoordinationExecutionStatusEnum> resultMap) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_coordinationtask");
        DynamicObject taskDy = helper.loadSingle((Object)taskResponse.getTaskId());
        CoordinationExecutionStatusEnum executionStatusEnum = (CoordinationExecutionStatusEnum)resultMap.getData();
        if (CoordinationExecutionStatusEnum.EXEFAILED == executionStatusEnum) {
            taskDy.set("taskrunmsg", (Object)resultMap.getMessage());
            taskResponse.setTaskMsg(resultMap.getMessage());
        }
        if (CoordinationExecutionStatusEnum.EXESUCCESS == executionStatusEnum) {
            taskDy.set("taskrunmsg", null);
            String msg = "";
            if (WTCStringUtils.isNotEmpty((String)taskResponse.getTipsMsg())) {
                msg = resultMap.getMessage();
            }
            if (SubscribeEnum.RESIGN.getCode().equals(taskResponse.getMsgSubNo())) {
                msg = msg + AttFileKDString.getStopAttendanceSuccessTips();
            }
            taskDy.set("taskrunmsg", (Object)msg);
        }
        taskDy.set("executionstatus", (Object)executionStatusEnum.getCode());
        taskResponse.setExecutionStatus(executionStatusEnum.getCode());
        helper.updateOne(taskDy);
    }

    @Override
    public void discardTask(List<Object> taskIds) {
        DynamicObject[] logDyArray;
        HRBaseServiceHelper taskHelper = new HRBaseServiceHelper("wtp_coordinationtask");
        DynamicObject[] taskDys = taskHelper.loadDynamicObjectArray(taskIds.toArray());
        Arrays.stream(taskDys).forEach(taskDy -> taskDy.set("taskstatus", (Object)CoordinationTaskStatusEnum.DISCARD.getCode()));
        taskHelper.update(taskDys);
        List logIds = Arrays.stream(taskDys).map(taskDy -> taskDy.getLong("coordinationlog")).collect(Collectors.toList());
        for (DynamicObject logDy : logDyArray = (DynamicObject[])DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtis", (String)"ICoordinationService", (String)"load", (Object[])new Object[]{logIds})) {
            logDy.set("taskcreatestatus", (Object)TaskCreateStatusEnum.TOBE_CREATE.getCode());
            logDy.set("org", null);
            logDy.set("contextobject", null);
        }
        DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtis", (String)"ICoordinationService", (String)"update", (Object[])new Object[]{Arrays.asList(logDyArray)});
    }
}

