/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.coordination.execute;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtp.business.coordination.CoordinationExecuteExtPlugin;
import kd.sdk.wtc.wtp.business.coordination.CoreCoordinationParam;
import kd.sdk.wtc.wtp.business.coordination.ExecutingCoordinationEvent;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.history.service.WTCCommonHisService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.business.attfile.AttFileServiceImpl;
import kd.wtc.wtp.business.attfile.schedule.AttFileScheduleBusiness;
import kd.wtc.wtp.business.coordination.wrapper.TranChangeWrapper;
import kd.wtc.wtp.common.model.coordination.CoordinationConfigModel;
import kd.wtc.wtp.enums.coordination.CoordinationConfTypeEnums;
import kd.wtc.wtp.enums.coordination.SubscribeEnum;

public class CoordinationOperateExecutor {
    private static final Log LOGGER = LogFactory.getLog(CoordinationOperateExecutor.class);

    public static CoordinationOperateExecutor getInstance() {
        return (CoordinationOperateExecutor)WTCAppContextHelper.getBean(CoordinationOperateExecutor.class);
    }

    public OperationResult addAttFile(List<DynamicObject> attFileDyList, List<CoordinationConfigModel> coordinationConfigModelList) {
        return this.addAttFile(attFileDyList, null, null);
    }

    public OperationResult addAttFile(List<DynamicObject> attFileDyList, DynamicObject messageDy, TranChangeWrapper tranChangeWrapper) {
        Date maxEndDate = WTCHisServiceHelper.getMaxEndDate();
        for (DynamicObject attFileSetEffStartDate : attFileDyList) {
            attFileSetEffStartDate.set("bsled", (Object)maxEndDate);
            if (attFileSetEffStartDate.getDate("startdate") == null) continue;
            attFileSetEffStartDate.set("bsed", (Object)attFileSetEffStartDate.getDate("startdate"));
        }
        if (LOGGER.isInfoEnabled() && WTCCollections.isNotEmpty(attFileDyList) && null != attFileDyList.get(0)) {
            DynamicObject dyLog = attFileDyList.get(0);
            AttFileHelper.logAttFileField(dyLog, "addAttFile", LOGGER);
        }
        long personId = this.getPersonId(attFileDyList);
        Set employeeIdSet = attFileDyList.stream().map(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"employee")).collect(Collectors.toSet());
        Optional<Date> min = attFileDyList.stream().map(d -> d.getDate("bsed")).min(Date::compareTo);
        Date startQuery = min.orElseGet(WTCHisServiceHelper::getMinEndDate);
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setEmpPersonSetIds(employeeIdSet);
        attFileQueryParam.setqFilter(new QFilter("bsed", ">", (Object)startQuery));
        Map<Long, List<DynamicObject>> existFileEmployeeMap = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().collect(Collectors.groupingBy(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"employee")));
        Throwable throwable = null;
        try (DLock lock = DLock.create((String)this.getLockKey(personId));){
            if (lock.tryLock(60000L)) {
                OperationResult addAttFileOperationResult;
                try (TXHandle required = TX.requiresNew();){
                    try {
                        addAttFileOperationResult = this.getAddAttFileOperationResult(attFileDyList, messageDy, tranChangeWrapper);
                    }
                    catch (Exception exception) {
                        LOGGER.error((Throwable)exception);
                        required.markRollback();
                        throw new KDBizException("CoordinationOperate addAttFile Error");
                    }
                }
                List successPkIds = addAttFileOperationResult.getSuccessPkIds();
                if (WTCCollections.isNotEmpty((Collection)successPkIds)) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("addAttFile successPkIds {}", (Object)JSON.toJSONString((Object)successPkIds));
                    }
                    Set saveSuccessFileBoId = successPkIds.stream().map(Long.class::cast).collect(Collectors.toSet());
                    AttFileQueryParam attFileQueryParamNewBo = new AttFileQueryParam();
                    attFileQueryParamNewBo.setSetBoIds(saveSuccessFileBoId);
                    attFileQueryParamNewBo.setAuthCheck(Boolean.FALSE);
                    List saveSuccessFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParamNewBo);
                    if (WTCCollections.isNotEmpty(existFileEmployeeMap)) {
                        Set hisIgnoreKeysSet = WTCHisServiceHelper.getHisIgnoreKeysSet();
                        hisIgnoreKeysSet.add("boid");
                        hisIgnoreKeysSet.add("org");
                        hisIgnoreKeysSet.add("number");
                        hisIgnoreKeysSet.add("startdate");
                        for (DynamicObject saveSuccessFile : saveSuccessFileList) {
                            List needExtendFileCollect;
                            long employeeId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)saveSuccessFile, (String)"employee");
                            Date saveSuccessFileStartDate = saveSuccessFile.getDate("bsed");
                            DynamicObject saveSuccessFileCopy = HRBaseServiceHelper.create((String)"wtp_attfilebase").generateEmptyDynamicObject();
                            HRDynamicObjectUtils.copy((DynamicObject)saveSuccessFile, (DynamicObject)saveSuccessFileCopy);
                            List<DynamicObject> existOtherBoFileList = existFileEmployeeMap.get(employeeId);
                            if (!WTCCollections.isNotEmpty(existOtherBoFileList) || !WTCCollections.isNotEmpty(needExtendFileCollect = existOtherBoFileList.stream().filter(d -> d.getDate("bsed").after(saveSuccessFileStartDate)).sorted(Comparator.comparing(d -> d.getDate("bsed"))).collect(Collectors.toList()))) continue;
                            Object orgObj = saveSuccessFile.get("org");
                            for (DynamicObject dynamicObject : needExtendFileCollect) {
                                if (SubscribeEnum.BECOME_FORMAL.getCode().equals(dynamicObject.getString("sourcetype"))) {
                                    this.reSetEmpPosOrgRelData(saveSuccessFileCopy, dynamicObject);
                                }
                                HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)saveSuccessFile, (Set)hisIgnoreKeysSet);
                                saveSuccessFile.set("org", orgObj);
                                OperateOption fileUpdateOperateOption = this.getIgnoreWarnOperateOption();
                                fileUpdateOperateOption.setVariableValue("synFileVid", "false");
                                OperationResult operationResult = this.executeCoordinationOp(tranChangeWrapper, messageDy, new ArrayList<DynamicObject>(Collections.singletonList(saveSuccessFile)), fileUpdateOperateOption, "file_modify", "wtp_attfilebase");
                                if (operationResult == null || operationResult.isSuccess() || !LOGGER.isInfoEnabled()) continue;
                                LOGGER.info("addAttFile modify fail", (Object)operationResult.toString());
                            }
                        }
                    }
                }
                var16_16 = addAttFileOperationResult;
                return var16_16;
            }
            try {
                LOGGER.warn("CoordinationOperate addAttFile  can not get lock");
                throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u4eba\u5df2\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u5176\u4ed6\u534f\u540c\u4efb\u52a1\u3002", (String)"CoordinationOperateExecutor_0", (String)"wtc-wtp-business", (Object[])new Object[0]));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private OperationResult getAddAttFileOperationResult(List<DynamicObject> attFileDyList, DynamicObject messageDy, TranChangeWrapper tranChangeWrapper) {
        List<Object> coordinationConfigModelList = tranChangeWrapper == null ? Lists.newArrayListWithExpectedSize((int)10) : tranChangeWrapper.getCoordinationConfigModelList();
        HashMap scheduleEnumFileBoSchDyMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap handlerSchDyMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<Long, Long> attFileExistMap = this.getLastFileBoSchDyMap(attFileDyList, (List<CoordinationConfigModel>)coordinationConfigModelList, scheduleEnumFileBoSchDyMap);
        for (CoordinationConfigModel coordinationConfigModel : coordinationConfigModelList) {
            Boolean setEmpty = coordinationConfigModel.getSetEmpty();
            CoordinationConfTypeEnums coordinationConfTypeEnums = coordinationConfigModel.getCoordinationConfTypeEnums();
            AttFileScheduleEnum attFileScheduleEnum = AttFileScheduleEnum.getAttFileScheduleEnumByKey((String)coordinationConfTypeEnums.getCode());
            if (attFileScheduleEnum == null) continue;
            String schKey = attFileScheduleEnum.getKey();
            if (setEmpty == null || setEmpty.booleanValue()) continue;
            HashMap personSchDyMap = Maps.newHashMapWithExpectedSize((int)16);
            this.putPersonSchDyMap(attFileDyList, scheduleEnumFileBoSchDyMap, attFileExistMap, attFileScheduleEnum, schKey, personSchDyMap);
            if (!WTCCollections.isNotEmpty((Map)personSchDyMap)) continue;
            handlerSchDyMap.put(attFileScheduleEnum, personSchDyMap);
        }
        OperateOption ignoreWarnOperateOption = this.getIgnoreWarnOperateOption();
        long l = ID.genLongId();
        ignoreWarnOperateOption.setVariableValue("event", String.valueOf(l));
        String opTips = WTCStringUtils.isEmpty((String)attFileDyList.get(0).getString("sourcetype")) ? "sourcetype" : attFileDyList.get(0).getString("sourcetype");
        ignoreWarnOperateOption.setVariableValue("sourcetype", opTips);
        OperationResult operationResult = this.executeCoordinationOp(tranChangeWrapper, messageDy, attFileDyList, ignoreWarnOperateOption, "save", "wtp_attfilebase");
        LOGGER.info("CoordinationOperateExecute.addAttFile OperationResult {}", (Object)operationResult.toString());
        boolean rosterSynErrCode = "E2001".equals(ignoreWarnOperateOption.getVariables().get("E2001"));
        if (rosterSynErrCode) {
            operationResult.setSponsor("E2001");
        }
        if (!operationResult.isSuccess() && !rosterSynErrCode) {
            return operationResult;
        }
        HashMap addSchDyMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<Long, DynamicObject> hasSaveFileDyMap = this.getHasSaveFileDyMap(operationResult);
        for (Map.Entry enMapEntry : handlerSchDyMap.entrySet()) {
            Map value = (Map)enMapEntry.getValue();
            AttFileScheduleEnum attFileScheduleEnum = (AttFileScheduleEnum)enMapEntry.getKey();
            for (Map.Entry<Long, List<DynamicObject>> entry : value.entrySet()) {
                Long key = (Long)entry.getKey();
                DynamicObject hasSaveFileDy = hasSaveFileDyMap.get(key);
                if (hasSaveFileDy == null) continue;
                this.reSetSchFileData(addSchDyMap, attFileScheduleEnum, entry, hasSaveFileDy);
            }
        }
        for (Map.Entry entries : addSchDyMap.entrySet()) {
            AttFileScheduleEnum key = (AttFileScheduleEnum)entries.getKey();
            List value = (List)entries.getValue();
            WTCCommonHisService.saveNotTimeHisModelData((List)value, null, (String)key.getPageId(), (Long)l);
        }
        return operationResult;
    }

    private void reSetSchFileData(Map<AttFileScheduleEnum, List<DynamicObject>> addSchDyMap, AttFileScheduleEnum attFileScheduleEnum, Map.Entry<Long, List<DynamicObject>> entry, DynamicObject hasSaveFileDy) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtp_attfilebase");
        DynamicObject fileDyBo = hrBaseServiceHelper.generateEmptyDynamicObject();
        DynamicObject fileDyVersion = hrBaseServiceHelper.generateEmptyDynamicObject();
        for (DynamicObject schDy : entry.getValue()) {
            long baseDataId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)hasSaveFileDy, (String)"org");
            AttFileScheduleBusiness.setOrgDy(baseDataId, schDy);
            fileDyBo.set("id", (Object)hasSaveFileDy.getLong("boid"));
            fileDyVersion.set("id", (Object)hasSaveFileDy.getLong("id"));
            schDy.set("attfileid", (Object)fileDyBo);
            schDy.set("attfilevid", (Object)fileDyVersion);
            schDy.set("attendstatus", (Object)hasSaveFileDy.getString("atttag.attendstatus"));
            List dynamicObjects = addSchDyMap.computeIfAbsent(attFileScheduleEnum, val -> Lists.newArrayListWithExpectedSize((int)10));
            dynamicObjects.add(schDy);
        }
    }

    private Map<Long, DynamicObject> getHasSaveFileDyMap(OperationResult operationResult) {
        List successPkIds = operationResult.getSuccessPkIds();
        AttFileQueryParam hasSaveFileQueryParam = new AttFileQueryParam(false);
        hasSaveFileQueryParam.setProperties("id,boid,person,person.id,org,org.id,atttag,atttag.attendstatus");
        hasSaveFileQueryParam.setSetBoIds(successPkIds.stream().map(Long.class::cast).collect(Collectors.toSet()));
        hasSaveFileQueryParam.setBeCurrent(Boolean.TRUE);
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(hasSaveFileQueryParam).stream().collect(Collectors.toMap(d -> d.getLong("person.id"), Function.identity(), (a, b) -> a));
    }

    private void putPersonSchDyMap(List<DynamicObject> attFileDyList, Map<AttFileScheduleEnum, Map<Long, List<DynamicObject>>> scheduleEnumFileBoSchDyMap, Map<Long, Long> attFileExistMap, AttFileScheduleEnum attFileScheduleEnum, String schKey, Map<Long, List<DynamicObject>> personSchDyMap) {
        for (DynamicObject fileDy : attFileDyList) {
            List<DynamicObject> lastFileSchDyList = this.getLastFileSchDyList(attFileExistMap, scheduleEnumFileBoSchDyMap, attFileScheduleEnum, fileDy);
            if (!WTCCollections.isNotEmpty(lastFileSchDyList) || null == fileDy.getDate("bsed")) continue;
            Date effStartDate = fileDy.getDate("startdate");
            if (attFileScheduleEnum.isTimeHis()) {
                Optional<DynamicObject> any = lastFileSchDyList.stream().filter(d -> d.getDate("bsed").compareTo(effStartDate) <= 0 && d.getDate("bsled").compareTo(effStartDate) >= 0).findAny();
                if (!any.isPresent()) continue;
                DynamicObject timeSchDy = any.get();
                this.setFileSchDyValue(schKey, fileDy, timeSchDy);
                continue;
            }
            List handlerSchNotTimeDyList = lastFileSchDyList.stream().filter(d -> d.getDate("enddate").compareTo(effStartDate) >= 0).collect(Collectors.toList());
            if (!WTCCollections.isNotEmpty(handlerSchNotTimeDyList)) continue;
            fileDy.set(schKey, null);
            ArrayList updateSchDyList = Lists.newArrayListWithExpectedSize((int)handlerSchNotTimeDyList.size());
            for (DynamicObject handlerSchNotTimeDy : handlerSchNotTimeDyList) {
                DynamicObject scheduleDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)attFileScheduleEnum.getPageId()));
                if (handlerSchNotTimeDy.getDate("startdate").compareTo(effStartDate) < 0) {
                    handlerSchNotTimeDy.set("startdate", (Object)effStartDate);
                }
                Set hisIgnoreKeysSet = WTCHisServiceHelper.getHisIgnoreKeysSet();
                hisIgnoreKeysSet.add("sourcevid");
                hisIgnoreKeysSet.add("boid");
                HRDynamicObjectUtils.copy((DynamicObject)handlerSchNotTimeDy, (DynamicObject)scheduleDy, (Set)hisIgnoreKeysSet);
                scheduleDy.set("iscurrentversion", (Object)true);
                updateSchDyList.add(scheduleDy);
            }
            if (!WTCCollections.isNotEmpty((Collection)updateSchDyList)) continue;
            personSchDyMap.put(fileDy.getLong("person.id"), updateSchDyList);
        }
    }

    private Map<Long, Long> getLastFileBoSchDyMap(List<DynamicObject> attFileDyList, List<CoordinationConfigModel> coordinationConfigModelList, Map<AttFileScheduleEnum, Map<Long, List<DynamicObject>>> scheduleEnumFileBoSchDyMap) {
        Set employeeSetIds = attFileDyList.stream().filter(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"person") != 0L).map(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"employee")).collect(Collectors.toSet());
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setEmpPersonSetIds(employeeSetIds);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setProperties("id,boid,person,person.id,startdate");
        Map<Long, Long> attFileExistMap = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().sorted(Comparator.comparing(file -> file.getDate("startdate"))).collect(Collectors.toMap(d -> d.getLong("person.id"), d -> d.getLong("boid"), (a, b) -> b));
        if (WTCCollections.isEmpty(attFileExistMap)) {
            return attFileExistMap;
        }
        AttFileScheduleQueryParam attFileScheduleQueryParam = new AttFileScheduleQueryParam();
        attFileScheduleQueryParam.setLoad(Boolean.TRUE);
        attFileScheduleQueryParam.setFileBoIdSet(new HashSet<Long>(attFileExistMap.values()));
        for (CoordinationConfigModel coordinationConfigModel : coordinationConfigModelList) {
            Boolean setEmpty = coordinationConfigModel.getSetEmpty();
            if (setEmpty == null || setEmpty.booleanValue()) continue;
            CoordinationConfTypeEnums coordinationConfTypeEnums = coordinationConfigModel.getCoordinationConfTypeEnums();
            AttFileScheduleEnum attFileScheduleEnum = AttFileScheduleEnum.getAttFileScheduleEnumByKey((String)coordinationConfTypeEnums.getCode());
            Map fileBoSchDyMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(attFileScheduleEnum, attFileScheduleQueryParam);
            if (!WTCCollections.isNotEmpty((Map)fileBoSchDyMap)) continue;
            scheduleEnumFileBoSchDyMap.put(attFileScheduleEnum, fileBoSchDyMap);
        }
        return attFileExistMap;
    }

    private void setFileSchDyValue(String schKey, DynamicObject fileDy, DynamicObject timeSchDy) {
        if ((fileDy.get(schKey) == null || this.strIsNull(schKey, fileDy)) && timeSchDy.get(schKey) != null) {
            fileDy.set(schKey, timeSchDy.get(schKey));
        }
    }

    private boolean strIsNull(String schKey, DynamicObject fileDy) {
        return fileDy.get(schKey) instanceof String && WTCStringUtils.isEmpty((String)fileDy.getString(schKey));
    }

    private List<DynamicObject> getLastFileSchDyList(Map<Long, Long> attFileExistMap, Map<AttFileScheduleEnum, Map<Long, List<DynamicObject>>> scheduleEnumFileBoSchDyMap, AttFileScheduleEnum attFileScheduleEnum, DynamicObject fileDy) {
        List<DynamicObject> schDyList;
        Long lastFileBoId = attFileExistMap.get(fileDy.getLong("person.id"));
        Map<Long, List<DynamicObject>> fileBoSchDyMap = scheduleEnumFileBoSchDyMap.get(attFileScheduleEnum);
        if (WTCCollections.isNotEmpty(fileBoSchDyMap) && WTCCollections.isNotEmpty(schDyList = fileBoSchDyMap.get(lastFileBoId))) {
            return schDyList;
        }
        return Collections.emptyList();
    }

    public OperateOption getIgnoreWarnOperateOption() {
        OperateOption ignoreWarnOperateOption = OperateOption.create();
        ignoreWarnOperateOption.setVariableValue("ignorewarn", "true");
        ignoreWarnOperateOption.setVariableValue("ishasright", "true");
        ignoreWarnOperateOption.setVariableValue("fromcoordination", "fromcoordination");
        return ignoreWarnOperateOption;
    }

    private List<DynamicObject> getUpdateAttFileCurrentData(List<DynamicObject> dyList) {
        if (WTCCollections.isNotEmpty(dyList)) {
            AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
            attFileQueryParam.setBeCurrent(Boolean.TRUE);
            attFileQueryParam.setSetBoIds(dyList.stream().map(d -> d.getLong("boid")).collect(Collectors.toSet()));
            Map collect = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().collect(Collectors.toMap(d -> d.getLong("boid"), Function.identity()));
            ArrayList hisCurrentData = Lists.newArrayListWithExpectedSize((int)collect.size());
            for (DynamicObject dynamicObject : dyList) {
                DynamicObject currentDy = (DynamicObject)collect.get(dynamicObject.getLong("boid"));
                if (currentDy == null) continue;
                HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)currentDy, (Set)WTCHisServiceHelper.getHisIgnoreKeysSet());
                hisCurrentData.add(currentDy);
            }
            return hisCurrentData;
        }
        return Collections.emptyList();
    }

    public OperationResult discardAttFile(DynamicObject dy, TranChangeWrapper tranChangeWrapper, List<DynamicObject> dyList) {
        if (kd.bos.util.CollectionUtils.isEmpty(dyList)) {
            OperationResult operationResult = new OperationResult();
            operationResult.setSuccess(false);
            return operationResult;
        }
        OperateOption operateOption = this.getIgnoreWarnOperateOption();
        operateOption.setVariableValue("ishasright", "true");
        operateOption.setVariableValue("fromcoordination", "fromcoordination");
        OperationResult operationResult = dy == null || tranChangeWrapper == null ? OperationServiceHelper.executeOperate((String)"discard", (String)"wtp_attfilebase", (DynamicObject[])dyList.toArray(new DynamicObject[0]), (OperateOption)operateOption) : CoordinationOperateExecutor.getInstance().executeCoordinationOp(tranChangeWrapper, dy, dyList, operateOption, "discard", "wtp_attfilebase");
        if (operationResult != null && !operationResult.isSuccess()) {
            LOGGER.info("CoordinationOperateExecute.discardAttFile OperationResult {}", (Object)operationResult.toString());
        }
        return operationResult;
    }

    @Deprecated
    public OperationResult discardAttFile(List<DynamicObject> dyList) {
        return this.discardAttFile(null, null, dyList);
    }

    public OperationResult updateAttFileAndSch(List<DynamicObject> dyList, List<CoordinationConfigModel> coordinationConfigModelList) {
        return this.updateAttFileAndSch(dyList, null, null);
    }

    /*
     * Exception decompiling
     */
    public OperationResult updateAttFileAndSch(List<DynamicObject> dyList, DynamicObject messageDy, TranChangeWrapper tranChangeWrapper) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private OperationResult getUpdateAttFileAndSchOperationResult(DynamicObject messageDy, TranChangeWrapper tranChangeWrapper, List<DynamicObject> updateAttFileCurrentData, TXHandle required) {
        OperationResult operationResult;
        List<Object> coordinationConfigModelList = tranChangeWrapper == null ? Lists.newArrayListWithExpectedSize((int)10) : tranChangeWrapper.getCoordinationConfigModelList();
        OperateOption fileUpdateOperateOption = this.getIgnoreWarnOperateOption();
        fileUpdateOperateOption.setVariableValue("synFileVid", "false");
        Optional<Date> min = updateAttFileCurrentData.stream().map(d -> d.getDate("bsed")).min(Date::compareTo);
        Set fileBoIdSet = updateAttFileCurrentData.stream().map(d -> d.getLong("boid")).collect(Collectors.toSet());
        Date startQuery = min.orElseGet(WTCHisServiceHelper::getMinEndDate);
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setSetBoIds(fileBoIdSet);
        attFileQueryParam.setqFilter(new QFilter("bsed", ">", (Object)startQuery));
        Map<Long, List<DynamicObject>> existFileMap = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().collect(Collectors.groupingBy(d -> d.getLong("boid")));
        ArrayList needReviseFileList = Lists.newArrayListWithExpectedSize((int)updateAttFileCurrentData.size());
        if (WTCCollections.isNotEmpty(existFileMap)) {
            for (DynamicObject updateAttFileCurrentDatum : updateAttFileCurrentData) {
                List collect;
                long fileBoId = updateAttFileCurrentDatum.getLong("boid");
                Date updateAttFileCurrentStartDate = updateAttFileCurrentDatum.getDate("bsed");
                List<DynamicObject> existFileList = existFileMap.get(fileBoId);
                if (!WTCCollections.isNotEmpty(existFileList) || !WTCCollections.isNotEmpty(collect = existFileList.stream().filter(d -> d.getDate("bsed").after(updateAttFileCurrentStartDate)).sorted(Comparator.comparing(d -> d.getDate("bsed"))).collect(Collectors.toList()))) continue;
                List needRevise = collect.stream().filter(d -> SubscribeEnum.BECOME_FORMAL.getCode().equals(d.getString("sourcetype"))).collect(Collectors.toList());
                if (WTCCollections.isNotEmpty(needRevise)) {
                    for (DynamicObject needReviseFile : needRevise) {
                        this.reSetEmpPosOrgRelData(updateAttFileCurrentDatum, needReviseFile);
                    }
                    needReviseFileList.addAll(needRevise);
                }
                Date date = ((DynamicObject)collect.get(0)).getDate("bsed");
                updateAttFileCurrentDatum.set("bsled", (Object)WTCDateUtils.getZeroDate((Date)WTCDateUtils.addDays((Date)date, (int)-1)));
            }
        }
        if (!(operationResult = this.executeCoordinationOp(tranChangeWrapper, messageDy, updateAttFileCurrentData, fileUpdateOperateOption, "file_modify", "wtp_attfilebase")).isSuccess()) {
            LOGGER.info("CoordinationOperateExecute.updateAttFileAndSch OperationResult {}", (Object)operationResult.toString());
            return operationResult;
        }
        if (WTCCollections.isNotEmpty((Collection)needReviseFileList)) {
            AttFileServiceImpl.getInstance().attFileRevise(needReviseFileList.toArray(new DynamicObject[0]));
        }
        ArrayList schBaseAddDyList = Lists.newArrayListWithExpectedSize((int)updateAttFileCurrentData.size());
        ArrayList schBaseUpdateDyList = Lists.newArrayListWithExpectedSize((int)updateAttFileCurrentData.size());
        ArrayList schRuleAddDyList = Lists.newArrayListWithExpectedSize((int)updateAttFileCurrentData.size());
        ArrayList schRuleUpdateDyList = Lists.newArrayListWithExpectedSize((int)updateAttFileCurrentData.size());
        ArrayList cardAddDyList = Lists.newArrayListWithExpectedSize((int)updateAttFileCurrentData.size());
        ArrayList cardUpdateDyList = Lists.newArrayListWithExpectedSize((int)updateAttFileCurrentData.size());
        ArrayList schRuleInvalidDyList = Lists.newArrayListWithExpectedSize((int)updateAttFileCurrentData.size());
        this.getHandlerData(coordinationConfigModelList, updateAttFileCurrentData, schBaseAddDyList, schBaseUpdateDyList, schRuleAddDyList, schRuleUpdateDyList, cardAddDyList, cardUpdateDyList, schRuleInvalidDyList);
        ArrayList addDyList = Lists.newArrayListWithExpectedSize((int)updateAttFileCurrentData.size());
        ArrayList updateDyList = Lists.newArrayListWithExpectedSize((int)updateAttFileCurrentData.size());
        addDyList.addAll(schBaseAddDyList);
        addDyList.addAll(schRuleAddDyList);
        addDyList.addAll(cardAddDyList);
        updateDyList.addAll(schRuleUpdateDyList);
        updateDyList.addAll(cardUpdateDyList);
        long eventId = ID.genLongId();
        OperationResult baseUpdateOperationResult = this.getAddUpdateOperationResult(tranChangeWrapper, messageDy, eventId, schBaseUpdateDyList, "false", null, "false");
        if (baseUpdateOperationResult != null) {
            required.markRollback();
            return baseUpdateOperationResult;
        }
        OperationResult invalidOperationResult = this.getAddUpdateOperationResult(tranChangeWrapper, messageDy, eventId, schRuleInvalidDyList, "true", "invalid", null);
        if (invalidOperationResult != null) {
            required.markRollback();
            return invalidOperationResult;
        }
        OperationResult updateOperationResult = this.getAddUpdateOperationResult(tranChangeWrapper, messageDy, eventId, updateDyList, "false", null, "false");
        if (updateOperationResult != null) {
            required.markRollback();
            return updateOperationResult;
        }
        OperationResult addOperationResult = this.getAddUpdateOperationResult(tranChangeWrapper, messageDy, eventId, addDyList, "true", null, "true");
        if (addOperationResult != null) {
            required.markRollback();
            return addOperationResult;
        }
        return operationResult;
    }

    private void reSetEmpPosOrgRelData(DynamicObject updateAttFileCurrentDatum, DynamicObject needReviseFile) {
        needReviseFile.set("position", updateAttFileCurrentDatum.get("position"));
        needReviseFile.set("adminorg", updateAttFileCurrentDatum.get("adminorg"));
        needReviseFile.set("company", updateAttFileCurrentDatum.get("company"));
        needReviseFile.set("job", updateAttFileCurrentDatum.get("job"));
        needReviseFile.set("workplace", updateAttFileCurrentDatum.get("workplace"));
        needReviseFile.set("managingscope", updateAttFileCurrentDatum.get("managingscope"));
        needReviseFile.set("agreedlocation", updateAttFileCurrentDatum.get("agreedlocation"));
        needReviseFile.set("empposorgrel", updateAttFileCurrentDatum.get("empposorgrel"));
        needReviseFile.set("cmpemp", updateAttFileCurrentDatum.get("cmpemp"));
        needReviseFile.set("depemp", updateAttFileCurrentDatum.get("depemp"));
    }

    private String getLockKey(long personId) {
        return WTCStringUtils.joinStr((String[])new String[]{"wtc", "_", "wtp", "_", "CoordinationOperateExecutor_", String.valueOf(personId)});
    }

    private long getPersonId(List<DynamicObject> dyList) {
        if (WTCCollections.isEmpty(dyList)) {
            return 0L;
        }
        DynamicObject dynamicObject = dyList.get(0);
        if (dynamicObject == null) {
            return 0L;
        }
        return dynamicObject.getLong("person.id");
    }

    private OperationResult getAddUpdateOperationResult(TranChangeWrapper tranChangeWrapper, DynamicObject messageDy, long eventId, List<DynamicObject> opDyList, String sign, String op, String synFileVid) {
        for (DynamicObject dynamicObject : opDyList) {
            AttFileScheduleEnum attFileScheduleEnum;
            OperateOption operateOption = this.getIgnoreWarnOperateOption();
            if (HRStringUtils.isNotEmpty((String)synFileVid)) {
                operateOption.setVariableValue("synFileVid", synFileVid);
            }
            if (HRStringUtils.isNotEmpty((String)sign)) {
                operateOption.setVariableValue("isAddNew", sign);
            }
            if (eventId != 0L) {
                operateOption.setVariableValue("event", String.valueOf(eventId));
            }
            if ((attFileScheduleEnum = AttFileScheduleEnum.getAttFileScheduleEnumByPageId((String)dynamicObject.getDataEntityType().getName())) == null) continue;
            String relOp = HRStringUtils.isEmpty((String)op) ? (attFileScheduleEnum.isTimeHis() ? "save" : "saverule") : op;
            operateOption.setVariableValue("ishasright", "true");
            OperationResult operationResult = this.executeCoordinationOp(tranChangeWrapper, messageDy, new ArrayList<DynamicObject>(Collections.singletonList(dynamicObject)), operateOption, relOp, attFileScheduleEnum.getPageId());
            if (operationResult == null || operationResult.isSuccess()) continue;
            LOGGER.info("CoordinationOperateExecute.getAddUpdateOperationResult OperationResult {}", (Object)operationResult.toString());
            return operationResult;
        }
        return null;
    }

    private void getHandlerData(List<CoordinationConfigModel> coordinationConfigModelList, List<DynamicObject> attFileDyList, List<DynamicObject> schBaseAddDyList, List<DynamicObject> schBaseUpdateDyList, List<DynamicObject> schRuleAddDyList, List<DynamicObject> schRuleUpdateDyList, List<DynamicObject> cardAddDyList, List<DynamicObject> cardUpdateDyList, List<DynamicObject> schRuleInvalidDyList) {
        if (coordinationConfigModelList == null) {
            coordinationConfigModelList = Lists.newArrayListWithExpectedSize((int)10);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("getHandlerData coordinationConfigModelJson {}", (Object)SerializationUtils.toJsonString((Object)coordinationConfigModelList));
        }
        Set attFileIdSet = attFileDyList.stream().map(file -> file.getLong("boid")).collect(Collectors.toSet());
        HashMap scheduleEnumDyGroupMap = Maps.newHashMapWithExpectedSize((int)attFileDyList.size());
        for (AttFileScheduleEnum attFileScheduleEnum : AttFileScheduleEnum.values()) {
            AttFileScheduleQueryParam queryParam = new AttFileScheduleQueryParam();
            queryParam.setqFilter(new QFilter("attfileid", "in", attFileIdSet));
            queryParam.setLoad(Boolean.TRUE);
            queryParam.setIgnoreIsCurrentVersion(true);
            List scheduleDyList = AttFileScheduleServiceImpl.getInstance().queryAttFileScheduleByList(attFileScheduleEnum, queryParam);
            Map<Long, List<DynamicObject>> scheduleDyGroupMap = scheduleDyList.stream().collect(Collectors.groupingBy(info -> info.getLong("attfileid.id")));
            scheduleEnumDyGroupMap.put(attFileScheduleEnum.getPageId(), scheduleDyGroupMap);
        }
        Map coordinationConfigModelMap = coordinationConfigModelList.stream().collect(Collectors.toMap(d -> d.getCoordinationConfTypeEnums().getCode(), Function.identity(), (a, b) -> a));
        Date maxEndDate = WTCHisServiceHelper.getMaxEndDate();
        for (AttFileScheduleEnum attFileScheduleEnum : AttFileScheduleEnum.values()) {
            long[] idsArr = this.genPrimaryKeys(attFileDyList, attFileScheduleEnum);
            String scheduleEnumKey = attFileScheduleEnum.getKey();
            CoordinationConfigModel coordinationConfigModel = (CoordinationConfigModel)coordinationConfigModelMap.get(scheduleEnumKey);
            for (int i = 0; i < attFileDyList.size(); ++i) {
                DynamicObject scheduleDy;
                DynamicObject fileEntity = attFileDyList.get(i);
                long fileBoId = fileEntity.getLong("boid");
                Date bsedDate = fileEntity.getDate("bsed");
                Date bsledDate = fileEntity.getDate("bsled");
                if (bsledDate == null) {
                    bsledDate = maxEndDate;
                }
                Date updateDate = WTCDateUtils.addDays((Date)bsedDate, (int)-1);
                Object curSchDy = fileEntity.get(scheduleEnumKey);
                Map longListMap = scheduleEnumDyGroupMap.getOrDefault(attFileScheduleEnum.getPageId(), new HashMap());
                List existSchDyList = (List)longListMap.get(fileBoId);
                if (HRObjectUtils.isEmpty((Object)curSchDy)) {
                    if (coordinationConfigModel == null || coordinationConfigModel.getSetEmpty() == null || !Boolean.TRUE.equals(coordinationConfigModel.getSetEmpty()) || attFileScheduleEnum.isTimeHis() || CollectionUtils.isEmpty((Collection)existSchDyList)) continue;
                    this.notTimeSchUpdateDataAdd(schRuleUpdateDyList, bsedDate, bsledDate, updateDate, existSchDyList);
                    this.notTimeSchInvalidDataAdd(schRuleInvalidDyList, bsedDate, bsledDate, existSchDyList);
                    continue;
                }
                if (attFileScheduleEnum.isTimeHis()) {
                    Optional<DynamicObject> currentDyOpt;
                    if (CollectionUtils.isEmpty((Collection)existSchDyList)) {
                        scheduleDy = AttFileScheduleBusiness.genNewFileSchDy(attFileScheduleEnum, idsArr[i], fileEntity);
                        if (scheduleDy == null) continue;
                        if (AttFileScheduleEnum.CARD == attFileScheduleEnum) {
                            cardAddDyList.add(scheduleDy);
                            continue;
                        }
                        schBaseAddDyList.add(scheduleDy);
                        continue;
                    }
                    Optional<DynamicObject> first = existSchDyList.stream().filter(d -> !d.getBoolean("iscurrentversion") && d.getDate("bsed").getTime() <= bsedDate.getTime() && d.getDate("bsled").getTime() >= bsedDate.getTime()).findFirst();
                    if (!first.isPresent() || !(currentDyOpt = existSchDyList.stream().filter(d -> d.getBoolean("iscurrentversion")).findAny()).isPresent()) continue;
                    DynamicObject updateSchDy = first.get();
                    DynamicObject currentDy = currentDyOpt.get();
                    HRDynamicObjectUtils.copy((DynamicObject)updateSchDy, (DynamicObject)currentDy, (Set)WTCHisServiceHelper.getHisIgnoreKeysSet());
                    currentDy.set("bsed", (Object)bsedDate);
                    currentDy.set("bsled", (Object)bsledDate);
                    currentDy.set(scheduleEnumKey, fileEntity.get(scheduleEnumKey));
                    if (AttFileScheduleEnum.CARD == attFileScheduleEnum) {
                        cardUpdateDyList.add(currentDy);
                        continue;
                    }
                    schBaseUpdateDyList.add(currentDy);
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)existSchDyList)) {
                    scheduleDy = AttFileScheduleBusiness.genNewFileSchDy(attFileScheduleEnum, idsArr[i], fileEntity);
                    if (scheduleDy == null) continue;
                    schRuleAddDyList.add(scheduleDy);
                    continue;
                }
                this.notTimeSchUpdateDataAdd(schRuleUpdateDyList, bsedDate, bsledDate, updateDate, existSchDyList);
                DynamicObject addSchDyObj = AttFileScheduleBusiness.genNewFileSchDy(attFileScheduleEnum, idsArr[i], fileEntity);
                schRuleAddDyList.add(addSchDyObj);
                this.notTimeSchInvalidDataAdd(schRuleInvalidDyList, bsedDate, bsledDate, existSchDyList);
            }
        }
    }

    private void notTimeSchInvalidDataAdd(List<DynamicObject> schRuleInvalidDyList, Date bsedDate, Date bsledDate, List<DynamicObject> existSchDyList) {
        List<Object> invalidDyList = !this.bsledIsMax(bsledDate) ? existSchDyList.stream().filter(d -> d.getBoolean("iscurrentversion") && d.getDate("startdate").getTime() >= bsedDate.getTime() && d.getDate("enddate").getTime() <= bsledDate.getTime()).collect(Collectors.toList()) : existSchDyList.stream().filter(d -> d.getBoolean("iscurrentversion") && d.getDate("startdate").getTime() >= bsedDate.getTime()).collect(Collectors.toList());
        invalidDyList.forEach(dynamicObject -> dynamicObject.set("busistatus", (Object)"0"));
        schRuleInvalidDyList.addAll(invalidDyList);
    }

    private void notTimeSchUpdateDataAdd(List<DynamicObject> schRuleUpdateDyList, Date bsedDate, Date bsledDate, Date updateDate, List<DynamicObject> existSchDyList) {
        Optional<DynamicObject> first = existSchDyList.stream().filter(d -> d.getBoolean("iscurrentversion") && d.getDate("startdate").getTime() < bsedDate.getTime() && d.getDate("enddate").getTime() >= bsedDate.getTime()).findFirst();
        if (first.isPresent()) {
            DynamicObject updateSchDy = first.get();
            updateSchDy.set("enddate", (Object)updateDate);
            schRuleUpdateDyList.add(updateSchDy);
        }
        if (!this.bsledIsMax(bsledDate)) {
            Date updateStartDate = WTCDateUtils.addDays((Date)bsledDate, (int)1);
            Optional<DynamicObject> bsledOptional = existSchDyList.stream().filter(d -> d.getBoolean("iscurrentversion") && d.getDate("startdate").getTime() <= bsledDate.getTime() && d.getDate("enddate").getTime() > bsledDate.getTime()).findFirst();
            if (bsledOptional.isPresent()) {
                DynamicObject updateSchDy = bsledOptional.get();
                updateSchDy.set("startdate", (Object)updateStartDate);
                schRuleUpdateDyList.add(updateSchDy);
            }
        }
    }

    private boolean bsledIsMax(Date bsledDate) {
        LocalDate localDate = LocalDate.of(2199, 12, 31);
        Date endDate = Date.from(localDate.atStartOfDay().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
        return bsledDate == null || !bsledDate.before(endDate);
    }

    private long[] genPrimaryKeys(List<DynamicObject> attFileDyList, AttFileScheduleEnum attFileScheduleEnum) {
        return ORM.create().genLongIds(attFileScheduleEnum.getPageId(), attFileDyList.size());
    }

    public OperationResult synAttPersonDy(List<DynamicObject> attPersonDyList) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"synattperson", (String)"wtp_attendperson", (DynamicObject[])attPersonDyList.toArray(new DynamicObject[0]), (OperateOption)this.getIgnoreWarnOperateOption());
        LOGGER.info("CoordinationOperateExecute.synAttPersonDy OperationResult {}", (Object)operationResult.toString());
        return operationResult;
    }

    public OperationResult synAttCmpDy(List<DynamicObject> cmpDyList) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"synattcmp", (String)"wtp_managescope", (DynamicObject[])cmpDyList.toArray(new DynamicObject[0]), (OperateOption)this.getIgnoreWarnOperateOption());
        LOGGER.info("AttFileAndPersonOperateService.synAttCmpDy OperationResult {}", (Object)operationResult.toString());
        return operationResult;
    }

    public OperationResult synAttFyDy(List<DynamicObject> cmpDyList) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"synattfy", (String)"wtp_fertilityinfo", (DynamicObject[])cmpDyList.toArray(new DynamicObject[0]), (OperateOption)this.getIgnoreWarnOperateOption());
        LOGGER.info("AttFileAndPersonOperateService.synAttFyDy OperationResult {}", (Object)operationResult.toString());
        return operationResult;
    }

    public OperationResult synAttEmpPosOrgRelDy(List<DynamicObject> empPosOrgRelDyList) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"synattempposorgrel", (String)"wtp_depempjob", (DynamicObject[])empPosOrgRelDyList.toArray(new DynamicObject[0]), (OperateOption)this.getIgnoreWarnOperateOption());
        LOGGER.info("AttFileAndPersonOperateService.synAttEmpPosOrgRelDy OperationResult {}", (Object)operationResult.toString());
        return operationResult;
    }

    public OperationResult executeCoordinationOp(TranChangeWrapper tranChangeWrapper, DynamicObject messageDy, List<DynamicObject> exeOpDyList, OperateOption operateOption, String operationKey, String entityNumber) {
        OperationResult operationResult;
        WTCPluginProxy coordinationExecuteExtPlugin = WTCPluginProxyFactory.create(CoordinationExecuteExtPlugin.class, (String)"kd.sdk.wtc.wtp.business.coordination.CoordinationExecuteExtPlugin");
        if (coordinationExecuteExtPlugin.hasPlugin()) {
            ExecutingCoordinationEvent executingCoordinationEvent = this.getCoordinationExecuteParam(tranChangeWrapper, messageDy, exeOpDyList, operationKey, entityNumber);
            coordinationExecuteExtPlugin.invokeReplace(plugin -> plugin.executingCoordination(executingCoordinationEvent));
            CoreCoordinationParam coreCoordinationParam = executingCoordinationEvent.getCoreCoordinationParam();
            operateOption.setVariableValue("coordinationcoreparam", SerializationUtils.toJsonString((Object)coreCoordinationParam));
            operationResult = OperationServiceHelper.executeOperate((String)executingCoordinationEvent.getOperationKey(), (String)executingCoordinationEvent.getEntityNumber(), (DynamicObject[])executingCoordinationEvent.getExeOpDyList().toArray(new DynamicObject[0]), (OperateOption)operateOption);
        } else {
            operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])exeOpDyList.toArray(new DynamicObject[0]), (OperateOption)operateOption);
        }
        if (WTCStringUtils.isNotEmpty((String)entityNumber)) {
            List successPkIds = operationResult.getSuccessPkIds();
            Map<String, List<Object>> successPkIdMap = tranChangeWrapper.getSuccessPkIdMap();
            successPkIdMap.put(entityNumber, successPkIds);
        }
        return operationResult;
    }

    private ExecutingCoordinationEvent getCoordinationExecuteParam(TranChangeWrapper tranChangeWrapper, DynamicObject messageDy, List<DynamicObject> exeOpDyList, String operationKey, String entityNumber) {
        if (tranChangeWrapper == null || messageDy == null) {
            return new ExecutingCoordinationEvent(operationKey, entityNumber, messageDy, exeOpDyList);
        }
        return new ExecutingCoordinationEvent(operationKey, entityNumber, tranChangeWrapper.getCoreCoordinationParam(), messageDy, exeOpDyList);
    }
}

