/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.coordination.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.wtc.wtis.business.coordination.AttFileSchemeDto;
import kd.sdk.wtc.wtis.business.coordination.EntryCoordinationParam;
import kd.sdk.wtc.wtis.business.coordination.NewAttFileCoordinationExpService;
import kd.sdk.wtc.wtp.business.coordination.CoreCoordinationParam;
import kd.wtc.wtbs.business.license.CertControlType;
import kd.wtc.wtbs.business.license.CertService;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.predata.hbss.PreDataBizType;
import kd.wtc.wtbs.common.predata.hbss.PreDataObjectType;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attfile.AttFileCoreDataService;
import kd.wtc.wtp.business.attfile.cert.AttFileCertService;
import kd.wtc.wtp.business.coordination.CoordinationTask;
import kd.wtc.wtp.business.coordination.ICoordination;
import kd.wtc.wtp.business.coordination.impl.CoordinationConfServiceImpl;
import kd.wtc.wtp.business.coordination.impl.CoordinationDefaultFactory;
import kd.wtc.wtp.business.coordination.wrapper.TranChangeWrapper;
import kd.wtc.wtp.common.kdstring.AttFileKDString;
import kd.wtc.wtp.common.kdstring.CoordinationKDString;
import kd.wtc.wtp.common.model.ResultMap;
import kd.wtc.wtp.common.model.coordination.CoordinationTaskResponse;
import kd.wtc.wtp.common.model.file.FileSaveDto;
import kd.wtc.wtp.enums.coordination.CoordinationExecutionStatusEnum;
import kd.wtc.wtp.enums.coordination.SubscribeEnum;
import kd.wtc.wtp.enums.coordination.TaskCreateStatusEnum;

public class CoordinationHelper {
    private static final String TRY_LOG_TIME_OUT = "try lock timeout!";
    private static final Log LOG = LogFactory.getLog(CoordinationHelper.class);
    HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_coordinationlog");
    public static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"wtc_wtis_coordination", (int)(Runtime.getRuntime().availableProcessors() + 1));

    public static CoordinationHelper getInstance() {
        return (CoordinationHelper)WTCAppContextHelper.getBean(CoordinationHelper.class);
    }

    public <T> T invokeHRMPService(String entityName, Long boId) {
        return (T)WTCServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listInfo", (Object[])new Object[]{entityName, null, boId, null});
    }

    public List<Map<String, Long>> invokeHRMPIHRCSStrategyService(Map<Long, Set<Long>> orgId2BusinessType, Long businessObjectId) {
        return (List)WTCServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"getHrBuByBusinessType", (Object[])new Object[]{orgId2BusinessType, businessObjectId});
    }

    private String getBoIdAttribute(Map<String, Object> item) {
        if ("0".equals(item.get("chgmode"))) {
            return "idafter";
        }
        return "idbefore";
    }

    public Map<String, Map<String, List<Map<String, Object>>>> getChangeContentByAll(Map<String, Map<String, Object>> changeAll) {
        return changeAll;
    }

    public List<DynamicObject> queryAttListByPersonIdAndDay(Long personId, Date day) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setPersonSetIds(Collections.singleton(personId));
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setStartDate(day);
        attFileQueryParam.setEndDate(day);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setAttStatus(AttStatusEnum.ATT_NORMAL);
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
    }

    public List<DynamicObject> queryAttListByPersonId(Long personId) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setPersonSetIds(Collections.singleton(personId));
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setAttStatus(null);
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
    }

    public List<DynamicObject> getEmployeeFileDyList(TranChangeWrapper tranChangeWrapper, Date queryDate) {
        Long employeeId;
        Optional<Map> any;
        List<Map<String, Object>> attendNeedChange = tranChangeWrapper.getAttendNeedChange();
        if (WTCCollections.isNotEmpty(attendNeedChange) && (any = attendNeedChange.stream().filter(d -> WTCCollections.isNotEmpty((Map)d) && "hrpi_employee".equals(d.get("entity")) && d.get("idafter") != null).findAny()).isPresent() && (employeeId = (Long)any.get().get("idafter")) != 0L) {
            AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
            attFileQueryParam.setqFilter(new QFilter("employee.id", "=", (Object)employeeId));
            attFileQueryParam.setStartDate(queryDate);
            attFileQueryParam.setEndDate(queryDate);
            attFileQueryParam.setBeCurrent(Boolean.FALSE);
            attFileQueryParam.setOrderBy("startdate desc");
            return AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        }
        return Collections.emptyList();
    }

    public List<DynamicObject> queryAttListByBoId(Long boId) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setSetBoIds(Collections.singleton(boId));
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setAttStatus(null);
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
    }

    public DynamicObject queryAttFileScheduleByAttFileIdAndDay(Long attFileBoId, Date day, AttFileScheduleEnum scheduleEnum) {
        AttFileScheduleQueryParam queryParam = new AttFileScheduleQueryParam();
        queryParam.setStartDate(day);
        queryParam.setEndDate(day);
        queryParam.setFileBoIdSet(Collections.singleton(attFileBoId));
        queryParam.setLoad(Boolean.TRUE);
        List dyList = (List)AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(scheduleEnum, queryParam).get(attFileBoId);
        if (WTCCollections.isNotEmpty((Collection)dyList)) {
            return (DynamicObject)dyList.get(0);
        }
        return null;
    }

    public Map<String, Object> getHrPiEntityChg(List<Map<String, Object>> attendNeedChange, String hrPiEntityName, String chgMode) {
        Long boId;
        Map firstItem;
        String entityName;
        List hrPiList;
        List hrPiCurrentList;
        List personChange = attendNeedChange.stream().filter(item -> {
            String entity = (String)item.get("entity");
            if (WTCStringUtils.isEmpty((String)chgMode)) {
                return hrPiEntityName.equals(entity);
            }
            return hrPiEntityName.equals(entity) && chgMode.equals(item.get("chgmode"));
        }).collect(Collectors.toList());
        if (WTCCollections.isNotEmpty(personChange) && WTCCollections.isNotEmpty(hrPiCurrentList = (hrPiList = (List)this.invokeHRMPService(entityName = (String)(firstItem = (Map)personChange.get(0)).get("entity"), boId = (Long)firstItem.get(this.getBoIdAttribute(firstItem)))).stream().filter(hr -> (Boolean)hr.get("iscurrentversion")).collect(Collectors.toList()))) {
            if (hrPiCurrentList.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636eboID = {0} \u67e5\u8be2\u6838\u5fc3\u4eba\u529b{1}\u5b9e\u4f53\u8fd4\u56de\u591a\u6761\u6570\u636e\uff0c\u6570\u636e\u9519\u8bef\uff0c\u534f\u540c\u5931\u8d25\u3002", (String)"CoordinationHelper_2", (String)"wtc-wtp-business", (Object[])new Object[]{boId, entityName}));
            }
            return (Map)hrPiCurrentList.get(0);
        }
        return null;
    }

    public Long getOrgIdByEmpPosOrgRel(Map<String, Object> newEmpPosOrgRel) {
        return this.getOrgIdByEmpPosOrgRel((Long)newEmpPosOrgRel.get("adminorg_id"));
    }

    public Long getOrgIdByEmpPosOrgRel(Long adminOrg) {
        Set<Long> attMgrSet = Collections.singleton(PreDataBizType.PD_104010L);
        HashMap newOrgIdBusinessTypeMap = Maps.newHashMapWithExpectedSize((int)1);
        newOrgIdBusinessTypeMap.put(adminOrg, attMgrSet);
        List<Map<String, Long>> newStrategyMap = this.invokeHRMPIHRCSStrategyService(newOrgIdBusinessTypeMap, PreDataObjectType.PD_1010L);
        LOG.info("call invokeHRMPIHRCSStrategyService newOrgIdBusinessTypeMap : {} newStrategyMap : {}", (Object)SerializationUtils.toJsonString((Object)newOrgIdBusinessTypeMap), (Object)SerializationUtils.toJsonString(newStrategyMap));
        if (WTCCollections.isEmpty(newStrategyMap) || newStrategyMap.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u884c\u653f\u7ec4\u7ec7\u67e5\u8be2\u5458\u5de5\u7ba1\u7406\u5173\u7cfb\u7b56\u7565\u83b7\u53d6\u7ec4\u7ec7\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u76f8\u5173\u6570\u636e\u3002", (String)"CoordinationHelper_5", (String)"wtc-wtp-business", (Object[])new Object[0]));
        }
        Long orgId = newStrategyMap.get(0).get("hrBuId");
        if (orgId == null || orgId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u884c\u653f\u7ec4\u7ec7\u67e5\u8be2\u5458\u5de5\u7ba1\u7406\u5173\u7cfb\u7b56\u7565\u83b7\u53d6\u7ec4\u7ec7\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u76f8\u5173\u6570\u636e\u3002", (String)"CoordinationHelper_5", (String)"wtc-wtp-business", (Object[])new Object[0]));
        }
        return orgId;
    }

    public DynamicObject getDy(String entityName, Long id) {
        HRBaseServiceHelper affiliateAdminOrgHelper = new HRBaseServiceHelper(entityName);
        DynamicObject dy = affiliateAdminOrgHelper.generateEmptyDynamicObject();
        dy.set("id", (Object)id);
        return dy;
    }

    public FileSaveDto fillEmpPosOrgRelInfo(TranChangeWrapper tranChangeWrapper, DynamicObject attFile) {
        Map<Long, FileSaveDto> fileSaveDtoMapByEmpIds;
        Iterator<FileSaveDto> iterator;
        FileSaveDto fileSaveDto;
        long empPosOrgRelId;
        if (tranChangeWrapper.getNewEmpPosOrgRelId() == 0L) {
            empPosOrgRelId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)attFile, (String)"empposorgrel");
            if (empPosOrgRelId == 0L) {
                String errMsg = ResManager.loadKDString((String)"\u4efb\u804c\u7ecf\u5386ID\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u4e8b\u52a1\u3002", (String)"CoordinationHelper_0", (String)"wtc-wtp-business", (Object[])new Object[0]);
                tranChangeWrapper.setErrMsg(errMsg);
                throw new KDBizException(errMsg);
            }
        } else {
            empPosOrgRelId = tranChangeWrapper.getNewEmpPosOrgRelId();
        }
        FileSaveDto fileSaveDto2 = fileSaveDto = (iterator = (fileSaveDtoMapByEmpIds = AttFileCoreDataService.getInstance().getFileSaveDtoMapByEmpIds(Collections.singletonList(empPosOrgRelId))).values().iterator()).hasNext() ? iterator.next() : null;
        if (fileSaveDto == null) {
            String errMsg = AttFileKDString.empPosOrgRelNotEffect();
            tranChangeWrapper.setErrMsg(errMsg);
            throw new KDBizException(errMsg);
        }
        AttFileCoreDataService.getInstance().initFileByFileSaveDto(fileSaveDto, attFile, null);
        attFile.getDynamicObject("person").set("personindexid", (Object)tranChangeWrapper.getPersonIndexId());
        return fileSaveDto;
    }

    public ResultMap callCoordination(CoordinationTaskResponse taskResponse, DynamicObject logDynamicObject) {
        ResultMap resultMap = new ResultMap();
        TranChangeWrapper tranChangeWrapper = (TranChangeWrapper)SerializationUtils.fromJsonString((String)logDynamicObject.getString("contextobject"), TranChangeWrapper.class);
        ICoordination coordination = ((CoordinationDefaultFactory)WTCAppContextHelper.getBean(CoordinationDefaultFactory.class)).getNeedCoordination(tranChangeWrapper);
        CoreCoordinationParam coreCoordinationParam = new CoreCoordinationParam(tranChangeWrapper.getConfigId(), tranChangeWrapper.getMsgSubNo(), tranChangeWrapper.getPersonId(), tranChangeWrapper.getEffectTime());
        tranChangeWrapper.setCoreCoordinationParam(coreCoordinationParam);
        this.accessData(coordination, logDynamicObject, tranChangeWrapper);
        if (WTCCollections.isNotEmpty(tranChangeWrapper.getRollbackResult())) {
            taskResponse.setRollbackResult(tranChangeWrapper.getRollbackResult());
        }
        if (WTCStringUtils.isNotEmpty((String)tranChangeWrapper.getErrMsg())) {
            resultMap.setMessage(tranChangeWrapper.getErrMsg());
            resultMap.setData((Object)CoordinationExecutionStatusEnum.EXEFAILED);
        } else {
            resultMap.setMessage(tranChangeWrapper.getErrMsg());
            resultMap.setData((Object)CoordinationExecutionStatusEnum.EXESUCCESS);
            THREAD_POOL.execute(() -> this.updateConsumeMsgInfo(logDynamicObject));
        }
        if (tranChangeWrapper.isIgnoreExecutionStatusFail()) {
            resultMap.setData((Object)CoordinationExecutionStatusEnum.EXESUCCESS);
            taskResponse.setTipsMsg(resultMap.getMessage());
        }
        taskResponse.setSuccessPkIdMap(tranChangeWrapper.getSuccessPkIdMap());
        taskResponse.setCoreCoordinationParam(tranChangeWrapper.getCoreCoordinationParam());
        return resultMap;
    }

    private void updateConsumeMsgInfo(DynamicObject coordinationLog) {
        HashMap consumeMsgMap = Maps.newHashMapWithExpectedSize((int)3);
        Object msgCenterBO = coordinationLog.get("msgcenterbo");
        if (msgCenterBO instanceof DynamicObject) {
            msgCenterBO = coordinationLog.get("msgcenterbo.id");
        }
        consumeMsgMap.put("msgCenterId", msgCenterBO);
        consumeMsgMap.put("msgSubNo", coordinationLog.get("msgsubno"));
        consumeMsgMap.put("handleStatus", "1");
        this.callIHRCSMsgService(consumeMsgMap);
    }

    private void callIHRCSMsgService(Map<String, Object> consumeMsgMap) {
        WTCServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSMsgService", (String)"updateConsumeMsgInfo", (Object[])new Object[]{consumeMsgMap});
    }

    private void accessData(ICoordination coordination, DynamicObject messageDy, TranChangeWrapper tranChangeWrapper) {
        if (WTCStringUtils.isEmpty((String)tranChangeWrapper.getErrMsg()) && coordination != null) {
            Map<String, List<DynamicObject>> dyMap = coordination.dataMapping(messageDy, tranChangeWrapper);
            coordination.beforeExecute(messageDy, tranChangeWrapper, dyMap);
            List<OperationResult> opResList = coordination.coordinationExecute(messageDy, tranChangeWrapper, dyMap);
            if (WTCCollections.isNotEmpty(opResList)) {
                this.accessOperationResult(tranChangeWrapper, opResList);
            }
        }
    }

    private void accessOperationResult(TranChangeWrapper tranChangeWrapper, List<OperationResult> opResList) {
        for (OperationResult operation : opResList) {
            if (operation == null || operation.isSuccess()) continue;
            List allErrorInfo = operation.getAllErrorOrValidateInfo();
            if (WTCCollections.isNotEmpty((Collection)allErrorInfo)) {
                StringBuilder errMsg = new StringBuilder();
                for (IOperateInfo errorInfo : allErrorInfo) {
                    errMsg.append(errorInfo.getMessage());
                }
                tranChangeWrapper.setErrMsg(errMsg.toString());
            }
            if (WTCStringUtils.isEmpty((String)tranChangeWrapper.getErrMsg())) {
                tranChangeWrapper.setErrMsg(operation.getMessage());
                if ("E2001".equals(operation.getSponsor())) {
                    tranChangeWrapper.setIgnoreExecutionStatusFail(true);
                }
            }
            if (!WTCStringUtils.isEmpty((String)tranChangeWrapper.getErrMsg())) break;
            tranChangeWrapper.setErrMsg(CoordinationKDString.sysUnKnowError());
            break;
        }
    }

    public List<Map<String, Object>> getAttendNeedChange(Map<String, Map<String, List<Map<String, Object>>>> changContent) {
        if (changContent == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u5fc3\u4eba\u529b\u8fd4\u56de\u7684changContent\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u4e8b\u52a1\u3002", (String)"MessageAccessor_2", (String)"wtc-wtp-business", (Object[])new Object[0]));
        }
        if (changContent.get("data") == null || changContent.get("data").get("data") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u5fc3\u4eba\u529b\u8fd4\u56de\u7684\u6570\u636e\u6709\u8bef\uff0c\u65e0\u6cd5\u6267\u884c\u4e8b\u52a1\u3002", (String)"MessageAccessor_3", (String)"wtc-wtp-business", (Object[])new Object[0]));
        }
        List<Map<String, Object>> allChang = changContent.get("data").get("data");
        return allChang.stream().filter(item -> TranChangeWrapper.ATTEND_NEED_ENTITY_SET.contains((String)item.get("entity"))).collect(Collectors.toList());
    }

    public void saveLog(DynamicObject logDynamicObject) {
        WTCServiceHelper.invokeWtcWtisBizService((String)"ICoordinationService", (String)"saveLog", (Object[])new Object[]{logDynamicObject});
    }

    public List<Map<String, Object>> getNewEmpPosOrgRelList(List<Map<String, Object>> attendNeedChange) {
        return attendNeedChange.stream().filter(item -> {
            String entity = (String)item.get("entity");
            Object chgMode = item.get("chgmode");
            return "hrpi_empposorgrel".equals(entity) && "0".equals(chgMode);
        }).collect(Collectors.toList());
    }

    public boolean checkIfResign(String msgSubNo) {
        return SubscribeEnum.RESIGN.getCode().equals(msgSubNo);
    }

    public boolean checkIfPersonChange(String msgSubNo) {
        return SubscribeEnum.PERSON_ATTACHE_INFO_MDF.getCode().equals(msgSubNo);
    }

    public boolean checkIfEntry(String msgSubNo) {
        return SubscribeEnum.CONFIRM_ENTRY.getCode().equals(msgSubNo);
    }

    public boolean checkIfShift(String msgSubNo) {
        return SubscribeEnum.INNER_SHIFT.getCode().equals(msgSubNo) || SubscribeEnum.OUTER_SHIFT.getCode().equals(msgSubNo);
    }

    public void callEntryPoint(DynamicObject newAttFile, TranChangeWrapper tranChangeWrapper) {
        try {
            AttFileSchemeDto attFileSchemeDto;
            EntryCoordinationParam entryCoordinationParam = new EntryCoordinationParam();
            entryCoordinationParam.setLogNo(tranChangeWrapper.getLogNo());
            entryCoordinationParam.setPersonId(tranChangeWrapper.getPersonId());
            entryCoordinationParam.setEmpPosOrgRelId(tranChangeWrapper.getNewEmpPosOrgRelId());
            HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, NewAttFileCoordinationExpService.class, (String)"kd.sdk.wtc.wtis.business.coordination.NewAttFileCoordinationExpService", null);
            List attFileSchemeDtoList = pluginProxy.callReplace(locationService -> locationService.genAttFileSchemeForEntry(entryCoordinationParam));
            if (WTCCollections.isNotEmpty((Collection)attFileSchemeDtoList) && (attFileSchemeDto = (AttFileSchemeDto)attFileSchemeDtoList.get(attFileSchemeDtoList.size() - 1)) != null) {
                newAttFile.set("ws", (Object)CoordinationHelper.getInstance().getDy(AttFileScheduleEnum.WS.getPageId(), attFileSchemeDto.getWorkScheduleId()));
                newAttFile.set("period", (Object)CoordinationHelper.getInstance().getDy(AttFileScheduleEnum.PERIOD.getPageId(), attFileSchemeDto.getPeriodId()));
                if (attFileSchemeDto.getAttMode() != null) {
                    newAttFile.set("mode", (Object)attFileSchemeDto.getAttMode().getCode());
                }
                newAttFile.set("card", (Object)attFileSchemeDto.getCard());
                newAttFile.set("tz", (Object)CoordinationHelper.getInstance().getDy(AttFileScheduleEnum.TZ.getPageId(), attFileSchemeDto.getTimeZoneId()));
                newAttFile.set("vp", (Object)CoordinationHelper.getInstance().getDy(AttFileScheduleEnum.VP.getPageId(), attFileSchemeDto.getVacationPlanBoId()));
                newAttFile.set("tp", (Object)CoordinationHelper.getInstance().getDy(AttFileScheduleEnum.TP.getPageId(), attFileSchemeDto.getTravelPlanBoId()));
                newAttFile.set("otp", (Object)CoordinationHelper.getInstance().getDy(AttFileScheduleEnum.OTP.getPageId(), attFileSchemeDto.getOvertimePlanBoId()));
                newAttFile.set("ex", (Object)CoordinationHelper.getInstance().getDy(AttFileScheduleEnum.EX.getPageId(), attFileSchemeDto.getExceptionPlanBoId()));
                newAttFile.set("ad", (Object)CoordinationHelper.getInstance().getDy(AttFileScheduleEnum.AD.getPageId(), attFileSchemeDto.getSupplePlanBoId()));
                newAttFile.set("idp", (Object)CoordinationHelper.getInstance().getDy(AttFileScheduleEnum.IDP.getPageId(), attFileSchemeDto.getIncAndDecPlanBoId()));
                newAttFile.set("att", (Object)CoordinationHelper.getInstance().getDy(AttFileScheduleEnum.ATT.getPageId(), attFileSchemeDto.getAttendPlanBoId()));
                newAttFile.set("qt", (Object)CoordinationHelper.getInstance().getDy(AttFileScheduleEnum.QT.getPageId(), attFileSchemeDto.getQuotaPlanBoId()));
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u5165\u804c\u534f\u540c\u6269\u5c55\u70b9{0}\u5931\u8d25\uff0c\u65e0\u6cd5\u534f\u540c\u3002", (String)"NewAttFileCoordination_0", (String)"wtc-wtp-business", (Object[])new Object[]{"kd.sdk.wtc.wtis.business.coordination.NewAttFileCoordinationExpService"}));
        }
    }

    public void fillEntryStartDate(DynamicObject newAttFile, TranChangeWrapper tranChangeWrapper) {
        Map<String, Object> hrPiEmployee = CoordinationHelper.getInstance().getHrPiEntityChg(tranChangeWrapper.getAttendNeedChange(), "hrpi_employee", "0");
        if (WTCCollections.isNotEmpty(hrPiEmployee)) {
            newAttFile.set("startdate", hrPiEmployee.get("startdate"));
        }
    }

    public boolean checkAttFileIfHaveStopAttTag(TranChangeWrapper tranChangeWrapper, List<DynamicObject> attFileList) {
        if (attFileList == null) {
            attFileList = this.queryAttListByPersonId(tranChangeWrapper.getPersonId());
        }
        this.sortAttFileList(attFileList);
        if (WTCCollections.isNotEmpty(attFileList)) {
            long boId = attFileList.get(0).getLong("boid");
            List list = attFileList.stream().filter(attFileDy -> boId == attFileDy.getLong("boid")).sorted((item1, item2) -> item2.getDate("bsed").compareTo(item1.getDate("bsed"))).collect(Collectors.toList());
            return WTCCollectionIndexUtil.getEleFromList(list, (int)0).filter(ele -> AttStatusEnum.ATT_STOP.getCode().equals(ele.get("atttag.attendstatus"))).isPresent();
        }
        return false;
    }

    public void sortAttFileList(List<DynamicObject> attFileList) {
        if (WTCCollections.isNotEmpty(attFileList)) {
            attFileList.sort((o1, o2) -> o2.getDate("startdate").compareTo(o1.getDate("startdate")));
        }
    }

    private String resignRevertCheck(TranChangeWrapper tranChangeWrapper) {
        List<DynamicObject> attFileList = CoordinationHelper.getInstance().getEmployeeFileDyList(tranChangeWrapper, null);
        if (WTCCollections.isNotEmpty(attFileList)) {
            if (!this.checkAttFileIfHaveStopAttTag(tranChangeWrapper, attFileList)) {
                return ResManager.loadKDString((String)"\u4eba\u5458\u6700\u665a\u7684\u8003\u52e4\u6863\u6848\u672a\u505c\u6b62\u8003\u52e4\uff0c\u65e0\u9700\u6267\u884c\u3002", (String)"CoordinationHelper_3", (String)"wtc-wtp-business", (Object[])new Object[0]);
            }
            tranChangeWrapper.setRevertAttFileBoId(attFileList.get(0).getLong("boid"));
            tranChangeWrapper.setRevertAttFileEndDate(attFileList.get(0).getDate("enddate"));
            Map<String, List<Long>> dealRes = AttFileCertService.getUpdateCertDealId(Collections.singletonList(attFileList.get(0)));
            Map checkRes = CertService.certControl((String)"wtp", (String)"wtp_attfilebase", dealRes.get("add"), (CertControlType)CertControlType.VALIDATORANDAPPLYCHECK);
            Map msg = (Map)checkRes.get("msg");
            if ("FORBIDDEN".equals(msg.get("infoType")) || ((String)msg.get("showMessage")).equals("true")) {
                return (String)msg.get("message");
            }
        }
        return null;
    }

    public String createCheck(DynamicObject logDynamicObject, TranChangeWrapper tranChangeWrapper) {
        long msgActionId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)logDynamicObject, (String)"msgaction");
        if (msgActionId == 0L) {
            DynamicObject dynamicObject = this.hrBaseServiceHelper.loadSingle(logDynamicObject.getPkValue());
            msgActionId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dynamicObject, (String)"msgaction");
        }
        if (msgActionId == 1210L) {
            return null;
        }
        if (msgActionId == 1110L) {
            return this.resignRevertCheck(tranChangeWrapper);
        }
        if (logDynamicObject.get("org") == null || logDynamicObject.getLong("org") == 0L) {
            return CoordinationKDString.cannotMapOrgId();
        }
        if (!this.checkIfPersonChange(tranChangeWrapper.getMsgSubNo()) && !this.checkIfResign(tranChangeWrapper.getMsgSubNo())) {
            DynamicObject confDy = CoordinationConfServiceImpl.getInstance().queryCoordinationConfByMsgSubNoAndOrg(logDynamicObject.getString("msgSubNo"), logDynamicObject.getLong("org"));
            if (confDy == null) {
                return CoordinationKDString.cannotFindRuleConf();
            }
            tranChangeWrapper.setConfigId(confDy.getLong("id"));
        }
        return null;
    }

    public void saveLog(DynamicObject logDynamicObject, String checkMsg) {
        if ("success".equals(checkMsg)) {
            logDynamicObject.set("taskcreatefailcause", (Object)"");
            logDynamicObject.set("taskcreatestatus", (Object)TaskCreateStatusEnum.SUCCESS.getCode());
        } else if (!StringUtil.isEmpty((String)checkMsg)) {
            logDynamicObject.set("taskcreatefailcause", (Object)checkMsg);
            logDynamicObject.set("taskcreatestatus", (Object)TaskCreateStatusEnum.FAIL.getCode());
            String failCause = logDynamicObject.getString("taskcreatefailcause");
            if (WTCStringUtils.isNotEmpty((String)failCause) && failCause.length() > 500) {
                failCause = failCause.substring(0, 500);
                logDynamicObject.set("taskcreatefailcause", (Object)failCause);
            }
        }
        this.hrBaseServiceHelper.saveOne(logDynamicObject);
    }

    public String createExecute(DynamicObject logDynamicObject, boolean ifManual, Map<String, Object> runResultMap) {
        Long msgCenterBoId = logDynamicObject.getLong("msgcenterbo_id");
        if (msgCenterBoId.equals(0L)) {
            msgCenterBoId = logDynamicObject.getLong("msgcenterbo");
        }
        Throwable throwable = null;
        try (DLock lock = DLock.create((String)String.valueOf(msgCenterBoId));){
            if (lock.tryLock(300000L)) {
                LOG.info("Coordination Log number {} executing.", (Object)logDynamicObject.getString("number"));
                TranChangeWrapper tranChangeWrapper = this.initTranChangeWrapper(logDynamicObject);
                if (!ifManual && this.checkIfRetreatEvent(tranChangeWrapper)) {
                    String string = null;
                    return string;
                }
                if (!TaskCreateStatusEnum.SUCCESS.getCode().equals(logDynamicObject.get("taskcreatestatus"))) {
                    if (this.coordinationPreCreateTaskCheck(logDynamicObject, tranChangeWrapper)) {
                        String string = tranChangeWrapper.getCreateErrMsg();
                        return string;
                    }
                    String checkMsg = CoordinationHelper.getInstance().createCheck(logDynamicObject, tranChangeWrapper);
                    logDynamicObject.set("contextobject", (Object)SerializationUtils.toJsonString((Object)tranChangeWrapper));
                    if (StringUtil.isEmpty((String)checkMsg)) {
                        this.saveLog(logDynamicObject, tranChangeWrapper.getCreateErrMsg());
                        CoordinationTaskResponse coordinationTaskResponse = CoordinationTask.getInstance().createTask(logDynamicObject, ifManual);
                        this.saveLog(logDynamicObject, "success");
                        CoordinationTask.getInstance().execute(coordinationTaskResponse, logDynamicObject);
                        if (runResultMap != null && WTCCollections.isNotEmpty((Map)coordinationTaskResponse.getRollbackResult())) {
                            runResultMap.putAll(coordinationTaskResponse.getRollbackResult());
                        }
                    } else {
                        tranChangeWrapper.setCreateErrMsg(checkMsg);
                        this.saveLog(logDynamicObject, tranChangeWrapper.getCreateErrMsg());
                    }
                } else {
                    String string = ResManager.loadKDString((String)"\u8be5\u6d88\u606f\u5df2\u5b58\u5728\u534f\u4f5c\u4efb\u52a1\uff0c\u65e0\u6cd5\u91cd\u590d\u521b\u5efa\u3002", (String)"CoordinationDefaultFactory_2", (String)"wtc-wtp-business", (Object[])new Object[]{logDynamicObject.getString("number")});
                    return string;
                }
                String string = tranChangeWrapper.getCreateErrMsg();
                return string;
            }
            try {
                throw new KDBizException(TRY_LOG_TIME_OUT);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public String createExecute(DynamicObject logDynamicObject, boolean ifManual) {
        return this.createExecute(logDynamicObject, ifManual, null);
    }

    public boolean coordinationPreCreateTaskCheck(DynamicObject logDynamicObject, TranChangeWrapper tranChangeWrapper) {
        if (logDynamicObject.get("org") == null || logDynamicObject.getLong("org") == 0L) {
            Map result = (Map)SerializationUtils.deSerializeFromBase64((String)logDynamicObject.getString("msgcontent"));
            Long recordId = (Long)result.get("recordId");
            if (recordId == null || recordId.equals(0L)) {
                tranChangeWrapper.setCreateErrMsg(ResManager.loadKDString((String)"\u6838\u5fc3\u4eba\u529b\u7684\u4e8b\u52a1\u53d8\u52a8ID\u4e3a\u7a7a\u6216\u8005\u4e3a0\uff0c\u65e0\u6cd5\u6267\u884c\u4e8b\u52a1\u3002", (String)"MessageAccessor_0", (String)"wtc-wtp-business", (Object[])new Object[0]));
                tranChangeWrapper.setCreateTaskErrTipsType("0");
                this.saveLog(logDynamicObject, tranChangeWrapper.getCreateErrMsg());
                return true;
            }
            Map changeAll = (Map)WTCServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgInfoDetailByRecordId", (Object[])new Object[]{recordId});
            Map<String, Map<String, List<Map<String, Object>>>> changeContent = CoordinationHelper.getInstance().getChangeContentByAll(changeAll);
            List<Map<String, Object>> attendNeedChange = CoordinationHelper.getInstance().getAttendNeedChange(changeContent);
            tranChangeWrapper.setAttendNeedChange(attendNeedChange);
            Map<String, Object> hrPiPerson = CoordinationHelper.getInstance().getHrPiEntityChg(attendNeedChange, "hrpi_person", null);
            if (hrPiPerson == null) {
                tranChangeWrapper.setCreateErrMsg(ResManager.loadKDString((String)"\u6838\u5fc3\u4eba\u529b\u7684\u4e8b\u52a1\u53d8\u52a8\u5bf9\u5e94\u4eba\u5458\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e5\u5fd7\u7f16\u7801{0}\u3002", (String)"CoordinationHelper_6", (String)"wtc-wtp-business", (Object[])new Object[]{tranChangeWrapper.getLogNo()}));
                tranChangeWrapper.setCreateTaskErrTipsType("0");
                this.saveLog(logDynamicObject, tranChangeWrapper.getCreateErrMsg());
                return true;
            }
            tranChangeWrapper.setHrPiPerson(hrPiPerson);
            tranChangeWrapper.setPersonIndexId((Long)hrPiPerson.get("personindexid"));
            tranChangeWrapper.setPersonId((Long)hrPiPerson.get("boid"));
            Date effectTime = new Date((Long)((Map)changeAll.get("data")).get("effectTime"));
            tranChangeWrapper.setEffectTime(effectTime);
            String msgSubNo = logDynamicObject.getString("msgsubno");
            tranChangeWrapper.setMsgSubNo(msgSubNo);
            DynamicObject currentAttFile = null;
            if (!this.checkIfEntry(msgSubNo)) {
                currentAttFile = this.initCurrentAttFile(tranChangeWrapper);
                if (currentAttFile == null) {
                    if (WTCStringUtils.isEmpty((String)tranChangeWrapper.getCreateErrMsg())) {
                        tranChangeWrapper.setCreateErrMsg(AttFileKDString.noFile());
                        tranChangeWrapper.setCreateTaskErrTipsType("0");
                    }
                    this.saveLog(logDynamicObject, tranChangeWrapper.getCreateErrMsg());
                    return true;
                }
                if (this.checkIfRetreatEvent(tranChangeWrapper)) {
                    long boId = currentAttFile.getLong("boid");
                    HashMap resultMsgMap = Maps.newHashMapWithExpectedSize((int)16);
                    resultMsgMap.put(boId, new ArrayList());
                    List tips = (List)resultMsgMap.get(boId);
                    if (!CollectionUtils.isEmpty((Collection)tips)) {
                        tranChangeWrapper.setCreateErrMsg((String)tips.get(0));
                        tranChangeWrapper.setCreateTaskErrTipsType("2");
                        this.saveLog(logDynamicObject, tranChangeWrapper.getCreateErrMsg());
                        return true;
                    }
                }
            }
            List<Map<String, Object>> newEmpPosOrgRelChgList = null;
            if (!this.checkIfRetreatEvent(tranChangeWrapper)) {
                newEmpPosOrgRelChgList = CoordinationHelper.getInstance().getNewEmpPosOrgRelList(tranChangeWrapper.getAttendNeedChange());
                if (WTCCollections.isNotEmpty(newEmpPosOrgRelChgList)) {
                    List newEmpPosOrgRelCurrentList;
                    Map<String, Object> newEmpPosOrgChgRel = newEmpPosOrgRelChgList.get(0);
                    Long newEmpPosOrgRelId = (Long)newEmpPosOrgChgRel.get("idafter");
                    tranChangeWrapper.setNewEmpPosOrgRelId(newEmpPosOrgRelId);
                    List newEmpPosOrgRelList = (List)CoordinationHelper.getInstance().invokeHRMPService("hrpi_empposorgrel", newEmpPosOrgRelId);
                    if (WTCCollections.isNotEmpty((Collection)newEmpPosOrgRelList) && WTCCollections.isNotEmpty(newEmpPosOrgRelCurrentList = newEmpPosOrgRelList.stream().filter(hr -> (Boolean)hr.get("iscurrentversion")).collect(Collectors.toList()))) {
                        if (newEmpPosOrgRelCurrentList.size() > 1) {
                            tranChangeWrapper.setCreateErrMsg(ResManager.loadKDString((String)"\u6839\u636eboID = {0} \u67e5\u8be2\u6838\u5fc3\u4eba\u529b{1}\u5b9e\u4f53\u8fd4\u56de\u591a\u6761\u6570\u636e\uff0c\u6570\u636e\u9519\u8bef\uff0c\u534f\u540c\u5931\u8d25\u3002", (String)"CoordinationHelper_2", (String)"wtc-wtp-business", (Object[])new Object[]{newEmpPosOrgRelId, "hrpi_empposorgrel"}));
                            tranChangeWrapper.setCreateTaskErrTipsType("0");
                            this.saveLog(logDynamicObject, tranChangeWrapper.getCreateErrMsg());
                            return true;
                        }
                        Map newEmpPosOrgRel = (Map)newEmpPosOrgRelCurrentList.get(0);
                        tranChangeWrapper.setNewEmpPosOrgRel(newEmpPosOrgRel);
                        Long orgId = CoordinationHelper.getInstance().getOrgIdByEmpPosOrgRel(newEmpPosOrgRel);
                        tranChangeWrapper.setNewOrgId(orgId);
                        logDynamicObject.set("org", (Object)orgId);
                    }
                } else if (currentAttFile != null) {
                    this.initOrgIdByCurrentFile(currentAttFile, tranChangeWrapper, logDynamicObject);
                }
            } else if (currentAttFile != null) {
                this.initOrgIdByCurrentFile(currentAttFile, tranChangeWrapper, logDynamicObject);
            }
        }
        return false;
    }

    public TranChangeWrapper initTranChangeWrapper(DynamicObject logDynamicObject) {
        String contextObjStr = logDynamicObject.getString("contextobject");
        TranChangeWrapper tranChangeWrapper = StringUtil.isEmpty((String)contextObjStr) ? new TranChangeWrapper() : (TranChangeWrapper)SerializationUtils.fromJsonString((String)contextObjStr, TranChangeWrapper.class);
        tranChangeWrapper.setMsgActionId(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)logDynamicObject, (String)"msgaction"));
        tranChangeWrapper.setLogNo(logDynamicObject.getString("number"));
        return tranChangeWrapper;
    }

    private void initOrgIdByCurrentFile(DynamicObject currentAttFile, TranChangeWrapper tranChangeWrapper, DynamicObject logDynamicObject) {
        Long orgId = CoordinationHelper.getInstance().getOrgIdByEmpPosOrgRel(currentAttFile.getLong("adminorg_id"));
        tranChangeWrapper.setNewOrgId(orgId);
        logDynamicObject.set("org", (Object)orgId);
    }

    private boolean checkIfRetreatEvent(TranChangeWrapper tranChangeWrapper) {
        return this.checkIfResignRetreatEvent(tranChangeWrapper) || this.checkIfEntryRetreatEvent(tranChangeWrapper);
    }

    private boolean checkIfResignRetreatEvent(TranChangeWrapper tranChangeWrapper) {
        return tranChangeWrapper.getMsgActionId() == 1110L;
    }

    private boolean checkIfEntryRetreatEvent(TranChangeWrapper tranChangeWrapper) {
        return tranChangeWrapper.getMsgActionId() == 1210L;
    }

    public DynamicObject initCurrentAttFile(TranChangeWrapper tranChangeWrapper) {
        Date queryDate = tranChangeWrapper.getEffectTime();
        if (this.checkIfRetreatEvent(tranChangeWrapper)) {
            queryDate = null;
        }
        List<DynamicObject> attFileList = CoordinationHelper.getInstance().getEmployeeFileDyList(tranChangeWrapper, queryDate);
        DynamicObject currentAttFile = null;
        if (WTCCollections.isNotEmpty(attFileList)) {
            if (this.checkIfRetreatEvent(tranChangeWrapper)) {
                this.sortAttFileList(attFileList);
                currentAttFile = attFileList.get(0);
            } else if (attFileList.size() > 1) {
                String dateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)tranChangeWrapper.getEffectTime());
                tranChangeWrapper.setCreateErrMsg(ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5728{0}\u5b58\u5728\u4e24\u6761\u4ee5\u4e0a\u6863\u6848\uff0c\u65e0\u6cd5\u534f\u540c\u3002", (String)"CoordinationDefaultFactory_0", (String)"wtc-wtp-business", (Object[])new Object[]{dateStr}));
            } else {
                currentAttFile = attFileList.get(0);
            }
        }
        return currentAttFile;
    }

    public String orgAndMsgSubscriberUniqueValidate(DynamicObject dy) {
        QFilter qFilter = new QFilter("org", "=", (Object)dy.getLong("org.id"));
        qFilter.and(new QFilter("msgsubscriber", "=", (Object)dy.getLong("msgsubscriber.id")));
        qFilter.and(new QFilter("id", "!=", dy.getPkValue()));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_coordinationconf");
        boolean exists = helper.isExists(qFilter);
        if (exists) {
            return ResManager.loadKDString((String)"\u4e0d\u53ef\u521b\u5efa\u91cd\u590d\u7684\u5df2\u8ba2\u9605\u4e1a\u52a1\u4e8b\u4ef6\u3002", (String)"CoordinationHelper_7", (String)"wtc-wtp-business", (Object[])new Object[0]);
        }
        return null;
    }

    public boolean isReviseEvent(String msgSubNo) {
        return SubscribeEnum.EMPENTREL_REVISE.getCode().equals(msgSubNo) || SubscribeEnum.TRIALPERIOD_REVISE.getCode().equals(msgSubNo) || SubscribeEnum.EMPPOSORGREL_REVISE.getCode().equals(msgSubNo);
    }
}

