/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.coordination.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonServiceImpl;
import kd.wtc.wtp.business.coordination.ICoordination;
import kd.wtc.wtp.business.coordination.factory.ICoordinationAbstractFactory;
import kd.wtc.wtp.business.coordination.helper.CoordinationHelper;
import kd.wtc.wtp.business.coordination.impl.AttendPersonCoordination;
import kd.wtc.wtp.business.coordination.impl.OnBrdRollBackCoordination;
import kd.wtc.wtp.business.coordination.impl.OnResignRollBackCoordination;
import kd.wtc.wtp.business.coordination.impl.RuleCoordination;
import kd.wtc.wtp.business.coordination.impl.UpdateAttFileCoordination;
import kd.wtc.wtp.business.coordination.wrapper.TranChangeWrapper;

public class CoordinationDefaultFactory
implements ICoordinationAbstractFactory {
    @Override
    public ICoordination makeUpdateAttFileCoordination(TranChangeWrapper tranChangeWrapper) {
        return new UpdateAttFileCoordination();
    }

    @Override
    public ICoordination makeAttendPersonCoordination(TranChangeWrapper tranChangeWrapper) {
        return new AttendPersonCoordination();
    }

    @Override
    public ICoordination getNeedCoordination(TranChangeWrapper tranChangeWrapper) {
        String msgSubNo = tranChangeWrapper.getMsgSubNo();
        if (CoordinationHelper.getInstance().checkIfPersonChange(msgSubNo)) {
            return this.getCoordination(tranChangeWrapper);
        }
        if (CoordinationHelper.getInstance().checkIfResign(msgSubNo)) {
            return this.makeUpdateAttFileCoordination(tranChangeWrapper);
        }
        if (1210L == tranChangeWrapper.getMsgActionId()) {
            return new OnBrdRollBackCoordination();
        }
        if (1110L == tranChangeWrapper.getMsgActionId()) {
            return new OnResignRollBackCoordination();
        }
        return this.getRuleCoordination(tranChangeWrapper);
    }

    @Override
    public ICoordination getRuleCoordination(TranChangeWrapper tranChangeWrapper) {
        return new RuleCoordination();
    }

    private ICoordination getCoordination(TranChangeWrapper tranChangeWrapper) {
        DynamicObject attPerson = AttendPersonServiceImpl.getInstance().queryAttendPersonByPersonId(Long.valueOf(tranChangeWrapper.getPersonId()));
        if (attPerson != null && attPerson.getString("name").equals(tranChangeWrapper.getHrPiPerson().get("name"))) {
            return this.makeAttendPersonCoordination(tranChangeWrapper);
        }
        if (attPerson != null && !attPerson.getString("name").equals(tranChangeWrapper.getHrPiPerson().get("name"))) {
            if (CoordinationHelper.getInstance().checkIfPersonChange(tranChangeWrapper.getMsgSubNo())) {
                tranChangeWrapper.setOnlySyncName(true);
            }
            return this.makeUpdateAttFileCoordination(tranChangeWrapper);
        }
        return null;
    }
}

