/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.coordination.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.license.CertControlType;
import kd.wtc.wtbs.business.license.CertService;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrResult;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonSynService;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attfile.AttFileServiceImpl;
import kd.wtc.wtp.business.attfile.cert.AttFileCertService;
import kd.wtc.wtp.business.attperiod.PerAttPeriodDataService;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.business.coordination.helper.CoordinationHelper;
import kd.wtc.wtp.business.coordination.impl.AttFileCoordination;
import kd.wtc.wtp.business.coordination.wrapper.TranChangeWrapper;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;

public class OnResignRollBackCoordination
extends AttFileCoordination {
    private static final Log LOG = LogFactory.getLog(OnResignRollBackCoordination.class);

    @Override
    public Map<String, List<DynamicObject>> dataMapping(DynamicObject dy, TranChangeWrapper tranChangeWrapper) {
        HashMap dyMap = Maps.newHashMapWithExpectedSize((int)1);
        List<DynamicObject> attFileList = CoordinationHelper.getInstance().queryAttListByBoId(tranChangeWrapper.getRevertAttFileBoId());
        dyMap.put(ATT_FILE, attFileList);
        return dyMap;
    }

    @Override
    public List<OperationResult> coordinationExecute(DynamicObject dy, TranChangeWrapper tranChangeWrapper, Map<String, List<DynamicObject>> dyMap) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)1);
        OperationResult operationResult = new OperationResult();
        if (WTCCollections.isNotEmpty(dyMap)) {
            block19: {
                if (StringUtil.isEmpty((String)tranChangeWrapper.getErrMsg())) {
                    List<DynamicObject> attFileList = dyMap.get(ATT_FILE);
                    List personIds = attFileList.stream().map(data -> data.getLong("person.id")).collect(Collectors.toList());
                    List empPosIds = attFileList.stream().map(data -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)data, (String)"empposorgrel")).collect(Collectors.toList());
                    AttendPersonCurrResult attendPersonCurrResult = AttendPersonSynService.getInstance().checkAndGetPersonData(personIds, empPosIds, null);
                    List<Long> personCertIds = AttFileCertService.getAddCertDealId(attFileList);
                    try (TXHandle tx = TX.required();){
                        try {
                            operationResult.setSuccess(true);
                            attFileList.forEach(file -> file.set("enddate", (Object)WTCHisServiceHelper.getMaxEndDate()));
                            AttFileServiceImpl.getInstance().attFileRevise(attFileList.toArray(new DynamicObject[0]));
                            Set<Long> boIdSet = Collections.singleton(tranChangeWrapper.getRevertAttFileBoId());
                            Map<String, Object> rollBackResult = AttFileServiceImpl.getInstance().rollBackFileToNormalAtt(boIdSet);
                            if (WTCCollections.isNotEmpty(rollBackResult)) {
                                tranChangeWrapper.setRollbackResult(rollBackResult);
                            }
                            AttendPersonSynService.getInstance().setEarliestAndLatestDate(attFileList.toArray(new DynamicObject[0]), attendPersonCurrResult);
                            AttendPersonSynService.getInstance().updateAttPerson(attendPersonCurrResult);
                            HashMap fileBoIdAndPersonIdMap = Maps.newHashMapWithExpectedSize((int)1);
                            fileBoIdAndPersonIdMap.put(tranChangeWrapper.getRevertAttFileBoId(), personIds.get(0));
                            PerAttPeriodDataService.getInstance().processPerAttPeriod(null, fileBoIdAndPersonIdMap);
                            if (LOG.isInfoEnabled()) {
                                LOG.info("call CertService.certControlOfAttPerson personCertIds = {}", (Object)SerializationUtils.toJsonString(personCertIds));
                            }
                            if (WTCCollections.isNotEmpty(personCertIds)) {
                                CertService.certControlOfAttPerson((String)"wtp", (String)"wtp_attfilebase", new HashSet<Long>(personCertIds), (CertControlType)CertControlType.VALIDATORANDAPPLIED);
                            }
                            this.rollBackExcInfo(tranChangeWrapper.getRevertAttFileBoId());
                            break block19;
                        }
                        catch (Exception exception) {
                            tx.markRollback();
                            throw new KDBizException((Throwable)exception, new ErrorCode("", exception.getMessage()), new Object[0]);
                        }
                    }
                }
                operationResult.setSuccess(false);
            }
            resultList.add(operationResult);
        }
        return resultList;
    }

    private void rollBackExcInfo(Long fileBoId) {
        List<AttStateInfoBO> attStateInfoBOS = AttStateInfoService.getInstance().queryAttStateInfoByBoid(Collections.singletonList(fileBoId));
        if (!CollectionUtils.isEmpty(attStateInfoBOS)) {
            HashMap fileBoIdWtteDyMap = Maps.newHashMapWithExpectedSize((int)1);
            ArrayList needUpdateFileBoIdList = Lists.newArrayListWithExpectedSize((int)1);
            HashMap newWtteDyMap = Maps.newHashMapWithExpectedSize((int)3);
            newWtteDyMap.put("isinfoexc", Boolean.FALSE);
            newWtteDyMap.put("excstartdate", null);
            newWtteDyMap.put("excenddate", null);
            fileBoIdWtteDyMap.put(fileBoId, newWtteDyMap);
            needUpdateFileBoIdList.add(fileBoId);
            if (WTCMaps.isNotEmpty((Map)fileBoIdWtteDyMap)) {
                AttStateInfoService.getInstance().updateExcInfo(fileBoIdWtteDyMap, needUpdateFileBoIdList);
            }
        }
    }
}

