/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.coordination.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.sdk.wtc.wtp.business.coordination.CoordinationExpandParam;
import kd.sdk.wtc.wtp.business.coordination.CoordinationExpandService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HSPMServiceImpl;
import kd.wtc.wtbs.common.enums.file.FileTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.business.coordination.CoordinationService;
import kd.wtc.wtp.business.coordination.helper.CoordinationHelper;
import kd.wtc.wtp.business.coordination.impl.AttFileCoordination;
import kd.wtc.wtp.business.coordination.wrapper.TranChangeWrapper;
import kd.wtc.wtp.common.model.coordination.CoordinationConfigModel;
import kd.wtc.wtp.common.model.file.FileSaveDto;
import kd.wtc.wtp.enums.coordination.AttCardTypeEnum;
import kd.wtc.wtp.enums.coordination.CoordinationConfTypeEnums;

public class RuleCoordination
extends AttFileCoordination {
    private static final Set<String> REG_ENTITY = Sets.newHashSetWithExpectedSize((int)8);
    private static final String COORDINATION_EXP_SERVICE = "kd.sdk.wtc.wtp.business.coordination.CoordinationExpandService";
    private static final Log LOG;

    @Override
    public Map<String, List<DynamicObject>> dataMapping(DynamicObject dy, TranChangeWrapper tranChangeWrapper) {
        HashMap dyMap = Maps.newHashMapWithExpectedSize((int)1);
        Map<String, Set<String>> sceneInputParam = CoordinationService.getInstance().getSceneInputParam();
        if (LOG.isInfoEnabled()) {
            LOG.info("longNo: {}, dataMapping sceneInputParam: {}", (Object)tranChangeWrapper.getLogNo(), (Object)SerializationUtils.toJsonString(sceneInputParam));
        }
        HashMap entryPointInputParam = Maps.newHashMapWithExpectedSize((int)8);
        HRBaseServiceHelper attFileServiceHelper = new HRBaseServiceHelper("wtp_attfilebase");
        DynamicObject newAttFile = attFileServiceHelper.generateEmptyDynamicObject();
        DynamicObject currentAttFile = this.initCurrentFile(tranChangeWrapper);
        if (currentAttFile != null) {
            HRDynamicObjectUtils.copy((DynamicObject)currentAttFile, (DynamicObject)newAttFile, (Set)WTCHisServiceHelper.getHisIgnoreKeysSet());
        }
        FileSaveDto fileSaveDto = CoordinationHelper.getInstance().fillEmpPosOrgRelInfo(tranChangeWrapper, newAttFile);
        newAttFile.set("dependency", null);
        newAttFile.set("empgroup", null);
        newAttFile.set("atttag", null);
        newAttFile.set("workplace", null);
        if (WTCCollections.isNotEmpty(sceneInputParam)) {
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)8);
            sceneInputParam.forEach((entity, fieldSet) -> {
                if (!REG_ENTITY.contains(entity)) {
                    entryPointInputParam.put(entity, fieldSet);
                }
                this.callInterfaceFillParamMap((String)entity, (Set<String>)fieldSet, tranChangeWrapper, currentAttFile, paramMap);
            });
            this.callEntryPointFillParamMap(entryPointInputParam, tranChangeWrapper, paramMap);
            if (LOG.isInfoEnabled()) {
                LOG.info("longNo: {}, callCoordinationMatchRes  paramMap: {}, tranChangeWrapper.getConfigId() = {}", new Object[]{tranChangeWrapper.getLogNo(), SerializationUtils.toJsonString((Object)paramMap), tranChangeWrapper.getConfigId()});
            }
            paramMap.put("currentLogOrgId", WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"org"));
            Map<String, Object> coordinationMatchRes = CoordinationService.getInstance().getCoordinationMatchRes(tranChangeWrapper.getConfigId(), paramMap, newAttFile);
            newAttFile = (DynamicObject)coordinationMatchRes.get("data");
            if (LOG.isInfoEnabled()) {
                LOG.info("longNo: {}, callCoordinationMatchRes  newAttFile: {}", (Object)tranChangeWrapper.getLogNo(), (Object)SerializationUtils.toJsonString((Object)newAttFile));
            }
        }
        if (WTCStringUtils.isNotEmpty((String)newAttFile.getString("card"))) {
            String card = newAttFile.getString("card");
            if (AttCardTypeEnum.SAMEJOBNUMBER.getCode().equals(card)) {
                newAttFile.set("card", tranChangeWrapper.getHrPiPerson().get("number"));
            } else {
                newAttFile.set("card", null);
            }
        }
        if (LOG.isInfoEnabled()) {
            AttFileHelper.logAttFileField(newAttFile, "dataMapping1", LOG);
        }
        newAttFile.set("affiliateadminorg", (Object)CoordinationHelper.getInstance().getDy("haos_adminorghr", fileSaveDto.getAdminOrgId()));
        if (CoordinationHelper.getInstance().checkIfEntry(tranChangeWrapper.getMsgSubNo())) {
            CoordinationHelper.getInstance().fillEntryStartDate(newAttFile, tranChangeWrapper);
            this.initAttTagDy(newAttFile);
            newAttFile.set("type", (Object)FileTypeEnum.ALLFILE.getFileType());
            newAttFile.set("filetype", (Object)"A");
            newAttFile.set("org", (Object)CoordinationHelper.getInstance().getDy("bos_org", tranChangeWrapper.getNewOrgId()));
            List<Map<String, Object>> hsPmErManFileList = this.callHsPmErManFile(tranChangeWrapper.getPersonId(), (Long)tranChangeWrapper.getNewEmpPosOrgRel().get("depemp_id"));
            if (WTCCollections.isNotEmpty(hsPmErManFileList)) {
                Map<String, Object> hsPmErManFile = hsPmErManFileList.get(0);
                Object dependencyTypeIdObj = hsPmErManFile.get("dependencytype_id");
                if (dependencyTypeIdObj == null || dependencyTypeIdObj.equals(0L)) {
                    newAttFile.set("dependencytype", (Object)CoordinationHelper.getInstance().getDy("hbss_depcytype", 1010L));
                } else {
                    newAttFile.set("dependencytype", (Object)CoordinationHelper.getInstance().getDy("hbss_depcytype", (Long)hsPmErManFile.get("dependencytype_id")));
                }
            }
            if (newAttFile.get("dependencytype") == null) {
                newAttFile.set("dependencytype", (Object)CoordinationHelper.getInstance().getDy("hbss_depcytype", 1010L));
            }
            CoordinationHelper.getInstance().callEntryPoint(newAttFile, tranChangeWrapper);
        } else if (currentAttFile != null && tranChangeWrapper.getNewOrgId() != WTCDynamicObjectUtils.getBaseDataId((DynamicObject)currentAttFile, (String)"org")) {
            newAttFile.set("startdate", (Object)tranChangeWrapper.getEffectTime());
            this.initAttTagDy(newAttFile);
            newAttFile.set("number", null);
            newAttFile.set("type", (Object)FileTypeEnum.ALLFILE.getFileType());
            newAttFile.set("filetype", (Object)"A");
            newAttFile.set("org", (Object)CoordinationHelper.getInstance().getDy("bos_org", tranChangeWrapper.getNewOrgId()));
        } else {
            newAttFile.set("bsed", (Object)tranChangeWrapper.getEffectTime());
            if (currentAttFile != null) {
                newAttFile.set("startdate", (Object)currentAttFile.getDate("startdate"));
                newAttFile.set("bsled", (Object)currentAttFile.getDate("enddate"));
            }
        }
        if (LOG.isInfoEnabled()) {
            AttFileHelper.logAttFileField(newAttFile, "dataMapping2", LOG);
        }
        CoordinationService.getInstance().initNoMatchRules(newAttFile, tranChangeWrapper);
        this.resetBaseInfoData(currentAttFile, newAttFile, tranChangeWrapper);
        dyMap.put(ATT_FILE, Collections.singletonList(newAttFile));
        return dyMap;
    }

    private void resetBaseInfoData(DynamicObject currentAttFile, DynamicObject newAttFile, TranChangeWrapper tranChangeWrapper) {
        List<CoordinationConfigModel> list = tranChangeWrapper.getCoordinationConfigModelList();
        for (CoordinationConfigModel model : list) {
            Boolean setEmpty;
            CoordinationConfTypeEnums confTypeEnums = model.getCoordinationConfTypeEnums();
            if (CoordinationConfTypeEnums.EMPGROUP != confTypeEnums && CoordinationConfTypeEnums.DEPENDENC != confTypeEnums && CoordinationConfTypeEnums.WORKPLACE != confTypeEnums && CoordinationConfTypeEnums.ATTTAG != confTypeEnums || !Boolean.FALSE.equals(setEmpty = model.getSetEmpty()) || currentAttFile == null) continue;
            String fieldStr = CoordinationConfTypeEnums.getRightDependencyFieldStr((String)confTypeEnums.getCode());
            newAttFile.set(fieldStr, currentAttFile.get(fieldStr));
        }
    }

    private void initAttTagDy(DynamicObject newAttFile) {
        long id = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)newAttFile, (String)"atttag");
        if (id != 0L) {
            HRBaseServiceHelper attendTagService = new HRBaseServiceHelper("wtbd_attendtag");
            DynamicObject dynamicObject = attendTagService.loadSingle((Object)id);
            newAttFile.set("atttag", (Object)dynamicObject);
        }
    }

    private void callEntryPointFillParamMap(Map<String, Set<String>> entryPointInputParam, TranChangeWrapper tranChangeWrapper, Map<String, Object> paramMap) {
        CoordinationExpandParam expandParam = new CoordinationExpandParam();
        expandParam.setPersonId(tranChangeWrapper.getPersonId());
        expandParam.setEmpPosOrgRelId(tranChangeWrapper.getNewEmpPosOrgRelId());
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, CoordinationExpandService.class, (String)COORDINATION_EXP_SERVICE, null);
        List expMapList = pluginProxy.callReplace(expandService -> expandService.genCoordinationSceneExpand(expandParam));
        if (CollectionUtils.isEmpty((Collection)expMapList)) {
            return;
        }
        LOG.info("CoordinationExpandService,found expand scene input param");
        Map expMap = (Map)expMapList.get(0);
        for (Map.Entry entry : expMap.entrySet()) {
            if (!entryPointInputParam.containsKey(entry.getKey())) continue;
            paramMap.put((String)entry.getKey(), entry.getValue());
        }
    }

    private void callInterfaceFillParamMap(String entity, Set<String> fieldSet, TranChangeWrapper tranChangeWrapper, DynamicObject currentAttFile, Map<String, Object> paramMap) {
        List<Long> personIdList = Collections.singletonList(tranChangeWrapper.getPersonId());
        Date effectTime = tranChangeWrapper.getEffectTime();
        HRPIMServiceImpl hrpimService = HRPIMServiceImpl.getInstance();
        String properties = String.join((CharSequence)",", fieldSet);
        if ("hrpi_pernontsprop".equals(entity) && StringUtils.isNotEmpty((String)properties)) {
            DynamicObject[] perNotPropArr = HRPIMServiceImpl.getInstance().listFieldsFilterInfo(properties, new QFilter("person.id", "in", personIdList), "hrpi_pernontsprop");
            if (LOG.isInfoEnabled()) {
                LOG.info("callInterfaceFillParamMap, perNotPropArr = {}", (Object)SerializationUtils.toJsonString((Object)perNotPropArr));
            }
            if (perNotPropArr != null && perNotPropArr.length > 0) {
                paramMap.put("hrpi_pernontsprop", perNotPropArr[0]);
            }
        }
        if ("hrpi_empentrel".equals(entity) && StringUtils.isNotEmpty((String)properties)) {
            List empentrelArr = hrpimService.listIntersectBusinessInfo("hrpi_empentrel", properties, effectTime, effectTime, personIdList, null, null);
            if (LOG.isInfoEnabled()) {
                LOG.info("callInterfaceFillParamMap, empentrelArr = {}", (Object)SerializationUtils.toJsonString((Object)empentrelArr));
            }
            if (WTCCollections.isNotEmpty((Collection)empentrelArr)) {
                paramMap.put("hrpi_empentrel", empentrelArr.get(0));
            }
        }
        if ("hrpi_empposorgrel".equals(entity) && StringUtils.isNotEmpty((String)properties)) {
            List empPosOrgRelArr = hrpimService.listIntersectBusinessInfo("hrpi_empposorgrel", properties, effectTime, effectTime, personIdList, null, null);
            if (LOG.isInfoEnabled()) {
                LOG.info("callInterfaceFillParamMap, empPosOrgRelArr = {}", (Object)SerializationUtils.toJsonString((Object)empPosOrgRelArr));
            }
            if (WTCCollections.isNotEmpty((Collection)empPosOrgRelArr)) {
                paramMap.put("hrpi_empposorgrel", empPosOrgRelArr.get(0));
            }
        }
        if ("hrpi_managingscope".equals(entity) && StringUtils.isNotEmpty((String)properties)) {
            List cpmepmArr = hrpimService.listIntersectBusinessInfo("hrpi_managingscope", properties, effectTime, effectTime, personIdList, null, null);
            if (LOG.isInfoEnabled()) {
                LOG.info("callInterfaceFillParamMap, cpmepmArr = {}", (Object)SerializationUtils.toJsonString((Object)cpmepmArr));
            }
            if (WTCCollections.isNotEmpty((Collection)cpmepmArr)) {
                paramMap.put("hrpi_managingscope", cpmepmArr.get(0));
            }
        }
        if ("hrpi_empjobrel".equals(entity) && StringUtils.isNotEmpty((String)properties)) {
            List empJobRelArr = hrpimService.listIntersectBusinessInfo("hrpi_empjobrel", properties, effectTime, effectTime, personIdList, null, null);
            if (LOG.isInfoEnabled()) {
                LOG.info("callInterfaceFillParamMap, empJobRelArr = {}", (Object)SerializationUtils.toJsonString((Object)empJobRelArr));
            }
            if (WTCCollections.isNotEmpty((Collection)empJobRelArr)) {
                paramMap.put("hrpi_empjobrel", empJobRelArr.get(0));
            }
        }
        if ("hrpi_trialperiod".equals(entity) && StringUtils.isNotEmpty((String)properties)) {
            List trialPeriodArr = hrpimService.listIntersectBusinessInfo("hrpi_trialperiod", properties, WTCHisServiceHelper.getMinEndDate(), WTCHisServiceHelper.getMaxEndDate(), personIdList, null, null);
            if (LOG.isInfoEnabled()) {
                LOG.info("callInterfaceFillParamMap, trialPeriodArr = {}", (Object)SerializationUtils.toJsonString((Object)trialPeriodArr));
            }
            if (WTCCollections.isNotEmpty((Collection)trialPeriodArr)) {
                paramMap.put("hrpi_trialperiod", trialPeriodArr.get(0));
            }
        }
        if ("hrpi_laborrelrecord".equals(entity) && StringUtils.isNotEmpty((String)properties)) {
            List laborrelrecordArr = hrpimService.listIntersectBusinessInfo("hrpi_laborrelrecord", properties, effectTime, effectTime, personIdList, null, null);
            if (LOG.isInfoEnabled()) {
                LOG.info("callInterfaceFillParamMap, laborrelrecordArr = {}", (Object)SerializationUtils.toJsonString((Object)laborrelrecordArr));
            }
            if (WTCCollections.isNotEmpty((Collection)laborrelrecordArr)) {
                paramMap.put("hrpi_laborrelrecord", laborrelrecordArr.get(0));
            }
        }
        if ("hspm_ermanfile".equals(entity) && StringUtils.isNotEmpty((String)properties)) {
            long depEmpId = 0L;
            if (tranChangeWrapper.getNewEmpPosOrgRel() != null) {
                depEmpId = (Long)tranChangeWrapper.getNewEmpPosOrgRel().get("depemp_id");
            } else if (currentAttFile != null) {
                depEmpId = currentAttFile.getLong("depemp.id");
            }
            List<Map<String, Object>> dataList = this.callHsPmErManFile(tranChangeWrapper.getPersonId(), depEmpId);
            if (LOG.isInfoEnabled()) {
                LOG.info("callInterfaceFillParamMap, dataList = {}", (Object)SerializationUtils.toJsonString(dataList));
            }
            if (WTCCollections.isNotEmpty(dataList)) {
                Map<String, Object> erManFileMap = dataList.get(0);
                HRBaseServiceHelper erManFileServiceHelper = new HRBaseServiceHelper("hspm_ermanfile");
                DynamicObject erManFileDy = erManFileServiceHelper.generateEmptyDynamicObject();
                fieldSet.forEach(field -> {
                    if ("dependency".equals(field)) {
                        erManFileDy.set(field, (Object)CoordinationHelper.getInstance().getDy("bd_country", (Long)erManFileMap.get(field + "_id")));
                    } else if ("dependencytype".equals(field)) {
                        erManFileDy.set(field, (Object)CoordinationHelper.getInstance().getDy("hbss_depcytype", (Long)erManFileMap.get(field + "_id")));
                    } else if ("empgroup".equals(field)) {
                        erManFileDy.set(field, (Object)CoordinationHelper.getInstance().getDy("hbss_empgroup", (Long)erManFileMap.get(field + "_id")));
                    }
                });
                paramMap.put("hspm_ermanfile", erManFileDy);
            }
        }
    }

    private List<Map<String, Object>> callHsPmErManFile(long personId, long depEmpId) {
        return HSPMServiceImpl.getInstance().queryErManFileDetail(personId, depEmpId);
    }

    @Override
    public List<OperationResult> coordinationExecute(DynamicObject dy, TranChangeWrapper tranChangeWrapper, Map<String, List<DynamicObject>> dyMap) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)1);
        DynamicObject currentAttFile = this.initCurrentFile(tranChangeWrapper);
        if (WTCCollections.isNotEmpty(dyMap)) {
            List<DynamicObject> dynamicObjects = dyMap.get(ATT_FILE);
            if (WTCCollections.isEmpty(dynamicObjects)) {
                return resultList;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("longNo: {}, coordinationExecute  newAttFile: {}", (Object)tranChangeWrapper.getLogNo(), (Object)SerializationUtils.toJsonString(dynamicObjects));
            }
            if (WTCStringUtils.isNotEmpty((String)tranChangeWrapper.getMsgSubNo())) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    dynamicObject.set("sourcetype", (Object)tranChangeWrapper.getMsgSubNo());
                }
            }
            if (CoordinationHelper.getInstance().checkIfEntry(tranChangeWrapper.getMsgSubNo())) {
                resultList.add(this.newAttFile(dynamicObjects, dy, tranChangeWrapper));
            } else if (currentAttFile != null && tranChangeWrapper.getNewOrgId() != WTCDynamicObjectUtils.getBaseDataId((DynamicObject)currentAttFile, (String)"org")) {
                resultList.add(this.newAttFile(dynamicObjects, dy, tranChangeWrapper));
            } else {
                resultList.add(this.updateAttFile(dynamicObjects, dy, tranChangeWrapper));
            }
        }
        return resultList;
    }

    static {
        REG_ENTITY.add("hrpi_pernontsprop");
        REG_ENTITY.add("hrpi_empentrel");
        REG_ENTITY.add("hrpi_empposorgrel");
        REG_ENTITY.add("hrpi_cmpemp");
        REG_ENTITY.add("hrpi_empjobrel");
        REG_ENTITY.add("hrpi_trialperiod");
        REG_ENTITY.add("hrpi_laborrelrecord");
        REG_ENTITY.add("hspm_ermanfile");
        LOG = LogFactory.getLog(RuleCoordination.class);
    }
}

