/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.coordination.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.common.enums.AttendEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attfile.AttFileServiceImpl;
import kd.wtc.wtp.business.coordination.ICoordination;
import kd.wtc.wtp.business.coordination.impl.AttFileCoordination;
import kd.wtc.wtp.business.coordination.impl.CoordinationDefaultFactory;
import kd.wtc.wtp.business.coordination.wrapper.TranChangeWrapper;
import kd.wtc.wtp.enums.coordination.SubscribeEnum;

public class UpdateAttFileCoordination
extends AttFileCoordination {
    private static final Log LOG = LogFactory.getLog(UpdateAttFileCoordination.class);

    @Override
    public Map<String, List<DynamicObject>> dataMapping(DynamicObject dy, TranChangeWrapper tranChangeWrapper) {
        DynamicObject currentAttFile = this.initCurrentFile(tranChangeWrapper);
        String msgSubNo = tranChangeWrapper.getMsgSubNo();
        HashMap dyMap = Maps.newHashMapWithExpectedSize((int)1);
        if (currentAttFile != null) {
            if (tranChangeWrapper.getOnlySyncName() && SubscribeEnum.PERSON_ATTACHE_INFO_MDF.getCode().equals(msgSubNo)) {
                currentAttFile.set("name", tranChangeWrapper.getHrPiPerson().get("name"));
                currentAttFile.set("textname", tranChangeWrapper.getHrPiPerson().get("name"));
                dyMap.put(ATT_FILE, Collections.singletonList(currentAttFile));
                return dyMap;
            }
            HRBaseServiceHelper attFileServiceHelper = new HRBaseServiceHelper("wtp_attfilebase");
            DynamicObject updateAttFile = attFileServiceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)currentAttFile, (DynamicObject)updateAttFile, (Set)WTCHisServiceHelper.getHisIgnoreKeysSet());
            if (SubscribeEnum.RESIGN.getCode().equals(msgSubNo)) {
                HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtbd_attendtag");
                DynamicObject attend = hrBaseServiceHelper.loadSingle((Object)AttendEnum.LEAVE.getId());
                updateAttFile.set("atttag", (Object)attend);
            } else if (SubscribeEnum.PERSON_ATTACHE_INFO_MDF.getCode().equals(msgSubNo)) {
                updateAttFile.set("name", tranChangeWrapper.getHrPiPerson().get("name"));
            }
            LOG.info("coordination log attFileId: {0} endDate: {1}", (Object)currentAttFile.getLong("id"), (Object)currentAttFile.getDate("enddate"));
            updateAttFile.set("bsed", (Object)tranChangeWrapper.getEffectTime());
            updateAttFile.set("bsled", (Object)currentAttFile.getDate("enddate"));
            dyMap.put(ATT_FILE, Collections.singletonList(updateAttFile));
        }
        return dyMap;
    }

    @Override
    public List<OperationResult> coordinationExecute(DynamicObject messageDy, TranChangeWrapper tranChangeWrapper, Map<String, List<DynamicObject>> dyMap) {
        List<DynamicObject> attFileList;
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)1);
        if (tranChangeWrapper.getOnlySyncName()) {
            return this.handleOnlySyncName(messageDy, tranChangeWrapper, dyMap, resultList);
        }
        if (WTCCollections.isNotEmpty(dyMap) && WTCCollections.isNotEmpty(attFileList = dyMap.get(ATT_FILE))) {
            if (WTCStringUtils.isNotEmpty((String)tranChangeWrapper.getMsgSubNo())) {
                for (DynamicObject dynamicObject : attFileList) {
                    dynamicObject.set("sourcetype", (Object)tranChangeWrapper.getMsgSubNo());
                }
            }
            resultList.add(this.updateAttFile(attFileList, messageDy, tranChangeWrapper));
        }
        return resultList;
    }

    private List<OperationResult> handleOnlySyncName(DynamicObject messageDy, TranChangeWrapper tranChangeWrapper, Map<String, List<DynamicObject>> dyMap, List<OperationResult> resultList) {
        List<DynamicObject> attFiles = this.checkOperationResult(dyMap, resultList);
        try {
            AttFileServiceImpl.getInstance().attFileRevise(attFiles.toArray(new DynamicObject[0]));
            CoordinationDefaultFactory factory = new CoordinationDefaultFactory();
            ICoordination iCoordination = factory.makeAttendPersonCoordination(tranChangeWrapper);
            dyMap.clear();
            dyMap = iCoordination.dataMapping(messageDy, tranChangeWrapper);
            List<OperationResult> operationResultList = iCoordination.coordinationExecute(messageDy, tranChangeWrapper, dyMap);
            resultList.addAll(operationResultList);
        }
        catch (Exception ex) {
            LOG.error("UpdateAttFileCoordination#handleOnlySyncName#error", (Throwable)ex);
            throw new KDBizException("UpdateAttFileCoordination#handleOnlySyncName#error");
        }
        return resultList;
    }

    private List<DynamicObject> checkOperationResult(Map<String, List<DynamicObject>> dyMap, List<OperationResult> resultList) {
        List<DynamicObject> attFiles = dyMap.get(ATT_FILE);
        if (CollectionUtils.isEmpty(attFiles)) {
            OperationResult operationResult = new OperationResult();
            operationResult.setSuccess(false);
            resultList.add(operationResult);
        }
        return attFiles;
    }
}

