/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.cumulate.calculate.model;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.cumulate.calculate.model.QTType;

public class QTDeductRule {
    private long id;
    private String category;
    private String unit;
    private BigDecimal lowerLimit;
    private List<QTType> deductOrder;
    private List<OrderRule> orderRuleList;

    public static QTDeductRule parse(DynamicObject dyn) {
        QTDeductRule res = new QTDeductRule();
        res.setId(dyn.getLong("id"));
        res.setCategory(dyn.getString("category"));
        res.setUnit(dyn.getString("unit"));
        BigDecimal lowerLimitFromDB = dyn.getBigDecimal("lowerlimit");
        if (lowerLimitFromDB == null) {
            lowerLimitFromDB = BigDecimal.ZERO;
        }
        res.setLowerLimit(lowerLimitFromDB);
        List<QTType> collect = dyn.getDynamicObjectCollection("entryentity").stream().map(row -> QTType.parse(row.getDynamicObject("qttype"))).collect(Collectors.toList());
        res.setDeductOrder(collect);
        List<OrderRule> orderRule = dyn.getDynamicObjectCollection("orderentity").stream().map(row -> new OrderRule(row.getString("sortfield"), row.getString("sortrule"))).filter(ele -> WTCStringUtils.isNotEmpty((String)ele.getSortField()) && WTCStringUtils.isNotEmpty((String)ele.getSortRule())).collect(Collectors.toList());
        res.setOrderRuleList(orderRule);
        return res;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(BigDecimal lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public List<QTType> getDeductOrder() {
        return this.deductOrder;
    }

    public void setDeductOrder(List<QTType> deductOrder) {
        this.deductOrder = deductOrder;
    }

    public List<OrderRule> getOrderRuleList() {
        return this.orderRuleList;
    }

    public void setOrderRuleList(List<OrderRule> orderRuleList) {
        this.orderRuleList = orderRuleList;
    }

    public String toString() {
        return "QTDeductRule{id=" + this.id + ", category='" + this.category + '\'' + ", unit='" + this.unit + '\'' + ", deductOrder=" + this.deductOrder + '}';
    }

    public static class OrderRule {
        String sortField;
        String sortRule;

        public OrderRule(String sortField, String sortRule) {
            this.sortField = sortField;
            this.sortRule = sortRule;
        }

        public String getSortField() {
            return this.sortField;
        }

        public String getSortRule() {
            return this.sortRule;
        }
    }
}

