/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.cumulate.calculate.model.result;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtp.business.cumulate.calculate.model.result.SBApplyRes;

public class MBApplyRes
implements Serializable {
    private static final long serialVersionUID = 5841925000025752551L;
    public static final String ALL_SUCCESS = "A";
    public static final String ALL_FAIL = "B";
    public static final String PARTIAL_SUCCESS = "C";
    public static final String CAUSE_FROM_BILL = "A";
    public static final String CAUSE_FROM_ENTRY = "B";
    public static final String CAUSE_FROM_UNKNOW = "C";
    private long id;
    private String frozenResult;
    private String errCode;
    private String errMsg;
    private String causeFrom;
    private List<SBApplyRes> sbApplyResList;

    public static MBApplyRes success(long id, List<SBApplyRes> sbApplyResList) {
        MBApplyRes res = new MBApplyRes();
        res.setId(id);
        res.setSbApplyResList(sbApplyResList);
        res.correctFrozenResult();
        return res;
    }

    public static MBApplyRes error(long id, String errorCode, String errMsg, String causeFrom, List<SBApplyRes> sbApplyResList) {
        MBApplyRes res = new MBApplyRes();
        res.setId(id);
        res.setErrCode(errorCode);
        res.setErrMsg(errMsg);
        res.setCauseFrom(causeFrom);
        res.setSbApplyResList(sbApplyResList);
        res.correctFrozenResult();
        return res;
    }

    @Deprecated
    public static MBApplyRes error(long id, String errorCode, String errMsg, List<SBApplyRes> sbApplyResList) {
        return MBApplyRes.error(id, errorCode, errMsg, "C", sbApplyResList);
    }

    public Map<String, Object> getErrEntryRetData() {
        Optional<SBApplyRes> first;
        if (!this.isAllSuccess() && "B".equals(this.causeFrom) && WTCCollections.isNotEmpty(this.sbApplyResList) && (first = this.sbApplyResList.stream().filter(ele -> !ele.isSuccess() && !ele.getErrCode().equals("CAUSE_BY_PREVIOUS_ENTRY")).findFirst()).isPresent()) {
            return first.get().getRetData();
        }
        return Collections.emptyMap();
    }

    public void correctFrozenResult() {
        if (WTCCollections.isEmpty(this.getSbApplyResList())) {
            if (this.errCode == null) {
                this.setFrozenResult("A");
            } else {
                this.setFrozenResult("B");
            }
            return;
        }
        int successCnt = 0;
        int failCnt = 0;
        for (SBApplyRes entry : this.getSbApplyResList()) {
            if (entry.isSuccess()) {
                ++successCnt;
                continue;
            }
            ++failCnt;
        }
        if (successCnt != 0 && failCnt != 0) {
            this.setFrozenResult("C");
        } else if (successCnt != 0) {
            this.setFrozenResult("A");
        } else {
            this.setFrozenResult("B");
        }
    }

    public boolean isAllSuccess() {
        if (this.getFrozenResult() == null) {
            this.correctFrozenResult();
        }
        return "A".equals(this.getFrozenResult());
    }

    public boolean isAllFail() {
        if (this.getFrozenResult() == null) {
            this.correctFrozenResult();
        }
        return "B".equals(this.getFrozenResult());
    }

    public boolean isPartialSuccess() {
        if (this.getFrozenResult() == null) {
            this.correctFrozenResult();
        }
        return "C".equals(this.getFrozenResult());
    }

    public String getCauseFrom() {
        return this.causeFrom;
    }

    public void setCauseFrom(String causeFrom) {
        this.causeFrom = causeFrom;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getFrozenResult() {
        return this.frozenResult;
    }

    public void setFrozenResult(String frozenResult) {
        this.frozenResult = frozenResult;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public List<SBApplyRes> getSbApplyResList() {
        return this.sbApplyResList;
    }

    public void setSbApplyResList(List<SBApplyRes> sbApplyResList) {
        this.sbApplyResList = sbApplyResList;
    }

    public String toString() {
        return "MBApplyRes{id=" + this.id + ", frozenResult='" + this.frozenResult + '\'' + ", errCode='" + this.errCode + '\'' + ", errMsg='" + this.errMsg + '\'' + ", causeFrom='" + this.causeFrom + '\'' + ", sbApplyResList=" + this.sbApplyResList + '}';
    }
}

