/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.cumulate.trading;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.wtc.wtbs.business.task.concurrencyctrl.TaskConcurrencyCtrlHelper;
import kd.wtc.wtbs.business.task.enums.TaskCategoryEnum;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtbs.common.deduction.BillApplyEntry;
import kd.wtc.wtbs.common.deduction.BillEntryDateSplit;
import kd.wtc.wtbs.common.deduction.QTApplyReq;
import kd.wtc.wtbs.common.deduction.QTApplyResult;
import kd.wtc.wtbs.common.deduction.QTAtomApplyResponse;
import kd.wtc.wtbs.common.deduction.QTBillApplyResult;
import kd.wtc.wtbs.common.deduction.usable.UsableQuotaInfo;
import kd.wtc.wtbs.common.deduction.usable.UsableQuotaQueryReq;
import kd.wtc.wtbs.common.deduction.usable.UsableQuotaQueryResp;
import kd.wtc.wtbs.common.deduction.usable.UsableQuotaQueryResult;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.cumulate.QTService;
import kd.wtc.wtp.business.cumulate.calculate.model.QTDeductRule;
import kd.wtc.wtp.business.cumulate.calculate.model.QTType;
import kd.wtc.wtp.business.cumulate.calculate.model.result.MBApplyRes;
import kd.wtc.wtp.business.cumulate.calculate.util.CheckUtils;
import kd.wtc.wtp.business.cumulate.trading.QTDealRecordDBService;
import kd.wtc.wtp.business.cumulate.trading.QTDeductService;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtp.business.cumulate.trading.QTOuterParamUtils;
import kd.wtc.wtp.business.cumulate.trading.QTRuntime;
import kd.wtc.wtp.business.cumulate.trading.comparator.DetailComparatorPackage;
import kd.wtc.wtp.business.cumulate.trading.model.AffluentQTLineDetail;
import kd.wtc.wtp.business.cumulate.trading.model.DealOperate;
import kd.wtc.wtp.business.cumulate.trading.model.DealStatus;
import kd.wtc.wtp.business.cumulate.trading.model.DeductSource;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillDeal;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillEntryDeal;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillEntryDealDetail;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;
import kd.wtc.wtp.business.cumulate.trading.model.QTSemiAtomApplyResponse;

public class QTBillOuterService {
    private static final Log log = LogFactory.getLog(QTBillOuterService.class);
    public static final int BILL_TYPE_SRC = 0;
    private static String countField = "id,qttype,qttype.id,ownvalue,canbeodvalue,usablevalue,freezevalue,usedvalue,invalidvalue,frozenodvalue,useodvalue,invalidodvalue,usestartdate,useenddate,genstartdate,genenddate,createtime";

    private static String genBatchNum() {
        return CodeRuleServiceHelper.getNumber((String)"wtp_qtbilldeal", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"wtp_qtbilldeal"), null);
    }

    private static String[] genBatchNum(int count) {
        if (count <= 0) {
            return new String[0];
        }
        return CodeRuleServiceHelper.getBatchNumber((String)"wtp_qtbilldeal", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"wtp_qtbilldeal"), null, (int)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<QTApplyResult> handleApplyReqForeach(QTApplyReq req) {
        String operateType = req.getOperateType();
        ArrayList<QTApplyResult> resList = new ArrayList<QTApplyResult>(req.getBillApplyList().size());
        String[] batchNumArr = QTBillOuterService.genBatchNum(req.getBillApplyList().size());
        int idx = 0;
        long ticket = DB.genGlobalLongId();
        try {
            List wantHandleBoSet = req.getBillApplyList().stream().map(BillApply::getAttFileBoId).distinct().collect(Collectors.toList());
            Set canNotHandleBo = WTCCollections.modifiableEmptySet();
            if (!"TRYFROZEN".equals(operateType)) {
                canNotHandleBo = TaskConcurrencyCtrlHelper.getInstance().getRunningKeyList(TaskCategoryEnum.QT_TIE.getCode(), wantHandleBoSet, Long.valueOf(ticket), Long.valueOf(ticket));
            }
            for (BillApply mainBill : req.getBillApplyList()) {
                MBApplyRes applyRes;
                if (canNotHandleBo.contains(mainBill.getAttFileBoId())) {
                    resList.add(QTBillOuterService.genLockedFailResult(mainBill));
                    continue;
                }
                String batchNum = batchNumArr[idx++];
                if ("FROZEN".equals(operateType)) {
                    applyRes = QTDeductService.frozen(batchNum, mainBill);
                } else if ("UNFROZEN".equals(operateType)) {
                    applyRes = QTDeductService.unfrozen(batchNum, mainBill);
                } else if ("USE".equals(operateType)) {
                    applyRes = QTDeductService.deduct(batchNum, mainBill);
                } else if ("DISUSE".equals(operateType)) {
                    applyRes = QTDeductService.refund(batchNum, mainBill);
                } else if ("TRYFROZEN".equals(operateType)) {
                    applyRes = QTDeductService.frozen(batchNum, mainBill, false);
                } else {
                    throw new IllegalArgumentException("not support operateType:" + operateType);
                }
                applyRes.correctFrozenResult();
                resList.add(QTBillOuterService.convert2QTApplyResult(applyRes));
            }
            ArrayList<QTApplyResult> arrayList = resList;
            return arrayList;
        }
        finally {
            if (!"TRYFROZEN".equals(operateType)) {
                TaskConcurrencyCtrlHelper.getInstance().deleteByTaskIds(TaskCategoryEnum.QT_TIE.getCode(), Collections.singletonList(ticket));
            }
        }
    }

    public static void amend(QTRuntime runtime, Map<DetailLogicKey, List<QTBillDeal>> map) {
        HashMap<Long, QTBillDeal> dirtyMap = new HashMap<Long, QTBillDeal>(map.size());
        List<QTBillDeal> waitStoreBillDeal = runtime.getWaitStoreBillDeal();
        for (QTBillDeal qTBillDeal : waitStoreBillDeal) {
            dirtyMap.put(qTBillDeal.getBillId(), qTBillDeal);
        }
        for (Map.Entry entry : map.entrySet()) {
            ((List)entry.getValue()).removeIf(billDeal -> dirtyMap.containsKey(billDeal.getBillId()));
        }
        Set<Long> waitDelBillDealPk = runtime.getWaitDelBillDealPk();
        map.values().forEach(bdList -> bdList.removeIf(bd -> waitDelBillDealPk.contains(bd.getId())));
        HashMap hashMap = new HashMap(16);
        map.values().stream().flatMap(Collection::stream).forEach(ele -> qtBillCluster.computeIfAbsent(ele.getChainID(), key -> new ArrayList(16)).add(ele));
        waitStoreBillDeal.forEach(ele -> qtBillCluster.computeIfAbsent(ele.getChainID(), key -> new ArrayList(16)).add(ele));
        for (QTBillDeal qTBillDeal : waitStoreBillDeal) {
            for (QTBillEntryDeal bed : qTBillDeal.getEntryDealList()) {
                for (QTBillEntryDealDetail bedd : bed.getDetailList()) {
                    if (!DeductSource.fromPool(bedd.getDeductSource())) continue;
                    long detailId = bedd.getQtSummaryDetailId();
                    QTLineDetail cacheDetail = runtime.getDetail(detailId);
                    DetailLogicKey logicKey = new DetailLogicKey(cacheDetail);
                    List billInfoList = map.computeIfAbsent(logicKey, key -> new ArrayList(16));
                    billInfoList.add(qTBillDeal);
                }
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            List value = (List)entry.getValue();
            HashSet<Long> chainIdSet = new HashSet<Long>(16);
            HashSet<Long> billIdSet = new HashSet<Long>(16);
            for (QTBillDeal billDeal4 : value) {
                chainIdSet.add(billDeal4.getChainID());
                billIdSet.add(billDeal4.getBillId());
            }
            chainIdSet.stream().flatMap(chainId -> qtBillCluster.getOrDefault(chainId, Collections.emptyList()).stream()).forEach(billDeal -> {
                if (billIdSet.add(billDeal.getBillId())) {
                    value.add(billDeal);
                }
            });
            billIdSet.clear();
            value.removeIf(billDeal -> !billIdSet.add(billDeal.getBillId()));
        }
    }

    @Deprecated
    public static QTSemiAtomApplyResponse handleReqSemiAtom(List<BillApply> useBillList, List<BillApply> frozenBillList, List<QTLineDetail> needInsDetailList, Set<DetailLogicKey> needDelDetailLK, QTRuntime runtime) {
        return QTBillOuterService.handleReqSemiAtom(useBillList, frozenBillList, new HashSet<QTBillDeal>(16), needInsDetailList, needDelDetailLK, runtime);
    }

    private static void playbackBill(List<BillApply> usedBillList, List<BillApply> frozenBillList, QTRuntime runtime) {
        HashMap<Long, DealOperate> opMap = new HashMap<Long, DealOperate>(16);
        HashMap<Long, BillApply> allBillId2BillMap = new HashMap<Long, BillApply>(16);
        for (BillApply billApply : usedBillList) {
            allBillId2BillMap.put(billApply.getId(), billApply);
            opMap.put(billApply.getId(), DealOperate.deduct);
        }
        for (BillApply frozenBill : frozenBillList) {
            allBillId2BillMap.put(frozenBill.getId(), frozenBill);
            opMap.put(frozenBill.getId(), DealOperate.frozen);
        }
        List useBillsParentBill = usedBillList.stream().map(bill -> (BillApply)allBillId2BillMap.get(bill.getParentId())).filter(Objects::nonNull).collect(Collectors.toList());
        if (WTCCollections.isNotEmpty(useBillsParentBill)) {
            Set parentBillId = useBillsParentBill.stream().map(BillApply::getId).collect(Collectors.toSet());
            List usedBillId = usedBillList.stream().filter(ele -> parentBillId.contains(ele.getParentId())).map(BillApply::getId).collect(Collectors.toList());
            log.warn("playbackBill before, detected bill arguments error. some usedBill's parent exist in argument. parentBillId:{}, usedBillId:{}", parentBillId, usedBillId);
            throw new IllegalArgumentException("playbackBill before, detected bill arguments error.");
        }
        HashMap needClusterBill = new HashMap(allBillId2BillMap);
        HashMap<Long, List> chainMap = new HashMap<Long, List>(16);
        for (BillApply useBill : usedBillList) {
            chainMap.put(useBill.getId(), QTOuterParamUtils.modifiableSingletonLinkedList(useBill));
            needClusterBill.remove(useBill.getId());
        }
        for (BillApply frozenBill : frozenBillList) {
            if (frozenBill.getParentId() != 0L && allBillId2BillMap.containsKey(frozenBill.getParentId())) continue;
            chainMap.put(frozenBill.getId(), QTOuterParamUtils.modifiableSingletonLinkedList(frozenBill));
            needClusterBill.remove(frozenBill.getId());
        }
        while (!needClusterBill.isEmpty()) {
            int beforeJointChain = needClusterBill.size();
            Set needClusterBillEntry = needClusterBill.entrySet();
            for (Map.Entry billIdEntry : needClusterBillEntry) {
                BillApply bill2 = (BillApply)billIdEntry.getValue();
                List chain = (List)chainMap.get(bill2.getParentId());
                if (chain == null) continue;
                chain.add(bill2);
                needClusterBill.remove(billIdEntry.getKey());
                chainMap.remove(bill2.getParentId());
                chainMap.put(bill2.getId(), chain);
            }
            if (beforeJointChain != needClusterBill.size()) continue;
            log.warn("playbackBill before, suspected bill chain emergence cycle. needClusterBill:{}, chainMap:{}", needClusterBill, chainMap);
            throw new IllegalArgumentException("playbackBill before, suspected bill chain emergence cycle.");
        }
        ArrayList<BillApply> res = new ArrayList<BillApply>(allBillId2BillMap.size());
        ArrayList<List<BillApply>> allChain = new ArrayList<List<BillApply>>(chainMap.values());
        int[] vernier = new int[allChain.size()];
        while (QTBillOuterService.notEnd(allChain, vernier)) {
            BillApply candidate = null;
            int candidateChainIdx = -1;
            for (int chainIdx = 0; chainIdx < vernier.length; ++chainIdx) {
                int chainVernier = vernier[chainIdx];
                List chain = (List)allChain.get(chainIdx);
                if (chainVernier >= chain.size()) continue;
                BillApply bill3 = (BillApply)chain.get(chainVernier);
                if (candidate == null) {
                    candidateChainIdx = chainIdx;
                    candidate = bill3;
                    continue;
                }
                long candidateApplyTime = candidate.getApplyTime().getTime();
                long billApplyTime = bill3.getApplyTime().getTime();
                if (billApplyTime < candidateApplyTime) {
                    candidateChainIdx = chainIdx;
                    candidate = bill3;
                    continue;
                }
                if (billApplyTime != candidateApplyTime) continue;
                DealOperate candidateOp = (DealOperate)((Object)opMap.get(candidate.getId()));
                DealOperate billOp = (DealOperate)((Object)opMap.get(bill3.getId()));
                if (candidateOp != DealOperate.deduct || billOp != DealOperate.frozen) continue;
                candidateChainIdx = chainIdx;
                candidate = bill3;
            }
            if (candidate == null) continue;
            res.add(candidate);
            int n = candidateChainIdx;
            vernier[n] = vernier[n] + 1;
        }
        for (BillApply bill4 : res) {
            String errMsg;
            String billNumber;
            DealOperate op = (DealOperate)((Object)opMap.get(bill4.getId()));
            if (op == DealOperate.deduct) {
                QTAtomApplyResponse deductRes = QTDeductService.batchDeduct(Collections.singletonList(bill4), runtime);
                if (deductRes.isSuccess()) continue;
                runtime.discard();
                log.warn("handleReqSemiAtom deduct fail, cause={}", (Object)deductRes);
                billNumber = deductRes.getErrBill() != null ? deductRes.getErrBill().getBillNo() : null;
                errMsg = ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u5ba1\u6279\u5355\u636e\u6263\u51cf\u5931\u8d25\uff0c\u5355\u636e\u7f16\u7801\u4e3a%s\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u662f\u5426\u5b58\u5728\u76f8\u5173\u7c7b\u578b\u7684\u989d\u5ea6\u4fe1\u606f\u3002", (String)"QTBillOuterService_0", (String)"wtc-wtp-business", (Object[])new Object[]{billNumber});
                if (billNumber != null) {
                    throw new KDBizException(new ErrorCode("bill_deduct_fail", errMsg), new Object[0]);
                }
                throw new KDBizException(errMsg);
            }
            QTAtomApplyResponse frozenRes = QTDeductService.batchFrozen(Collections.singletonList(bill4), runtime);
            if (frozenRes.isSuccess()) continue;
            runtime.discard();
            log.warn("handleReqSemiAtom frozen fail, cause={}", (Object)frozenRes);
            billNumber = frozenRes.getErrBill() != null ? frozenRes.getErrBill().getBillNo() : null;
            errMsg = ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u5ba1\u6279\u5355\u636e\u6263\u51cf\u5931\u8d25\uff0c\u5355\u636e\u7f16\u7801\u4e3a%s\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u662f\u5426\u5b58\u5728\u76f8\u5173\u7c7b\u578b\u7684\u989d\u5ea6\u4fe1\u606f\u3002", (String)"QTBillOuterService_1", (String)"wtc-wtp-business", (Object[])new Object[]{billNumber});
            if (billNumber != null) {
                throw new KDBizException(new ErrorCode("bill_deduct_fail", errMsg), new Object[0]);
            }
            throw new KDBizException(errMsg);
        }
        runtime.addDirtyBillApplyPackage(usedBillList);
    }

    private static boolean notEnd(List<List<BillApply>> allChain, int[] vernier) {
        for (int chainIdx = 0; chainIdx < vernier.length; ++chainIdx) {
            if (vernier[chainIdx] >= allChain.get(chainIdx).size()) continue;
            return true;
        }
        return false;
    }

    public static QTSemiAtomApplyResponse evacuation(List<QTBillDeal> evacuationBd, List<QTLineDetail> needInsDetailList, Set<Long> curPeriodOldDBLineIdSet, Set<DetailLogicKey> needDelDetailLK, QTRuntime runtime) {
        Set<DetailLogicKey> needInsDetailLKSet = needInsDetailList.stream().map(DetailLogicKey::new).collect(Collectors.toSet());
        needInsDetailLKSet.addAll(needDelDetailLK);
        runtime.plusPool(QTLineDetailDBService.loadDetailByLK(needInsDetailLKSet));
        runtime.delLineDetailByLogicKey(needInsDetailLKSet);
        runtime.plusPoolAndMarkDirty(needInsDetailList);
        HashMap<Long, QTLineDetail> lineMap = new HashMap<Long, QTLineDetail>(needInsDetailList.size());
        for (QTLineDetail line : needInsDetailList) {
            curPeriodOldDBLineIdSet.remove(line.getBid());
            lineMap.put(line.getBid(), line);
        }
        QTBillOuterService.doEvacuationForEmptyLine(evacuationBd, lineMap);
        if (WTCCollections.isNotEmpty(curPeriodOldDBLineIdSet)) {
            for (QTBillDeal billDeal : evacuationBd) {
                if (billDeal.getEntryDealList() == null) continue;
                boolean frozen = DealStatus.isFrozen(billDeal.getDealState());
                for (QTBillEntryDeal bed : billDeal.getEntryDealList()) {
                    if (bed.getDetailList() == null) continue;
                    for (QTBillEntryDealDetail bedDetail : bed.getDetailList()) {
                        if (!curPeriodOldDBLineIdSet.contains(bedDetail.getQtSummaryDetailId())) continue;
                        BigDecimal applyValue = bedDetail.getApplyValue();
                        QTLineDetail suitableLine = QTBillOuterService.findSuitableLine(needInsDetailList, bed.getStartDate(), bed.getEndDate(), applyValue);
                        if (suitableLine == null) continue;
                        if (DeductSource.pool.name().equals(bedDetail.getDeductSource())) {
                            if (frozen) {
                                suitableLine.setFreezeValue(suitableLine.getFreezeValue().add(applyValue));
                            } else {
                                suitableLine.setUsedValue(suitableLine.getUsedValue().add(applyValue));
                            }
                        } else if (DeductSource.pool_ivd.name().equals(bedDetail.getDeductSource())) {
                            if (frozen) {
                                suitableLine.setFreezeValue(suitableLine.getFreezeValue().add(applyValue));
                            } else {
                                suitableLine.setInvalidValue(suitableLine.getInvalidValue().add(applyValue));
                            }
                        }
                        bedDetail.setQtSummaryDetailId(suitableLine.getBid());
                        billDeal.setBatchNum(runtime.getBatchNum());
                        runtime.addWaitUpdateBillDeal(billDeal);
                        QTDeductService.reBalanceDetail(suitableLine);
                    }
                }
            }
        }
        return QTSemiAtomApplyResponse.newOne(runtime);
    }

    private static QTLineDetail findSuitableLine(List<QTLineDetail> lineList, Date start, Date end, BigDecimal value) {
        ArrayList<QTLineDetail> sortedLineList = new ArrayList<QTLineDetail>(lineList);
        sortedLineList.sort(Comparator.comparing(QTLineDetail::getUseEndDateDayLast));
        for (QTLineDetail line : sortedLineList) {
            if (!WTCDateUtils.hasIntersectionLCRC((Date)start, (Date)end, (Date)line.getUseStartDate(), (Date)line.getUseEndDateDayLast()) || !CheckUtils.isLargeEqual(line.getUsableValue(), value)) continue;
            return line;
        }
        for (QTLineDetail line : sortedLineList) {
            if (!WTCDateUtils.hasIntersectionLCRC((Date)start, (Date)end, (Date)line.getUseStartDate(), (Date)line.getUseEndDateDayLast()) || !CheckUtils.isLargeEqual(line.getUsableValue().add(line.getCanBeOdValue()), value)) continue;
            return line;
        }
        for (QTLineDetail line : sortedLineList) {
            if (!WTCDateUtils.hasIntersectionLCRC((Date)start, (Date)end, (Date)line.getUseStartDate(), (Date)line.getUseEndDateDayLast()) || !CheckUtils.isPositive(line.getUsableValue())) continue;
            return line;
        }
        for (QTLineDetail line : sortedLineList) {
            if (!WTCDateUtils.hasIntersectionLCRC((Date)start, (Date)end, (Date)line.getUseStartDate(), (Date)line.getUseEndDateDayLast()) || !CheckUtils.isPositive(line.getCanBeOdValue())) continue;
            return line;
        }
        for (QTLineDetail line : sortedLineList) {
            if (!CheckUtils.isPositive(line.getUsableValue())) continue;
            return line;
        }
        for (QTLineDetail line : sortedLineList) {
            if (!CheckUtils.isPositive(line.getCanBeOdValue())) continue;
            return line;
        }
        return lineList.isEmpty() ? null : lineList.get(0);
    }

    public static void doEvacuationForEmptyLine(List<QTBillDeal> evacuationBd, Map<Long, QTLineDetail> lineMap) {
        for (QTBillDeal billDeal : evacuationBd) {
            if (billDeal.getEntryDealList() == null) continue;
            boolean frozen = DealStatus.isFrozen(billDeal.getDealState());
            for (QTBillEntryDeal bed : billDeal.getEntryDealList()) {
                if (bed.getDetailList() == null) continue;
                for (QTBillEntryDealDetail bedDetail : bed.getDetailList()) {
                    long lineDetailDBId = bedDetail.getQtSummaryDetailId();
                    BigDecimal applyValue = bedDetail.getApplyValue();
                    QTLineDetail line = lineMap.get(lineDetailDBId);
                    if (line == null) continue;
                    if (DeductSource.pool.name().equals(bedDetail.getDeductSource())) {
                        if (frozen) {
                            line.setFreezeValue(line.getFreezeValue().add(applyValue));
                            continue;
                        }
                        line.setUsedValue(line.getUsedValue().add(applyValue));
                        continue;
                    }
                    if (!DeductSource.pool_ivd.name().equals(bedDetail.getDeductSource())) continue;
                    if (frozen) {
                        line.setFreezeValue(line.getFreezeValue().add(applyValue));
                        continue;
                    }
                    line.setInvalidValue(line.getInvalidValue().add(applyValue));
                }
            }
        }
        for (QTLineDetail line : lineMap.values()) {
            QTDeductService.reBalanceDetail(line);
        }
    }

    public static QTSemiAtomApplyResponse handleReqSemiAtom(List<BillApply> useBillList, List<BillApply> frozenBillList, Set<QTBillDeal> waitRefundBD, List<QTLineDetail> needInsDetailList, Set<DetailLogicKey> needDelDetailLK, QTRuntime runtime) {
        needInsDetailList.forEach(ele -> ele.setFrozenOdValue(BigDecimal.ZERO));
        List<BillApply> useMainBillList = QTBillOuterService.deepCopy(useBillList);
        List<BillApply> frozenMainBillList = QTBillOuterService.deepCopy(frozenBillList);
        if (useMainBillList == null) {
            log.warn("handleReqSemiAtom useMainBillList is null.");
            useMainBillList = new ArrayList<BillApply>(0);
        }
        if (frozenMainBillList == null) {
            log.warn("handleReqSemiAtom frozenMainBillList is null.");
            frozenMainBillList = new ArrayList<BillApply>(0);
        }
        HashSet billIdSet = new HashSet(useBillList.size());
        useMainBillList.removeIf(bill -> !billIdSet.add(bill.getId()));
        billIdSet.clear();
        frozenMainBillList.removeIf(bill -> !billIdSet.add(bill.getId()));
        ArrayList<BillApply> allBill = new ArrayList<BillApply>(useMainBillList);
        allBill.addAll(frozenMainBillList);
        Map<Long, QTDeductRule> deductRuleMap = QTDeductService.initDeductRule(allBill);
        runtime.plusDeductRuleMap(deductRuleMap);
        runtime.plusPool(QTDeductService.initPool(runtime.getAttFileBoId(), allBill, runtime.getDeductRuleMap()));
        Set<DetailLogicKey> needInsDetailLKSet = needInsDetailList.stream().map(DetailLogicKey::new).collect(Collectors.toSet());
        needInsDetailLKSet.addAll(needDelDetailLK);
        runtime.plusPool(QTLineDetailDBService.loadDetailByLK(needInsDetailLKSet));
        Set<Long> needQueryBillIdList = allBill.stream().map(BillApply::getId).collect(Collectors.toSet());
        Map<Long, QTBillDeal> cacheBillDeal = runtime.getWaitStoreBillDealByBillId(needQueryBillIdList);
        needQueryBillIdList = needQueryBillIdList.stream().filter(ele -> !cacheBillDeal.containsKey(ele)).collect(Collectors.toSet());
        Map<Long, QTBillDeal> allBillDealMap = QTDealRecordDBService.loadBDByBillId(needQueryBillIdList, true);
        allBillDealMap.putAll(cacheBillDeal);
        Set delBillDealId = allBillDealMap.values().stream().filter(ele -> runtime.isWaitDelBillDeal(ele.getId())).map(QTBillDeal::getBillId).collect(Collectors.toSet());
        for (Long bdId : delBillDealId) {
            allBillDealMap.remove(bdId);
        }
        List<QTBillDeal> needDelBD = waitRefundBD.stream().filter(bd -> !allBillDealMap.containsKey(bd.getBillId())).collect(Collectors.toList());
        needDelBD.addAll(allBillDealMap.values());
        QTDeductService.batchRefundBillDeal(needDelBD, runtime);
        runtime.delLineDetailByLogicKey(needInsDetailLKSet);
        runtime.plusPoolAndMarkDirty(needInsDetailList);
        QTDeductService.coverApplyDate(allBill, allBillDealMap);
        QTBillOuterService.playbackBill(useMainBillList, frozenMainBillList, runtime);
        return QTSemiAtomApplyResponse.newOne(runtime);
    }

    private static void oldDeductLogic(QTRuntime runtime, List<BillApply> useMainBillList, List<BillApply> frozenMainBillList) {
        List<BillApply> sortedUseMainBillList = QTDeductService.getSortedMainBillList(useMainBillList);
        QTAtomApplyResponse deductRes = QTDeductService.batchDeduct(sortedUseMainBillList, runtime);
        if (!deductRes.isSuccess()) {
            runtime.discard();
            log.warn("handleReqSemiAtom deduct fail, cause={}", (Object)deductRes);
            String billNumber = deductRes.getErrBill() != null ? deductRes.getErrBill().getBillNo() : null;
            String errMsg = ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u5ba1\u6279\u5355\u636e\u6263\u51cf\u5931\u8d25\uff0c\u5355\u636e\u7f16\u7801\u4e3a%s\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u662f\u5426\u5b58\u5728\u76f8\u5173\u7c7b\u578b\u7684\u989d\u5ea6\u4fe1\u606f\u3002", (String)"QTBillOuterService_0", (String)"wtc-wtp-business", (Object[])new Object[]{billNumber});
            if (billNumber != null) {
                throw new KDBizException(new ErrorCode("bill_deduct_fail", errMsg), new Object[0]);
            }
            throw new KDBizException(errMsg);
        }
        List<BillApply> sortedFrozenMainBillList = QTDeductService.getSortedMainBillList(frozenMainBillList);
        QTAtomApplyResponse frozenRes = QTDeductService.batchFrozen(sortedFrozenMainBillList, runtime);
        if (!frozenRes.isSuccess()) {
            runtime.discard();
            log.warn("handleReqSemiAtom frozen fail, cause={}", (Object)frozenRes);
            String billNumber = frozenRes.getErrBill() != null ? frozenRes.getErrBill().getBillNo() : null;
            String errMsg = ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u5ba1\u6279\u5355\u636e\u6263\u51cf\u5931\u8d25\uff0c\u5355\u636e\u7f16\u7801\u4e3a%s\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u662f\u5426\u5b58\u5728\u76f8\u5173\u7c7b\u578b\u7684\u989d\u5ea6\u4fe1\u606f\u3002", (String)"QTBillOuterService_1", (String)"wtc-wtp-business", (Object[])new Object[]{billNumber});
            if (billNumber != null) {
                throw new KDBizException(new ErrorCode("bill_deduct_fail", errMsg), new Object[0]);
            }
            throw new KDBizException(errMsg);
        }
        runtime.flushUsedPackage(useMainBillList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QTAtomApplyResponse handleApplyReqAtom(QTApplyReq req) {
        List copyMainBillList = QTBillOuterService.deepCopy(req.getBillApplyList());
        if (copyMainBillList == null || copyMainBillList.isEmpty()) {
            return QTAtomApplyResponse.success();
        }
        String operateType = req.getOperateType();
        if (!operateType.equals("USE")) {
            return QTAtomApplyResponse.error((String)"illegal state", (String)("expect op: use, actual op: " + operateType), null);
        }
        Set collect = req.getBillApplyList().stream().map(BillApply::getAttFileBoId).collect(Collectors.toSet());
        if (collect.size() != 1) {
            return QTAtomApplyResponse.error((String)"illegal billList", (String)"expect all bill from same attFileBo", null);
        }
        long attFileBoId = (Long)collect.stream().findFirst().get();
        long ticket = DB.genGlobalLongId();
        try {
            List<Long> wantHandleBoSet = Collections.singletonList(attFileBoId);
            Set canNotHandleBo = TaskConcurrencyCtrlHelper.getInstance().getRunningKeyList(TaskCategoryEnum.QT_TIE.getCode(), wantHandleBoSet, Long.valueOf(ticket), Long.valueOf(ticket));
            if (!canNotHandleBo.isEmpty()) {
                QTAtomApplyResponse qTAtomApplyResponse = QTAtomApplyResponse.error((String)"try lock fail", (String)("lock fail, try lock attFileBo: " + attFileBoId), null);
                return qTAtomApplyResponse;
            }
            ArrayList<BillApply> usefulMainBillList = new ArrayList<BillApply>(copyMainBillList.size());
            List<Long> billIdList = copyMainBillList.stream().map(BillApply::getId).collect(Collectors.toList());
            Map<Long, BillApply> longBillApplyMap = QTDealRecordDBService.queryBillApplyPackage(billIdList);
            for (BillApply billApply : copyMainBillList) {
                int billType = billApply.getBillType();
                if (billType != 0) {
                    BillApply oldBillApply = longBillApplyMap.get(billApply.getId());
                    if (oldBillApply == null) {
                        usefulMainBillList.add(billApply);
                        continue;
                    }
                    log.info("before do amendOldBillApply, oldBillApply={}, billApply={}", (Object)oldBillApply, (Object)billApply);
                    boolean hasAmend = QTBillOuterService.amendOldBillApply(billApply, oldBillApply);
                    if (!hasAmend) continue;
                    usefulMainBillList.add(oldBillApply);
                    continue;
                }
                usefulMainBillList.add(billApply);
            }
            log.info("after amendOldBillApply but before do batchDeductAtom, billList={}", usefulMainBillList);
            QTAtomApplyResponse qTAtomApplyResponse = QTDeductService.batchDeductAtom(QTBillOuterService.genBatchNum(), attFileBoId, usefulMainBillList);
            return qTAtomApplyResponse;
        }
        finally {
            TaskConcurrencyCtrlHelper.getInstance().deleteByTaskIds(TaskCategoryEnum.QT_TIE.getCode(), Collections.singletonList(ticket));
        }
    }

    public static boolean amendOldBillApply(BillApply billApply, BillApply oldBillApply) {
        boolean hasAmend = false;
        List oldEntryEntities = oldBillApply.getEntryEntities();
        HashMap<Long, BillApplyEntry> oldEntryMap = new HashMap<Long, BillApplyEntry>(oldEntryEntities.size());
        for (BillApplyEntry entry : oldEntryEntities) {
            oldEntryMap.put(entry.getEntryId(), entry);
        }
        for (BillApplyEntry entry : billApply.getEntryEntities()) {
            BillApplyEntry oldEntry = (BillApplyEntry)oldEntryMap.remove(entry.getEntryId());
            if (oldEntry == null) {
                oldEntryEntities.add(entry);
                oldEntry = entry;
                hasAmend = true;
            } else {
                if (!entry.getSplitList().isEmpty()) {
                    hasAmend = hasAmend || oldEntry.getDeductionRuleId() != entry.getDeductionRuleId();
                    oldEntry.setDeductionRuleId(entry.getDeductionRuleId());
                }
                hasAmend = hasAmend || oldEntry.getDisposable() != entry.getDisposable();
                oldEntry.setDisposable(entry.getDisposable());
                hasAmend = hasAmend || oldEntry.getNonQuota() != entry.getNonQuota();
                oldEntry.setNonQuota(entry.getNonQuota());
                hasAmend = hasAmend || !WTCStringUtils.equals((String)oldEntry.getEntryUnit(), (String)entry.getEntryUnit());
                oldEntry.setEntryUnit(entry.getEntryUnit());
                hasAmend = hasAmend || !oldEntry.getStartDate().equals(entry.getStartDate());
                oldEntry.setStartDate(entry.getStartDate());
                hasAmend = hasAmend || !oldEntry.getEndDate().equals(entry.getEndDate());
                oldEntry.setEndDate(entry.getEndDate());
                for (BillEntryDateSplit dateSplit : entry.getSplitList()) {
                    BillEntryDateSplit oldDateSplit = oldEntry.getDateSplitByDate(dateSplit.getDate());
                    if (oldDateSplit == null) {
                        oldEntry.getSplitList().add(dateSplit);
                        hasAmend = true;
                        continue;
                    }
                    if (CheckUtils.isNotEqual(dateSplit.getVaTimeDay(), oldDateSplit.getVaTimeDay())) {
                        oldDateSplit.setVaTimeDay(dateSplit.getVaTimeDay());
                        hasAmend = true;
                    }
                    if (!CheckUtils.isNotEqual(dateSplit.getVaTimeHour(), oldDateSplit.getVaTimeHour())) continue;
                    oldDateSplit.setVaTimeHour(dateSplit.getVaTimeHour());
                    hasAmend = true;
                }
            }
            BigDecimal day = BigDecimal.ZERO;
            BigDecimal hour = BigDecimal.ZERO;
            for (BillEntryDateSplit oldDateSplit : oldEntry.getSplitList()) {
                day = day.add(oldDateSplit.getVaTimeDay());
                hour = hour.add(oldDateSplit.getVaTimeHour());
            }
            hasAmend = hasAmend || CheckUtils.isNotEqual(day, oldEntry.getVaTimeDay());
            oldEntry.setVaTimeDay(day);
            hasAmend = hasAmend || CheckUtils.isNotEqual(hour, oldEntry.getVaTimeHour());
            oldEntry.setVaTimeHour(hour);
        }
        return hasAmend;
    }

    public static <T> T deepCopy(T object) {
        if (object == null) {
            return null;
        }
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(bo);
            oo.writeObject(object);
            ByteArrayInputStream bi = new ByteArrayInputStream(bo.toByteArray());
            ObjectInputStream oi = new ObjectInputStream(bi);
            return (T)oi.readObject();
        }
        catch (IOException | ClassNotFoundException exp) {
            return null;
        }
    }

    private static QTApplyResult genLockedFailResult(BillApply bill) {
        QTApplyResult tmp = new QTApplyResult();
        tmp.setId(bill.getId());
        tmp.setFrozenResult("B");
        tmp.setErrCode("CONCURRENT_FAIL");
        tmp.setErrMsg("CONCURRENT_FAIL");
        List entryRes = bill.getEntryEntities().stream().map(ele -> {
            QTBillApplyResult eRes = new QTBillApplyResult();
            eRes.setEntryId(ele.getEntryId());
            eRes.setResultMsg("CONCURRENT_FAIL");
            eRes.setSuccess(false);
            return eRes;
        }).collect(Collectors.toList());
        tmp.setQtBillApplyResList(entryRes);
        return tmp;
    }

    private static QTApplyResult convert2QTApplyResult(MBApplyRes mbRefundRes) {
        mbRefundRes.correctFrozenResult();
        String frozenResult = mbRefundRes.isAllSuccess() ? "A" : "B";
        List<Object> collect = new LinkedList();
        if (WTCCollections.isNotEmpty(mbRefundRes.getSbApplyResList())) {
            collect = mbRefundRes.getSbApplyResList().stream().map(sbRes -> {
                QTBillApplyResult entryRes = new QTBillApplyResult();
                entryRes.setEntryId(sbRes.getBillId());
                entryRes.setSuccess(sbRes.isSuccess());
                entryRes.setResultMsg(sbRes.getResultMsg());
                entryRes.setErrCode(sbRes.getErrCode());
                entryRes.setRetData(sbRes.getRetData());
                return entryRes;
            }).collect(Collectors.toList());
        }
        QTApplyResult res = new QTApplyResult();
        res.setId(mbRefundRes.getId());
        res.setErrCode(mbRefundRes.getErrCode());
        res.setErrMsg(mbRefundRes.getErrMsg());
        res.setCauseFrom(mbRefundRes.getCauseFrom());
        res.setFrozenResult(frozenResult);
        res.setQtBillApplyResList(collect);
        return res;
    }

    public static List<UsableQuotaQueryResp> handleQueryReq(List<UsableQuotaQueryReq> reqList) {
        return reqList.stream().map(QTBillOuterService::handleQueryReq).collect(Collectors.toList());
    }

    public static UsableQuotaQueryResp handleQueryReq(UsableQuotaQueryReq req) {
        DynamicObject tmp;
        Map<Long, QTDeductRule> deductRuleVIdMap = QTService.loadDeductRuleWithVId(req.getDeductionRuleIds());
        Set<Long> qtTypeIdSet = deductRuleVIdMap.values().stream().flatMap(deductRule -> deductRule.getDeductOrder().stream()).map(QTType::getId).collect(Collectors.toSet());
        Date startDate = req.getStartDate();
        Date endDate = req.getEndDate();
        if (startDate == null && endDate == null) {
            startDate = endDate = new Date();
        } else if (startDate == null) {
            startDate = endDate;
        } else if (endDate == null) {
            endDate = startDate;
        }
        QFilter qFilter = new QFilter("busstatus", "=", (Object)"0");
        qFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        List<DynamicObject> detailList = QTLineDetailDBService.queryLineDetail(String.join((CharSequence)",", QTLineDetailDBService.SELECT), req.getAttFileBoId(), qtTypeIdSet, startDate, endDate, qFilter);
        HashMap<Long, DealStatus> bdStateMap = new HashMap<Long, DealStatus>(16);
        HashMap<Long, List<DynamicObject>> bdId2BedMap = new HashMap(16);
        if (req.getParentId() != 0L && (tmp = QTDealRecordDBService.queryBDByBillId("chainid", req.getParentId())) != null) {
            long chainId = tmp.getLong("chainid");
            List<DynamicObject> bdList = QTDealRecordDBService.queryBDByChainId("id,chainid,dealstate", chainId);
            ArrayList<Long> bdIdList = new ArrayList<Long>(bdList.size());
            for (DynamicObject bd : bdList) {
                DealStatus dealStatus = DealStatus.get(bd.getString("dealstate"));
                bdStateMap.put(bd.getLong("id"), dealStatus);
                bdIdList.add(bd.getLong("id"));
            }
            String selectKey = "id,pid,entryentity,entryentity.qtsummarydetail,entryentity.dapplyvalue";
            bdId2BedMap = QTDealRecordDBService.queryBEDByBDID(selectKey, bdIdList);
        }
        ArrayList<UsableQuotaQueryResult> usableQTList = new ArrayList<UsableQuotaQueryResult>(req.getDeductionRuleIds().size());
        for (Long deductionRuleVId : req.getDeductionRuleIds()) {
            String unit = null;
            BigDecimal canBeOD = BigDecimal.ZERO;
            BigDecimal usable = BigDecimal.ZERO;
            BigDecimal frozen = BigDecimal.ZERO;
            BigDecimal used = BigDecimal.ZERO;
            BigDecimal srcBillFrozen = BigDecimal.ZERO;
            BigDecimal srcBillUsed = BigDecimal.ZERO;
            QTDeductRule deductRule2 = deductRuleVIdMap.get(deductionRuleVId);
            ArrayList<UsableQuotaInfo> usableQuotaInfoList = new ArrayList<UsableQuotaInfo>(16);
            if (deductRule2 != null) {
                Object dyn2;
                unit = QTOuterParamUtils.convert2OuterBillUnit(deductRule2.getUnit());
                Set needCountTypeIDSet = deductRule2.getDeductOrder().stream().map(QTType::getId).collect(Collectors.toSet());
                List needCountDetailList = detailList.stream().filter(detail -> needCountTypeIDSet.contains(detail.getLong("qttype.id"))).collect(Collectors.toList());
                HashMap<Long, DynamicObject> detailDynMap = new HashMap<Long, DynamicObject>(needCountDetailList.size());
                for (Object dyn2 : needCountDetailList) {
                    detailDynMap.put(dyn2.getLong("id"), (DynamicObject)dyn2);
                }
                List<AffluentQTLineDetail> lineDetailList = needCountDetailList.stream().map(QTLineDetailDBService::parseFromDyn).map(AffluentQTLineDetail::new).collect(Collectors.toList());
                new DetailComparatorPackage(deductRule2).sort(lineDetailList);
                dyn2 = lineDetailList.iterator();
                while (dyn2.hasNext()) {
                    AffluentQTLineDetail qld = (AffluentQTLineDetail)dyn2.next();
                    DynamicObject detail2 = (DynamicObject)detailDynMap.get(qld.getSrc().getId());
                    canBeOD = canBeOD.add(detail2.getBigDecimal("canbeodvalue"));
                    usable = usable.add(detail2.getBigDecimal("usablevalue"));
                    frozen = frozen.add(detail2.getBigDecimal("freezevalue"));
                    used = used.add(detail2.getBigDecimal("usedvalue"));
                    usableQuotaInfoList.add(QTOuterParamUtils.parse2UsableQuotaInfo(detail2, deductRule2.getUnit()));
                }
                if (!bdStateMap.isEmpty()) {
                    Set<Long> detailIdSet = needCountDetailList.stream().map(ele -> ele.getLong("id")).collect(Collectors.toSet());
                    Tuple<BigDecimal, BigDecimal> appliedValue = QTBillOuterService.collectAppliedValue(bdStateMap, bdId2BedMap, detailIdSet);
                    srcBillFrozen = (BigDecimal)appliedValue.getKey();
                    srcBillUsed = (BigDecimal)appliedValue.getValue();
                }
            }
            UsableQuotaQueryResult subRes = new UsableQuotaQueryResult();
            subRes.setDeductionRuleId(deductionRuleVId.longValue());
            subRes.setUnit(unit);
            subRes.setUsable(usable);
            subRes.setFrozen(frozen);
            subRes.setCanBeOverdraft(canBeOD);
            subRes.setUsed(used);
            subRes.setSrcBillFrozen(srcBillFrozen);
            subRes.setSrcBillUsed(srcBillUsed);
            subRes.setUseableQuotaInfos(usableQuotaInfoList);
            usableQTList.add(subRes);
        }
        UsableQuotaQueryResp res = new UsableQuotaQueryResp();
        res.setId(req.getId());
        res.setAttFileBoId(req.getAttFileBoId().longValue());
        res.setAttFileVId(req.getAttFileVId().longValue());
        res.setPersonId(req.getPersonId().longValue());
        res.setResult(usableQTList);
        return res;
    }

    private static Tuple<BigDecimal, BigDecimal> collectAppliedValue(Map<Long, DealStatus> bdStateMap, Map<Long, List<DynamicObject>> bdId2BedMap, Set<Long> detailIdSet) {
        BigDecimal frozen = BigDecimal.ZERO;
        BigDecimal used = BigDecimal.ZERO;
        for (Map.Entry<Long, List<DynamicObject>> entry : bdId2BedMap.entrySet()) {
            Long bdId = entry.getKey();
            List<DynamicObject> bedList = entry.getValue();
            DealStatus dealStatus = bdStateMap.get(bdId);
            for (DynamicObject bed : bedList) {
                DynamicObjectCollection entries = bed.getDynamicObjectCollection("entryentity");
                for (DynamicObject row : entries) {
                    long detailId = row.getLong("qtsummarydetail.id");
                    if (!detailIdSet.contains(detailId)) continue;
                    if (dealStatus == DealStatus.FROZEN_LOCK || dealStatus == DealStatus.FROZEN) {
                        frozen = frozen.add(row.getBigDecimal("dapplyvalue"));
                        continue;
                    }
                    if (dealStatus != DealStatus.USED_LOCK && dealStatus != DealStatus.USED) continue;
                    used = used.add(row.getBigDecimal("dapplyvalue"));
                }
            }
        }
        return new Tuple((Object)frozen, (Object)used);
    }
}

