/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.cumulate.trading;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.EntryProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillDeal;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillEntryDeal;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillEntryDealDetail;

public class QTDealRecordConverter {
    public static DynamicObject newDyn(String pageNumber) {
        return new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)pageNumber));
    }

    private static void copyBEDDAttr(DynamicObject dyn, QTBillEntryDealDetail res) {
        res.setPk(dyn.getLong("id"));
        res.setDeductSource(dyn.getString("deductsource"));
        res.setSeq(dyn.getInt("seq"));
        res.setQtSummaryDetailId(dyn.getLong("qtsummarydetail.id"));
        res.setApplyValue(dyn.getBigDecimal("dapplyvalue"));
    }

    public static void copyBEDDAttr(QTBillEntryDealDetail from, DynamicObject to) {
        to.set("id", (Object)from.getPk());
        to.set("deductsource", (Object)from.getDeductSource());
        to.set("seq", (Object)from.getSeq());
        to.set("qtsummarydetail", (Object)from.getQtSummaryDetailId());
        to.set("dapplyvalue", (Object)from.getApplyValue());
    }

    public static QTBillEntryDealDetail parseBEDD(DynamicObject dyn) {
        QTBillEntryDealDetail res = new QTBillEntryDealDetail();
        QTDealRecordConverter.copyBEDDAttr(dyn, res);
        return res;
    }

    private static void copyBEDAttr(DynamicObject from, QTBillEntryDeal to) {
        to.setId(from.getLong("id"));
        to.setPid(from.getLong("pid"));
        to.setBillEntryId(from.getLong("billentryid"));
        to.setDeductRuleId(from.getLong("deductrule.id"));
        to.setApplyValue(from.getBigDecimal("applyvalue"));
        to.setApplyUnit(from.getString("applyunit"));
        to.setStartDate(from.getDate("startdate"));
        to.setEndDate(from.getDate("enddate"));
    }

    public static void copyBEDAttr(QTBillEntryDeal bed, DynamicObject res) {
        res.set("id", (Object)bed.getId());
        res.set("pid", (Object)bed.getPid());
        res.set("billentryid", (Object)bed.getBillEntryId());
        res.set("deductrule", (Object)bed.getDeductRuleId());
        res.set("applyvalue", (Object)bed.getApplyValue());
        res.set("applyunit", (Object)bed.getApplyUnit());
        res.set("startdate", (Object)bed.getStartDate());
        res.set("enddate", (Object)bed.getEndDate());
    }

    public static QTBillEntryDeal parse2BED(DynamicObject bedDyn) {
        QTBillEntryDeal res = new QTBillEntryDeal();
        QTDealRecordConverter.copyBEDAttr(bedDyn, res);
        DynamicObjectCollection entries = bedDyn.getDynamicObjectCollection("entryentity");
        List<QTBillEntryDealDetail> detailList = entries.stream().map(QTDealRecordConverter::parseBEDD).collect(Collectors.toList());
        res.setDetailList(detailList);
        return res;
    }

    public static DynamicObject parse2BED(QTBillEntryDeal bed, boolean archive) {
        DynamicObject res = archive ? QTDealRecordConverter.newDyn("wtp_qtbillentrydealhis") : QTDealRecordConverter.newDyn("wtp_qtbillentrydeal");
        QTDealRecordConverter.copyBEDAttr(bed, res);
        EntryProp entryProp = (EntryProp)res.getDataEntityType().getProperties().get((Object)"entryentity");
        EntryType entryType = (EntryType)entryProp.getItemType();
        DynamicObjectCollection entries = res.getDynamicObjectCollection("entryentity");
        for (QTBillEntryDealDetail bedd : bed.getDetailList()) {
            DynamicObject newRow = new DynamicObject((DynamicObjectType)entryType);
            QTDealRecordConverter.copyBEDDAttr(bedd, newRow);
            entries.add((Object)newRow);
        }
        return res;
    }

    private static void copyBDAttr(DynamicObject bdDyn, QTBillDeal billDeal) {
        billDeal.setId(bdDyn.getLong("id"));
        billDeal.setSrcID(bdDyn.getLong("srcid"));
        billDeal.setSrcPID(bdDyn.getLong("srcpid"));
        billDeal.setChainID(bdDyn.getLong("chainid"));
        billDeal.setBatchNum(bdDyn.getString("batchnum"));
        billDeal.setAttFileBoId(bdDyn.getLong("attfileboid"));
        billDeal.setParentBillId(bdDyn.getLong("parentbillid"));
        billDeal.setBillId(bdDyn.getLong("billid"));
        billDeal.setBillNumber(bdDyn.getString("billnumber"));
        billDeal.setDealOperate(bdDyn.getString("dealoperate"));
        billDeal.setDealState(bdDyn.getString("dealstate"));
        billDeal.setApplyTime(bdDyn.getDate("applytime"));
    }

    public static void copyBDAttr(QTBillDeal bill, DynamicObject bdDyn) {
        bdDyn.set("id", (Object)bill.getId());
        bdDyn.set("srcid", (Object)bill.getSrcID());
        bdDyn.set("srcpid", (Object)bill.getSrcPID());
        bdDyn.set("chainid", (Object)bill.getChainID());
        bdDyn.set("batchnum", (Object)bill.getBatchNum());
        bdDyn.set("attfileboid", (Object)bill.getAttFileBoId());
        bdDyn.set("parentbillid", (Object)bill.getParentBillId());
        bdDyn.set("billid", (Object)bill.getBillId());
        bdDyn.set("billnumber", (Object)bill.getBillNumber());
        bdDyn.set("dealoperate", (Object)bill.getDealOperate());
        bdDyn.set("dealstate", (Object)bill.getDealState());
        bdDyn.set("applytime", (Object)bill.getApplyTime());
    }

    public static QTBillDeal parse2BD(DynamicObject bdDyn) {
        QTBillDeal billDeal = new QTBillDeal();
        QTDealRecordConverter.copyBDAttr(bdDyn, billDeal);
        billDeal.setEntryDealList(new ArrayList<QTBillEntryDeal>(16));
        return billDeal;
    }

    public static DynamicObject parse2BD(QTBillDeal bill, boolean archive) {
        DynamicObject bdDyn = archive ? QTDealRecordConverter.newDyn("wtp_qtbilldealhis") : QTDealRecordConverter.newDyn("wtp_qtbilldeal");
        QTDealRecordConverter.copyBDAttr(bill, bdDyn);
        return bdDyn;
    }
}

