/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.cumulate.trading;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtp.business.cumulate.calculate.util.CheckUtils;
import kd.wtc.wtp.business.cumulate.trading.QTDealRecordConverter;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtp.business.cumulate.trading.model.DealStatus;
import kd.wtc.wtp.business.cumulate.trading.model.DeductSource;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.EffectiveEntityVoExt;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillDeal;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillEntryDeal;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillEntryDealDetail;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTDealRecordDBService {
    private static final Log log = LogFactory.getLog(QTDealRecordDBService.class);
    public static final HRBaseServiceHelper bdDao = new HRBaseServiceHelper("wtp_qtbilldeal");
    public static final HRBaseServiceHelper bdArchiveDao = new HRBaseServiceHelper("wtp_qtbilldealhis");
    public static final HRBaseServiceHelper bedDao = new HRBaseServiceHelper("wtp_qtbillentrydeal");
    public static final HRBaseServiceHelper bedArchiveDao = new HRBaseServiceHelper("wtp_qtbillentrydealhis");
    public static final HRBaseServiceHelper beddArchiveDao = new HRBaseServiceHelper("wtp_qtbeddetail");
    public static final HRBaseServiceHelper billPackageDao = new HRBaseServiceHelper("wtp_qtbillpackage");

    public static void deleteAllDealByFileBoId(Collection<Long> fileBoIds) {
        DynamicObject[] arr = bdDao.query("id,billid", new QFilter("attfileboid", "in", fileBoIds).toArray());
        billPackageDao.deleteByFilter(new QFilter("billid", "in", Arrays.stream(arr).map(ele -> ele.getLong("billid")).collect(Collectors.toSet())).toArray());
        bedDao.deleteByFilter(new QFilter("pid", "in", Arrays.stream(arr).map(ele -> ele.getLong("id")).collect(Collectors.toSet())).toArray());
        bdDao.deleteByFilter(new QFilter("attfileboid", "in", fileBoIds).toArray());
        arr = bdArchiveDao.query("id,billid", new QFilter("attfileboid", "in", fileBoIds).toArray());
        billPackageDao.deleteByFilter(new QFilter("billid", "in", Arrays.stream(arr).map(ele -> ele.getLong("billid")).collect(Collectors.toSet())).toArray());
        bedArchiveDao.deleteByFilter(new QFilter("pid", "in", Arrays.stream(arr).map(ele -> ele.getLong("id")).collect(Collectors.toSet())).toArray());
        bdArchiveDao.deleteByFilter(new QFilter("attfileboid", "in", fileBoIds).toArray());
    }

    private static void setChildType(List<EffectiveEntityVoExt> list) {
        HRBaseServiceHelper hvaApplyServiceelper = new HRBaseServiceHelper("wtabm_vaapply");
        String queryFields = "id, billno, ischange, applytyperadio, entryentity.entryvacationtype, entryentity.entrystartdate, entryentity.entryenddate";
        Set billIdList = list.stream().map(EffectiveEntityVoExt::getBillId).collect(Collectors.toSet());
        DynamicObject[] billDynArr = hvaApplyServiceelper.query(queryFields, new QFilter("id", "in", billIdList).toArray());
        HashMap<Long, String> tmp = new HashMap<Long, String>(billDynArr.length);
        for (DynamicObject bill : billDynArr) {
            DynamicObjectCollection subBillArr = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject subBill : subBillArr) {
                tmp.put(subBill.getLong("id"), subBill.getString("entryvacationtype.name"));
            }
        }
        for (EffectiveEntityVoExt ele : list) {
            ele.setChildType((String)tmp.get(ele.getId()));
        }
    }

    private static boolean needSkip(int queryType, QTBillDeal billDeal) {
        if (queryType == 0) {
            return false;
        }
        if (queryType == 1) {
            return !billDeal.getDealState().equals(DealStatus.USED.code) && !billDeal.getDealState().equals(DealStatus.USED_LOCK.code);
        }
        if (queryType == 2) {
            return !billDeal.getDealState().equals(DealStatus.FROZEN.code) && !billDeal.getDealState().equals(DealStatus.FROZEN_LOCK.code);
        }
        if (queryType == 3) {
            return !billDeal.getDealState().equals(DealStatus.USED.code) && !billDeal.getDealState().equals(DealStatus.USED_LOCK.code);
        }
        return false;
    }

    public static Map<Long, List<EffectiveEntityVoExt>> loadBillDeal(Collection<Long> lineDetailIdList, int queryType) {
        DynamicObject[] beddArr = beddArchiveDao.query("id,fid", new QFilter("qtsummarydetail", "in", lineDetailIdList).toArray());
        Set tarBedIdSet = Arrays.stream(beddArr).map(bedd -> bedd.getLong("fid")).collect(Collectors.toSet());
        DynamicObject[] bedArr = bedDao.query("id,pid", new QFilter("id", "in", tarBedIdSet).toArray());
        Set<Long> tarBdIdSet = Arrays.stream(bedArr).map(bed -> bed.getLong("pid")).collect(Collectors.toSet());
        Map<Long, QTBillDeal> longQTBillDealMap = QTDealRecordDBService.loadBDByPK(tarBdIdSet, true);
        HashMap<Long, List<EffectiveEntityVoExt>> res = new HashMap<Long, List<EffectiveEntityVoExt>>(lineDetailIdList.size());
        for (Long l : lineDetailIdList) {
            res.put(l, new ArrayList(16));
        }
        for (QTBillDeal qTBillDeal : longQTBillDealMap.values()) {
            if (QTDealRecordDBService.needSkip(queryType, qTBillDeal)) continue;
            for (QTBillEntryDeal qTBillEntryDeal : qTBillDeal.getEntryDealList()) {
                HashMap<Long, EffectiveEntityVoExt> tmp = new HashMap<Long, EffectiveEntityVoExt>(16);
                for (QTBillEntryDealDetail qTBillEntryDealDetail : qTBillEntryDeal.getDetailList()) {
                    if (!DeductSource.fromPool(qTBillEntryDealDetail.getDeductSource())) continue;
                    EffectiveEntityVoExt vo = tmp.computeIfAbsent(qTBillEntryDealDetail.getQtSummaryDetailId(), key -> new EffectiveEntityVoExt());
                    vo.setId(qTBillEntryDeal.getBillEntryId());
                    vo.setBillno(qTBillDeal.getBillNumber());
                    vo.setStartDate(qTBillEntryDeal.getStartDate());
                    vo.setEndDate(qTBillEntryDeal.getEndDate());
                    vo.setBillId(qTBillDeal.getBillId());
                    if (queryType == 0) {
                        vo.setValue(vo.getValue().add(qTBillEntryDealDetail.getApplyValue()));
                    } else if (DeductSource.fromPoolNotIvd(qTBillEntryDealDetail.getDeductSource())) {
                        vo.setValue(vo.getValue().add(qTBillEntryDealDetail.getApplyValue()));
                    }
                    vo.setApplyDate(qTBillDeal.getApplyTime());
                }
                for (Map.Entry entry : tmp.entrySet()) {
                    List list = (List)res.get(entry.getKey());
                    if (list == null) continue;
                    list.add(entry.getValue());
                }
            }
        }
        List<EffectiveEntityVoExt> collect = res.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        QTDealRecordDBService.setChildType(collect);
        for (Map.Entry entry : res.entrySet()) {
            ((List)entry.getValue()).sort((o1, o2) -> {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.getApplyDate().compareTo(o2.getApplyDate());
            });
        }
        if (queryType != 1) {
            return res;
        }
        Map<Long, QTLineDetail> map = QTLineDetailDBService.loadLineDetail(lineDetailIdList);
        block6: for (Map.Entry<Long, QTLineDetail> entry : map.entrySet()) {
            Long detailId = entry.getKey();
            BigDecimal useOdValue = entry.getValue().getUseOdValue();
            if (CheckUtils.isPositive(useOdValue)) {
                List list = (List)res.get(detailId);
                ArrayList tmpVpList = new ArrayList(list);
                list.clear();
                for (int i = tmpVpList.size() - 1; i >= 0; --i) {
                    EffectiveEntityVoExt vo = (EffectiveEntityVoExt)((Object)tmpVpList.get(i));
                    if (CheckUtils.isLargeEqual(vo.getValue(), useOdValue)) {
                        vo.setValue(useOdValue);
                        list.add(0, vo);
                        continue block6;
                    }
                    useOdValue = useOdValue.subtract(vo.getValue());
                    list.add(0, vo);
                }
                continue;
            }
            ((List)res.get(detailId)).clear();
        }
        return res;
    }

    public static Map<Long, QTBillDeal> loadBillDealByLineId(Collection<Long> lineIds) {
        DynamicObject[] beddArr = beddArchiveDao.query("id,fid", new QFilter("qtsummarydetail", "in", lineIds).toArray());
        Set tarBedIdSet = Arrays.stream(beddArr).map(bedd -> bedd.getLong("fid")).collect(Collectors.toSet());
        DynamicObject[] bedArr = bedDao.query("id,pid", new QFilter("id", "in", tarBedIdSet).toArray());
        Set<Long> tarBdIdSet = Arrays.stream(bedArr).map(bed -> bed.getLong("pid")).collect(Collectors.toSet());
        return QTDealRecordDBService.loadBDByPK(tarBdIdSet, true);
    }

    public static Map<DetailLogicKey, List<QTBillDeal>> loadBillInfo(List<DetailLogicKey> list) {
        long count = list.stream().filter(lk -> lk.getAttFileBoId() <= 0L || lk.getQtTypeId() <= 0L || lk.getCycleId() <= 0L || (long)lk.getCycleIndex() <= 0L).count();
        if (count > 0L) {
            throw new IllegalArgumentException("just support full logicKey query");
        }
        HashSet<Long> fileBoIdList = new HashSet<Long>(list.size());
        HashSet<Long> qtTypeIdList = new HashSet<Long>(list.size());
        HashSet<Long> pCycleIdList = new HashSet<Long>(list.size());
        HashSet<Integer> periodNumList = new HashSet<Integer>(list.size());
        for (DetailLogicKey logicKey : list) {
            fileBoIdList.add(logicKey.getAttFileBoId());
            qtTypeIdList.add(logicKey.getQtTypeId());
            pCycleIdList.add(logicKey.getCycleId());
            periodNumList.add(logicKey.getCycleIndex());
        }
        QFilter filter = new QFilter("attfilebo", "in", fileBoIdList).and("qttype", "in", qtTypeIdList).and("periodcircleid", "in", pCycleIdList).and("periodnum", "in", periodNumList);
        DynamicObject[] lineArr = QTLineDetailDBService.lineDetailDao.query(String.join((CharSequence)",", QTLineDetailDBService.SELECT), filter.toArray());
        HashMap<Long, DynamicObject> lineMap = new HashMap<Long, DynamicObject>(lineArr.length);
        for (DynamicObject line : lineArr) {
            long lineId = line.getLong("id");
            lineMap.put(lineId, line);
        }
        DynamicObject[] beddArr = beddArchiveDao.query("id,fid", new QFilter("qtsummarydetail", "in", lineMap.keySet()).toArray());
        Set tarBedIdSet = Arrays.stream(beddArr).map(bedd -> bedd.getLong("fid")).collect(Collectors.toSet());
        DynamicObject[] bedArr = bedDao.query("id,pid", new QFilter("id", "in", tarBedIdSet).toArray());
        Set tarBdIdSet = Arrays.stream(bedArr).map(bed -> bed.getLong("pid")).collect(Collectors.toSet());
        DynamicObject[] bdArr = bdDao.query("chainid", new QFilter("id", "in", tarBdIdSet).toArray());
        Set<Long> tarChainIdSet = Arrays.stream(bdArr).map(bd -> bd.getLong("chainid")).collect(Collectors.toSet());
        Map<Long, List<QTBillDeal>> longListMap = QTDealRecordDBService.loadBDByChainId(tarChainIdSet, true);
        List<QTBillDeal> allBillDeal = longListMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        Map<Long, QTBillDeal> dissociateBDParentMap = QTDealRecordDBService.queryDissociateBD(allBillDeal);
        HashMap<DetailLogicKey, List<QTBillDeal>> res = new HashMap<DetailLogicKey, List<QTBillDeal>>(16);
        for (DetailLogicKey detailLogicKey : list) {
            res.put(detailLogicKey, new ArrayList(16));
        }
        for (QTBillDeal qTBillDeal : allBillDeal) {
            Set lineIdSet = qTBillDeal.getEntryDealList().stream().flatMap(ele -> ele.getDetailList().stream()).map(QTBillEntryDealDetail::getQtSummaryDetailId).filter(ele -> ele > 0L).collect(Collectors.toSet());
            HashSet<DetailLogicKey> affiliation = new HashSet<DetailLogicKey>(16);
            for (Long lineId : lineIdSet) {
                int periodNum;
                long pCycleId;
                long qtTypeId;
                long attFileBoId;
                DetailLogicKey logicKey1;
                List qtBillDeals1;
                DynamicObject line = (DynamicObject)lineMap.get(lineId);
                if (line == null || (qtBillDeals1 = (List)res.get(logicKey1 = new DetailLogicKey(attFileBoId = line.getLong("attfilebo.id"), qtTypeId = line.getLong("qttype.id"), pCycleId = line.getLong("periodcircleid.id"), periodNum = line.getInt("periodnum")))) == null || !affiliation.add(logicKey1)) continue;
                qtBillDeals1.add(qTBillDeal);
            }
        }
        for (Map.Entry entry : res.entrySet()) {
            List value = (List)entry.getValue();
            HashSet<Long> chainIdSet = new HashSet<Long>(16);
            HashSet<Long> billIdSet = new HashSet<Long>(16);
            for (QTBillDeal billDeal3 : value) {
                chainIdSet.add(billDeal3.getChainID());
                billIdSet.add(billDeal3.getBillId());
            }
            chainIdSet.stream().flatMap(chainId -> longListMap.getOrDefault(chainId, Collections.emptyList()).stream()).forEach(billDeal -> {
                if (billIdSet.add(billDeal.getBillId())) {
                    value.add(billDeal);
                }
            });
            billIdSet.forEach(billId -> {
                QTBillDeal billDeal = (QTBillDeal)dissociateBDParentMap.get(billId);
                if (billDeal != null && billIdSet.add(billDeal.getBillId())) {
                    value.add(billDeal);
                }
            });
        }
        return res;
    }

    private static Map<Long, QTBillDeal> queryDissociateBD(List<QTBillDeal> allBillDeal) {
        if (DealRecordOperationCTRLParam.queryDissociateBD()) {
            Set allBillId = allBillDeal.stream().map(QTBillDeal::getBillId).collect(Collectors.toSet());
            QFilter[] filterDissociate = new QFilter("parentbillid", "in", allBillId).and("billid", "not in", allBillId).toArray();
            DynamicObject[] dissociateBD = bdDao.query("id", filterDissociate);
            Set<Long> dissociateBDID = Arrays.stream(dissociateBD).map(ele -> ele.getLong("id")).collect(Collectors.toSet());
            Map<Long, QTBillDeal> dissociateBDMap = QTDealRecordDBService.loadBDByPK(dissociateBDID, true);
            HashMap<Long, QTBillDeal> dissociateBDParentMap = new HashMap<Long, QTBillDeal>(dissociateBDMap.size());
            for (Map.Entry<Long, QTBillDeal> entry : dissociateBDMap.entrySet()) {
                QTBillDeal billDeal = entry.getValue();
                if (billDeal == null) continue;
                dissociateBDParentMap.put(billDeal.getParentBillId(), billDeal);
            }
            return dissociateBDParentMap;
        }
        return Collections.emptyMap();
    }

    public static boolean existSameBillIdBD(long billId) {
        QFilter qFilter = new QFilter("billid", "=", (Object)billId);
        return bdDao.isExists(qFilter);
    }

    public static void saveBD(QTBillDeal billDeal) {
        DynamicObject dyn = QTDealRecordConverter.parse2BD(billDeal, false);
        bdDao.saveOne(dyn);
        billDeal.setId(dyn.getLong("id"));
    }

    public static void saveBD(List<QTBillDeal> billDealList) {
        DynamicObject[] dynamicObjects = (DynamicObject[])billDealList.stream().map(ele -> QTDealRecordConverter.parse2BD(ele, false)).toArray(DynamicObject[]::new);
        bdDao.save(dynamicObjects);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            billDealList.get(i).setId(dynamicObjects[i].getLong("id"));
        }
    }

    public static void updateOrInsertBD(Collection<QTBillDeal> billDealList) {
        if (WTCCollections.isNotEmpty(billDealList)) {
            Set idSet = billDealList.stream().map(QTBillDeal::getId).collect(Collectors.toSet());
            DynamicObject[] arr = bdDao.loadDynamicObjectArray(new QFilter("id", "in", idSet).toArray());
            HashMap<Long, DynamicObject> updateMap = new HashMap<Long, DynamicObject>(arr.length);
            for (DynamicObject bdDyn : arr) {
                updateMap.put(bdDyn.getLong("id"), bdDyn);
            }
            Map insertMap = WTCCollections.modifiableEmptyMap();
            for (QTBillDeal billDeal : billDealList) {
                DynamicObject dyn = (DynamicObject)updateMap.get(billDeal.getId());
                if (dyn == null) {
                    insertMap.put(billDeal.getId(), QTDealRecordConverter.parse2BD(billDeal, false));
                    continue;
                }
                QTDealRecordConverter.copyBDAttr(billDeal, dyn);
            }
            bdDao.update(updateMap.values().toArray(new DynamicObject[0]));
            bdDao.save(insertMap.values().toArray(new DynamicObject[0]));
        }
    }

    public static void updateOrInsertBD2Archive(List<QTBillDeal> billDealList) {
        if (DealRecordOperationCTRLParam.enableArchive() && WTCCollections.isNotEmpty(billDealList)) {
            Set idSet = billDealList.stream().map(QTBillDeal::getId).collect(Collectors.toSet());
            DynamicObject[] arr = bdArchiveDao.loadDynamicObjectArray(new QFilter("id", "in", idSet).toArray());
            HashMap<Long, DynamicObject> updateMap = new HashMap<Long, DynamicObject>(arr.length);
            for (DynamicObject bdDyn : arr) {
                updateMap.put(bdDyn.getLong("id"), bdDyn);
            }
            Map insertMap = WTCCollections.modifiableEmptyMap();
            for (QTBillDeal billDeal : billDealList) {
                DynamicObject dyn = (DynamicObject)updateMap.get(billDeal.getId());
                if (dyn == null) {
                    insertMap.put(billDeal.getId(), QTDealRecordConverter.parse2BD(billDeal, true));
                    continue;
                }
                QTDealRecordConverter.copyBDAttr(billDeal, dyn);
            }
            bdArchiveDao.update(updateMap.values().toArray(new DynamicObject[0]));
            bdArchiveDao.save(insertMap.values().toArray(new DynamicObject[0]));
        }
    }

    public static void saveBD2Archive(QTBillDeal billDeal) {
        if (DealRecordOperationCTRLParam.enableArchive()) {
            DynamicObject dyn = QTDealRecordConverter.parse2BD(billDeal, true);
            bdArchiveDao.saveOne(dyn);
        }
    }

    public static void saveBD2Archive(List<QTBillDeal> billDealList) {
        if (DealRecordOperationCTRLParam.enableArchive()) {
            DynamicObject[] dynamicObjects = (DynamicObject[])billDealList.stream().map(ele -> QTDealRecordConverter.parse2BD(ele, true)).toArray(DynamicObject[]::new);
            bdDao.save(dynamicObjects);
        }
    }

    public static Set<Long> queryChainId(Collection<Long> billId) {
        DynamicObject[] query = bdDao.query("chainid", new QFilter("billid", "in", billId).toArray());
        return Arrays.stream(query).map(ele -> ele.getLong("chainid")).collect(Collectors.toSet());
    }

    public static Map<Long, List<QTBillDeal>> loadBDByChainId(Collection<Long> chainIdList, boolean loadBED) {
        HashMap<Long, List<QTBillDeal>> res = new HashMap<Long, List<QTBillDeal>>(16);
        if (chainIdList != null && !chainIdList.isEmpty()) {
            DynamicObject[] arr = bdDao.loadDynamicObjectArray(new QFilter("chainid", "in", chainIdList).toArray());
            List collect = Arrays.stream(arr).map(QTDealRecordConverter::parse2BD).collect(Collectors.toList());
            if (loadBED) {
                List<Long> bdIdList = collect.stream().map(QTBillDeal::getId).collect(Collectors.toList());
                Map<Long, List<QTBillEntryDeal>> bdEntryListMap = QTDealRecordDBService.loadBEDByBDID(bdIdList);
                for (QTBillDeal billDeal : collect) {
                    List<QTBillEntryDeal> entries = bdEntryListMap.get(billDeal.getId());
                    if (entries == null) continue;
                    billDeal.setEntryDealList(entries);
                }
            }
            for (QTBillDeal billDeal : collect) {
                List chain = res.computeIfAbsent(billDeal.getChainID(), key -> new ArrayList(16));
                chain.add(billDeal);
            }
        }
        return res;
    }

    public static List<DynamicObject> queryBDByChainId(String selectKey, long chainId) {
        DynamicObject[] query = bdDao.query(selectKey, new QFilter("chainid", "=", (Object)chainId).toArray());
        return Arrays.asList(query);
    }

    public static QTBillDeal loadBDByPK(long pk, boolean loadBED) {
        DynamicObject bdDyn = bdDao.loadDynamicObject(new QFilter("id", "=", (Object)pk));
        if (bdDyn != null) {
            QTBillDeal bd = QTDealRecordConverter.parse2BD(bdDyn);
            if (loadBED) {
                bd.setEntryDealList(QTDealRecordDBService.loadBEDByBDID(bd.getId()));
            } else {
                bd.setEntryDealList(new ArrayList<QTBillEntryDeal>());
            }
            return bd;
        }
        return null;
    }

    public static Map<Long, QTBillDeal> loadBDByPK(Collection<Long> pkList, boolean loadBED) {
        QTBillDeal billDeal;
        DynamicObject[] arr = bdDao.loadDynamicObjectArray(new QFilter("id", "in", pkList).toArray());
        HashMap<Long, QTBillDeal> res = new HashMap<Long, QTBillDeal>(pkList.size());
        for (DynamicObject dyn : arr) {
            billDeal = QTDealRecordConverter.parse2BD(dyn);
            res.put(billDeal.getId(), billDeal);
        }
        if (loadBED) {
            List<Long> bdIdList = res.values().stream().map(QTBillDeal::getId).collect(Collectors.toList());
            Map<Long, List<QTBillEntryDeal>> bdEntryListMap = QTDealRecordDBService.loadBEDByBDID(bdIdList);
            for (Map.Entry entry : res.entrySet()) {
                billDeal = (QTBillDeal)entry.getValue();
                List<QTBillEntryDeal> entries = bdEntryListMap.get(billDeal.getId());
                if (entries == null) continue;
                billDeal.setEntryDealList(entries);
            }
        }
        return res;
    }

    public static DynamicObject queryBDByBillId(String selectKey, long billId) {
        if (selectKey == null) {
            return bdDao.loadDynamicObject(new QFilter("billid", "=", (Object)billId).toArray());
        }
        return bdDao.queryOne(selectKey, new QFilter("billid", "=", (Object)billId).toArray());
    }

    public static QTBillDeal loadBDByBillId(long billId, boolean loadBED) {
        DynamicObject bdDyn = bdDao.loadDynamicObject(new QFilter("billid", "=", (Object)billId).toArray());
        if (bdDyn != null) {
            QTBillDeal bd = QTDealRecordConverter.parse2BD(bdDyn);
            if (loadBED) {
                bd.setEntryDealList(QTDealRecordDBService.loadBEDByBDID(bd.getId()));
            } else {
                bd.setEntryDealList(new ArrayList<QTBillEntryDeal>());
            }
            return bd;
        }
        return null;
    }

    public static Map<Long, QTBillDeal> loadBDByBillId(Collection<Long> billIdList, boolean loadBED) {
        QTBillDeal billDeal;
        QFilter[] filters = new QFilter("billid", "in", billIdList).toArray();
        DynamicObject[] bdDynArr = bdDao.loadDynamicObjectArray(filters);
        HashMap<Long, QTBillDeal> res = new HashMap<Long, QTBillDeal>(billIdList.size());
        for (DynamicObject dyn : bdDynArr) {
            billDeal = QTDealRecordConverter.parse2BD(dyn);
            res.put(billDeal.getBillId(), billDeal);
        }
        if (loadBED) {
            List<Long> bdIdList = res.values().stream().map(QTBillDeal::getId).collect(Collectors.toList());
            Map<Long, List<QTBillEntryDeal>> bdEntryListMap = QTDealRecordDBService.loadBEDByBDID(bdIdList);
            for (Map.Entry entry : res.entrySet()) {
                billDeal = (QTBillDeal)entry.getValue();
                List<QTBillEntryDeal> entries = bdEntryListMap.get(billDeal.getId());
                if (entries == null) continue;
                billDeal.setEntryDealList(entries);
            }
        }
        return res;
    }

    public static void deleteBDByPK(long pk) {
        bdDao.deleteOne((Object)pk);
    }

    public static void deleteBDByPK(Collection<Long> pkList) {
        bdDao.delete(pkList.toArray(new Object[0]));
    }

    public static void saveBED(List<QTBillEntryDeal> bedList) {
        DynamicObject[] bedDynArr = (DynamicObject[])bedList.stream().map(ele -> QTDealRecordConverter.parse2BED(ele, false)).toArray(DynamicObject[]::new);
        bedDao.save(bedDynArr);
        for (int idx = 0; idx < bedDynArr.length; ++idx) {
            bedList.get(idx).setId(bedDynArr[idx].getLong("id"));
        }
    }

    public static void saveBED2Archive(List<QTBillEntryDeal> bedList) {
        if (DealRecordOperationCTRLParam.enableArchive()) {
            DynamicObject[] bedDynArr = (DynamicObject[])bedList.stream().map(ele -> QTDealRecordConverter.parse2BED(ele, true)).toArray(DynamicObject[]::new);
            bedArchiveDao.save(bedDynArr);
        }
    }

    public static void updateOrInsertBED(Collection<QTBillEntryDeal> bedList) {
        if (WTCCollections.isNotEmpty(bedList)) {
            Set idSet = bedList.stream().map(QTBillEntryDeal::getId).collect(Collectors.toSet());
            DynamicObject[] arr = bedDao.loadDynamicObjectArray(new QFilter("id", "in", idSet).toArray());
            HashMap<Long, DynamicObject> updateMap = new HashMap<Long, DynamicObject>(arr.length);
            Map insertMap = WTCCollections.modifiableEmptyMap();
            for (DynamicObject dyn : arr) {
                updateMap.put(dyn.getLong("id"), dyn);
            }
            for (QTBillEntryDeal bed : bedList) {
                DynamicObject dyn = (DynamicObject)updateMap.get(bed.getId());
                if (dyn == null) {
                    insertMap.put(bed.getId(), QTDealRecordConverter.parse2BED(bed, false));
                    continue;
                }
                QTDealRecordConverter.copyBEDAttr(bed, dyn);
                Set bedIdSet = bed.getDetailList().stream().map(QTBillEntryDealDetail::getPk).collect(Collectors.toSet());
                DynamicObjectCollection entries = dyn.getDynamicObjectCollection("entryentity");
                entries.removeIf(ele -> !bedIdSet.contains(ele.getLong("id")));
                HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>(entries.size());
                for (DynamicObject entry : entries) {
                    entryMap.put(entry.getLong("id"), entry);
                }
                for (QTBillEntryDealDetail bedDetail : bed.getDetailList()) {
                    DynamicObject entry = (DynamicObject)entryMap.get(bedDetail.getPk());
                    if (entry == null) {
                        EntryProp entryProp = (EntryProp)dyn.getDataEntityType().getProperties().get((Object)"entryentity");
                        EntryType entryType = (EntryType)entryProp.getItemType();
                        DynamicObject entryDyn = new DynamicObject((DynamicObjectType)entryType);
                        QTDealRecordConverter.copyBEDDAttr(bedDetail, entryDyn);
                        entryMap.put(bedDetail.getPk(), entryDyn);
                        entries.add((Object)entryDyn);
                        continue;
                    }
                    QTDealRecordConverter.copyBEDDAttr(bedDetail, entry);
                }
            }
            bedDao.update(updateMap.values().toArray(new DynamicObject[0]));
            bedDao.save(insertMap.values().toArray(new DynamicObject[0]));
        }
    }

    public static void updateOrInsertBED2Archive(Collection<QTBillEntryDeal> bedList) {
        if (DealRecordOperationCTRLParam.enableArchive() && WTCCollections.isNotEmpty(bedList)) {
            Set idSet = bedList.stream().map(QTBillEntryDeal::getId).collect(Collectors.toSet());
            DynamicObject[] arr = bedArchiveDao.loadDynamicObjectArray(new QFilter("id", "in", idSet).toArray());
            HashMap<Long, DynamicObject> updateMap = new HashMap<Long, DynamicObject>(arr.length);
            Map insertMap = WTCCollections.modifiableEmptyMap();
            for (DynamicObject dyn : arr) {
                updateMap.put(dyn.getLong("id"), dyn);
            }
            for (QTBillEntryDeal bed : bedList) {
                DynamicObject dyn = (DynamicObject)updateMap.get(bed.getId());
                if (dyn == null) {
                    insertMap.put(bed.getId(), QTDealRecordConverter.parse2BED(bed, true));
                    continue;
                }
                QTDealRecordConverter.copyBEDAttr(bed, dyn);
                Set bedIdSet = bed.getDetailList().stream().map(QTBillEntryDealDetail::getPk).collect(Collectors.toSet());
                DynamicObjectCollection entries = dyn.getDynamicObjectCollection("entryentity");
                entries.removeIf(ele -> !bedIdSet.contains(ele.getLong("id")));
                HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>(entries.size());
                for (DynamicObject entry : entries) {
                    entryMap.put(entry.getLong("id"), entry);
                }
                for (QTBillEntryDealDetail bedDetail : bed.getDetailList()) {
                    DynamicObject entry = (DynamicObject)entryMap.get(bedDetail.getPk());
                    if (entry == null) {
                        EntryProp entryProp = (EntryProp)dyn.getDataEntityType().getProperties().get((Object)"entryentity");
                        EntryType entryType = (EntryType)entryProp.getItemType();
                        DynamicObject entryDyn = new DynamicObject((DynamicObjectType)entryType);
                        QTDealRecordConverter.copyBEDDAttr(bedDetail, entryDyn);
                        entryMap.put(bedDetail.getPk(), entryDyn);
                        entries.add((Object)entryDyn);
                        continue;
                    }
                    QTDealRecordConverter.copyBEDDAttr(bedDetail, entry);
                }
            }
            bedArchiveDao.update(updateMap.values().toArray(new DynamicObject[0]));
            bedArchiveDao.save(insertMap.values().toArray(new DynamicObject[0]));
        }
    }

    public static List<QTBillEntryDeal> loadBEDByBDID(long billDealPK) {
        QFilter qFilter = new QFilter("pid", "=", (Object)billDealPK);
        DynamicObject[] bedDynArr = bedDao.loadDynamicObjectArray(qFilter.toArray());
        return Arrays.stream(bedDynArr).map(QTDealRecordConverter::parse2BED).collect(Collectors.toList());
    }

    public static Map<Long, List<QTBillEntryDeal>> loadBEDByBDID(List<Long> billDealPKList) {
        QFilter qFilter = new QFilter("pid", "in", billDealPKList);
        DynamicObject[] bedDynArr = bedDao.loadDynamicObjectArray(qFilter.toArray());
        return Arrays.stream(bedDynArr).map(QTDealRecordConverter::parse2BED).collect(Collectors.groupingBy(QTBillEntryDeal::getPid));
    }

    public static Map<Long, List<DynamicObject>> queryBEDByBDID(String selectKey, List<Long> billDealPKList) {
        QFilter qFilter = new QFilter("pid", "in", billDealPKList);
        DynamicObject[] bedDynArr = bedDao.query(selectKey, qFilter.toArray());
        HashMap<Long, List<DynamicObject>> res = new HashMap<Long, List<DynamicObject>>(bedDynArr.length);
        for (DynamicObject bed : bedDynArr) {
            long pid = bed.getLong("pid");
            List bedList = res.computeIfAbsent(pid, key -> new ArrayList());
            bedList.add(bed);
        }
        return res;
    }

    public static void deleteBEDByBDID(long billDealPK) {
        QFilter qFilter = new QFilter("pid", "=", (Object)billDealPK);
        bedDao.deleteByFilter(qFilter.toArray());
    }

    public static void deleteBEDByBDID(Collection<Long> billDealPK) {
        QFilter qFilter = new QFilter("pid", "in", billDealPK);
        bedDao.deleteByFilter(qFilter.toArray());
    }

    public static Map<Long, BillApply> queryBillApplyPackage(Collection<Long> billIdList) {
        DynamicObject[] dynArr;
        HashMap<Long, BillApply> res = new HashMap<Long, BillApply>(16);
        QFilter qFilter = new QFilter("billid", "in", billIdList);
        for (DynamicObject dyn : dynArr = billPackageDao.loadDynamicObjectArray(qFilter.toArray())) {
            String version = dyn.getString("version");
            String packageTag = dyn.getString("package_tag");
            BillApply bill = QTDealRecordDBService.deSerialization(version, packageTag);
            res.put(dyn.getLong("billid"), bill);
        }
        return res;
    }

    public static void deleteBillApplyPackage(Collection<Long> billIdList) {
        QFilter qFilter = new QFilter("billid", "in", billIdList);
        billPackageDao.deleteByFilter(qFilter.toArray());
    }

    public static void saveBillApplyPackage(Collection<BillApply> billList) {
        if (billList != null && !billList.isEmpty()) {
            DynamicObject[] arr = (DynamicObject[])billList.stream().map(ele -> {
                DynamicObject dyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtp_qtbillpackage"));
                dyn.set("billid", (Object)ele.getId());
                dyn.set("version", (Object)"V0001");
                dyn.set("package_tag", (Object)QTDealRecordDBService.serialization("V0001", ele));
                return dyn;
            }).toArray(DynamicObject[]::new);
            billPackageDao.save(arr);
        }
    }

    private static String serialization(String version, BillApply bill) {
        if (version.equals("V0001")) {
            return WTCSerializationUtils.serializeToBase64((Object)bill);
        }
        return null;
    }

    private static BillApply deSerialization(String version, String billStr) {
        if (version.equals("V0001")) {
            return (BillApply)WTCSerializationUtils.deSerializeFromBase64((String)billStr);
        }
        return null;
    }

    private static class DealRecordOperationCTRLParam {
        private static final long updateIntervalMills = 600000L;
        private static volatile Date lastUpdateTime = null;
        private static volatile boolean queryDissociateBD = false;
        private static volatile boolean enableArchive = false;

        private DealRecordOperationCTRLParam() {
        }

        private static boolean needUpdate() {
            Date tmp = lastUpdateTime;
            return tmp == null || tmp.getTime() + 600000L <= new Date().getTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static void updateParamIfNeed() {
            if (!DealRecordOperationCTRLParam.needUpdate()) return;
            Class<DealRecordOperationCTRLParam> clazz = DealRecordOperationCTRLParam.class;
            synchronized (DealRecordOperationCTRLParam.class) {
                if (!DealRecordOperationCTRLParam.needUpdate()) return;
                HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbs_taskpara");
                ArrayList<String> categoryList = new ArrayList<String>(16);
                categoryList.add("wtte_qttiefixdata");
                categoryList.add("wtte_qtstoredealbk");
                DynamicObject[] query = helper.query("category", new QFilter("category", "in", categoryList).toArray());
                Set categorySet = Arrays.stream(query).map(dyn -> dyn.getString("category")).collect(Collectors.toSet());
                queryDissociateBD = categorySet.contains("wtte_qttiefixdata");
                enableArchive = categorySet.contains("wtte_qtstoredealbk");
                lastUpdateTime = new Date();
                log.info("DealRecordOperationCTRLParam update success:queryDissociateBD={},enableArchive={},lastUpdateTime={}", new Object[]{queryDissociateBD, enableArchive, lastUpdateTime});
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        public static boolean queryDissociateBD() {
            DealRecordOperationCTRLParam.updateParamIfNeed();
            return queryDissociateBD;
        }

        public static boolean enableArchive() {
            DealRecordOperationCTRLParam.updateParamIfNeed();
            return enableArchive;
        }
    }
}

