/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.cumulate.trading;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtbs.common.deduction.BillApplyEntry;
import kd.wtc.wtbs.common.deduction.BillEntryDateSplit;
import kd.wtc.wtbs.common.deduction.QTApplyInventory;
import kd.wtc.wtbs.common.deduction.QTAtomApplyResponse;
import kd.wtc.wtbs.common.deduction.QTWarnEvent;
import kd.wtc.wtbs.common.deduction.usable.AffluentUsableQuotaInfo;
import kd.wtc.wtbs.common.util.MapBuilder;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.cumulate.QTService;
import kd.wtc.wtp.business.cumulate.calculate.model.QTDeductRule;
import kd.wtc.wtp.business.cumulate.calculate.model.QTType;
import kd.wtc.wtp.business.cumulate.calculate.model.result.MBApplyRes;
import kd.wtc.wtp.business.cumulate.calculate.model.result.SBApplyRes;
import kd.wtc.wtp.business.cumulate.calculate.util.CheckUtils;
import kd.wtc.wtp.business.cumulate.trading.QTDealRecordDBService;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtp.business.cumulate.trading.QTOuterParamUtils;
import kd.wtc.wtp.business.cumulate.trading.QTRuntime;
import kd.wtc.wtp.business.cumulate.trading.anchor.QTDeductAnchor;
import kd.wtc.wtp.business.cumulate.trading.comparator.DetailComparatorPackage;
import kd.wtc.wtp.business.cumulate.trading.model.AffluentQTLineDetail;
import kd.wtc.wtp.business.cumulate.trading.model.DealOperate;
import kd.wtc.wtp.business.cumulate.trading.model.DealStatus;
import kd.wtc.wtp.business.cumulate.trading.model.DeductSource;
import kd.wtc.wtp.business.cumulate.trading.model.QTApplyInventoryHolder;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillDeal;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillEntryDeal;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillEntryDealDetail;
import kd.wtc.wtp.business.cumulate.trading.model.QTDRDebrisAccumulator;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTDeductService {
    private static final Log log = LogFactory.getLog(QTDeductService.class);
    private static final String ExtraValue = "ExtraValue";
    private static final String UsableValue = "UsableValue";
    private static final String CanBeOdValue = "CanBeOdValue";
    private static final String TotalValue = "TotalValue";
    private static final String emptyStr = "";

    public static void batchRefundBillDeal(Collection<QTBillDeal> billDealList, QTRuntime runtime) {
        for (QTBillDeal billDeal : billDealList) {
            DealStatus dealStatus = DealStatus.get(billDeal.getDealState());
            if (dealStatus == DealStatus.USED) {
                QTDeductService.refundVariousUsed(billDeal, runtime);
                continue;
            }
            if (dealStatus == DealStatus.USED_LOCK) {
                QTDeductService.refundVariousUsed(billDeal, runtime);
                continue;
            }
            if (dealStatus == DealStatus.FROZEN) {
                QTDeductService.refundVariousFrozen(billDeal, runtime);
                continue;
            }
            if (dealStatus != DealStatus.FROZEN_LOCK) continue;
            QTDeductService.refundVariousFrozen(billDeal, runtime);
        }
    }

    public static QTAtomApplyResponse batchDeduct(List<BillApply> sortedMainBillList, QTRuntime runtime) {
        for (BillApply mainBill : sortedMainBillList) {
            runtime.updateApplyTime(mainBill.getApplyTime());
            MBApplyRes applyRes = QTDeductService.newDeduct(0L, runtime, DealOperate.deduct, mainBill.getApplyTime(), mainBill);
            if (applyRes.isAllSuccess()) continue;
            return QTAtomApplyResponse.error((String)applyRes.getErrCode(), (String)applyRes.getErrMsg(), (BillApply)mainBill);
        }
        return QTAtomApplyResponse.success();
    }

    public static QTAtomApplyResponse batchFrozen(List<BillApply> sortedMainBillList, QTRuntime runtime) {
        for (BillApply mainBill : sortedMainBillList) {
            QTBillDeal locked;
            runtime.updateApplyTime(mainBill.getApplyTime());
            long srcPID = 0L;
            long chainID = 0L;
            if (mainBill.getParentId() != 0L && (locked = QTDeductService.lock(mainBill.getParentId(), runtime, false)) != null) {
                srcPID = locked.getId();
                chainID = locked.getChainID();
            }
            Map<Long, QTLineDetail> extraSlotMap = srcPID == 0L ? Collections.emptyMap() : QTDeductService.genExtraSlotMap(srcPID, runtime);
            runtime.setExtraSlotMap(extraSlotMap);
            MBApplyRes applyRes = QTDeductService.newFrozen(srcPID, chainID, mainBill, runtime);
            runtime.clearExtraSlotMapEffective();
            if (applyRes.isAllSuccess()) continue;
            return QTAtomApplyResponse.error((String)applyRes.getErrCode(), (String)applyRes.getErrMsg(), (BillApply)mainBill);
        }
        return QTAtomApplyResponse.success();
    }

    public static QTAtomApplyResponse batchDeductAtom(String batchNum, long attFileBoId, List<BillApply> mainBillList) {
        QTRuntime runtime = new QTRuntime(attFileBoId, new Date(), batchNum);
        runtime.setDeductRuleMap(QTDeductService.initDeductRule(mainBillList));
        runtime.setExtraSlotMap(Collections.emptyMap());
        runtime.plusPool(QTDeductService.initPool(attFileBoId, mainBillList, runtime.getDeductRuleMap()));
        QTDeductAnchor.beforeDoBatchDeductAtom(runtime);
        try {
            List<Long> billIdList = mainBillList.stream().map(BillApply::getId).collect(Collectors.toList());
            Map<Long, QTBillDeal> srcBillDealMap = QTDealRecordDBService.loadBDByBillId(billIdList, true);
            HashMap<Long, OPInfo> srcBillDealInfoMap = new HashMap<Long, OPInfo>(srcBillDealMap.size());
            for (BillApply billApply : mainBillList) {
                QTBillDeal srcBillDeal = srcBillDealMap.get(billApply.getId());
                if (srcBillDeal != null) {
                    long srcBillDealId;
                    DealStatus srcDealStatus = DealStatus.get(srcBillDeal.getDealState());
                    if (srcDealStatus == DealStatus.USED) {
                        runtime.updateApplyTime(billApply.getApplyTime());
                        srcBillDealId = QTDeductService.refundBeforeAmend(billApply, srcBillDeal, runtime);
                        srcBillDealInfoMap.put(billApply.getId(), new OPInfo(srcBillDealId, DealOperate.amend));
                    } else if (srcDealStatus == DealStatus.FROZEN) {
                        runtime.updateApplyTime(billApply.getApplyTime());
                        srcBillDealId = QTDeductService.releaseBeforeFrozen2Used(srcBillDeal, runtime);
                        srcBillDealInfoMap.put(billApply.getId(), new OPInfo(srcBillDealId, DealOperate.deduct));
                    } else {
                        return QTAtomApplyResponse.error((String)"illegal bill state", (String)("can't deduct illegal status bill[id=" + billApply.getId() + "], expect state: frozen/used, actual state:" + srcDealStatus.name()), (BillApply)billApply);
                    }
                    billApply.setApplyTime(srcBillDeal.getApplyTime());
                    continue;
                }
                srcBillDealInfoMap.put(billApply.getId(), new OPInfo(0L, DealOperate.deduct));
                if (billApply.getParentId() == 0L) continue;
                QTDeductService.releaseBeforeApplyUsed(billApply, runtime);
            }
            QTDeductService.coverApplyDate(mainBillList, srcBillDealMap);
            List<BillApply> sortedMainBillList = QTDeductService.getSortedMainBillList(mainBillList);
            for (BillApply mainBill : sortedMainBillList) {
                OPInfo opInfo = (OPInfo)srcBillDealInfoMap.get(mainBill.getId());
                runtime.updateApplyTime(mainBill.getApplyTime());
                MBApplyRes applyRes = QTDeductService.newDeduct(opInfo.srcBDId, runtime, opInfo.expectOp, mainBill.getApplyTime(), mainBill);
                if (applyRes.isAllSuccess()) continue;
                return QTAtomApplyResponse.error((String)applyRes.getErrCode(), (String)applyRes.getErrMsg(), (BillApply)mainBill);
            }
            for (QTLineDetail qtLineDetail : runtime.getAllDirtyDetail()) {
                if (!QTDeductService.checkDetailImbalance(qtLineDetail)) continue;
                log.info("frozen fail[batchNum={}]: QTDetail imbalance. detail={}", (Object)qtLineDetail);
                throw new IllegalStateException("QTDetail imbalance.");
            }
            try (TXHandle tXHandle = TX.required();){
                try {
                    runtime.flushUsedPackage(mainBillList);
                    runtime.flushDB(true);
                }
                catch (Exception exp) {
                    tXHandle.markRollback();
                    throw exp;
                }
            }
            return QTAtomApplyResponse.success();
        }
        catch (Exception exp) {
            log.warn("batchNum={} batchDeduct error: ", (Object)batchNum, (Object)exp);
            log.warn("batchNum={} batchDeduct bill fail. expect batchDeduct mainBillList={}", (Object)batchNum, mainBillList);
            return QTAtomApplyResponse.error((String)"UN_KNOW", (String)("batchDeduct bill fail, batchNum=" + batchNum + ". cause:" + exp.getMessage()), null);
        }
    }

    public static MBApplyRes frozen(String batchNum, BillApply mainBill) {
        return QTDeductService.frozen(batchNum, mainBill, true);
    }

    public static MBApplyRes frozen(String batchNum, BillApply mainBill, boolean flushDB) {
        try {
            QTBillDeal locked;
            if (QTDealRecordDBService.existSameBillIdBD(mainBill.getId())) {
                log.info("frozen fail[batchNum={}]: can't duplicate apply frozen bill. detamainBillil={}", (Object)batchNum, (Object)mainBill);
                return QTDeductService.genErrorMBApplyResFromBill(mainBill, "FROZEN_DUPLICATE", emptyStr);
            }
            QTRuntime runtime = new QTRuntime(mainBill.getAttFileBoId(), mainBill.getApplyTime(), batchNum);
            if (!flushDB) {
                runtime.discard();
            }
            long srcPID = 0L;
            long chainID = 0L;
            if (mainBill.getParentId() != 0L && (locked = QTDeductService.lock(mainBill.getParentId(), runtime, true)) != null) {
                srcPID = locked.getId();
                chainID = locked.getChainID();
            }
            Map<Long, QTLineDetail> extraSlotMap = srcPID == 0L ? Collections.emptyMap() : QTDeductService.genExtraSlotMap(srcPID, runtime);
            runtime.setExtraSlotMap(extraSlotMap);
            runtime.setDeductRuleMap(QTDeductService.initDeductRule(mainBill));
            runtime.plusPool(QTDeductService.initPool(mainBill, runtime.getDeductRuleMap()));
            MBApplyRes mbApplyRes = QTDeductService.newFrozen(srcPID, chainID, mainBill, runtime);
            if (mbApplyRes.isAllSuccess() && flushDB) {
                for (QTLineDetail qtLineDetail : runtime.getAllDirtyDetail()) {
                    if (!QTDeductService.checkDetailImbalance(qtLineDetail)) continue;
                    log.info("frozen warning[batchNum={}]: QTDetail imbalance. detail={}, billdeal={}", (Object)runtime.getBatchNum(), (Object)qtLineDetail);
                    log.info("frozen warning[batchNum={}]: QTDetail imbalance. billdeal={}", (Object)runtime.getBatchNum(), runtime.getWaitStoreBillDeal());
                    if (!QTDeductService.reBalanceDetail(qtLineDetail)) continue;
                    log.info("frozen fail[batchNum={}]: QTDetail imbalance. detail={}", new Object[]{runtime.getBatchNum(), qtLineDetail, runtime.getWaitStoreBillDeal()});
                    throw new IllegalStateException("QTDetail imbalance.");
                }
                try (TXHandle txHandle = TX.required();){
                    try {
                        runtime.flushDB(true);
                    }
                    catch (Exception exp) {
                        txHandle.markRollback();
                        throw exp;
                    }
                }
            }
            return mbApplyRes;
        }
        catch (Exception exp) {
            KDBizException kdExp;
            ErrorCode errorCode;
            log.warn("batchNum={} frozen error: ", (Object)batchNum, (Object)exp);
            log.warn("batchNum={} frozen bill fail. expect frozen mainBill={}", (Object)batchNum, (Object)mainBill);
            String code = "UN_KNOW";
            if (exp instanceof KDBizException && (errorCode = (kdExp = (KDBizException)((Object)exp)).getErrorCode()) != null && WTCStringUtils.isNotEmpty((String)errorCode.getCode())) {
                code = errorCode.getCode();
            }
            return QTDeductService.genErrorMBApplyResFromUnKnow(mainBill, code, emptyStr);
        }
    }

    public static MBApplyRes unfrozen(String batchNum, BillApply mainBill) {
        try {
            QTBillDeal billDeal = QTDealRecordDBService.loadBDByBillId(mainBill.getId(), true);
            if (billDeal == null) {
                return QTDeductService.genSuccessMbApplyRes(mainBill);
            }
            if (!billDeal.getDealState().equals(DealStatus.FROZEN.code)) {
                throw new KDBizException("can't refund illegal status bill[id=" + billDeal.getBillId() + "], expect state: frozen, actual state: " + billDeal.getDealState());
            }
            QTRuntime runtime = new QTRuntime(mainBill.getAttFileBoId(), mainBill.getApplyTime(), batchNum);
            QTDeductAnchor.beforeUnFrozen(runtime);
            QTDeductService.refundVariousFrozen(billDeal, runtime);
            if (billDeal.getSrcPID() != 0L) {
                QTDeductService.unlock(billDeal.getSrcPID(), runtime);
            }
            try (TXHandle txHandle = TX.required();){
                try {
                    runtime.flushDB(true);
                }
                catch (Exception exp) {
                    txHandle.markRollback();
                    throw exp;
                }
            }
            return QTDeductService.genSuccessMbApplyRes(mainBill);
        }
        catch (Exception exp) {
            log.warn("batchNum={} unfrozen error: ", (Object)batchNum, (Object)exp);
            log.warn("batchNum={} unfrozen bill fail. expect unfrozen mainBill={}", (Object)batchNum, (Object)mainBill);
            return QTDeductService.genErrorMBApplyResFromUnKnow(mainBill, "UN_KNOW", emptyStr);
        }
    }

    public static MBApplyRes deduct(String batchNum, BillApply mainBill) {
        try {
            QTRuntime runtime = new QTRuntime(mainBill.getAttFileBoId(), mainBill.getApplyTime(), batchNum);
            runtime.setDeductRuleMap(QTDeductService.initDeductRule(mainBill));
            runtime.setExtraSlotMap(Collections.emptyMap());
            runtime.plusPool(QTDeductService.initPool(mainBill, runtime.getDeductRuleMap()));
            MBApplyRes mbApplyRes = QTDeductService.deductWithQTRuntime(mainBill, runtime);
            if (mbApplyRes.isAllSuccess()) {
                try (TXHandle txHandle = TX.required();){
                    try {
                        runtime.flushUsedPackage(Collections.singletonList(mainBill));
                        runtime.flushDB(true);
                    }
                    catch (Exception exp) {
                        txHandle.markRollback();
                        throw exp;
                    }
                }
            }
            return mbApplyRes;
        }
        catch (Exception exp) {
            log.warn("batchNum={} deduct error:", (Object)batchNum, (Object)exp);
            log.warn("batchNum={} deduct bill fail. expect deduct mainBill={}", (Object)batchNum, (Object)mainBill);
            return QTDeductService.genErrorMBApplyResFromUnKnow(mainBill, "UN_KNOW", emptyStr);
        }
    }

    public static MBApplyRes batchRefundAndDeductWithQTRuntime(QTRuntime runtime, List<BillApply> useBillList) {
        int i;
        Map clueMap = WTCCollections.modifiableEmptyMap();
        for (i = useBillList.size() - 1; i >= 0; --i) {
            BillApply mainBill = useBillList.get(i);
            QTBillDeal srcBillDeal = runtime.loadBDByBillId(mainBill.getId(), true);
            if (srcBillDeal == null) {
                if (mainBill.getParentId() != 0L) {
                    QTDeductService.releaseBeforeApplyUsed(mainBill, runtime);
                }
                clueMap.put(i, new OPInfo(0L, DealOperate.deduct));
                continue;
            }
            DealStatus srcDealStatus = DealStatus.get(srcBillDeal.getDealState());
            if (srcDealStatus == DealStatus.USED) {
                long srcId = QTDeductService.refundBeforeAmend(mainBill, srcBillDeal, runtime);
                clueMap.put(i, new OPInfo(srcId, DealOperate.amend));
                continue;
            }
            if (srcDealStatus == DealStatus.FROZEN) {
                long srcID = QTDeductService.releaseBeforeFrozen2Used(srcBillDeal, runtime);
                clueMap.put(i, new OPInfo(srcID, DealOperate.deduct));
                continue;
            }
            throw new KDBizException("can't deduct illegal status bill[id=" + mainBill.getId() + "], expect state: frozen/used, actual state:" + srcDealStatus.name());
        }
        for (i = 0; i < useBillList.size(); ++i) {
            BillApply billApply = useBillList.get(i);
            OPInfo opInfo = (OPInfo)clueMap.get(i);
            MBApplyRes mbApplyRes = QTDeductService.newDeduct(opInfo.srcBDId, runtime, opInfo.expectOp, billApply.getApplyTime(), billApply);
            if (mbApplyRes.isAllSuccess()) continue;
            return mbApplyRes;
        }
        return null;
    }

    private static MBApplyRes deductWithQTRuntime(BillApply mainBill, QTRuntime runtime) {
        MBApplyRes mbApplyRes;
        QTBillDeal srcBillDeal = runtime.loadBDByBillId(mainBill.getId(), true);
        if (srcBillDeal == null) {
            if (mainBill.getParentId() != 0L) {
                QTDeductService.releaseBeforeApplyUsed(mainBill, runtime);
            }
            mbApplyRes = QTDeductService.newDeduct(0L, runtime, DealOperate.deduct, mainBill.getApplyTime(), mainBill);
        } else {
            DealStatus srcDealStatus = DealStatus.get(srcBillDeal.getDealState());
            if (srcDealStatus == DealStatus.USED) {
                long srcId = QTDeductService.refundBeforeAmend(mainBill, srcBillDeal, runtime);
                mbApplyRes = QTDeductService.newDeduct(srcId, runtime, DealOperate.amend, srcBillDeal.getApplyTime(), mainBill);
            } else if (srcDealStatus == DealStatus.FROZEN) {
                long srcID = QTDeductService.releaseBeforeFrozen2Used(srcBillDeal, runtime);
                mbApplyRes = QTDeductService.newDeduct(srcID, runtime, DealOperate.deduct, srcBillDeal.getApplyTime(), mainBill);
            } else {
                throw new KDBizException("can't deduct illegal status bill[id=" + mainBill.getId() + "], expect state: frozen/used, actual state:" + srcDealStatus.name());
            }
        }
        return mbApplyRes;
    }

    public static MBApplyRes refund(String batchNum, BillApply mainBill) {
        try {
            QTBillDeal billDeal = QTDealRecordDBService.loadBDByBillId(mainBill.getId(), true);
            if (billDeal == null) {
                return QTDeductService.genSuccessMbApplyRes(mainBill);
            }
            if (!billDeal.getDealState().equals(DealStatus.USED.code)) {
                throw new KDBizException("can't refund illegal status bill[id=" + mainBill.getParentId() + "], expect state: used, actual state: " + billDeal.getDealState());
            }
            QTRuntime runtime = new QTRuntime(mainBill.getAttFileBoId(), mainBill.getApplyTime(), batchNum);
            QTDeductService.refundVariousUsed(billDeal, runtime);
            try (TXHandle txHandle = TX.required();){
                try {
                    runtime.flushUsedPackage(WTCCollections.modifiableList((Object[])new BillApply[]{mainBill}));
                    runtime.flushDB(true);
                }
                catch (Exception exp) {
                    txHandle.markRollback();
                    throw exp;
                }
            }
            return QTDeductService.genSuccessMbApplyRes(mainBill);
        }
        catch (Exception exp) {
            log.warn("batchNum={} refund error:", (Object)batchNum, (Object)exp);
            log.warn("batchNum={} refund bill fail. expect refund mainBill={}", (Object)batchNum, (Object)mainBill);
            return QTDeductService.genErrorMBApplyResFromUnKnow(mainBill, "UN_KNOW", emptyStr);
        }
    }

    private static void unlock(long billDealPK, QTRuntime runtime) {
        QTBillDeal billDeal;
        if (billDealPK != 0L && (billDeal = QTDealRecordDBService.loadBDByPK(billDealPK, true)) != null) {
            if (!DealStatus.isLock(billDeal.getDealState())) {
                throw new KDBizException("can't unlock the unlocked bill, billDealPK=" + billDealPK);
            }
            long oldBillDealID = billDeal.getId();
            long newBillDealID = DB.genGlobalLongId();
            billDeal.setId(newBillDealID);
            billDeal.setSrcID(oldBillDealID);
            billDeal.setBatchNum(runtime.getBatchNum());
            billDeal.setDealOperate(DealOperate.unlock.name());
            billDeal.setDealState(DealStatus.get((String)billDeal.getDealState()).unLock().code);
            List<QTBillEntryDeal> bedList = billDeal.getEntryDealList();
            for (QTBillEntryDeal bed : bedList) {
                bed.setId(0L);
                bed.setPid(newBillDealID);
                for (QTBillEntryDealDetail bedDetail : bed.getDetailList()) {
                    bedDetail.setPk(0L);
                }
            }
            runtime.addWaitDelBillDealPk(oldBillDealID);
            runtime.addWaitStoreBillDeal(billDeal);
        }
    }

    private static QTBillDeal lock(long billId, QTRuntime runtime, boolean strongVerify) {
        if (billId != 0L) {
            QTBillDeal billDeal;
            QTBillDeal cacheBillDeal = runtime.getWaitStoreBillDealByBillId(billId);
            QTBillDeal qTBillDeal = billDeal = cacheBillDeal != null ? cacheBillDeal : runtime.loadBDByBillId(billId, true);
            if (billDeal != null) {
                if (strongVerify && DealStatus.isLock(billDeal.getDealState())) {
                    DynamicObject holdLockBillDeal = QTDealRecordDBService.bdDao.queryOne("srcpid,billnumber", new QFilter("srcpid", "=", (Object)billDeal.getId()).toArray());
                    String errMsg = String.format("can't lock the locked bill[billId=%s], target bill's lock owned by bill[billNo=%s]", billId, holdLockBillDeal.getString("billnumber"));
                    throw new KDBizException(new ErrorCode("LOCK_FAIL", errMsg), new Object[0]);
                }
                long oldBillDealID = billDeal.getId();
                long newBillDealID = DB.genGlobalLongId();
                billDeal.setId(newBillDealID);
                billDeal.setSrcID(oldBillDealID);
                billDeal.setBatchNum(runtime.getBatchNum());
                billDeal.setDealOperate(DealOperate.lock.name());
                billDeal.setDealState(DealStatus.get((String)billDeal.getDealState()).toLock().code);
                List<QTBillEntryDeal> bedList = billDeal.getEntryDealList();
                for (QTBillEntryDeal bed : bedList) {
                    bed.setId(0L);
                    bed.setPid(newBillDealID);
                    for (QTBillEntryDealDetail bedDetail : bed.getDetailList()) {
                        bedDetail.setPk(0L);
                    }
                }
                runtime.addWaitDelBillDealPk(oldBillDealID);
                runtime.addWaitStoreBillDeal(billDeal);
                return billDeal;
            }
        }
        return null;
    }

    private static void releaseBeforeApplyUsed(BillApply mainBill, QTRuntime runtime) {
        QTBillDeal parentBillDeal;
        if (mainBill.getParentId() != 0L && (parentBillDeal = runtime.loadBDByBillId(mainBill.getParentId(), true)) != null) {
            long srcPID = parentBillDeal.getSrcPID();
            long parentBillId = mainBill.getParentId();
            DealStatus parentDealStatus = DealStatus.get(parentBillDeal.getDealState());
            if (parentDealStatus == DealStatus.FROZEN) {
                QTDeductService.refundVariousFrozen(parentBillDeal, runtime);
            } else if (parentDealStatus == DealStatus.USED) {
                QTDeductService.refundVariousUsed(parentBillDeal, runtime);
            } else {
                throw new KDBizException("can't refund illegal status bill[id=" + parentBillDeal.getBillId() + "], expect state: frozen/used, actual state: " + parentDealStatus.name());
            }
            if (srcPID != 0L) {
                QTDeductService.releaseLockedChain(srcPID, parentBillId, runtime);
            }
        }
    }

    private static long releaseBeforeFrozen2Used(QTBillDeal srcBillDeal, QTRuntime runtime) {
        long srcID = srcBillDeal.getId();
        long srcPID = srcBillDeal.getSrcPID();
        long parentBillId = srcBillDeal.getParentBillId();
        QTDeductService.refundVariousFrozen(srcBillDeal, runtime);
        if (srcPID != 0L) {
            QTDeductService.releaseLockedChain(srcPID, parentBillId, runtime);
        }
        return srcID;
    }

    private static void releaseLockedChain(long srcPID, long parentBillId, QTRuntime runtime) {
        QTBillDeal parentBillDeal;
        while (!(srcPID == 0L && parentBillId == 0L || (parentBillDeal = runtime.loadBDByPK(srcPID, true)) == null && (parentBillDeal = runtime.loadBDByBillId(parentBillId, true)) == null)) {
            srcPID = parentBillDeal.getSrcPID();
            parentBillId = parentBillDeal.getParentBillId();
            DealStatus parentDealStatus = DealStatus.get(parentBillDeal.getDealState());
            if (parentDealStatus == DealStatus.FROZEN_LOCK || parentDealStatus == DealStatus.FROZEN) {
                QTDeductService.refundVariousFrozen(parentBillDeal, runtime);
                continue;
            }
            if (parentDealStatus == DealStatus.USED_LOCK || parentDealStatus == DealStatus.USED) {
                QTDeductService.refundVariousUsed(parentBillDeal, runtime);
                continue;
            }
            throw new KDBizException("can't release illegal status BillDealRecord[id=" + srcPID + "], expect state: locked, actual state: " + parentDealStatus.name());
        }
    }

    private static long refundBeforeAmend(BillApply mainBill, QTBillDeal billDeal, QTRuntime runtime) {
        if (billDeal.getBillId() != mainBill.getId()) {
            throw new KDBizException("can't amend: illegal bill relation. expect amend bill[id=" + mainBill.getId() + "], actual in parameter billDeal[billId=" + billDeal.getBillId() + "]");
        }
        if (billDeal.getParentBillId() != mainBill.getParentId()) {
            throw new KDBizException("can't amend: illegal bill parentId. expect amend bill[id=" + mainBill.getId() + ",parentId=" + mainBill.getParentId() + "], actual in parameter billDeal[billId=" + billDeal.getBillId() + ",parentBillId=" + billDeal.getParentBillId() + "]");
        }
        if (!billDeal.getDealState().equals(DealStatus.USED.code)) {
            throw new KDBizException("can't amend: illegal status bill[id=" + billDeal.getBillId() + "]. expect state: used, actual state: " + billDeal.getDealState());
        }
        long srcId = billDeal.getId();
        QTDeductService.refundVariousUsed(billDeal, runtime);
        return srcId;
    }

    public static void refundVariousFrozen(QTBillDeal billDeal, QTRuntime runtime) {
        DealStatus dealStatus = DealStatus.get(billDeal.getDealState());
        if (dealStatus != DealStatus.FROZEN && dealStatus != DealStatus.FROZEN_LOCK) {
            throw new KDBizException("can't refund illegal status bill[id=" + billDeal.getBillId() + "], expect state: frozen/frozen_lock, actual state: " + billDeal.getDealState());
        }
        if (billDeal.getEntryDealList().isEmpty()) {
            runtime.addWaitDelBillDealPk(billDeal.getId());
            return;
        }
        Set<Long> detailIdSet = billDeal.getEntryDealList().stream().flatMap(bed -> bed.getDetailList().stream()).map(QTBillEntryDealDetail::getQtSummaryDetailId).collect(Collectors.toSet());
        runtime.plusPoolByDetailID(detailIdSet);
        for (QTBillEntryDeal bed2 : billDeal.getEntryDealList()) {
            for (QTBillEntryDealDetail bedDetail : bed2.getDetailList()) {
                BigDecimal actualBackValue;
                if (CheckUtils.isZero(bedDetail.getApplyValue()) || !DeductSource.fromPool(bedDetail.getDeductSource())) continue;
                QTLineDetail qtDetail = runtime.getDetail(bedDetail.getQtSummaryDetailId());
                if (qtDetail == null) {
                    log.warn("refundVariousFrozen fail[batchNum={}]: can't find Quota-Summary-Detail by detailId={}, billEntryDeal={}", new Object[]{runtime.getBatchNum(), bedDetail.getQtSummaryDetailId(), bed2});
                    continue;
                }
                if (CheckUtils.isLarge(bedDetail.getApplyValue(), qtDetail.getFreezeValue())) {
                    String errMsg = ResManager.loadKDString((String)"\u5b9a\u989d\u660e\u7ec6[ID={0}]\u65e0\u8db3\u591f\u51bb\u7ed3\u65f6\u957f\uff1b\u9000\u8fd8\u65f6\u957f{1}\uff0c\u660e\u7ec6\u5269\u4f59\u51bb\u7ed3\u65f6\u957f{2}\u3002", (String)"QTDeductService_01", (String)"wtc-wtp-business", (Object[])new Object[]{bedDetail.getQtSummaryDetailId(), bedDetail.getApplyValue(), qtDetail.getFreezeValue()});
                    throw new KDBizException(errMsg);
                }
                QTDeductService.detectCarryDownedDetailAndRecoverIt(qtDetail);
                if (QTDeductService.checkDetailImbalance(qtDetail) && QTDeductService.reBalanceDetail(qtDetail)) {
                    log.warn("refundVariousFrozen fail[batchNum={}]: before doRefund detected QTDetail imbalance. detail={}, billDeal={}", new Object[]{runtime.getBatchNum(), qtDetail, billDeal});
                    throw new IllegalStateException("QTDetail imbalance.");
                }
                BigDecimal expectBackValue = bedDetail.getApplyValue();
                if (CheckUtils.isNonZero(expectBackValue) && CheckUtils.isNegative(qtDetail.getUsableValue())) {
                    BigDecimal needFillValue = BigDecimal.ZERO.subtract(qtDetail.getUsableValue());
                    BigDecimal actualBackValue2 = QTDeductService.min(needFillValue, expectBackValue);
                    qtDetail.setUsableValue(qtDetail.getUsableValue().add(actualBackValue2));
                    qtDetail.setFreezeValue(qtDetail.getFreezeValue().subtract(actualBackValue2));
                    BigDecimal frozenOdAdjustValue = QTDeductService.min(actualBackValue2, qtDetail.getFrozenOdValue());
                    qtDetail.setFrozenOdValue(qtDetail.getFrozenOdValue().subtract(frozenOdAdjustValue));
                    BigDecimal remainFrozenOdAdjustValue = frozenOdAdjustValue;
                    BigDecimal useOdMaxAdjustValue = qtDetail.getUsedValue().subtract(qtDetail.getUseOdValue());
                    BigDecimal useOdAdjustValue = QTDeductService.min(useOdMaxAdjustValue, remainFrozenOdAdjustValue);
                    qtDetail.setUseOdValue(qtDetail.getUseOdValue().add(useOdAdjustValue));
                    remainFrozenOdAdjustValue = remainFrozenOdAdjustValue.subtract(useOdAdjustValue);
                    BigDecimal invalidOdMaxAdjustValue = qtDetail.getInvalidValue().subtract(qtDetail.getInvalidOdValue());
                    BigDecimal invalidOdAdjustValue = QTDeductService.min(invalidOdMaxAdjustValue, remainFrozenOdAdjustValue);
                    qtDetail.setInvalidOdValue(qtDetail.getInvalidOdValue().add(invalidOdAdjustValue));
                    remainFrozenOdAdjustValue = remainFrozenOdAdjustValue.subtract(invalidOdAdjustValue);
                    if (CheckUtils.isNonZero(remainFrozenOdAdjustValue)) {
                        log.warn("refundVariousFrozen fail[batchNum={}]: algorithmic error. needFillValue={}, frozenOdAdjustValue={}, useOdMaxAdjustValue={}, invalidOdMaxAdjustValue={}, remainFrozenOdAdjustValue={}", new Object[]{runtime.getBatchNum(), needFillValue, frozenOdAdjustValue, useOdMaxAdjustValue, invalidOdMaxAdjustValue, remainFrozenOdAdjustValue});
                        log.warn("refundVariousFrozen fail[batchNum={}]: qtDetail={}, billDeal={}", new Object[]{runtime.getBatchNum(), qtDetail, billDeal});
                        throw new IllegalStateException("refundVariousFrozen fail[batchNum=" + runtime.getBatchNum() + "]: algorithmic error.");
                    }
                    expectBackValue = expectBackValue.subtract(actualBackValue2);
                }
                if (CheckUtils.isNonZero(expectBackValue) && CheckUtils.isPositive(qtDetail.getFrozenOdValue())) {
                    actualBackValue = QTDeductService.min(qtDetail.getFrozenOdValue(), expectBackValue);
                    qtDetail.setCanBeOdValue(qtDetail.getCanBeOdValue().add(actualBackValue));
                    qtDetail.setFrozenOdValue(qtDetail.getFrozenOdValue().subtract(actualBackValue));
                    qtDetail.setFreezeValue(qtDetail.getFreezeValue().subtract(actualBackValue));
                    expectBackValue = expectBackValue.subtract(actualBackValue);
                }
                if (CheckUtils.isNonZero(expectBackValue) && CheckUtils.isPositive(qtDetail.getUseOdValue())) {
                    actualBackValue = QTDeductService.min(qtDetail.getUseOdValue(), expectBackValue);
                    qtDetail.setCanBeOdValue(qtDetail.getCanBeOdValue().add(actualBackValue));
                    qtDetail.setUseOdValue(qtDetail.getUseOdValue().subtract(actualBackValue));
                    qtDetail.setFreezeValue(qtDetail.getFreezeValue().subtract(actualBackValue));
                    expectBackValue = expectBackValue.subtract(actualBackValue);
                }
                if (CheckUtils.isNonZero(expectBackValue) && CheckUtils.isPositive(qtDetail.getInvalidOdValue())) {
                    actualBackValue = QTDeductService.min(qtDetail.getInvalidOdValue(), expectBackValue);
                    qtDetail.setCanBeOdValue(qtDetail.getCanBeOdValue().add(actualBackValue));
                    qtDetail.setInvalidOdValue(qtDetail.getInvalidOdValue().subtract(actualBackValue));
                    qtDetail.setFreezeValue(qtDetail.getFreezeValue().subtract(actualBackValue));
                    expectBackValue = expectBackValue.subtract(actualBackValue);
                }
                if (CheckUtils.isNonZero(expectBackValue)) {
                    qtDetail.setUsableValue(qtDetail.getUsableValue().add(expectBackValue));
                    qtDetail.setFreezeValue(qtDetail.getFreezeValue().subtract(expectBackValue));
                }
                if (!QTDeductService.checkDetailImbalance(qtDetail) || !QTDeductService.reBalanceDetail(qtDetail)) continue;
                log.warn("refundVariousFrozen fail[batchNum={}]: QTDetail imbalance. detail={}, billDeal={}", new Object[]{runtime.getBatchNum(), qtDetail, billDeal});
                throw new IllegalStateException("QTDetail imbalance.");
            }
        }
        runtime.addWaitDelBillDealPk(billDeal.getId());
    }

    public static void refundVariousUsed(QTBillDeal billDeal, QTRuntime runtime) {
        Date now = new Date();
        DealStatus dealStatus = DealStatus.get(billDeal.getDealState());
        if (dealStatus != DealStatus.USED && dealStatus != DealStatus.USED_LOCK) {
            throw new KDBizException("can't refund illegal status bill[id=" + billDeal.getBillId() + "], expect state: used/used_lock, actual state: " + billDeal.getDealState());
        }
        if (billDeal.getEntryDealList().isEmpty()) {
            runtime.addWaitDelBillDealPk(billDeal.getId());
            return;
        }
        Set<Long> detailIdSet = billDeal.getEntryDealList().stream().flatMap(bed -> bed.getDetailList().stream()).map(QTBillEntryDealDetail::getQtSummaryDetailId).collect(Collectors.toSet());
        runtime.plusPoolByDetailID(detailIdSet);
        for (QTBillEntryDeal bed2 : billDeal.getEntryDealList()) {
            for (QTBillEntryDealDetail bedDetail : bed2.getDetailList()) {
                BigDecimal compareVal;
                String deductSource = bedDetail.getDeductSource();
                if (CheckUtils.isZero(bedDetail.getApplyValue()) || !DeductSource.fromPool(bedDetail.getDeductSource())) continue;
                QTLineDetail qtDetail = runtime.getDetail(bedDetail.getQtSummaryDetailId());
                if (qtDetail == null) {
                    log.warn("refundVariousUsed fail[batchNum={}]: can't find Quota-Summary-Detail by detailId={}, billEntryDeal={}", new Object[]{runtime.getBatchNum(), bedDetail.getQtSummaryDetailId(), bed2});
                    continue;
                }
                boolean refundFromInvalidValue = deductSource.equals(DeductSource.pool_ivd.name());
                BigDecimal bigDecimal = compareVal = refundFromInvalidValue ? qtDetail.getInvalidValue() : qtDetail.getUsedValue();
                if (CheckUtils.isLarge(bedDetail.getApplyValue(), compareVal)) {
                    String errMsg = ResManager.loadKDString((String)"\u5b9a\u989d\u660e\u7ec6[ID={0}]\u65e0\u8db3\u591f\u6263\u51cf\u65f6\u957f\u3002\u6b32\u9000\u8fd8\u65f6\u957f{1}\uff0c\u660e\u7ec6\u5269\u4f59\u5df2\u7528/\u5df2\u5931\u6548\u65f6\u957f{2}\u3002\u662f\u5426\u4ece\u5df2\u5931\u6548\u9000\u8fd8:{3}\u3002", (String)"QTDeductService_02", (String)"wtc-wtp-business", (Object[])new Object[]{bedDetail.getQtSummaryDetailId(), bed2.getApplyValue(), compareVal, refundFromInvalidValue});
                    throw new KDBizException(errMsg);
                }
                QTDeductService.detectCarryDownedDetailAndRecoverIt(qtDetail);
                if (QTDeductService.checkDetailImbalance(qtDetail) && QTDeductService.reBalanceDetail(qtDetail)) {
                    log.warn("refundVariousUsed fail[batchNum={}]: before doRefund detected QTDetail imbalance. detail={}, billDeal={}", new Object[]{runtime.getBatchNum(), qtDetail, billDeal});
                    throw new IllegalStateException("QTDetail imbalance.");
                }
                if (QTDeductService.shouldBeCarryDowned(qtDetail, now)) {
                    QTDeductAnchor.beforeRefundCarryDownedQTLine(runtime, qtDetail);
                }
                BigDecimal expectBackValue = bedDetail.getApplyValue();
                if (refundFromInvalidValue) {
                    QTDeductService.doRefundFromInvalid(qtDetail, expectBackValue);
                } else {
                    QTDeductService.doRefundFromUsed(qtDetail, expectBackValue);
                }
                if (!QTDeductService.checkDetailImbalance(qtDetail) || !QTDeductService.reBalanceDetail(qtDetail)) continue;
                log.warn("refundVariousUsed fail[batchNum={}]: QTDetail imbalance. bedDetailSeq={}, detail={}, billDeal={}", new Object[]{runtime.getBatchNum(), bedDetail.getSeq(), qtDetail, billDeal});
                throw new IllegalStateException("QTDetail imbalance.");
            }
        }
        runtime.addWaitDelBillDealPk(billDeal.getId());
    }

    private static boolean checkDetailImbalance(QTLineDetail qtDetail) {
        BigDecimal freezeValue = qtDetail.getFreezeValue();
        BigDecimal usedValue = qtDetail.getUsedValue();
        BigDecimal balance = qtDetail.getBalance();
        BigDecimal invalidValue = qtDetail.getInvalidValue();
        BigDecimal totalCost = freezeValue.add(usedValue).add(balance).add(invalidValue);
        BigDecimal frozenOdValue = qtDetail.getFrozenOdValue();
        BigDecimal useOdValue = qtDetail.getUseOdValue();
        BigDecimal invalidOdValue = qtDetail.getInvalidOdValue();
        BigDecimal odCost = useOdValue.add(frozenOdValue).add(invalidOdValue);
        BigDecimal ownValue = qtDetail.getOwnValue();
        BigDecimal usableValue = qtDetail.getUsableValue();
        BigDecimal fromUsable = ownValue.subtract(usableValue);
        BigDecimal ownOdValue = qtDetail.getOwnOdValue();
        BigDecimal canBeOdValue = qtDetail.getCanBeOdValue();
        BigDecimal fromOd = ownOdValue.subtract(canBeOdValue);
        if (CheckUtils.isLarge(usableValue, ownValue)) {
            log.warn("checkDetailBalance fail: usableValue={} large than ownValue={}", (Object)usableValue, (Object)ownValue);
            return true;
        }
        if (CheckUtils.isLarge(canBeOdValue, ownOdValue)) {
            log.warn("checkDetailBalance fail: canBeOdValue={} large than ownOdValue={}", (Object)canBeOdValue, (Object)ownOdValue);
            return true;
        }
        if (CheckUtils.isNegative(canBeOdValue)) {
            log.warn("checkDetailBalance fail: canBeOdValue={} is negative", (Object)canBeOdValue);
            return true;
        }
        if (CheckUtils.isNotEqual(totalCost, fromUsable.add(fromOd))) {
            log.warn("checkDetailBalance fail: totalCost={} not equals totalApply[fromUsable={}, fromOd={}]", new Object[]{totalCost, fromUsable, fromOd});
            return true;
        }
        if (CheckUtils.isNotEqual(odCost, fromOd)) {
            log.warn("checkDetailBalance fail: odCost={} not equals fromOd={}", (Object)odCost, (Object)fromOd);
            return true;
        }
        if (CheckUtils.isLarge(frozenOdValue, freezeValue) || CheckUtils.isLarge(useOdValue, usedValue) || CheckUtils.isLarge(invalidOdValue, invalidValue)) {
            log.warn("checkDetailBalance fail: frozenOdValue={}, fromOd={}, useOdValue={}, usedValue={}, invalidOdValue={}, invalidValue={}", new Object[]{frozenOdValue, fromOd, useOdValue, usedValue, invalidOdValue, invalidValue});
            return true;
        }
        if (CheckUtils.isNegative(qtDetail.getUsableValue()) && CheckUtils.isNonZero(qtDetail.getCanBeOdValue())) {
            log.warn("checkDetailBalance fail: usableValue={} is negative, but occur canBeOdValue={}.", (Object)qtDetail.getUsableValue(), (Object)qtDetail.getCanBeOdValue());
            return true;
        }
        if (CheckUtils.isPositive(fromOd) && CheckUtils.isPositive(qtDetail.getUsableValue())) {
            log.warn("checkDetailBalance fail: fromOd={} is positive, but usableValue={} is positive.", (Object)fromOd, (Object)qtDetail.getUsableValue());
            return true;
        }
        return false;
    }

    private static void doRefundFromInvalid(QTLineDetail qtDetail, BigDecimal expectBackValue) {
        BigDecimal actualBackValue;
        if (CheckUtils.isNonZero(expectBackValue) && CheckUtils.isNegative(qtDetail.getUsableValue())) {
            BigDecimal needFillValue = BigDecimal.ZERO.subtract(qtDetail.getUsableValue());
            BigDecimal actualBackValue2 = QTDeductService.min(needFillValue, expectBackValue);
            qtDetail.setUsableValue(qtDetail.getUsableValue().add(actualBackValue2));
            qtDetail.setInvalidValue(qtDetail.getInvalidValue().subtract(actualBackValue2));
            expectBackValue = expectBackValue.subtract(actualBackValue2);
        }
        if (CheckUtils.isNonZero(expectBackValue) && CheckUtils.isPositive(qtDetail.getInvalidOdValue())) {
            actualBackValue = QTDeductService.min(qtDetail.getInvalidOdValue(), expectBackValue);
            qtDetail.setInvalidOdValue(qtDetail.getInvalidOdValue().subtract(actualBackValue));
            qtDetail.setCanBeOdValue(qtDetail.getCanBeOdValue().add(actualBackValue));
            qtDetail.setInvalidValue(qtDetail.getInvalidValue().subtract(actualBackValue));
            expectBackValue = expectBackValue.subtract(actualBackValue);
        }
        if (CheckUtils.isNonZero(expectBackValue) && CheckUtils.isPositive(qtDetail.getUseOdValue())) {
            actualBackValue = QTDeductService.min(qtDetail.getUseOdValue(), expectBackValue);
            qtDetail.setUseOdValue(qtDetail.getUseOdValue().subtract(actualBackValue));
            qtDetail.setCanBeOdValue(qtDetail.getCanBeOdValue().add(actualBackValue));
            qtDetail.setInvalidValue(qtDetail.getInvalidValue().subtract(actualBackValue));
            expectBackValue = expectBackValue.subtract(actualBackValue);
        }
        if (CheckUtils.isNonZero(expectBackValue) && CheckUtils.isPositive(qtDetail.getFrozenOdValue())) {
            actualBackValue = QTDeductService.min(qtDetail.getFrozenOdValue(), expectBackValue);
            qtDetail.setCanBeOdValue(qtDetail.getCanBeOdValue().add(actualBackValue));
            qtDetail.setFrozenOdValue(qtDetail.getFrozenOdValue().subtract(actualBackValue));
            qtDetail.setInvalidValue(qtDetail.getInvalidValue().subtract(actualBackValue));
            expectBackValue = expectBackValue.subtract(actualBackValue);
        }
        if (CheckUtils.isNonZero(expectBackValue)) {
            qtDetail.setUsableValue(qtDetail.getUsableValue().add(expectBackValue));
            qtDetail.setInvalidValue(qtDetail.getInvalidValue().subtract(expectBackValue));
        }
    }

    private static void doRefundFromUsed(QTLineDetail qtDetail, BigDecimal expectBackValue) {
        BigDecimal actualBackValue;
        if (CheckUtils.isNonZero(expectBackValue) && CheckUtils.isNegative(qtDetail.getUsableValue())) {
            BigDecimal needFillValue = BigDecimal.ZERO.subtract(qtDetail.getUsableValue());
            BigDecimal actualBackValue2 = QTDeductService.min(needFillValue, expectBackValue);
            qtDetail.setUsableValue(qtDetail.getUsableValue().add(actualBackValue2));
            qtDetail.setUsedValue(qtDetail.getUsedValue().subtract(actualBackValue2));
            expectBackValue = expectBackValue.subtract(actualBackValue2);
        }
        if (CheckUtils.isNonZero(expectBackValue) && CheckUtils.isPositive(qtDetail.getUseOdValue())) {
            actualBackValue = QTDeductService.min(qtDetail.getUseOdValue(), expectBackValue);
            qtDetail.setUseOdValue(qtDetail.getUseOdValue().subtract(actualBackValue));
            qtDetail.setCanBeOdValue(qtDetail.getCanBeOdValue().add(actualBackValue));
            qtDetail.setUsedValue(qtDetail.getUsedValue().subtract(actualBackValue));
            expectBackValue = expectBackValue.subtract(actualBackValue);
        }
        if (CheckUtils.isNonZero(expectBackValue) && CheckUtils.isPositive(qtDetail.getFrozenOdValue())) {
            actualBackValue = QTDeductService.min(qtDetail.getFrozenOdValue(), expectBackValue);
            qtDetail.setCanBeOdValue(qtDetail.getCanBeOdValue().add(actualBackValue));
            qtDetail.setFrozenOdValue(qtDetail.getFrozenOdValue().subtract(actualBackValue));
            qtDetail.setUsedValue(qtDetail.getUsedValue().subtract(actualBackValue));
            expectBackValue = expectBackValue.subtract(actualBackValue);
        }
        if (CheckUtils.isNonZero(expectBackValue) && CheckUtils.isPositive(qtDetail.getInvalidOdValue())) {
            actualBackValue = QTDeductService.min(qtDetail.getInvalidOdValue(), expectBackValue);
            qtDetail.setCanBeOdValue(qtDetail.getCanBeOdValue().add(actualBackValue));
            qtDetail.setInvalidOdValue(qtDetail.getInvalidOdValue().subtract(actualBackValue));
            qtDetail.setUsedValue(qtDetail.getUsedValue().subtract(actualBackValue));
            expectBackValue = expectBackValue.subtract(actualBackValue);
        }
        if (CheckUtils.isNonZero(expectBackValue)) {
            qtDetail.setUsableValue(qtDetail.getUsableValue().add(expectBackValue));
            qtDetail.setUsedValue(qtDetail.getUsedValue().subtract(expectBackValue));
        }
    }

    private static boolean shouldBeCarryDowned(QTLineDetail qtDetail, Date baseTime) {
        return qtDetail.getUseEndDateDayLast().before(baseTime);
    }

    public static boolean reBalanceDetail(QTLineDetail detail) {
        BigDecimal freezeValue = detail.getFreezeValue();
        BigDecimal usedValue = detail.getUsedValue();
        BigDecimal balance = detail.getBalance();
        BigDecimal invalidValue = detail.getInvalidValue();
        BigDecimal totalCost = freezeValue.add(usedValue).add(balance).add(invalidValue);
        BigDecimal maxFrozenOdValue = QTDeductService.min(freezeValue, detail.getOwnOdValue());
        BigDecimal maxUseOdValue = QTDeductService.min(usedValue, detail.getOwnOdValue());
        BigDecimal maxInvalidOdValue = QTDeductService.min(invalidValue, detail.getOwnOdValue());
        detail.setPastValue(BigDecimal.ZERO);
        detail.setCarryDownedValue(BigDecimal.ZERO);
        detail.setSettlementValue(BigDecimal.ZERO);
        if (CheckUtils.isLessEqual(totalCost, detail.getOwnValue())) {
            detail.setUsableValue(detail.getOwnValue().subtract(totalCost));
            detail.setCanBeOdValue(detail.getOwnOdValue());
            detail.setFrozenOdValue(BigDecimal.ZERO);
            detail.setUseOdValue(BigDecimal.ZERO);
            detail.setInvalidOdValue(BigDecimal.ZERO);
        } else if (CheckUtils.isLarge(totalCost, detail.getOwnValue()) && CheckUtils.isLessEqual(totalCost, detail.getOwnValue().add(detail.getOwnOdValue()))) {
            detail.setUsableValue(BigDecimal.ZERO);
            detail.setCanBeOdValue(detail.getOwnOdValue().subtract(totalCost).add(detail.getOwnValue()));
            BigDecimal needFillOdValue = totalCost.subtract(detail.getOwnValue());
            BigDecimal resetFrozenOdValue = QTDeductService.min(maxFrozenOdValue, needFillOdValue);
            detail.setFrozenOdValue(resetFrozenOdValue);
            needFillOdValue = needFillOdValue.subtract(resetFrozenOdValue);
            BigDecimal resetUseOdValue = QTDeductService.min(maxUseOdValue, needFillOdValue);
            detail.setUseOdValue(resetUseOdValue);
            needFillOdValue = needFillOdValue.subtract(resetUseOdValue);
            BigDecimal resetInvalidOdValue = QTDeductService.min(maxInvalidOdValue, needFillOdValue);
            detail.setInvalidOdValue(resetInvalidOdValue);
            needFillOdValue = needFillOdValue.subtract(resetInvalidOdValue);
            if (CheckUtils.isNonZero(needFillOdValue)) {
                log.warn("reBalanceDetail fail, detail={}" + detail);
                throw new IllegalStateException("reBalanceDetail fail");
            }
        } else if (CheckUtils.isLarge(totalCost, detail.getOwnValue().add(detail.getOwnOdValue()))) {
            detail.setUsableValue(detail.getOwnValue().add(detail.getOwnOdValue()).subtract(totalCost));
            detail.setCanBeOdValue(BigDecimal.ZERO);
            BigDecimal needFillOdValue = detail.getOwnOdValue();
            BigDecimal resetFrozenOdValue = QTDeductService.min(maxFrozenOdValue, needFillOdValue);
            detail.setFrozenOdValue(resetFrozenOdValue);
            needFillOdValue = needFillOdValue.subtract(resetFrozenOdValue);
            BigDecimal resetUseOdValue = QTDeductService.min(maxUseOdValue, needFillOdValue);
            detail.setUseOdValue(resetUseOdValue);
            needFillOdValue = needFillOdValue.subtract(resetUseOdValue);
            BigDecimal resetInvalidOdValue = QTDeductService.min(maxInvalidOdValue, needFillOdValue);
            detail.setInvalidOdValue(resetInvalidOdValue);
            needFillOdValue = needFillOdValue.subtract(resetInvalidOdValue);
            if (CheckUtils.isNonZero(needFillOdValue)) {
                log.warn("reBalanceDetail fail, detail={}" + detail);
                throw new IllegalStateException("reBalanceDetail fail");
            }
        }
        return QTDeductService.checkDetailImbalance(detail);
    }

    private static void detectCarryDownedDetailAndRecoverIt(QTLineDetail qtDetail) {
        BigDecimal srcSurplus;
        BigDecimal canBeOdValue;
        BigDecimal freezeValue = qtDetail.getFreezeValue();
        BigDecimal usedValue = qtDetail.getUsedValue();
        BigDecimal balance = qtDetail.getBalance();
        BigDecimal invalidValue = qtDetail.getInvalidValue();
        BigDecimal totalCost = freezeValue.add(usedValue).add(balance).add(invalidValue);
        BigDecimal frozenOdValue = qtDetail.getFrozenOdValue();
        BigDecimal useOdValue = qtDetail.getUseOdValue();
        BigDecimal invalidOdValue = qtDetail.getInvalidOdValue();
        BigDecimal odCost = useOdValue.add(frozenOdValue).add(invalidOdValue);
        BigDecimal ownValue = qtDetail.getOwnValue();
        BigDecimal usableValue = qtDetail.getUsableValue();
        BigDecimal fromUsable = ownValue.subtract(usableValue);
        BigDecimal ownOdValue = qtDetail.getOwnOdValue();
        BigDecimal fromOd = ownOdValue.subtract(canBeOdValue = qtDetail.getCanBeOdValue());
        boolean isUnBalanceOd = CheckUtils.isNotEqual(fromOd, odCost);
        if (isUnBalanceOd) {
            log.info("detectCarryDownedDetailAndRecoverIt isUnBalanceOd: fromOd={}, odCost={}, line={}", new Object[]{fromOd, odCost, qtDetail});
            qtDetail.setCanBeOdValue(qtDetail.getCanBeOdValue().add(fromOd.subtract(odCost)));
            canBeOdValue = qtDetail.getCanBeOdValue();
            fromOd = ownOdValue.subtract(canBeOdValue);
        }
        if (CheckUtils.isNonZero(srcSurplus = fromUsable.add(fromOd).subtract(totalCost))) {
            qtDetail.setUsableValue(qtDetail.getUsableValue().add(srcSurplus));
        }
        qtDetail.setPastValue(BigDecimal.ZERO);
        qtDetail.setCarryDownedValue(BigDecimal.ZERO);
        qtDetail.setSettlementValue(BigDecimal.ZERO);
    }

    private static MBApplyRes newFrozen(long srcPID, long chainID, BillApply mainBill, QTRuntime runtime) {
        try {
            QTBillDeal srcBillDeal = runtime.loadBDByBillId(mainBill.getId(), false);
            if (srcBillDeal != null && !runtime.isWaitDelBillDeal(srcBillDeal.getId())) {
                return QTDeductService.genErrorMBApplyResFromBill(mainBill, "FROZEN_DUPLICATE", "can't duplicate apply bill.");
            }
            QTBillDeal billDeal = QTDeductService.genBD(0L, srcPID, runtime.getBatchNum(), mainBill, DealOperate.frozen, null, DealStatus.FROZEN);
            long billDealId = DB.genGlobalLongId();
            billDeal.setId(billDealId);
            billDeal.setChainID(chainID == 0L ? billDealId : chainID);
            ArrayList<SBApplyRes> sbResList = new ArrayList<SBApplyRes>(mainBill.getEntryEntities().size());
            for (BillApplyEntry billEntry : mainBill.getEntryEntities()) {
                SBApplyRes sbApplyRes = QTDeductService.frozenBillEntry(billDealId, billEntry, runtime);
                if (!sbApplyRes.isSuccess()) {
                    log.info("newFrozen fail[batchNum={}]: billEntry apply result:{}. Currently trying to apply billEntry={}", new Object[]{runtime.getBatchNum(), sbApplyRes, billEntry});
                    log.info("newFrozen fail[batchNum={}]: current completed billDealRecord={}", (Object)runtime.getBatchNum(), (Object)billDeal);
                    runtime.logDeductRuntime(log);
                    return QTDeductService.genErrorMBApplyResFromEntry(mainBill, sbResList, sbApplyRes, runtime);
                }
                sbResList.add(sbApplyRes);
                if (sbApplyRes.getBillEntryDeal() == null) continue;
                billDeal.getEntryDealList().add(sbApplyRes.getBillEntryDeal());
            }
            runtime.addWaitStoreBillDeal(billDeal);
            QTDeductService.beforeNewFrozenSuccessRet(mainBill, runtime, sbResList);
            return MBApplyRes.success(mainBill.getId(), sbResList);
        }
        catch (Exception exp) {
            log.warn("newFrozen error[batchNum={}]:", (Object)runtime.getBatchNum(), (Object)exp);
            log.warn("newFrozen error[batchNum={}]: expect newFrozen mainBill={}", (Object)runtime.getBatchNum(), (Object)mainBill);
            return QTDeductService.genErrorMBApplyResFromUnKnow(mainBill, "UN_KNOW", "newFrozen bill fail, batchNum=" + runtime.getBatchNum() + ". cause:" + exp.getMessage());
        }
    }

    private static void beforeNewFrozenSuccessRet(BillApply mainBill, QTRuntime runtime, List<SBApplyRes> sbResList) {
        for (int i = 0; i < mainBill.getEntryEntities().size(); ++i) {
            QTDeductService.fetchUsableQTLineDetailInfo((BillApplyEntry)mainBill.getEntryEntities().get(i), sbResList.get(i), runtime);
        }
    }

    private static MBApplyRes newDeduct(long srcID, QTRuntime runtime, DealOperate dop, Date dbApplyTime, BillApply mainBill) {
        try {
            QTBillDeal srcBillDeal = runtime.loadBDByBillId(mainBill.getId(), false);
            if (srcBillDeal != null && !runtime.isWaitDelBillDeal(srcBillDeal.getId())) {
                return QTDeductService.genErrorMBApplyResFromBill(mainBill, "USE_DUPLICATE", "can't duplicate apply bill.");
            }
            QTBillDeal billDeal = QTDeductService.genBD(srcID, 0L, runtime.getBatchNum(), mainBill, dop, dbApplyTime, DealStatus.USED);
            long billDealId = DB.genGlobalLongId();
            billDeal.setId(billDealId);
            billDeal.setChainID(billDealId);
            ArrayList<SBApplyRes> sbResList = new ArrayList<SBApplyRes>(mainBill.getEntryEntities().size());
            for (BillApplyEntry billEntry : mainBill.getEntryEntities()) {
                SBApplyRes sbApplyRes = QTDeductService.deductBillEntry(billDealId, billEntry, runtime);
                if (!sbApplyRes.isSuccess()) {
                    log.info("newDeduct fail[batchNum={}], billEntry apply result:{}. Currently trying to apply billEntry={}", new Object[]{runtime.getBatchNum(), sbApplyRes, billEntry});
                    log.info("newDeduct fail[batchNum={}]. current completed billDealRecord={}", (Object)runtime.getBatchNum(), (Object)billDeal);
                    runtime.logDeductRuntime(log);
                    return QTDeductService.genErrorMBApplyResFromEntry(mainBill, sbResList, sbApplyRes, runtime);
                }
                sbResList.add(sbApplyRes);
                if (sbApplyRes.getBillEntryDeal() == null) continue;
                billDeal.getEntryDealList().add(sbApplyRes.getBillEntryDeal());
            }
            runtime.addWaitStoreBillDeal(billDeal);
            return MBApplyRes.success(mainBill.getId(), sbResList);
        }
        catch (Exception exp) {
            log.warn("newDeduct error[batchNum={}]:", (Object)runtime.getBatchNum(), (Object)exp);
            log.warn("newDeduct error[batchNum={}]: expect newDeduct mainBill={}", (Object)runtime.getBatchNum(), (Object)mainBill);
            return QTDeductService.genErrorMBApplyResFromUnKnow(mainBill, "UN_KNOW", "newDeduct bill fail, batchNum=" + runtime.getBatchNum() + ". cause:" + exp.getMessage());
        }
    }

    private static SBApplyRes frozenBillEntry(long billDealId, BillApplyEntry billEntry, QTRuntime runtime) {
        boolean returnNow;
        BigDecimal expectApplyTotalValue;
        if (billEntry.getDeductionRuleId() == 0L) {
            return SBApplyRes.success(billEntry.getEntryId(), null, null);
        }
        QTDeductRule deductRule = runtime.getQTDeductRule(billEntry.getDeductionRuleId());
        if (deductRule == null) {
            log.info("frozenBillEntry fail[batchNum={}]: can't find deductRule[vid={}] to deduct for billEntry={}.", new Object[]{runtime.getBatchNum(), billEntry.getDeductionRuleId(), billEntry});
            String errMsg = String.format("batchNum=%s. can't find deductRule[vid=%s] to frozen for billEntry[id=%s].", runtime.getBatchNum(), billEntry.getDeductionRuleId(), billEntry.getEntryId());
            return SBApplyRes.fail(billEntry.getEntryId(), "NONEXISTENT_DEDUCT_RULE", errMsg, MapBuilder.toSingleMap((String)"deductionRuleId", (Object)billEntry.getDeductionRuleId()));
        }
        BigDecimal bigDecimal = expectApplyTotalValue = "D".equals(deductRule.getUnit()) ? billEntry.getVaTimeDay() : billEntry.getVaTimeHour();
        if (CheckUtils.isNegative(expectApplyTotalValue)) {
            log.info("frozenBillEntry fail[batchNum={}]: can't deduct negative value[{}]. billEntry={}", new Object[]{runtime.getBatchNum(), expectApplyTotalValue, billEntry});
            String errMsg = String.format("batchNum=%s. can't apply negative value[%s].", runtime.getBatchNum(), expectApplyTotalValue.toString());
            return SBApplyRes.fail(billEntry.getEntryId(), "ENTRY_APPLY_NEGATIVE", errMsg, MapBuilder.toSingleMap((String)"expectApplyTotalValue", (Object)expectApplyTotalValue));
        }
        if (CheckUtils.isZero(expectApplyTotalValue)) {
            return SBApplyRes.success(billEntry.getEntryId(), null, null);
        }
        if (billEntry.getNonQuota()) {
            return SBApplyRes.success(billEntry.getEntryId(), null, null);
        }
        QTBillEntryDeal billEntryDeal = QTDeductService.genBED(billDealId, billEntry, deductRule);
        List<Long> qtTypeIdList = deductRule.getDeductOrder().stream().map(QTType::getId).collect(Collectors.toList());
        Date unCoverDate = QTDeductService.checkCoverBeforeFrozen(billEntry, runtime, qtTypeIdList);
        if (unCoverDate != null) {
            log.info("frozenBillEntry fail[batchNum={}]: uncover. billEntry={}", (Object)runtime.getBatchNum(), (Object)billEntry);
            return SBApplyRes.fail(billEntry.getEntryId(), "UN_COVER", "batchNum=" + runtime.getBatchNum() + ", can't cover apply time range.", MapBuilder.toSingleMap((String)"unCoverDate", (Object)unCoverDate));
        }
        BigDecimal expectApplyValue = "D".equals(deductRule.getUnit()) ? billEntry.getVaTimeDay() : billEntry.getVaTimeHour();
        QTDRDebrisAccumulator debrisAccumulator = new QTDRDebrisAccumulator();
        List<AffluentQTLineDetail> mergedSortDetailList = runtime.getMergedSortDetailList(qtTypeIdList, new DetailComparatorPackage(deductRule));
        QTApplyInventoryHolder applyInventoryHolder = new QTApplyInventoryHolder();
        QTDeductService.beforeFrozenEntry(applyInventoryHolder, billEntry, runtime, deductRule, mergedSortDetailList);
        boolean drain = billEntry.getDisposable();
        boolean notNeedCheckRemainValue = CheckUtils.isNFrom(expectApplyValue, deductRule.getLowerLimit(), true);
        expectApplyValue = QTDeductService.tryFrozenFromExtra(billEntry, runtime, mergedSortDetailList, expectApplyValue, debrisAccumulator);
        expectApplyValue = QTDeductService.tryFrozenFromUsable(billEntry, runtime, mergedSortDetailList, expectApplyValue, debrisAccumulator);
        expectApplyValue = QTDeductService.tryFrozenFromOverdrawn(billEntry, runtime, mergedSortDetailList, expectApplyValue, debrisAccumulator);
        boolean bl = returnNow = !drain && notNeedCheckRemainValue;
        if (returnNow) {
            if (CheckUtils.isZero(expectApplyValue)) {
                billEntryDeal.setDetailList(debrisAccumulator.mergeDebris());
                return SBApplyRes.success(billEntry.getEntryId(), null, billEntryDeal, QTDeductService.buildQTApplyInventoryRetMap4Frozen(debrisAccumulator, applyInventoryHolder, runtime));
            }
            log.info("frozenBillEntry fail[batchNum={}]: insufficient_quota. billEntry={}", (Object)runtime.getBatchNum(), (Object)billEntry);
            return SBApplyRes.fail(billEntry.getEntryId(), "INSUFFICIENT_QUOTA", "insufficient quota");
        }
        if (drain) {
            return QTDeductService.doDrain(billEntry, runtime, billEntryDeal, expectApplyValue, debrisAccumulator, mergedSortDetailList, applyInventoryHolder);
        }
        return QTDeductService.doGradientLimit(billEntry, runtime, deductRule, billEntryDeal, expectApplyValue, debrisAccumulator, mergedSortDetailList, applyInventoryHolder);
    }

    private static SBApplyRes doGradientLimit(BillApplyEntry billEntry, QTRuntime runtime, QTDeductRule deductRule, QTBillEntryDeal billEntryDeal, BigDecimal expectApplyValue, QTDRDebrisAccumulator debrisAccumulator, List<AffluentQTLineDetail> mergedSortDetailList, QTApplyInventoryHolder applyInventoryHolder) {
        if (CheckUtils.isZero(expectApplyValue)) {
            MapBuilder remainValueMap = QTDeductService.sumPositiveRemainValue(billEntry, runtime, mergedSortDetailList, true).replaceKeyIfExist(ExtraValue, "remainExtraValue").replaceKeyIfExist(UsableValue, "remainUsableValue").replaceKeyIfExist(CanBeOdValue, "remainCanBeOdValue").replaceKeyIfExist(TotalValue, "remainTotalValue");
            if (remainValueMap.containsKey("remainUsableValue") || remainValueMap.containsKey("remainExtraValue")) {
                log.info("frozenBillEntry fail[batchNum={}]: GRADIENT_LIMIT. remainValueMap={}, billEntry={}", new Object[]{runtime.getBatchNum(), remainValueMap, billEntry});
                remainValueMap.setAttribute("gradientValue", (Object)deductRule.getLowerLimit()).setAttribute("gradientUnit", (Object)deductRule.getUnit()).setAttribute("vacationType", (Object)billEntry.getVacationType());
                return SBApplyRes.fail(billEntry.getEntryId(), "GRADIENT_LIMIT", "gradient limit", remainValueMap.toMap());
            }
            billEntryDeal.setDetailList(debrisAccumulator.mergeDebris());
            return SBApplyRes.success(billEntry.getEntryId(), null, billEntryDeal, QTDeductService.buildQTApplyInventoryRetMap4Frozen(debrisAccumulator, applyInventoryHolder, runtime));
        }
        log.info("frozenBillEntry fail[batchNum={}]: insufficient_quota. billEntry={}", (Object)runtime.getBatchNum(), (Object)billEntry);
        return SBApplyRes.fail(billEntry.getEntryId(), "INSUFFICIENT_QUOTA", "insufficient quota");
    }

    private static SBApplyRes doDrain(BillApplyEntry billEntry, QTRuntime runtime, QTBillEntryDeal billEntryDeal, BigDecimal expectApplyValue, QTDRDebrisAccumulator debrisAccumulator, List<AffluentQTLineDetail> mergedSortDetailList, QTApplyInventoryHolder applyInventoryHolder) {
        if (CheckUtils.isZero(expectApplyValue)) {
            MapBuilder needFrozenRemainValueMap = QTDeductService.sumPositiveRemainValue(billEntry, runtime, mergedSortDetailList, true);
            if (!needFrozenRemainValueMap.isEmpty()) {
                QTDeductService.frozenAllRemainValue(billEntry, runtime, mergedSortDetailList, debrisAccumulator);
                MapBuilder remainValueMap = QTDeductService.sumPositiveRemainValue(billEntry, runtime, mergedSortDetailList, false).replaceKeyIfExist(UsableValue, "remainUsableValue").replaceKeyIfExist(CanBeOdValue, "remainCanBeOdValue").replaceKeyIfExist(TotalValue, "remainTotalValue");
                if (remainValueMap.containsKey("remainUsableValue") || remainValueMap.containsKey("remainCanBeOdValue")) {
                    log.info("frozenBillEntry fail[batchNum={}]: ILLEGAL_DISPOSABLE. un touch code branch, needFrozenRemainValueMap={}, remainValueMap={}, billEntry={}", new Object[]{runtime.getBatchNum(), needFrozenRemainValueMap, remainValueMap, billEntry});
                    log.info("frozenBillEntry fail[batchNum={}]: ILLEGAL_DISPOSABLE. un touch code branch, mergedSortDetailList={}", (Object)runtime.getBatchNum(), mergedSortDetailList);
                    return SBApplyRes.fail(billEntry.getEntryId(), "ILLEGAL_DISPOSABLE", "ILLEGAL_DISPOSABLE: remainValueMap=" + remainValueMap, remainValueMap.toMap());
                }
                billEntryDeal.setDetailList(debrisAccumulator.mergeDebris());
                Map retData = needFrozenRemainValueMap.replaceKeyIfExist(UsableValue, "extraFreezeUsableValue").replaceKeyIfExist(CanBeOdValue, "extraFreezeCanBeOdValue").replaceKeyIfExist(TotalValue, "extraFreezeTotalValue").setAttribute("QTWarnEvent", QTOuterParamUtils.modifiableSingletonList(QTWarnEvent.disposableExtraFreeze)).setAll(QTDeductService.buildQTApplyInventoryRetMap4Frozen(debrisAccumulator, applyInventoryHolder, runtime)).toMap();
                return SBApplyRes.success(billEntry.getEntryId(), null, billEntryDeal, retData);
            }
            billEntryDeal.setDetailList(debrisAccumulator.mergeDebris());
            return SBApplyRes.success(billEntry.getEntryId(), null, billEntryDeal, QTDeductService.buildQTApplyInventoryRetMap4Frozen(debrisAccumulator, applyInventoryHolder, runtime));
        }
        log.info("frozenBillEntry fail[batchNum={}]: insufficient_quota. billEntry={}", (Object)runtime.getBatchNum(), (Object)billEntry);
        return SBApplyRes.fail(billEntry.getEntryId(), "INSUFFICIENT_QUOTA", "insufficient quota");
    }

    private static void beforeFrozenEntry(QTApplyInventoryHolder applyInventoryCollector, BillApplyEntry billEntry, QTRuntime runtime, QTDeductRule deductRule, List<AffluentQTLineDetail> mergedSortDetailList) {
        List<AffluentUsableQuotaInfo> beforeFrozenQTInfo = mergedSortDetailList.stream().filter(detailWrapper -> {
            QTLineDetail detail = detailWrapper.getSrc();
            boolean intersect = WTCDateUtils.hasIntersectionLCRC((Date)WTCDateUtils.getZeroDate((Date)billEntry.getStartDate()), (Date)WTCDateUtils.getDayLastDate((Date)billEntry.getEndDate()), (Date)detail.getUseStartDate(), (Date)detail.getUseEndDateDayLast());
            return intersect && !QTDeductService.isUnUsableDetailType(detail, runtime);
        }).filter(detailWrapper -> {
            QTLineDetail detail = detailWrapper.getSrc();
            return CheckUtils.isPositive(detailWrapper.getActualCanBeUseExtraValue()) || CheckUtils.isPositive(detail.getUsableValue()) || CheckUtils.isPositive(detail.getCanBeOdValue());
        }).map(detailWrapper -> QTOuterParamUtils.parse2AffluentUsableQuotaInfo(detailWrapper, deductRule.getUnit())).collect(Collectors.toList());
        applyInventoryCollector.setBeforeFrozenEntryQTInfo(beforeFrozenQTInfo);
    }

    private static Map<String, Object> buildQTApplyInventoryRetMap4Frozen(QTDRDebrisAccumulator debrisAccumulator, QTApplyInventoryHolder applyInventoryCollector, QTRuntime runtime) {
        LinkedList<QTApplyInventory> objects = new LinkedList<QTApplyInventory>();
        objects.add(QTApplyInventory.involved_line_detail_deduct_info);
        objects.add(QTApplyInventory.before_frozen_entry_quota_info);
        return MapBuilder.newInstance().setAttribute("QTApplyInventory", objects).setAttribute(QTApplyInventory.involved_line_detail_deduct_info.name(), debrisAccumulator.mergeDebris2DeductInfo(runtime)).setAttribute(QTApplyInventory.before_frozen_entry_quota_info.name(), applyInventoryCollector.getBeforeFrozenEntryQTInfo()).toMap();
    }

    private static Map<String, Object> buildQTApplyInventoryRetMap4Deduct(QTDRDebrisAccumulator debrisAccumulator, QTRuntime runtime) {
        return MapBuilder.newInstance().setAttribute("QTApplyInventory", QTOuterParamUtils.modifiableSingletonLinkedList(QTApplyInventory.involved_line_detail_deduct_info)).setAttribute(QTApplyInventory.involved_line_detail_deduct_info.name(), debrisAccumulator.mergeDebris2DeductInfo(runtime)).toMap();
    }

    private static void frozenAllRemainValue(BillApplyEntry billEntry, QTRuntime runtime, List<AffluentQTLineDetail> mergedSortDetailList, QTDRDebrisAccumulator debrisAccumulator) {
        for (AffluentQTLineDetail detailWrapper : mergedSortDetailList) {
            QTLineDetail detail = detailWrapper.getSrc();
            boolean intersect = WTCDateUtils.hasIntersectionLCRC((Date)WTCDateUtils.getZeroDate((Date)billEntry.getStartDate()), (Date)WTCDateUtils.getDayLastDate((Date)billEntry.getEndDate()), (Date)detail.getUseStartDate(), (Date)detail.getUseEndDateDayLast());
            if (!intersect || QTDeductService.isUnUsableDetailType(detail, runtime)) continue;
            if (QTDeductService.checkDetailImbalance(detail) && QTDeductService.reBalanceDetail(detail)) {
                log.warn("frozenBillEntry fail[batchNum={}]: QTDetail imbalance on frozenAllRemainValue. detail={}", (Object)runtime.getBatchNum(), (Object)detailWrapper.getSrc());
                throw new IllegalStateException("QTDetail imbalance.");
            }
            BigDecimal actualApplyValue = BigDecimal.ZERO;
            if (CheckUtils.isPositive(detail.getUsableValue())) {
                runtime.markDirty(detail);
                BigDecimal drainUsableValue = detail.getUsableValue();
                detail.setUsableValue(detail.getUsableValue().subtract(drainUsableValue));
                detail.setFreezeValue(detail.getFreezeValue().add(drainUsableValue));
                actualApplyValue = actualApplyValue.add(drainUsableValue);
            }
            if (CheckUtils.isPositive(detail.getCanBeOdValue())) {
                runtime.markDirty(detail);
                BigDecimal drainCanBeOdValue = detail.getCanBeOdValue();
                detail.setCanBeOdValue(detail.getCanBeOdValue().subtract(drainCanBeOdValue));
                detail.setFreezeValue(detail.getFreezeValue().add(drainCanBeOdValue));
                detail.setFrozenOdValue(detail.getFrozenOdValue().add(drainCanBeOdValue));
                actualApplyValue = actualApplyValue.add(drainCanBeOdValue);
            }
            if (!CheckUtils.isPositive(actualApplyValue)) continue;
            debrisAccumulator.addPoolInvalidDebris(billEntry.getEntryId(), detail.getId(), null, actualApplyValue);
        }
    }

    private static Date checkCoverBeforeFrozen(BillApplyEntry billEntry, QTRuntime runtime, List<Long> qtTypeIdList) {
        Date curDate = WTCDateUtils.getZeroDate((Date)billEntry.getStartDate());
        Date lastDate = WTCDateUtils.getDayLastDate((Date)billEntry.getEndDate());
        List<AffluentQTLineDetail> mergedUnSortDetailList = runtime.getMergedUnSortDetailList(qtTypeIdList);
        block0: while (curDate.before(lastDate)) {
            for (AffluentQTLineDetail detailWrapper : mergedUnSortDetailList) {
                boolean intersect;
                QTLineDetail detail = detailWrapper.getSrc();
                if (QTDeductService.isUnUsableDetailType(detail, runtime) || !(intersect = WTCDateUtils.hasIntersectionLCRC((Date)WTCDateUtils.getZeroDate((Date)curDate), (Date)WTCDateUtils.getDayLastDate((Date)curDate), (Date)detail.getUseStartDate(), (Date)detail.getUseEndDateDayLast()))) continue;
                curDate = WTCDateUtils.getNextDate((Date)curDate);
                continue block0;
            }
            log.info("batchNum={} apply fail: can't cover apply time range. uncover date={}, billEntry={}", new Object[]{runtime.getBatchNum(), WTCDateUtils.date2Str((Date)curDate, (String)"yyyy-MM-dd"), billEntry});
            return curDate;
        }
        return null;
    }

    private static BigDecimal tryFrozenFromExtra(BillApplyEntry billEntry, QTRuntime runtime, List<AffluentQTLineDetail> mergedSortDetailList, BigDecimal expectApplyValue, QTDRDebrisAccumulator debrisAccumulator) {
        if (CheckUtils.isZero(expectApplyValue)) {
            return expectApplyValue;
        }
        for (AffluentQTLineDetail detailWrapper : mergedSortDetailList) {
            QTLineDetail detail = detailWrapper.getSrc();
            boolean intersect = WTCDateUtils.hasIntersectionLCRC((Date)WTCDateUtils.getZeroDate((Date)billEntry.getStartDate()), (Date)WTCDateUtils.getDayLastDate((Date)billEntry.getEndDate()), (Date)detail.getUseStartDate(), (Date)detail.getUseEndDateDayLast());
            if (!intersect || QTDeductService.isUnUsableDetailType(detail, runtime)) continue;
            if (CheckUtils.isNegative(detail.getUsableValue()) && CheckUtils.isNegative(detailWrapper.getActualCanBeUseExtraValue())) {
                log.warn("frozenBillEntry warn[batchNum={}]: detected a QTDetail[id={}, usableValue={}, extraValue={}] occur negative value, billEntry={}", new Object[]{runtime.getBatchNum(), detail.getId(), detail.getUsableValue(), detailWrapper.getExtraValue(), billEntry});
                continue;
            }
            if (CheckUtils.isNonZero(expectApplyValue) && CheckUtils.isPositive(detailWrapper.getActualCanBeUseExtraValue()) && CheckUtils.isPositive(detailWrapper.getExtraValue())) {
                runtime.markDirty(detail);
                BigDecimal actualApplyValue = QTDeductService.min(detailWrapper.getActualCanBeUseExtraValue(), expectApplyValue);
                detailWrapper.setExtraValue(detailWrapper.getExtraValue().subtract(actualApplyValue));
                expectApplyValue = expectApplyValue.subtract(actualApplyValue);
                debrisAccumulator.addParentDebris(billEntry.getEntryId(), detail.getId(), null, actualApplyValue);
            }
            if (!CheckUtils.isZero(expectApplyValue)) continue;
            break;
        }
        return expectApplyValue;
    }

    private static BigDecimal tryFrozenFromUsable(BillApplyEntry billEntry, QTRuntime runtime, List<AffluentQTLineDetail> mergedSortDetailList, BigDecimal expectApplyValue, QTDRDebrisAccumulator debrisAccumulator) {
        if (CheckUtils.isZero(expectApplyValue)) {
            return expectApplyValue;
        }
        for (AffluentQTLineDetail detailWrapper : mergedSortDetailList) {
            if (CheckUtils.isZero(expectApplyValue)) break;
            QTLineDetail detail = detailWrapper.getSrc();
            boolean intersect = WTCDateUtils.hasIntersectionLCRC((Date)WTCDateUtils.getZeroDate((Date)billEntry.getStartDate()), (Date)WTCDateUtils.getDayLastDate((Date)billEntry.getEndDate()), (Date)detail.getUseStartDate(), (Date)detail.getUseEndDateDayLast());
            if (!intersect || QTDeductService.isUnUsableDetailType(detail, runtime)) continue;
            if (CheckUtils.isNonZero(expectApplyValue) && CheckUtils.isPositive(detail.getUsableValue())) {
                if (QTDeductService.checkDetailImbalance(detail) && QTDeductService.reBalanceDetail(detail)) {
                    log.warn("frozenBillEntry fail[batchNum={}]: QTDetail imbalance on tryFrozenFromUsable. detail={}", (Object)runtime.getBatchNum(), (Object)detailWrapper.getSrc());
                    throw new IllegalStateException("QTDetail imbalance.");
                }
                runtime.markDirty(detail);
                BigDecimal actualApplyValue = QTDeductService.min(detail.getUsableValue(), expectApplyValue);
                detail.setUsableValue(detail.getUsableValue().subtract(actualApplyValue));
                detail.setFreezeValue(detail.getFreezeValue().add(actualApplyValue));
                expectApplyValue = expectApplyValue.subtract(actualApplyValue);
                debrisAccumulator.addPoolDebris(billEntry.getEntryId(), detail.getId(), null, actualApplyValue);
            }
            if (!CheckUtils.isZero(expectApplyValue)) continue;
            break;
        }
        return expectApplyValue;
    }

    private static BigDecimal tryFrozenFromOverdrawn(BillApplyEntry billEntry, QTRuntime runtime, List<AffluentQTLineDetail> mergedSortDetailList, BigDecimal expectApplyValue, QTDRDebrisAccumulator debrisAccumulator) {
        if (CheckUtils.isZero(expectApplyValue)) {
            return expectApplyValue;
        }
        for (AffluentQTLineDetail detailWrapper : mergedSortDetailList) {
            if (CheckUtils.isZero(expectApplyValue)) break;
            QTLineDetail detail = detailWrapper.getSrc();
            boolean intersect = WTCDateUtils.hasIntersectionLCRC((Date)WTCDateUtils.getZeroDate((Date)billEntry.getStartDate()), (Date)WTCDateUtils.getDayLastDate((Date)billEntry.getEndDate()), (Date)detail.getUseStartDate(), (Date)detail.getUseEndDateDayLast());
            if (!intersect || QTDeductService.isUnUsableDetailType(detail, runtime)) continue;
            if (CheckUtils.isNonZero(expectApplyValue) && CheckUtils.isPositive(detail.getCanBeOdValue())) {
                if (QTDeductService.checkDetailImbalance(detail) && QTDeductService.reBalanceDetail(detail)) {
                    log.warn("frozenBillEntry fail[batchNum={}]: QTDetail imbalance on tryFrozenFromOverdrawn. detail={}", (Object)runtime.getBatchNum(), (Object)detailWrapper.getSrc());
                    throw new IllegalStateException("QTDetail imbalance.");
                }
                runtime.markDirty(detail);
                BigDecimal actualApplyValue = QTDeductService.min(detail.getCanBeOdValue(), expectApplyValue);
                detail.setCanBeOdValue(detail.getCanBeOdValue().subtract(actualApplyValue));
                detail.setFrozenOdValue(detail.getFrozenOdValue().add(actualApplyValue));
                detail.setFreezeValue(detail.getFreezeValue().add(actualApplyValue));
                expectApplyValue = expectApplyValue.subtract(actualApplyValue);
                debrisAccumulator.addPoolDebris(billEntry.getEntryId(), detail.getId(), null, actualApplyValue);
            }
            if (!CheckUtils.isZero(expectApplyValue)) continue;
            break;
        }
        return expectApplyValue;
    }

    private static void fetchUsableQTLineDetailInfo(BillApplyEntry billEntry, SBApplyRes sbApplyRes, QTRuntime runtime) {
        if (billEntry.getDeductionRuleId() == 0L) {
            return;
        }
        QTDeductRule deductRule = runtime.getQTDeductRule(billEntry.getDeductionRuleId());
        if (deductRule == null) {
            return;
        }
        List<Long> qtTypeIdList = deductRule.getDeductOrder().stream().map(QTType::getId).collect(Collectors.toList());
        List usableDetailList = runtime.getMergedSortDetailList(qtTypeIdList, new DetailComparatorPackage(deductRule)).stream().filter(detailWrapper -> {
            QTLineDetail detail = detailWrapper.getSrc();
            boolean intersect = WTCDateUtils.hasIntersectionLCRC((Date)WTCDateUtils.getZeroDate((Date)billEntry.getStartDate()), (Date)WTCDateUtils.getDayLastDate((Date)billEntry.getEndDate()), (Date)detail.getUseStartDate(), (Date)detail.getUseEndDateDayLast());
            return intersect && !QTDeductService.isUnUsableDetailType(detail, runtime);
        }).collect(Collectors.toList());
        ArrayList<AffluentUsableQuotaInfo> remainValueQTLineDetailList = new ArrayList<AffluentUsableQuotaInfo>(16);
        for (AffluentQTLineDetail detailWrapper2 : usableDetailList) {
            QTLineDetail detail = detailWrapper2.getSrc();
            if (!CheckUtils.isPositive(detailWrapper2.getActualCanBeUseExtraValue()) && !CheckUtils.isPositive(detail.getUsableValue()) && !CheckUtils.isPositive(detail.getCanBeOdValue())) continue;
            AffluentUsableQuotaInfo affluentUsableQuotaInfo = QTOuterParamUtils.parse2AffluentUsableQuotaInfo(detailWrapper2, deductRule.getUnit());
            remainValueQTLineDetailList.add(affluentUsableQuotaInfo);
        }
        if (!remainValueQTLineDetailList.isEmpty()) {
            List applyInventoryList = QTApplyInventory.parseQTApplyInventory(sbApplyRes.getRetData());
            if (!applyInventoryList.contains(QTApplyInventory.remain_quota_info)) {
                applyInventoryList.add(QTApplyInventory.remain_quota_info);
            }
            Map retData = MapBuilder.newInstance(sbApplyRes.getRetData()).setAttribute("QTApplyInventory", (Object)applyInventoryList).setAttribute(QTApplyInventory.remain_quota_info.name(), remainValueQTLineDetailList).toMap();
            sbApplyRes.setRetData(retData);
        }
    }

    private static MapBuilder sumPositiveRemainValue(BillApplyEntry billEntry, QTRuntime runtime, List<AffluentQTLineDetail> mergedSortDetailList, boolean countExtraValue) {
        BigDecimal totalSum;
        BigDecimal extraValue = BigDecimal.ZERO;
        BigDecimal usableValue = BigDecimal.ZERO;
        BigDecimal canBeOdValue = BigDecimal.ZERO;
        for (AffluentQTLineDetail detailWrapper : mergedSortDetailList) {
            QTLineDetail detail = detailWrapper.getSrc();
            boolean intersect = WTCDateUtils.hasIntersectionLCRC((Date)WTCDateUtils.getZeroDate((Date)billEntry.getStartDate()), (Date)WTCDateUtils.getDayLastDate((Date)billEntry.getEndDate()), (Date)detail.getUseStartDate(), (Date)detail.getUseEndDateDayLast());
            if (!intersect || QTDeductService.isUnUsableDetailType(detail, runtime)) continue;
            if (countExtraValue && CheckUtils.isPositive(detailWrapper.getActualCanBeUseExtraValue())) {
                extraValue = extraValue.add(detailWrapper.getActualCanBeUseExtraValue());
            }
            if (CheckUtils.isPositive(detail.getUsableValue())) {
                usableValue = usableValue.add(detail.getUsableValue());
            }
            if (!CheckUtils.isPositive(detail.getCanBeOdValue())) continue;
            canBeOdValue = canBeOdValue.add(detail.getCanBeOdValue());
        }
        MapBuilder mapBuilder = MapBuilder.newInstance();
        if (CheckUtils.isNonZero(extraValue)) {
            mapBuilder.setAttribute(ExtraValue, (Object)extraValue);
        }
        if (CheckUtils.isNonZero(usableValue)) {
            mapBuilder.setAttribute(UsableValue, (Object)usableValue);
        }
        if (CheckUtils.isNonZero(canBeOdValue)) {
            mapBuilder.setAttribute(CanBeOdValue, (Object)canBeOdValue);
        }
        if (CheckUtils.isNonZero(totalSum = usableValue.add(canBeOdValue).add(extraValue))) {
            mapBuilder.setAttribute(TotalValue, (Object)totalSum);
        }
        return mapBuilder;
    }

    private static SBApplyRes deductBillEntry(long billDealId, BillApplyEntry billEntry, QTRuntime runtime) {
        BigDecimal expectApplyTotalValue;
        if (billEntry.getDeductionRuleId() == 0L) {
            return SBApplyRes.success(billEntry.getEntryId(), null, null);
        }
        QTDeductRule deductRule = runtime.getQTDeductRule(billEntry.getDeductionRuleId());
        if (deductRule == null) {
            log.warn("deductBillEntry fail[batchNum={}]: can't find deductRule[vid={}] to deduct for billEntry={}.", new Object[]{runtime.getBatchNum(), billEntry.getDeductionRuleId(), billEntry});
            String errMsg = String.format("batchNum=%s. can't find deductRule[vid=%s] to deduct for billEntry[id=%s].", runtime.getBatchNum(), billEntry.getDeductionRuleId(), billEntry.getEntryId());
            return SBApplyRes.fail(billEntry.getEntryId(), "NONEXISTENT_DEDUCT_RULE", errMsg, MapBuilder.toSingleMap((String)"deductionRuleId", (Object)billEntry.getDeductionRuleId()));
        }
        if (billEntry.getNonQuota()) {
            return SBApplyRes.success(billEntry.getEntryId(), null, null);
        }
        BigDecimal bigDecimal = expectApplyTotalValue = "D".equals(deductRule.getUnit()) ? billEntry.getVaTimeDay() : billEntry.getVaTimeHour();
        if (CheckUtils.isNegative(expectApplyTotalValue)) {
            log.warn("deductBillEntry fail[batchNum={}]: can't deduct negative value[{}]. billEntry={}", new Object[]{runtime.getBatchNum(), expectApplyTotalValue, billEntry});
            String errMsg = String.format("batchNum=%s. can't deduct negative value[%s].", runtime.getBatchNum(), expectApplyTotalValue.toString());
            return SBApplyRes.fail(billEntry.getEntryId(), "ENTRY_APPLY_NEGATIVE", errMsg, MapBuilder.toSingleMap((String)"expectApplyTotalValue", (Object)expectApplyTotalValue));
        }
        SBApplyRes errRes = QTDeductService.checkEntryDateSplitValue(billEntry, runtime);
        if (errRes != null) {
            return errRes;
        }
        if (CheckUtils.isZero(expectApplyTotalValue)) {
            return SBApplyRes.success(billEntry.getEntryId(), null, null);
        }
        QTBillEntryDeal billEntryDeal = QTDeductService.genBED(billDealId, billEntry, deductRule);
        List<Long> qtTypeIdList = deductRule.getDeductOrder().stream().map(QTType::getId).collect(Collectors.toList());
        List<AffluentQTLineDetail> mergedSortDetailList = runtime.getMergedSortDetailList(qtTypeIdList, new DetailComparatorPackage(deductRule));
        Date unCoverDate = QTDeductService.checkCoverBeforeUsed(billEntry, runtime, deductRule, mergedSortDetailList);
        if (unCoverDate != null) {
            log.info("deductBillEntry fail[batchNum={}]: uncover. billEntry={}", (Object)runtime.getBatchNum(), (Object)billEntry);
            return SBApplyRes.fail(billEntry.getEntryId(), "UN_COVER", "batchNum=" + runtime.getBatchNum() + ", can't cover apply time range.", MapBuilder.toSingleMap((String)"unCoverDate", (Object)unCoverDate));
        }
        boolean drain = billEntry.getDisposable();
        QTDRDebrisAccumulator debrisAccumulator = new QTDRDebrisAccumulator();
        for (BillEntryDateSplit beds : billEntry.getSplitList()) {
            BigDecimal dateExpectApplyValue;
            BigDecimal bigDecimal2 = dateExpectApplyValue = "D".equals(deductRule.getUnit()) ? beds.getVaTimeDay() : beds.getVaTimeHour();
            if (CheckUtils.isZero(dateExpectApplyValue)) {
                debrisAccumulator.addEmptyDebris(billEntry.getEntryId(), 0L, beds.getDate(), dateExpectApplyValue);
                continue;
            }
            if (CheckUtils.isZero(dateExpectApplyValue = QTDeductService.tryDeductFromUsable(billEntry, runtime, mergedSortDetailList, debrisAccumulator, beds, dateExpectApplyValue)) || CheckUtils.isZero(dateExpectApplyValue = QTDeductService.tryDeductFromOverdraw(billEntry, runtime, mergedSortDetailList, debrisAccumulator, beds, dateExpectApplyValue)) || CheckUtils.isZero(dateExpectApplyValue = QTDeductService.tryDeductFromOverUsable(billEntry, runtime, mergedSortDetailList, debrisAccumulator, beds, dateExpectApplyValue))) continue;
            log.info("deductBillEntry fail[batchNum={}]: insufficient_quota[{}]. BillEntryDateSplit={}, billEntry={}", new Object[]{runtime.getBatchNum(), dateExpectApplyValue, beds, billEntry});
            log.info("deductBillEntry fail[batchNum={}]: insufficient_quota[{}]. debrisAccumulator={}", new Object[]{runtime.getBatchNum(), dateExpectApplyValue, debrisAccumulator});
            return SBApplyRes.fail(billEntry.getEntryId(), "INSUFFICIENT_QUOTA", "insufficient quota");
        }
        if (drain) {
            QTDeductService.drainRemainValue(billEntry, runtime, mergedSortDetailList, debrisAccumulator);
        }
        billEntryDeal.setDetailList(debrisAccumulator.mergeDebris());
        return SBApplyRes.success(billEntry.getEntryId(), null, billEntryDeal, QTDeductService.buildQTApplyInventoryRetMap4Deduct(debrisAccumulator, runtime));
    }

    private static Date checkCoverBeforeUsed(BillApplyEntry billEntry, QTRuntime runtime, QTDeductRule deductRule, List<AffluentQTLineDetail> mergedSortDetailList) {
        for (BillEntryDateSplit beds : billEntry.getSplitList()) {
            BigDecimal dateExpectApplyValue;
            BigDecimal bigDecimal = dateExpectApplyValue = "D".equals(deductRule.getUnit()) ? beds.getVaTimeDay() : beds.getVaTimeHour();
            if (CheckUtils.isZero(dateExpectApplyValue)) continue;
            boolean hit = false;
            for (AffluentQTLineDetail detailWrapper : mergedSortDetailList) {
                QTLineDetail detail = detailWrapper.getSrc();
                boolean intersect = WTCDateUtils.hasIntersectionLCRC((Date)WTCDateUtils.getZeroDate((Date)beds.getDate()), (Date)WTCDateUtils.getDayLastDate((Date)beds.getDate()), (Date)detail.getUseStartDate(), (Date)detail.getUseEndDateDayLast());
                if (!intersect || QTDeductService.isUnUsableDetailType(detail, runtime)) continue;
                hit = true;
                break;
            }
            if (hit) continue;
            log.info("batchNum={} apply fail: can't cover apply time range. uncover date={}, billEntry={}", new Object[]{runtime.getBatchNum(), WTCDateUtils.date2Str((Date)beds.getDate(), (String)"yyyy-MM-dd"), billEntry});
            return beds.getDate();
        }
        return null;
    }

    private static SBApplyRes checkEntryDateSplitValue(BillApplyEntry billEntry, QTRuntime runtime) {
        QTDeductRule deductRule = runtime.getQTDeductRule(billEntry.getDeductionRuleId());
        BigDecimal expectApplyTotalValue = "D".equals(deductRule.getUnit()) ? billEntry.getVaTimeDay() : billEntry.getVaTimeHour();
        BigDecimal tmp = BigDecimal.ZERO;
        for (BillEntryDateSplit dateSplit : billEntry.getSplitList()) {
            BigDecimal dateExpectApplyValue;
            BigDecimal bigDecimal = dateExpectApplyValue = "D".equals(deductRule.getUnit()) ? dateSplit.getVaTimeDay() : dateSplit.getVaTimeHour();
            if (CheckUtils.isNegative(dateExpectApplyValue)) {
                log.warn("deductBillEntry fail[batchNum={}]: can't deduct negative value[{}] for splitDate[{}] billEntry={}", new Object[]{runtime.getBatchNum(), dateExpectApplyValue, dateSplit.getDate(), billEntry});
                String errMsg = "date " + WTCDateUtils.date2Str((Date)dateSplit.getDate(), (String)"yyyy-MM-dd") + " split value occur negative value:" + dateExpectApplyValue + " for billEntry:" + billEntry;
                Map retData = MapBuilder.newInstance().setAttribute("entryApplyUnit", (Object)deductRule.getUnit()).setAttribute("splitDate", (Object)dateSplit.getDate()).setAttribute("splitDateValue", (Object)dateExpectApplyValue).toMap();
                return SBApplyRes.fail(billEntry.getEntryId(), "ENTRY_SPLIT_DATE_APPLY_NEGATIVE", errMsg, retData);
            }
            tmp = tmp.add(dateExpectApplyValue);
        }
        if (!CheckUtils.isEqual(expectApplyTotalValue, tmp)) {
            log.warn("deductBillEntry fail[batchNum={}]: billEntry apply value must equal to date split value sum. billEntry={}", (Object)runtime.getBatchNum(), (Object)billEntry);
            String errMsg = "billEntry apply value must equal to date split value sum. billEntry apply value:" + expectApplyTotalValue + ", date split value sum:" + tmp + ". billEntry:" + billEntry;
            Map retData = MapBuilder.newInstance().setAttribute("entryApplyUnit", (Object)deductRule.getUnit()).setAttribute("entryApplyValue", (Object)expectApplyTotalValue).setAttribute("splitDateSumValue", (Object)tmp).toMap();
            return SBApplyRes.fail(billEntry.getEntryId(), "ENTRY_SPLIT_DATE_SUM_ILLEGAL", errMsg, retData);
        }
        return null;
    }

    private static BigDecimal tryDeductFromUsable(BillApplyEntry billEntry, QTRuntime runtime, List<AffluentQTLineDetail> mergedSortDetailList, QTDRDebrisAccumulator debrisAccumulator, BillEntryDateSplit beds, BigDecimal dateExpectApplyValue) {
        for (AffluentQTLineDetail detailWrapper : mergedSortDetailList) {
            if (CheckUtils.isZero(dateExpectApplyValue)) break;
            QTLineDetail detail = detailWrapper.getSrc();
            boolean intersect = WTCDateUtils.hasIntersectionLCRC((Date)WTCDateUtils.getZeroDate((Date)beds.getDate()), (Date)WTCDateUtils.getDayLastDate((Date)beds.getDate()), (Date)detail.getUseStartDate(), (Date)detail.getUseEndDateDayLast());
            if (!intersect || QTDeductService.isUnUsableDetailType(detail, runtime)) continue;
            if (CheckUtils.isNonZero(dateExpectApplyValue) && CheckUtils.isPositive(detail.getUsableValue())) {
                if (QTDeductService.checkDetailImbalance(detail) && QTDeductService.reBalanceDetail(detail)) {
                    log.warn("deductBillEntry fail[batchNum={}]: QTDetail imbalance on tryDeductFromUsable. detail={}", (Object)runtime.getBatchNum(), (Object)detailWrapper.getSrc());
                    throw new IllegalStateException("QTDetail imbalance.");
                }
                runtime.markDirty(detail);
                BigDecimal actualApplyValue = QTDeductService.min(detail.getUsableValue(), dateExpectApplyValue);
                detail.setUsableValue(detail.getUsableValue().subtract(actualApplyValue));
                detail.setUsedValue(detail.getUsedValue().add(actualApplyValue));
                dateExpectApplyValue = dateExpectApplyValue.subtract(actualApplyValue);
                debrisAccumulator.addPoolDebris(billEntry.getEntryId(), detail.getId(), beds.getDate(), actualApplyValue);
            }
            if (!CheckUtils.isZero(dateExpectApplyValue)) continue;
            break;
        }
        return dateExpectApplyValue;
    }

    private static BigDecimal tryDeductFromOverdraw(BillApplyEntry billEntry, QTRuntime runtime, List<AffluentQTLineDetail> mergedSortDetailList, QTDRDebrisAccumulator debrisAccumulator, BillEntryDateSplit beds, BigDecimal dateExpectApplyValue) {
        for (AffluentQTLineDetail detailWrapper : mergedSortDetailList) {
            if (CheckUtils.isZero(dateExpectApplyValue)) break;
            QTLineDetail detail = detailWrapper.getSrc();
            boolean intersect = WTCDateUtils.hasIntersectionLCRC((Date)WTCDateUtils.getZeroDate((Date)beds.getDate()), (Date)WTCDateUtils.getDayLastDate((Date)beds.getDate()), (Date)detail.getUseStartDate(), (Date)detail.getUseEndDateDayLast());
            if (!intersect || QTDeductService.isUnUsableDetailType(detail, runtime)) continue;
            if (CheckUtils.isNonZero(dateExpectApplyValue) && CheckUtils.isPositive(detail.getCanBeOdValue())) {
                if (QTDeductService.checkDetailImbalance(detail) && QTDeductService.reBalanceDetail(detail)) {
                    log.warn("deductBillEntry fail[batchNum={}]: QTDetail imbalance on tryDeductFromOverdraw. detail={}", (Object)runtime.getBatchNum(), (Object)detailWrapper.getSrc());
                    throw new IllegalStateException("QTDetail imbalance.");
                }
                runtime.markDirty(detail);
                BigDecimal actualApplyValue = QTDeductService.min(detail.getCanBeOdValue(), dateExpectApplyValue);
                detail.setUseOdValue(detail.getUseOdValue().add(actualApplyValue));
                detail.setCanBeOdValue(detail.getCanBeOdValue().subtract(actualApplyValue));
                detail.setUsedValue(detail.getUsedValue().add(actualApplyValue));
                dateExpectApplyValue = dateExpectApplyValue.subtract(actualApplyValue);
                debrisAccumulator.addPoolDebris(billEntry.getEntryId(), detail.getId(), beds.getDate(), actualApplyValue);
            }
            if (!CheckUtils.isZero(dateExpectApplyValue)) continue;
            break;
        }
        return dateExpectApplyValue;
    }

    private static BigDecimal tryDeductFromOverUsable(BillApplyEntry billEntry, QTRuntime runtime, List<AffluentQTLineDetail> mergedSortDetailList, QTDRDebrisAccumulator debrisAccumulator, BillEntryDateSplit beds, BigDecimal dateExpectApplyValue) {
        for (AffluentQTLineDetail detailWrapper : mergedSortDetailList) {
            if (CheckUtils.isZero(dateExpectApplyValue)) break;
            QTLineDetail detail = detailWrapper.getSrc();
            boolean intersect = WTCDateUtils.hasIntersectionLCRC((Date)WTCDateUtils.getZeroDate((Date)beds.getDate()), (Date)WTCDateUtils.getDayLastDate((Date)beds.getDate()), (Date)detail.getUseStartDate(), (Date)detail.getUseEndDateDayLast());
            if (!intersect || QTDeductService.isUnUsableDetailType(detail, runtime)) continue;
            if (CheckUtils.isNonZero(dateExpectApplyValue)) {
                if (QTDeductService.checkDetailImbalance(detail) && QTDeductService.reBalanceDetail(detail)) {
                    log.warn("deductBillEntry fail[batchNum={}]: QTDetail imbalance on tryDeductFromOverUsable. detail={}", (Object)runtime.getBatchNum(), (Object)detailWrapper.getSrc());
                    throw new IllegalStateException("QTDetail imbalance.");
                }
                runtime.markDirty(detail);
                BigDecimal actualApplyValue = dateExpectApplyValue;
                detail.setUsableValue(detail.getUsableValue().subtract(actualApplyValue));
                detail.setUsedValue(detail.getUsedValue().add(actualApplyValue));
                dateExpectApplyValue = dateExpectApplyValue.subtract(actualApplyValue);
                debrisAccumulator.addPoolDebris(billEntry.getEntryId(), detail.getId(), beds.getDate(), actualApplyValue);
            }
            if (!CheckUtils.isZero(dateExpectApplyValue)) continue;
            break;
        }
        return dateExpectApplyValue;
    }

    private static void drainRemainValue(BillApplyEntry billEntry, QTRuntime runtime, List<AffluentQTLineDetail> mergedSortDetailList, QTDRDebrisAccumulator debrisAccumulator) {
        Date start = billEntry.getStartDate();
        Date endDate = billEntry.getEndDate();
        for (AffluentQTLineDetail detailWrapper : mergedSortDetailList) {
            QTLineDetail detail = detailWrapper.getSrc();
            boolean intersect = WTCDateUtils.hasIntersectionLCRC((Date)WTCDateUtils.getZeroDate((Date)start), (Date)WTCDateUtils.getDayLastDate((Date)endDate), (Date)detail.getUseStartDate(), (Date)detail.getUseEndDateDayLast());
            if (!intersect || QTDeductService.isUnUsableDetailType(detail, runtime)) continue;
            BigDecimal actualApplyValue = BigDecimal.ZERO;
            if (CheckUtils.isPositive(detail.getUsableValue())) {
                runtime.markDirty(detail);
                BigDecimal drainUsableValue = detail.getUsableValue();
                detail.setUsableValue(detail.getUsableValue().subtract(drainUsableValue));
                detail.setInvalidValue(detail.getInvalidValue().add(drainUsableValue));
                actualApplyValue = actualApplyValue.add(drainUsableValue);
            }
            if (CheckUtils.isPositive(detail.getCanBeOdValue())) {
                runtime.markDirty(detail);
                BigDecimal drainCanBeOdValue = detail.getCanBeOdValue();
                detail.setCanBeOdValue(detail.getCanBeOdValue().subtract(drainCanBeOdValue));
                detail.setInvalidValue(detail.getInvalidValue().add(drainCanBeOdValue));
                detail.setInvalidOdValue(detail.getInvalidOdValue().add(drainCanBeOdValue));
                actualApplyValue = actualApplyValue.add(drainCanBeOdValue);
            }
            if (!CheckUtils.isPositive(actualApplyValue)) continue;
            debrisAccumulator.addPoolInvalidDebris(billEntry.getEntryId(), detail.getId(), null, actualApplyValue);
        }
    }

    private static boolean isUnUsableDetailType(QTLineDetail detail, QTRuntime runtime) {
        return !detail.isUsableDetailSource() || CheckUtils.isNegative(detail.getOwnValue()) || !detail.isEffect();
    }

    private static Map<Long, QTDeductRule> initDeductRule(BillApply mainBill) {
        return QTDeductService.initDeductRule(Collections.singletonList(mainBill));
    }

    public static Map<Long, QTDeductRule> initDeductRule(List<BillApply> mainBillList) {
        List<Long> deductRuleVidList = mainBillList.stream().map(BillApply::getNonZeroDeductRuleVidList).flatMap(Collection::stream).collect(Collectors.toList());
        Map<Long, QTDeductRule> deductRuleMap = QTService.loadDeductRuleWithVId(deductRuleVidList);
        List lackDeductRuleEntry = mainBillList.stream().flatMap(ele -> ele.getEntryEntities().stream()).filter(billEntry -> billEntry.getDeductionRuleId() != 0L).filter(billEntry -> !deductRuleMap.containsKey(billEntry.getDeductionRuleId())).collect(Collectors.toList());
        if (!lackDeductRuleEntry.isEmpty()) {
            throw new KDBizException("detect some billEntry can't find it deduct rule. billEntryList=" + lackDeductRuleEntry);
        }
        return deductRuleMap;
    }

    private static List<QTLineDetail> initPool(BillApply mainBill, Map<Long, QTDeductRule> deductRuleMap) {
        return QTDeductService.initPool(mainBill.getAttFileBoId(), Collections.singletonList(mainBill), deductRuleMap);
    }

    public static List<QTLineDetail> initPool(long attFileBoId, List<BillApply> mainBillList, Map<Long, QTDeductRule> deductRuleMap) {
        Date[] dateRange = new Date[]{null, null};
        Set<Long> qtTypeIdSet = mainBillList.stream().flatMap(mainBill -> mainBill.getEntryEntities().stream()).map(billEntry -> {
            dateRange[0] = CheckUtils.getMinDate(dateRange[0], billEntry.getStartDate());
            dateRange[1] = CheckUtils.getMaxDate(dateRange[1], billEntry.getEndDate());
            return (QTDeductRule)deductRuleMap.get(billEntry.getDeductionRuleId());
        }).filter(Objects::nonNull).flatMap(deductRule -> deductRule.getDeductOrder().stream().map(QTType::getId)).collect(Collectors.toSet());
        return QTLineDetailDBService.loadLineDetail(attFileBoId, qtTypeIdSet, dateRange[0], dateRange[1]);
    }

    public static Map<Long, QTLineDetail> genExtraSlotMap(long billDealPK, QTRuntime runtime) {
        if (billDealPK == 0L) {
            return new HashMap<Long, QTLineDetail>(16);
        }
        QTBillDeal billDeal = runtime.getWaitStoreBillDeal(billDealPK);
        QTBillDeal qTBillDeal = billDeal = billDeal == null ? QTDealRecordDBService.loadBDByPK(billDealPK, true) : billDeal;
        if (billDeal == null) {
            return new HashMap<Long, QTLineDetail>(16);
        }
        Map<Long, QTLineDetail> extraSlotMap = QTDeductService.genExtraSlotMap(billDeal.getSrcPID(), runtime);
        for (QTBillEntryDeal bed : billDeal.getEntryDealList()) {
            for (QTBillEntryDealDetail bedDetail : bed.getDetailList()) {
                QTLineDetail ext;
                if (!DeductSource.fromPool(bedDetail.getDeductSource())) continue;
                long detailId = bedDetail.getQtSummaryDetailId();
                BigDecimal applyValue = bedDetail.getApplyValue();
                BigDecimal usableValue = (ext = extraSlotMap.computeIfAbsent(detailId, key -> {
                    QTLineDetail tmp = new QTLineDetail();
                    tmp.setId((long)key);
                    return tmp;
                })).getUsableValue();
                ext.setUsableValue(usableValue == null ? applyValue : usableValue.add(applyValue));
            }
        }
        return extraSlotMap;
    }

    private static MBApplyRes genSuccessMbApplyRes(BillApply mainBill) {
        ArrayList<SBApplyRes> tmp = new ArrayList<SBApplyRes>(mainBill.getEntryEntities().size());
        for (BillApplyEntry subBill : mainBill.getEntryEntities()) {
            tmp.add(SBApplyRes.success(subBill.getEntryId(), null));
        }
        return MBApplyRes.success(mainBill.getId(), tmp);
    }

    private static MBApplyRes genErrorMBApplyResFromBill(BillApply mainBill, String errCode, String msg) {
        return MBApplyRes.error(mainBill.getId(), errCode, msg, "A", null);
    }

    private static MBApplyRes genErrorMBApplyResFromEntry(BillApply mainBill, List<SBApplyRes> sbResList, SBApplyRes sbApplyRes, QTRuntime runtime) {
        ArrayList<SBApplyRes> tmp = new ArrayList<SBApplyRes>(sbResList);
        String errCode = sbApplyRes.getErrCode();
        String errMsg = "batchNum=" + runtime.getBatchNum() + ", " + sbApplyRes.getResultMsg();
        boolean beginFail = false;
        String otherErrMsg = "cause by previous entry[id=" + sbApplyRes.getBillId() + "]";
        for (BillApplyEntry subBill : mainBill.getEntryEntities()) {
            if (!beginFail && subBill.getEntryId() == sbApplyRes.getBillId()) {
                tmp.add(SBApplyRes.fail(subBill.getEntryId(), errCode, errMsg, sbApplyRes.getRetData()));
                beginFail = true;
                continue;
            }
            if (!beginFail) continue;
            tmp.add(SBApplyRes.fail(subBill.getEntryId(), "CAUSE_BY_PREVIOUS_ENTRY", otherErrMsg, null));
        }
        return MBApplyRes.error(mainBill.getId(), errCode, errMsg, "B", tmp);
    }

    private static MBApplyRes genErrorMBApplyResFromUnKnow(BillApply mainBill, String errCode, String msg) {
        return MBApplyRes.error(mainBill.getId(), errCode, msg, "C", null);
    }

    private static BigDecimal min(BigDecimal num1, BigDecimal num2) {
        return num1.compareTo(num2) < 0 ? num1 : num2;
    }

    private static QTBillEntryDeal genBED(long billDealId, BillApplyEntry entry, QTDeductRule deductRule) {
        BigDecimal applyValue = "D".equals(deductRule.getUnit()) ? entry.getVaTimeDay() : entry.getVaTimeHour();
        QTBillEntryDeal billEntryDeal = new QTBillEntryDeal();
        billEntryDeal.setPid(billDealId);
        billEntryDeal.setBillEntryId(entry.getEntryId());
        billEntryDeal.setDeductRuleId(entry.getDeductionRuleId());
        billEntryDeal.setApplyValue(applyValue);
        billEntryDeal.setApplyUnit(deductRule.getUnit());
        billEntryDeal.setStartDate(entry.getStartDate());
        billEntryDeal.setEndDate(entry.getEndDate());
        billEntryDeal.setDetailList(new ArrayList<QTBillEntryDealDetail>(16));
        return billEntryDeal;
    }

    private static QTBillDeal genBD(long srcID, long srcPID, String batchNum, BillApply mainBill, DealOperate dop, Date dbApplyTime, DealStatus dealStatus) {
        QTBillDeal mdr = new QTBillDeal();
        mdr.setSrcID(srcID);
        mdr.setSrcPID(srcPID);
        mdr.setBatchNum(batchNum);
        mdr.setAttFileBoId(mainBill.getAttFileBoId());
        mdr.setParentBillId(mainBill.getParentId());
        mdr.setBillId(mainBill.getId());
        mdr.setBillNumber(mainBill.getBillNo());
        mdr.setDealOperate(dop.name());
        mdr.setDealState(dealStatus.code);
        if (dbApplyTime != null) {
            mdr.setApplyTime(dbApplyTime);
        } else {
            mdr.setApplyTime(mainBill.getApplyTime());
        }
        mdr.setEntryDealList(new ArrayList<QTBillEntryDeal>(16));
        return mdr;
    }

    public static void coverApplyDate(List<BillApply> mainBillList, Map<Long, QTBillDeal> srcBillDealMap) {
        for (BillApply mainBill : mainBillList) {
            QTBillDeal srcBillDeal = srcBillDealMap.get(mainBill.getId());
            if (srcBillDeal == null) continue;
            mainBill.setApplyTime(srcBillDeal.getApplyTime());
        }
    }

    public static List<BillApply> getSortedMainBillList(List<BillApply> mainBillList) {
        ArrayList<BillApply> soredMainBillList = new ArrayList<BillApply>(mainBillList);
        soredMainBillList.sort((o1, o2) -> {
            long time1 = o1.getApplyTime().getTime();
            long time2 = o2.getApplyTime().getTime();
            return Long.compare(time1, time2);
        });
        return soredMainBillList;
    }

    public static class OPInfo {
        long srcBDId;
        DealOperate expectOp;

        public OPInfo(long srcBDId, DealOperate expectOp) {
            this.srcBDId = srcBDId;
            this.expectOp = expectOp;
        }
    }
}

