/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.cumulate.trading;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowUtil;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.cumulate.calculate.model.result.QTPool;
import kd.wtc.wtp.business.cumulate.trading.DateRange;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTLineDetailDBService {
    private static final Log log = LogFactory.getLog(QTLineDetailDBService.class);
    public static final HRBaseServiceHelper lineDetailDao = new HRBaseServiceHelper("wtp_qtlinedetail");
    public static final HRBaseServiceHelper lineDetailDaoHis = new HRBaseServiceHelper("wtp_qtlinedetailhis");
    public static List<String> SELECT = Arrays.asList("id", "org.id", "attfilebo.id", "attfileid.id", "qttype.id", "periodcircleid.id", "periodnum", "genstartdate", "genenddate", "usestartdate", "useenddate", "source", "busstatus", "initstatus", "balance", "balanceid.id", "nousegenvalue", "nousegenvalueid.id", "genvalue", "genvalueid.id", "genvalueid.attitemvid.id", "genvalueid.sourceattitemid", "genvalueid.crossstartdate", "genvalueid.crossenddate", "ownvalue", "ownvalueid.id", "ownvalueid.attitemvid.id", "ownvalueid.sourceattitemid", "usablevalue", "usablevalueid.id", "usablevalueid.attitemvid.id", "usablevalueid.sourceattitemid", "freezevalue", "freezevalueid.id", "usedvalue", "usedvalueid.id", "invalidvalue", "invalidvalueId.id", "ownodvalue", "ownodvalueid.id", "canbeodvalue", "canbeodvalueid.id", "frozenodvalue", "useodvalue", "useodvalueid.id", "invalidodvalue", "pastvalue", "pastvalueid.id", "cdedvalue", "cdedvalueid", "cdedvalueid.id", "cdedvalueid.vesttype", "cdedvalueid.usestartdate", "cdedvalueid.useenddate", "departvalue", "departvalueid.id", "cdcanbeodvalue", "blsuseodvalue", "settlementvalue", "slementvalueid.id", "qtdetailaddid.id", "detailsourceid.id", "gencondition", "modifytime", "creator.id", "createtime", "isdpconvert", "issettlement");
    public static final int USE_RANGE_LIMIT = 0;
    public static final int GEN_RANGE_LIMIT = 1;
    public static final int USE_AND_GEN_RANGE_LIMIT = 2;
    public static final int USE_OR_GEN_RANGE_LIMIT = 3;

    public static QFilter newCanUseBusStatusLineFilter() {
        return new QFilter("busstatus", "=", (Object)"0");
    }

    public static QFilter newCanUseInitStatusLineFilter() {
        return new QFilter("initstatus", "=", (Object)"2");
    }

    public static QFilter newQueryEffectLineFilter() {
        return QTLineDetailDBService.newCanUseBusStatusLineFilter().and(QTLineDetailDBService.newCanUseInitStatusLineFilter());
    }

    public static List<DynamicObject> loadLineDetailDyn(String selectField, long attFileBoId, List<Long> qtTypeIdList, DateRange range, int rangeQueryType, QFilter customFilter) {
        if (attFileBoId <= 0L) {
            return new ArrayList<DynamicObject>(16);
        }
        QFilter filter = new QFilter("attfilebo", "=", (Object)attFileBoId);
        QFilter rangeFilter = null;
        if (rangeQueryType == 0) {
            rangeFilter = range.getFilterIntersectionLCRC("usestartdate", "useenddate");
        } else if (rangeQueryType == 1) {
            rangeFilter = range.getFilterIntersectionLCRC("genstartdate", "genenddate");
        } else if (rangeQueryType == 2) {
            rangeFilter = range.getFilterIntersectionLCRC("usestartdate", "useenddate").and(range.getFilterIntersectionLCRC("genstartdate", "genenddate"));
        } else if (rangeQueryType == 3) {
            rangeFilter = range.getFilterIntersectionLCRC("usestartdate", "useenddate").or(range.getFilterIntersectionLCRC("genstartdate", "genenddate"));
        } else {
            throw new IllegalArgumentException("rangeQueryType can't be " + rangeQueryType);
        }
        filter.and(rangeFilter);
        if (qtTypeIdList != null && !qtTypeIdList.isEmpty()) {
            if (qtTypeIdList.size() == 1) {
                filter.and("qttype.id", "=", (Object)qtTypeIdList.get(0));
            } else {
                filter.and("qttype.id", "in", qtTypeIdList);
            }
        }
        if (customFilter != null) {
            filter.and(customFilter);
        }
        DynamicObject[] dynamicObjectArray = WTCStringUtils.isEmpty((String)selectField) ? lineDetailDao.loadDynamicObjectArray(filter.toArray()) : lineDetailDao.query(selectField, filter.toArray());
        return Arrays.asList(dynamicObjectArray);
    }

    public static List<QTLineDetail> loadDetailByLK(Collection<DetailLogicKey> keyList) {
        QFilter filter = null;
        for (DetailLogicKey key : keyList) {
            if (filter == null) {
                filter = key.toQFilter();
                continue;
            }
            filter.or(key.toQFilter());
        }
        if (filter != null) {
            DynamicObject[] arr = lineDetailDao.loadDynamicObjectArray(filter.toArray());
            return Arrays.stream(arr).map(QTLineDetailDBService::parseFromDyn).collect(Collectors.toList());
        }
        return new ArrayList<QTLineDetail>(16);
    }

    public static QTPool loadPool(DetailLogicKey key) {
        DynamicObject[] arr = lineDetailDao.query(String.join((CharSequence)",", SELECT), key.toQFilter().toArray());
        List<QTLineDetail> collect = Arrays.stream(arr).map(QTLineDetailDBService::parseFromDyn).collect(Collectors.toList());
        QTPool qtPool = new QTPool();
        qtPool.setLineDetailList(collect);
        qtPool.setAttFileBoId(key.getAttFileBoId());
        qtPool.setQtTypeId(key.getQtTypeId());
        return qtPool;
    }

    public static List<QTLineDetail> loadLineBatch(Collection<Long> attFileBoId, Collection<Long> qtTypeIdList, QFilter condition) {
        QFilter filter = new QFilter("attfilebo", "in", attFileBoId).and("qttype", "in", qtTypeIdList);
        if (condition != null) {
            filter.and(condition);
        }
        DynamicObject[] query = lineDetailDao.query(String.join((CharSequence)",", SELECT), filter.toArray());
        return Arrays.stream(query).map(QTLineDetailDBService::parseFromDyn).collect(Collectors.toList());
    }

    public static List<QTLineDetail> loadLineBatch(Collection<Long> attFileBoId, Collection<Long> qtTypeIdList, QFilter andCondition, QFilter orCondition) {
        QFilter filter = new QFilter("attfilebo", "in", attFileBoId).and("qttype", "in", qtTypeIdList);
        if (andCondition != null) {
            filter.and(andCondition);
        }
        if (orCondition != null) {
            filter.or(orCondition);
        }
        DynamicObject[] query = lineDetailDao.query(String.join((CharSequence)",", SELECT), filter.toArray());
        return Arrays.stream(query).map(QTLineDetailDBService::parseFromDyn).collect(Collectors.toList());
    }

    public static List<QTPool> loadPoolBatch(Collection<Long> attFileBoId, Collection<Long> qtTypeIdList, QFilter condition) {
        QFilter filter = new QFilter("attfilebo", "in", attFileBoId).and("qttype", "in", qtTypeIdList);
        if (condition != null) {
            filter.and(condition);
        }
        DynamicObject[] query = lineDetailDao.query(String.join((CharSequence)",", SELECT), filter.toArray());
        int size = attFileBoId.size() * 2;
        HashMap map = Maps.newHashMapWithExpectedSize((int)size);
        for (DynamicObject row : query) {
            QTLineDetail qtLineDetail;
            Long attBoId = row.getLong("attfilebo.id");
            QTPool qtPool = (QTPool)map.get(attBoId);
            if (null == qtPool) {
                qtPool = new QTPool();
                qtPool.setAttFileBoId(attBoId);
                qtLineDetail = QTLineDetailDBService.parseFromDyn(row);
                ArrayList qtLineDetails = Lists.newArrayListWithExpectedSize((int)3);
                qtLineDetails.add(qtLineDetail);
                qtPool.setLineDetailList(qtLineDetails);
                map.put(attBoId, qtPool);
                continue;
            }
            qtLineDetail = QTLineDetailDBService.parseFromDyn(row);
            qtPool.getLineDetailList().add(qtLineDetail);
        }
        return new ArrayList<QTPool>(map.values());
    }

    public static List<QTLineDetail> loadLineDetail(long attFileBoId, Collection<Long> qtTypeIdList, Date startDate, Date endDate) {
        List<DynamicObject> dynamicObjects = QTLineDetailDBService.queryLineDetail(null, attFileBoId, qtTypeIdList, startDate, endDate);
        return dynamicObjects.stream().map(QTLineDetailDBService::parseFromDyn).collect(Collectors.toList());
    }

    public static List<DynamicObject> queryLineDetail(String selectKey, long attFileBoId, Collection<Long> qtTypeIdList, Date startDate, Date endDate) {
        return QTLineDetailDBService.queryLineDetail(selectKey, attFileBoId, qtTypeIdList, startDate, endDate, null);
    }

    public static List<DynamicObject> queryLineDetail(String selectKey, long attFileBoId, Collection<Long> qtTypeIdList, Date startDate, Date endDate, QFilter customFilter) {
        QFilter qFilter = new QFilter("attfilebo", "=", (Object)attFileBoId).and("qttype", "in", qtTypeIdList);
        if (startDate != null) {
            qFilter.and("useenddate", ">=", (Object)WTCDateUtils.getZeroDate((Date)startDate));
        }
        if (endDate != null) {
            qFilter.and("usestartdate", "<=", (Object)endDate);
        }
        if (customFilter != null) {
            qFilter.and(customFilter);
        }
        DynamicObject[] dynArr = selectKey == null ? lineDetailDao.loadDynamicObjectArray(qFilter.toArray()) : lineDetailDao.query(selectKey, qFilter.toArray());
        return Arrays.asList(dynArr);
    }

    public static QTLineDetail loadLineDetail(Long pk) {
        QFilter qFilter = new QFilter("id", "=", (Object)pk);
        DynamicObject dyn = lineDetailDao.loadDynamicObject(qFilter);
        return QTLineDetailDBService.parseFromDyn(dyn);
    }

    public static DynamicObject loadLineDetailDyn(Long pk) {
        QFilter qFilter = new QFilter("id", "=", (Object)pk);
        return lineDetailDao.loadDynamicObject(qFilter);
    }

    public static Map<Long, QTLineDetail> loadLineDetail(Collection<Long> pkList) {
        QFilter qFilter = new QFilter("id", "in", pkList);
        DynamicObject[] arr = lineDetailDao.loadDynamicObjectArray(qFilter.toArray());
        HashMap<Long, QTLineDetail> res = new HashMap<Long, QTLineDetail>(arr.length);
        for (DynamicObject dyn : arr) {
            if (dyn == null) continue;
            QTLineDetail detail = QTLineDetailDBService.parseFromDyn(dyn);
            res.put(dyn.getLong("id"), detail);
        }
        return res;
    }

    public static Map<Long, DynamicObject> loadLineDetailDyn(Collection<Object> pkList) {
        QFilter qFilter = new QFilter("id", "in", pkList);
        DynamicObject[] arr = lineDetailDao.loadDynamicObjectArray(qFilter.toArray());
        HashMap<Long, DynamicObject> res = new HashMap<Long, DynamicObject>(arr.length);
        for (DynamicObject dyn : arr) {
            if (dyn == null) continue;
            res.put(dyn.getLong("id"), dyn);
        }
        return res;
    }

    public static void saveLineDetail(QTLineDetail detail) {
        QTLineDetailDBService.saveLineDetail(Collections.singletonList(detail));
    }

    public static void saveLineDetail(Collection<QTLineDetail> detailList) {
        DynamicObject[] dyn = (DynamicObject[])detailList.stream().map(QTLineDetailDBService::parseFromEntityWithDefaultCreatorId).toArray(DynamicObject[]::new);
        lineDetailDao.save(dyn);
        int i = 0;
        for (QTLineDetail detail : detailList) {
            detail.setId(dyn[i].getLong("id"));
            ++i;
        }
    }

    public static void saveOrUpdateLineDetail(QTLineDetail detail) {
        if (detail.getId() == 0L) {
            QTLineDetailDBService.saveLineDetail(detail);
        } else {
            DynamicObject dbDetail = QTLineDetailDBService.loadLineDetailDyn(detail.getId());
            if (dbDetail == null) {
                QTLineDetailDBService.saveLineDetail(detail);
            } else {
                QTLineDetailDBService.copyAttr(detail, dbDetail);
                lineDetailDao.updateOne(dbDetail);
            }
        }
    }

    public static void deleteByPK(Collection<Long> pkList) {
        QFilter qFilter = new QFilter("id", "in", pkList);
        DynamicObject[] srcObj = lineDetailDao.loadDynamicObjectArray(qFilter.toArray());
        DynamicObject[] needSaveObj = new DynamicObject[srcObj.length];
        for (int i = 0; i < srcObj.length; ++i) {
            needSaveObj[i] = lineDetailDaoHis.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)srcObj[i], (DynamicObject)needSaveObj[i]);
        }
        lineDetailDaoHis.save(needSaveObj);
        lineDetailDao.deleteByFilter(qFilter.toArray());
    }

    public static void saveOrUpdateLineDetail(Collection<QTLineDetail> detailList) {
        List<QTLineDetail> shouldSaveDetailList = detailList.stream().filter(ele -> ele.getId() == 0L).collect(Collectors.toList());
        List wantUpdateDetailList = detailList.stream().filter(ele -> ele.getId() != 0L).collect(Collectors.toList());
        List<Object> wantUpdateDetailIDList = wantUpdateDetailList.stream().map(QTLineDetail::getId).collect(Collectors.toList());
        Map<Long, DynamicObject> dbDetailMap = QTLineDetailDBService.loadLineDetailDyn(wantUpdateDetailIDList);
        ArrayList<DynamicObject> shouldUpdateDetailList = new ArrayList<DynamicObject>(16);
        Iterator iterator = wantUpdateDetailList.iterator();
        while (iterator.hasNext()) {
            QTLineDetail detail = (QTLineDetail)iterator.next();
            DynamicObject dbDetail = dbDetailMap.get(detail.getId());
            if (dbDetail == null) {
                shouldSaveDetailList.add(detail);
                iterator.remove();
                continue;
            }
            QTLineDetailDBService.copyAttr(detail, dbDetail);
            shouldUpdateDetailList.add(dbDetail);
        }
        QTLineDetailDBService.saveLineDetail(shouldSaveDetailList);
        lineDetailDao.update(shouldUpdateDetailList.toArray(new DynamicObject[0]));
    }

    public static QTLineDetail parseFromDyn(DynamicObject dyn) {
        if (dyn == null) {
            return null;
        }
        QTLineDetail detail = new QTLineDetail();
        QTLineDetailDBService.copyAttr(dyn, detail);
        return detail;
    }

    public static QTLineDetail parseFromDateSet(Row dyn) {
        if (dyn == null) {
            return null;
        }
        QTLineDetail detail = new QTLineDetail();
        try {
            QTLineDetailDBService.copyAttr(dyn, detail);
        }
        catch (Exception e) {
            Field[] fields = ((AbstractRow)dyn).getRowMeta().getFields();
            log.info("parseFromDateSet_error_fields_{}_rowMap_{} ", (Object)fields, (Object)RowUtil.toMap((Row)dyn));
            log.warn((Throwable)e);
            throw e;
        }
        return detail;
    }

    public static DynamicObject parseFromEntity(QTLineDetail entity) {
        if (entity == null) {
            return null;
        }
        DynamicObject res = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtp_qtlinedetail"));
        QTLineDetailDBService.copyAttr(entity, res);
        return res;
    }

    public static DynamicObject parseFromEntityWithDefaultCreatorId(QTLineDetail entity) {
        DynamicObject res = QTLineDetailDBService.parseFromEntity(entity);
        if (res == null) {
            return null;
        }
        res.set("creator", (Object)RequestContext.get().getCurrUserId());
        return res;
    }

    private static void copyAttr(DynamicObject from, QTLineDetail to) {
        to.setId(from.getLong("id"));
        to.setOrgId(from.getLong("org.id"));
        to.setAttFileBoId(from.getLong("attfilebo.id"));
        to.setAttFileVid(from.getLong("attfileid.id"));
        to.setQtTypeId(from.getLong("qttype.id"));
        to.setpCycleId(from.getLong("periodcircleid.id"));
        to.setPeriodNum(from.getInt("periodnum"));
        to.setGenStartDate(from.getDate("genstartdate"));
        to.setGenEndDate(from.getDate("genenddate"));
        to.setUseStartDate(from.getDate("usestartdate"));
        to.setUseEndDate(from.getDate("useenddate"));
        to.setSource(from.getString("source"));
        to.setGenValue(from.getBigDecimal("genvalue"));
        to.setOwnValue(from.getBigDecimal("ownvalue"));
        to.setOwnOdValue(from.getBigDecimal("ownodvalue"));
        to.setNoUseGenValue(from.getBigDecimal("nousegenvalue"));
        to.setPastValue(from.getBigDecimal("pastvalue"));
        to.setBalance(from.getBigDecimal("balance"));
        to.setCarryDownedValue(from.getBigDecimal("cdedvalue"));
        to.setCdCanBeOdValue(from.getBigDecimal("cdcanbeodvalue"));
        to.setUsableValue(from.getBigDecimal("usablevalue"));
        to.setFreezeValue(from.getBigDecimal("freezevalue"));
        to.setUsedValue(from.getBigDecimal("usedvalue"));
        to.setInvalidValue(from.getBigDecimal("invalidvalue"));
        to.setCanBeOdValue(from.getBigDecimal("canbeodvalue"));
        to.setFrozenOdValue(from.getBigDecimal("frozenodvalue"));
        to.setUseOdValue(from.getBigDecimal("useodvalue"));
        to.setInvalidOdValue(from.getBigDecimal("invalidodvalue"));
        to.setGenValueId(from.getLong("genvalueid.id"));
        to.setOrignUseStartDate(from.getDate("genvalueid.usestartdate"));
        to.setOrignEndStartDate(from.getDate("genvalueid.useenddate"));
        to.setOwnValueId(from.getLong("ownvalueid.id"));
        to.setOwnOdValueId(from.getLong("ownodvalueid.id"));
        to.setNoUseGenValueId(from.getLong("nousegenvalueid.id"));
        to.setPastValueId(from.getLong("pastvalueid.id"));
        to.setBalanceId(from.getLong("balanceid.id"));
        to.setCarryDownedValueId(from.getLong("cdedvalueid.id"));
        to.setVestType(from.getString("cdedvalueid.vesttype"));
        to.setUsableValueId(from.getLong("usablevalueid.id"));
        to.setFreezeValueId(from.getLong("freezevalueid.id"));
        to.setUsedValueId(from.getLong("usedvalueid.id"));
        to.setInvalidValueId(from.getLong("invalidvalueId.id"));
        to.setCanBeOdValueId(from.getLong("canbeodvalueid.id"));
        to.setUseOdValueId(from.getLong("useodvalueid.id"));
        to.setGenItemBid(from.getLong("genvalueid.sourceattitemid"));
        to.setOwnValueItemBid(from.getLong("ownvalueid.sourceattitemid"));
        to.setCrossStartdate(from.getDate("genvalueid.crossstartdate"));
        to.setCrossEnddate(from.getDate("genvalueid.crossenddate"));
        to.setUsableValueAttItemVid(from.getLong("usablevalueid.attitemvid.id"));
        to.setUsablevalueItemBid(from.getLong("usablevalueid.sourceattitemid"));
        to.setCarryDownedStart(from.getDate("cdedvalueid.usestartdate"));
        to.setCarryDownedend(from.getDate("cdedvalueid.useenddate"));
        to.setDepartValue(from.getBigDecimal("departvalue"));
        to.setDepartValueItemId(from.getLong("departvalueid.id"));
        to.setQtDetailAddId(from.getLong("qtdetailaddid.id"));
        to.setBusstatus(from.getString("busstatus"));
        to.setInitstatus(from.getString("initstatus"));
        to.setModifyTime(from.getDate("modifytime"));
        to.setCreateTime(from.getDate("createtime"));
        to.setCreatorId(from.getLong("creator.id"));
        to.setDetailSourceId(from.getLong("detailsourceid.id"));
        to.setSettlementValue(from.getBigDecimal("settlementvalue"));
        to.setSettlementValueId(from.getLong("slementvalueid.id"));
        to.setBalanceUseOdValue(from.getBigDecimal("blsuseodvalue"));
        to.setDpConvert(from.getBoolean("isdpconvert"));
        to.setSettlement(from.getBoolean("issettlement"));
        to.setGenConditionStr(from.getString("gencondition"));
    }

    private static void copyAttr(Row from, QTLineDetail to) {
        to.setId(from.getLong("id"));
        to.setOrgId(from.getLong("org.id"));
        to.setAttFileBoId(from.getLong("attfilebo.id"));
        to.setAttFileVid(from.getLong("attfileid.id"));
        to.setQtTypeId(from.getLong("qttype.id"));
        to.setpCycleId(from.getLong("periodcircleid.id"));
        to.setPeriodNum(from.getInteger("periodnum"));
        to.setGenStartDate(from.getDate("genstartdate"));
        to.setGenEndDate(from.getDate("genenddate"));
        to.setUseStartDate(from.getDate("usestartdate"));
        to.setUseEndDate(from.getDate("useenddate"));
        to.setSource(from.getString("source"));
        to.setGenValue(from.getBigDecimal("genvalue"));
        to.setOwnValue(from.getBigDecimal("ownvalue"));
        to.setOwnOdValue(from.getBigDecimal("ownodvalue"));
        to.setNoUseGenValue(from.getBigDecimal("nousegenvalue"));
        to.setPastValue(from.getBigDecimal("pastvalue"));
        to.setBalance(from.getBigDecimal("balance"));
        to.setCarryDownedValue(from.getBigDecimal("cdedvalue"));
        to.setCdCanBeOdValue(from.getBigDecimal("cdcanbeodvalue"));
        to.setVestType(from.getString("cdedvalueid.vesttype"));
        to.setUsableValue(from.getBigDecimal("usablevalue"));
        to.setFreezeValue(from.getBigDecimal("freezevalue"));
        to.setUsedValue(from.getBigDecimal("usedvalue"));
        to.setInvalidValue(from.getBigDecimal("invalidvalue"));
        to.setCanBeOdValue(from.getBigDecimal("canbeodvalue"));
        to.setFrozenOdValue(from.getBigDecimal("frozenodvalue"));
        to.setUseOdValue(from.getBigDecimal("useodvalue"));
        to.setInvalidOdValue(from.getBigDecimal("invalidodvalue"));
        to.setGenValueId(from.getLong("genvalueid.id"));
        to.setOrignUseStartDate(from.getDate("genvalueid.usestartdate"));
        to.setOrignEndStartDate(from.getDate("genvalueid.useenddate"));
        to.setOwnValueId(from.getLong("ownvalueid.id"));
        to.setOwnOdValueId(from.getLong("ownodvalueid.id"));
        to.setNoUseGenValueId(from.getLong("nousegenvalueid.id"));
        to.setPastValueId(from.getLong("pastvalueid.id"));
        to.setBalanceId(from.getLong("balanceid.id"));
        to.setCarryDownedValueId(from.getLong("cdedvalueid") == 0L ? 0L : from.getLong("cdedvalueid.id"));
        to.setUsableValueId(from.getLong("usablevalueid.id"));
        to.setFreezeValueId(from.getLong("freezevalueid.id"));
        to.setUsedValueId(from.getLong("usedvalueid.id"));
        to.setInvalidValueId(from.getLong("invalidvalueId.id"));
        to.setCanBeOdValueId(from.getLong("canbeodvalueid.id"));
        to.setUseOdValueId(from.getLong("useodvalueid.id"));
        to.setGenItemBid(from.getLong("genvalueid.sourceattitemid"));
        to.setOwnValueItemBid(from.getLong("ownvalueid.sourceattitemid"));
        to.setUsableValueAttItemVid(from.getLong("usablevalueid.attitemvid.id"));
        to.setUsablevalueItemBid(from.getLong("usablevalueid.sourceattitemid"));
        to.setCrossStartdate(from.getDate("genvalueid.crossstartdate"));
        to.setCrossEnddate(from.getDate("genvalueid.crossenddate"));
        to.setCarryDownedStart(from.getDate("cdedvalueid.usestartdate"));
        to.setCarryDownedend(from.getDate("cdedvalueid.useenddate"));
        to.setDepartValue(from.getBigDecimal("departvalue"));
        to.setDepartValueItemId(from.getLong("departvalueid.id"));
        to.setQtDetailAddId(from.getLong("qtdetailaddid.id"));
        to.setBusstatus(from.getString("busstatus"));
        to.setInitstatus(from.getString("initstatus"));
        to.setModifyTime(from.getDate("modifytime"));
        to.setCreateTime(from.getDate("createtime"));
        to.setCreatorId(from.getLong("creator.id"));
        to.setDetailSourceId(from.getLong("detailsourceid.id"));
        to.setSettlementValue(from.getBigDecimal("settlementvalue"));
        to.setSettlementValueId(from.getLong("slementvalueid.id"));
        to.setDpConvert(from.getBoolean("isdpconvert"));
        to.setSettlement(from.getBoolean("issettlement"));
        to.setGenConditionStr(from.getString("gencondition"));
    }

    public static void copyAttr(QTLineDetail from, DynamicObject to) {
        to.set("id", (Object)from.getId());
        to.set("org", (Object)from.getOrgId());
        to.set("attfilebo", (Object)from.getAttFileBoId());
        to.set("attfileid", (Object)from.getAttFileVid());
        to.set("qttype", (Object)from.getQtTypeId());
        to.set("periodcircleid", (Object)from.getpCycleId());
        to.set("periodnum", (Object)from.getPeriodNum());
        to.set("genstartdate", (Object)from.getGenStartDate());
        to.set("genenddate", (Object)from.getGenEndDate());
        to.set("usestartdate", (Object)from.getUseStartDate());
        to.set("useenddate", (Object)from.getUseEndDate());
        to.set("source", (Object)from.getSource());
        to.set("genvalue", (Object)from.getGenValue());
        to.set("ownvalue", (Object)from.getOwnValue());
        to.set("ownodvalue", (Object)from.getOwnOdValue());
        to.set("nousegenvalue", (Object)from.getNoUseGenValue());
        to.set("pastvalue", (Object)from.getPastValue());
        to.set("balance", (Object)from.getBalance());
        to.set("cdedvalue", (Object)from.getCarryDownedValue());
        to.set("cdcanbeodvalue", (Object)from.getCdCanBeOdValue());
        to.set("usablevalue", (Object)from.getUsableValue());
        to.set("freezevalue", (Object)from.getFreezeValue());
        to.set("usedvalue", (Object)from.getUsedValue());
        to.set("invalidvalue", (Object)from.getInvalidValue());
        to.set("canbeodvalue", (Object)from.getCanBeOdValue());
        to.set("frozenodvalue", (Object)from.getFrozenOdValue());
        to.set("useodvalue", (Object)from.getUseOdValue());
        to.set("invalidodvalue", (Object)from.getInvalidOdValue());
        to.set("genvalueid", (Object)from.getGenValueId());
        to.set("ownvalueid", (Object)from.getOwnValueId());
        to.set("ownodvalueid", (Object)from.getOwnOdValueId());
        to.set("nousegenvalueid", (Object)from.getNoUseGenValueId());
        to.set("pastvalueid", (Object)from.getPastValueId());
        to.set("balanceid", (Object)from.getBalanceId());
        to.set("cdedvalueid", (Object)from.getCarryDownedValueId());
        to.set("usablevalueid", (Object)from.getUsableValueId());
        to.set("freezevalueid", (Object)from.getFreezeValueId());
        to.set("usedvalueid", (Object)from.getUsedValueId());
        to.set("invalidvalueid", (Object)from.getInvalidValueId());
        to.set("canbeodvalueid", (Object)from.getCanBeOdValueId());
        to.set("useodvalueid", (Object)from.getUseOdValueId());
        to.set("departvalue", (Object)from.getDepartValue());
        to.set("departvalueid", (Object)from.getDepartValueItemId());
        to.set("qtdetailaddid", (Object)from.getQtDetailAddId());
        to.set("busstatus", (Object)from.getBusstatus());
        to.set("initstatus", (Object)from.getInitstatus());
        to.set("detailsourceid", (Object)from.getDetailSourceId());
        to.set("settlementvalue", (Object)from.getSettlementValue());
        to.set("slementvalueid", (Object)from.getSettlementValueId());
        to.set("blsuseodvalue", (Object)from.getBalanceUseOdValue());
        to.set("isdpconvert", (Object)from.isDpConvert());
        to.set("issettlement", (Object)from.isSettlement());
        to.set("gencondition", (Object)from.getGenConditionStr());
        if (from.getCreatorId() != 0L) {
            to.set("creator", (Object)from.getCreatorId());
        }
        to.set("periodcircleid_id", (Object)from.getpCycleId());
        to.set("usablevalueid_id", (Object)from.getUsableValueId());
        to.set("ownvalueid_id", (Object)from.getOwnValueId());
    }

    public static void deleteAllDealByFileBoId(Collection<Long> fileBoIds) {
        DynamicObject[] preSlementDys;
        QFilter qFilter = new QFilter("attfilebo", "in", fileBoIds);
        qFilter.and(new QFilter("source", "=", (Object)"DT-005"));
        DynamicObject[] dys = lineDetailDao.query("detailsourceid", qFilter.toArray());
        HashSet<Long> detailIds = new HashSet<Long>(dys.length);
        for (DynamicObject dynamicObject : dys) {
            detailIds.add(dynamicObject.getLong("detailsourceid.id"));
        }
        QFilter slementQFilter = new QFilter("id", "in", detailIds);
        DynamicObject[] slementDys = lineDetailDao.query("attfilebo", slementQFilter.toArray());
        HashSet<Long> preAttFileBoidIds = new HashSet<Long>(slementDys.length);
        for (DynamicObject dy : slementDys) {
            preAttFileBoidIds.add(dy.getLong("attfilebo.boid"));
        }
        QFilter qFilter2 = new QFilter("attfilebo", "in", preAttFileBoidIds);
        qFilter2.and(new QFilter("issettlement", "=", (Object)"1"));
        for (DynamicObject dy : preSlementDys = lineDetailDao.query("issettlement", qFilter2.toArray())) {
            dy.set("issettlement", (Object)"0");
        }
        lineDetailDao.update(preSlementDys);
        lineDetailDao.deleteByFilter(new QFilter("attfilebo", "in", fileBoIds).toArray());
        lineDetailDaoHis.deleteByFilter(new QFilter("attfilebo", "in", fileBoIds).toArray());
    }
}

