/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.cumulate.trading;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.model.DateRange;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtp.common.model.personhome.QuotaIndexQueryDto;
import kd.wtc.wtp.common.model.teamhome.TeamQuotaIndexQueryDto;

public class QTLineDetailOuterService {
    public static List<String> SELECT = Arrays.asList("id", "org.id", "attfilebo.id", "attfilebo.attperson.id", "attfileid.id", "attfileid.affiliateadminorg.id", "qttype.id", "qttype.name", "usestartdate", "useenddate", "genvalue", "genvalueid.id", "genvalueid.attitemvid.id", "ownvalue", "ownvalueid.id", "ownvalueid.attitemvid.id", "ownodvalue", "ownodvalueid.id", "ownodvalueid.attitemvid.id", "nousegenvalue", "nousegenvalueid.id", "nousegenvalueid.attitemvid.id", "pastvalue", "pastvalueid.id", "pastvalueid.attitemvid.id", "balance", "balanceid.id", "balanceid.attitemvid.id", "cdedvalue", "cdedvalueid.id", "cdedvalueid.attitemvid.id", "usablevalue", "usablevalueid.id", "usablevalueid.attitemvid.id", "freezevalue", "freezevalueid.id", "freezevalueid.attitemvid.id", "usedvalue", "usedvalueid.id", "usedvalueid.attitemvid.id", "canbeodvalue", "canbeodvalueid.id", "canbeodvalueid.attitemvid.id", "useodvalue", "useodvalueid.id", "useodvalueid.attitemvid.id", "frozenodvalue", "invalidvalue", "invalidvalueId.id", "invalidodvalue");
    public static List<String> countFieldList = Arrays.asList("ownvalue", "usablevalue", "freezevalue", "usedvalue", "canbeodvalue", "useodvalue", "cdedvalue", "pastvalue");
    public static final String itemSuffix = "id.attitemvid.id";

    private static void fillArgs(Map<Long, List<Long>> indexIdAndAttItemIdListMap, Map<Long, List<Long>> reverseMap, Set<Long> attItemBoIdSet) {
        for (Map.Entry<Long, List<Long>> entry : indexIdAndAttItemIdListMap.entrySet()) {
            for (Long attItemBoId : entry.getValue()) {
                List indexIdList = reverseMap.computeIfAbsent(attItemBoId, key -> new ArrayList(16));
                indexIdList.add(entry.getKey());
                attItemBoIdSet.add(attItemBoId);
            }
        }
    }

    public static void queryByTeamQuotaIndexQueryDto(TeamQuotaIndexQueryDto req) {
        if (req.isQueryByFileBoId() && WTCCollections.isEmpty((Collection)req.getFileBoIdList()) || !req.isQueryByFileBoId() && WTCCollections.isEmpty((Collection)req.getPersonIdList()) || req.getStartDate() == null || req.getEndDate() == null || WTCCollections.isEmpty((Map)req.getIndexIdAndAttItemIdListMap())) {
            req.setPersonIdAndIndexWithValue(new HashMap(16));
            req.setIndexIdAndQuotaDetailIdListMap(new HashMap(16));
            return;
        }
        Map indexIdAndAttItemIdListMap = req.getIndexIdAndAttItemIdListMap();
        HashMap<Long, List<Long>> reverseMap = new HashMap<Long, List<Long>>(16);
        HashSet<Long> attItemBoIdSet = new HashSet<Long>(16);
        QTLineDetailOuterService.fillArgs(indexIdAndAttItemIdListMap, reverseMap, attItemBoIdSet);
        Map<Long, Long> attItemMap = QTLineDetailOuterService.genItemVidToBoIdMap(attItemBoIdSet);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(16);
        if (req.isQueryByFileBoId()) {
            filterList.add(new QFilter("attfilebo.id", "in", (Object)req.getFileBoIdList()));
        } else {
            filterList.add(new QFilter("attfilebo.attperson.id", "in", (Object)req.getPersonIdList()));
        }
        filterList.add(new QFilter("attfileid.affiliateadminorg.id", "=", (Object)req.getAdminOrgId()));
        filterList.add(DateRange.range((Date)req.getStartDate(), (Date)req.getEndDate()).getFilterIntersectionLCRC("usestartdate", "useenddate"));
        filterList.add(QTLineDetailDBService.newQueryEffectLineFilter());
        DynamicObject[] lineDetailArr = QTLineDetailDBService.lineDetailDao.query(String.join((CharSequence)",", SELECT), filterList.toArray(new QFilter[0]));
        HashMap<Long, Map<Long, BigDecimal>> resMap = new HashMap<Long, Map<Long, BigDecimal>>(16);
        HashMap<Long, Map<Long, Set<Long>>> clueMap = new HashMap<Long, Map<Long, Set<Long>>>(16);
        for (DynamicObject lineDetail : lineDetailArr) {
            for (String field : countFieldList) {
                QTLineDetailOuterService.collectDetailInfoBatch(resMap, clueMap, reverseMap, attItemMap, lineDetail, field);
            }
        }
        req.setPersonIdAndIndexWithValue(resMap);
        req.setIndexIdAndQuotaDetailIdListMap(clueMap);
    }

    private static Map<Long, Long> genItemVidToBoIdMap(Set<Long> attItemBoIdSet) {
        DynamicObject[] attItemArr;
        HashMap<Long, Long> attItemMap = new HashMap<Long, Long>(16);
        HRBaseServiceHelper attItemDao = new HRBaseServiceHelper("wtbd_attitem");
        QFilter qFilter = new QFilter("boid", "in", attItemBoIdSet);
        for (DynamicObject attItem : attItemArr = attItemDao.query("id,boid", qFilter.toArray())) {
            attItemMap.put(attItem.getLong("id"), attItem.getLong("boid"));
        }
        return attItemMap;
    }

    private static void collectDetailInfoBatch(Map<Long, Map<Long, BigDecimal>> resMap, Map<Long, Map<Long, Set<Long>>> personClueMap, Map<Long, List<Long>> reverseMap, Map<Long, Long> attItemMap, DynamicObject lineDetail, String field) {
        long attPersonId = lineDetail.getLong("attfilebo.attperson.id");
        long lineDetailId = lineDetail.getLong("id");
        BigDecimal itemValue = lineDetail.getBigDecimal(field);
        long attItemVId = lineDetail.getLong(field + itemSuffix);
        List<Long> indexIdList = reverseMap.get(attItemMap.get(attItemVId));
        if (WTCCollections.isNotEmpty(indexIdList)) {
            Map personResMap = resMap.computeIfAbsent(attPersonId, key -> new HashMap(16));
            Map clueMap = personClueMap.computeIfAbsent(attPersonId, key -> new HashMap(16));
            for (Long indexId : indexIdList) {
                BigDecimal sum = personResMap.computeIfAbsent(indexId, key -> BigDecimal.ZERO);
                personResMap.put(indexId, sum.add(itemValue));
                Set lineDetailIds = clueMap.computeIfAbsent(indexId, key -> new HashSet(16));
                lineDetailIds.add(lineDetailId);
            }
        }
    }

    public static void queryByQuotaIndexQueryDto(QuotaIndexQueryDto req) {
        if (req.isQueryByFileBoId() && req.getPersonFileBoIdList() == null || !req.isQueryByFileBoId() && req.getPersonId() == null || req.getStartDate() == null || req.getEndDate() == null || WTCCollections.isEmpty((Map)req.getIndexIdAndAttItemIdListMap())) {
            req.setIndexIdAndValueMap(new HashMap(16));
            req.setIndexIdAndQuotaDetailIdListMap(new HashMap(16));
            return;
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(16);
        if (req.isQueryByFileBoId()) {
            filterList.add(new QFilter("attfilebo.id", "in", (Object)req.getPersonFileBoIdList()));
        } else {
            filterList.add(new QFilter("attfilebo.attperson.id", "=", (Object)req.getPersonId()));
        }
        filterList.add(DateRange.range((Date)req.getStartDate(), (Date)req.getEndDate()).getFilterIntersectionLCRC("usestartdate", "useenddate"));
        if (WTCStringUtils.isNotEmpty((String)req.getQuotaName())) {
            filterList.add(new QFilter("qttype.name", "like", (Object)req.getQuotaName()));
        }
        filterList.add(QTLineDetailDBService.newQueryEffectLineFilter());
        DynamicObject[] lineDetailArr = QTLineDetailDBService.lineDetailDao.query(String.join((CharSequence)",", SELECT), filterList.toArray(new QFilter[0]));
        HashMap<Long, BigDecimal> resMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, Set<Long>> clueMap = new HashMap<Long, Set<Long>>(16);
        Map indexIdAndAttItemIdListMap = req.getIndexIdAndAttItemIdListMap();
        HashMap<Long, List<Long>> reverseMap = new HashMap<Long, List<Long>>(16);
        HashSet<Long> attItemBoIdSet = new HashSet<Long>(16);
        for (Map.Entry entry : indexIdAndAttItemIdListMap.entrySet()) {
            for (Long attItemBoId : (List)entry.getValue()) {
                List indexIdList = reverseMap.computeIfAbsent(attItemBoId, key -> new ArrayList(16));
                indexIdList.add(entry.getKey());
                attItemBoIdSet.add(attItemBoId);
            }
        }
        Map<Long, Long> attItemMap = QTLineDetailOuterService.genItemVidToBoIdMap(attItemBoIdSet);
        for (DynamicObject lineDetail : lineDetailArr) {
            for (String field : countFieldList) {
                QTLineDetailOuterService.collectDetailInfo(resMap, clueMap, reverseMap, attItemMap, lineDetail, field);
            }
        }
        req.setIndexIdAndValueMap(resMap);
        req.setIndexIdAndQuotaDetailIdListMap(clueMap);
    }

    private static void collectDetailInfo(Map<Long, BigDecimal> resMap, Map<Long, Set<Long>> clueMap, Map<Long, List<Long>> reverseMap, Map<Long, Long> attItemMap, DynamicObject lineDetail, String field) {
        long lineDetailId = lineDetail.getLong("id");
        BigDecimal itemValue = lineDetail.getBigDecimal(field);
        long attItemVId = lineDetail.getLong(field + itemSuffix);
        List<Long> indexIdList = reverseMap.get(attItemMap.get(attItemVId));
        if (WTCCollections.isNotEmpty(indexIdList)) {
            for (Long indexId : indexIdList) {
                BigDecimal sum = resMap.computeIfAbsent(indexId, key -> BigDecimal.ZERO);
                resMap.put(indexId, sum.add(itemValue));
                Set lineDetailIds = clueMap.computeIfAbsent(indexId, key -> new HashSet(16));
                lineDetailIds.add(lineDetailId);
            }
        }
    }
}

