/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.cumulate.trading;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.wtc.wtbs.common.deduction.usable.AffluentUsableQuotaInfo;
import kd.wtc.wtbs.common.deduction.usable.UsableQuotaInfo;
import kd.wtc.wtp.business.cumulate.trading.model.AffluentQTLineDetail;

public final class QTOuterParamUtils {
    public static final String ENTRY_UNIT_DAY = "A";
    public static final String ENTRY_UNIT_HOUR = "B";

    public static String convert2OuterBillUnit(String qtUnit) {
        if ("D".equals(qtUnit)) {
            return ENTRY_UNIT_DAY;
        }
        if ("H".equals(qtUnit)) {
            return ENTRY_UNIT_HOUR;
        }
        throw new IllegalStateException("can not support qtUnit: " + qtUnit);
    }

    public static AffluentUsableQuotaInfo parse2AffluentUsableQuotaInfo(AffluentQTLineDetail detailWrapper, String qtUnit) {
        AffluentUsableQuotaInfo info = new AffluentUsableQuotaInfo();
        info.setExtraValue(detailWrapper.getExtraValue());
        info.setQtTypeId(detailWrapper.getSrc().getQtTypeId());
        info.setOwnValue(detailWrapper.getSrc().getOwnValue());
        info.setUsableValue(detailWrapper.getSrc().getUsableValue());
        info.setFreezeValue(detailWrapper.getSrc().getFreezeValue());
        info.setUsedValue(detailWrapper.getSrc().getUsedValue());
        info.setInvalidValue(detailWrapper.getSrc().getInvalidValue());
        info.setCanBeOdValue(detailWrapper.getSrc().getCanBeOdValue());
        info.setFrozenOdValue(detailWrapper.getSrc().getFrozenOdValue());
        info.setUseOdValue(detailWrapper.getSrc().getUseOdValue());
        info.setInvalidOdValue(detailWrapper.getSrc().getInvalidOdValue());
        info.setUnit(QTOuterParamUtils.convert2OuterBillUnit(qtUnit));
        info.setUseStartDate(detailWrapper.getSrc().getUseStartDate());
        info.setUseEndDate(detailWrapper.getSrc().getUseEndDate());
        return info;
    }

    public static UsableQuotaInfo parse2UsableQuotaInfo(DynamicObject detail, String qtUnit) {
        UsableQuotaInfo info = new UsableQuotaInfo();
        info.setQtTypeId(detail.getLong("qttype.id"));
        info.setOwnValue(detail.getBigDecimal("ownvalue"));
        info.setUsableValue(detail.getBigDecimal("usablevalue"));
        info.setFreezeValue(detail.getBigDecimal("freezevalue"));
        info.setUsedValue(detail.getBigDecimal("usedvalue"));
        info.setInvalidValue(detail.getBigDecimal("invalidvalue"));
        info.setCanBeOdValue(detail.getBigDecimal("canbeodvalue"));
        info.setFrozenOdValue(detail.getBigDecimal("frozenodvalue"));
        info.setUseOdValue(detail.getBigDecimal("useodvalue"));
        info.setInvalidOdValue(detail.getBigDecimal("invalidodvalue"));
        info.setUnit(QTOuterParamUtils.convert2OuterBillUnit(qtUnit));
        info.setUseStartDate(detail.getDate("usestartdate"));
        info.setUseEndDate(detail.getDate("useenddate"));
        return info;
    }

    public static <T> List<T> modifiableSingletonList(T obj) {
        ArrayList<T> ts = new ArrayList<T>(8);
        ts.add(obj);
        return ts;
    }

    public static <T> List<T> modifiableSingletonLinkedList(T obj) {
        LinkedList<T> ts = new LinkedList<T>();
        ts.add(obj);
        return ts;
    }
}

