/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.cumulate.trading;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.sdk.wtc.wtbs.common.model.AbstractExtendableObj;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtp.business.cumulate.calculate.model.QTDeductRule;
import kd.wtc.wtp.business.cumulate.trading.QTDealRecordDBService;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtp.business.cumulate.trading.anchor.QTDeductAnchor;
import kd.wtc.wtp.business.cumulate.trading.comparator.DetailComparatorPackage;
import kd.wtc.wtp.business.cumulate.trading.model.AffluentQTLineDetail;
import kd.wtc.wtp.business.cumulate.trading.model.DealStatus;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillDeal;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillEntryDeal;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillEntryDealDetail;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTRuntime
extends AbstractExtendableObj {
    private boolean discard = false;
    private final long attFileBoId;
    private Date applyTime;
    private final String batchNum;
    private Map<Long, QTDeductRule> deductRuleMap = new HashMap<Long, QTDeductRule>(16);
    private final Map<Long, QTLineDetail> newDirtyDetailCache = new HashMap<Long, QTLineDetail>(16);
    private final Map<Long, QTLineDetail> detailCache = new HashMap<Long, QTLineDetail>(16);
    private final Map<Long, QTLineDetail> extraDetailMap = new HashMap<Long, QTLineDetail>(16);
    private final Map<Long, List<AffluentQTLineDetail>> poolDetailMap = new HashMap<Long, List<AffluentQTLineDetail>>(16);
    private final Map<Long, AffluentQTLineDetail> affluentDetailMap = new HashMap<Long, AffluentQTLineDetail>(16);
    private final Set<Long> waitDelLineDetailPK = new HashSet<Long>(16);
    private final Map<Long, QTBillDeal> waitStoreBillDeal = new HashMap<Long, QTBillDeal>(16);
    private final Map<Long, QTBillDeal> waitUpdateBillDeal = new HashMap<Long, QTBillDeal>(16);
    private final Set<Long> waitDelBillDealPk = new HashSet<Long>(16);
    private final Map<Long, QTLineDetail> dirtyDetailMap = new HashMap<Long, QTLineDetail>(16);
    private final Map<Long, BillApply> dirtyBillApplyForCal = new HashMap<Long, BillApply>(16);
    private boolean preQueryBillDeal = false;
    private final Map<Long, QTBillDeal> preQueryBDMap = new HashMap<Long, QTBillDeal>(16);
    private final Map<Long, QTBillDeal> preQueryBill2BDMap = new HashMap<Long, QTBillDeal>(16);

    public boolean isPreQueryBillDeal() {
        return this.preQueryBillDeal;
    }

    public Map<Long, QTBillDeal> getPreQueryBDMap() {
        return this.preQueryBDMap;
    }

    public void setPreQueryBD(List<QTBillDeal> preQueryBDMap) {
        for (QTBillDeal billDeal : preQueryBDMap) {
            this.preQueryBDMap.put(billDeal.getId(), billDeal);
            this.preQueryBill2BDMap.put(billDeal.getBillId(), billDeal);
        }
        this.preQueryBillDeal = true;
    }

    public QTBillDeal loadBDByPK(long bdId, boolean loadBED) {
        if (this.preQueryBillDeal) {
            return this.preQueryBDMap.get(bdId);
        }
        return QTDealRecordDBService.loadBDByPK(bdId, loadBED);
    }

    public QTBillDeal loadBDByBillId(long billId, boolean loadBED) {
        if (this.preQueryBillDeal) {
            return this.preQueryBill2BDMap.get(billId);
        }
        return QTDealRecordDBService.loadBDByBillId(billId, loadBED);
    }

    public void addDirtyBillApplyPackage(List<BillApply> useBill) {
        for (BillApply billApply : useBill) {
            this.dirtyBillApplyForCal.put(billApply.getId(), billApply);
        }
    }

    public List<BillApply> getDirtyBillApplyPackage() {
        Collection<BillApply> mainBillList = this.dirtyBillApplyForCal.values();
        Set storeBillIdSet = this.getWaitStoreBillDeal().stream().map(QTBillDeal::getBillId).collect(Collectors.toSet());
        return mainBillList.stream().filter(ele -> storeBillIdSet.contains(ele.getId())).collect(Collectors.toList());
    }

    public boolean isDiscard() {
        return this.discard;
    }

    public void discard() {
        this.discard = true;
    }

    public static void flush(Collection<QTRuntime> list) {
        HashSet<Long> totalWaitDeleteBillDealPk = new HashSet<Long>(16);
        ArrayList<QTBillDeal> totalWaitStoreBD = new ArrayList<QTBillDeal>(16);
        ArrayList<QTBillDeal> totalWaitUpdateBD = new ArrayList<QTBillDeal>(16);
        ArrayList<QTBillEntryDeal> totalWaitStoreBED = new ArrayList<QTBillEntryDeal>(16);
        ArrayList<QTBillEntryDeal> totalWaitUpdateBED = new ArrayList<QTBillEntryDeal>(16);
        HashSet<Long> totalAllWaitDelLineDetailPK = new HashSet<Long>(16);
        ArrayList<QTLineDetail> totalAllDirtyDetail = new ArrayList<QTLineDetail>(16);
        for (QTRuntime runtime : list) {
            if (runtime.isDiscard()) continue;
            Set<Long> waitDeleteBillDealPk = runtime.getWaitDelBillDealPk();
            totalWaitDeleteBillDealPk.addAll(waitDeleteBillDealPk);
            List<QTBillDeal> waitStoreBD = runtime.getWaitStoreBillDeal();
            waitStoreBD.removeIf(next -> DealStatus.USED.code.equals(next.getDealState()) && WTCCollections.isEmpty(next.getEntryDealList()));
            totalWaitStoreBD.addAll(waitStoreBD);
            List<QTBillDeal> waitUpdateBD = runtime.getWaitUpdateBillDeal();
            Set update2EmptyBDIDSet = waitUpdateBD.stream().filter(ele -> DealStatus.USED.code.equals(ele.getDealState()) && WTCCollections.isEmpty(ele.getEntryDealList())).map(QTBillDeal::getId).collect(Collectors.toSet());
            totalWaitDeleteBillDealPk.addAll(update2EmptyBDIDSet);
            waitUpdateBD.removeIf(next -> DealStatus.USED.code.equals(next.getDealState()) && WTCCollections.isEmpty(next.getEntryDealList()));
            totalWaitUpdateBD.addAll(waitUpdateBD);
            HashMap<Long, Long> tmpMap = new HashMap<Long, Long>(16);
            for (QTLineDetail qTLineDetail : runtime.getAllDirtyDetail()) {
                long originalId = qTLineDetail.getOriginalId();
                if (originalId <= 0L) continue;
                tmpMap.put(qTLineDetail.getId(), originalId);
                qTLineDetail.recoverIdByOriginalId();
            }
            List waitStoreBED = waitStoreBD.stream().flatMap(billDeal -> billDeal.getEntryDealList().stream()).collect(Collectors.toList());
            for (QTBillEntryDeal bed : waitStoreBED) {
                for (QTBillEntryDealDetail bedd : bed.getDetailList()) {
                    long qtSummaryDetailId = bedd.getQtSummaryDetailId();
                    Long originalId = (Long)tmpMap.get(qtSummaryDetailId);
                    if (originalId == null || originalId <= 0L) continue;
                    bedd.setQtSummaryDetailId(originalId);
                }
            }
            totalWaitStoreBED.addAll(waitStoreBED);
            List list2 = waitUpdateBD.stream().flatMap(billDeal -> billDeal.getEntryDealList().stream()).collect(Collectors.toList());
            for (QTBillEntryDeal bed : list2) {
                for (QTBillEntryDealDetail bedd : bed.getDetailList()) {
                    long qtSummaryDetailId = bedd.getQtSummaryDetailId();
                    Long originalId = (Long)tmpMap.get(qtSummaryDetailId);
                    if (originalId == null || originalId <= 0L) continue;
                    bedd.setQtSummaryDetailId(originalId);
                }
            }
            totalWaitUpdateBED.addAll(list2);
            HashSet<Long> allWaitDelLineDetailPK = new HashSet<Long>(runtime.getAllWaitDelLineDetailPK());
            allWaitDelLineDetailPK.removeAll(tmpMap.values());
            totalAllWaitDelLineDetailPK.addAll(allWaitDelLineDetailPK);
            totalAllDirtyDetail.addAll(runtime.getAllDirtyDetail());
        }
        QTDealRecordDBService.deleteBDByPK(totalWaitDeleteBillDealPk);
        QTDealRecordDBService.deleteBEDByBDID(totalWaitDeleteBillDealPk);
        QTDealRecordDBService.saveBD(totalWaitStoreBD);
        QTDealRecordDBService.saveBD2Archive(totalWaitStoreBD);
        QTDealRecordDBService.saveBED(totalWaitStoreBED);
        QTDealRecordDBService.saveBED2Archive(totalWaitStoreBED);
        QTDealRecordDBService.updateOrInsertBD(totalWaitUpdateBD);
        QTDealRecordDBService.updateOrInsertBD2Archive(totalWaitUpdateBD);
        QTDealRecordDBService.updateOrInsertBED(totalWaitUpdateBED);
        QTDealRecordDBService.updateOrInsertBED2Archive(totalWaitUpdateBED);
        QTLineDetailDBService.deleteByPK(totalAllWaitDelLineDetailPK);
        QTLineDetailDBService.saveOrUpdateLineDetail(totalAllDirtyDetail);
    }

    public Collection<QTLineDetail> getNewestDetail() {
        return this.newDirtyDetailCache.values();
    }

    public QTRuntime(long attFileBoId, Date applyTime, String batchNum) {
        this.attFileBoId = attFileBoId;
        this.applyTime = applyTime;
        this.batchNum = batchNum;
    }

    public void flushUsedPackage(List<BillApply> mainBillList) {
        QTDealRecordDBService.saveBillApplyPackage(this.getNeedStoreBillPackage(mainBillList));
    }

    public List<BillApply> getNeedStoreBillPackage(Collection<BillApply> mainBillList) {
        List<Long> collect = mainBillList.stream().map(BillApply::getId).collect(Collectors.toList());
        collect.addAll(mainBillList.stream().map(BillApply::getParentId).collect(Collectors.toSet()));
        QTDealRecordDBService.deleteBillApplyPackage(collect);
        Set storeBillIdSet = this.getWaitStoreBillDeal().stream().map(QTBillDeal::getBillId).collect(Collectors.toSet());
        return mainBillList.stream().filter(ele -> storeBillIdSet.contains(ele.getId())).collect(Collectors.toList());
    }

    public void flushDB(boolean excludeEmptyBillDeal) {
        if (this.discard) {
            return;
        }
        Set<Long> waitDeleteBillDealPk = this.getWaitDelBillDealPk();
        QTDealRecordDBService.deleteBDByPK(waitDeleteBillDealPk);
        QTDealRecordDBService.deleteBEDByBDID(waitDeleteBillDealPk);
        List<QTBillDeal> waitStoreBD = this.getWaitStoreBillDeal();
        waitStoreBD.removeIf(next -> excludeEmptyBillDeal && DealStatus.USED.code.equals(next.getDealState()) && WTCCollections.isEmpty(next.getEntryDealList()));
        QTDealRecordDBService.saveBD(waitStoreBD);
        QTDealRecordDBService.saveBD2Archive(waitStoreBD);
        List<QTBillEntryDeal> waitStoreBED = waitStoreBD.stream().flatMap(billDeal -> billDeal.getEntryDealList().stream()).collect(Collectors.toList());
        HashMap<Long, Long> tmpMap = new HashMap<Long, Long>(16);
        for (QTLineDetail qtLineDetail : this.getAllDirtyDetail()) {
            long originalId = qtLineDetail.getOriginalId();
            if (originalId <= 0L) continue;
            tmpMap.put(qtLineDetail.getId(), originalId);
            qtLineDetail.recoverIdByOriginalId();
        }
        for (QTBillEntryDeal bed : waitStoreBED) {
            for (QTBillEntryDealDetail qTBillEntryDealDetail : bed.getDetailList()) {
                long qtSummaryDetailId = qTBillEntryDealDetail.getQtSummaryDetailId();
                Long originalId = (Long)tmpMap.get(qtSummaryDetailId);
                if (originalId == null || originalId <= 0L) continue;
                qTBillEntryDealDetail.setQtSummaryDetailId(originalId);
            }
        }
        QTDealRecordDBService.saveBED(waitStoreBED);
        QTDealRecordDBService.saveBED2Archive(waitStoreBED);
        List<QTBillDeal> waitUpdateBD = this.getWaitUpdateBillDeal();
        Set<Long> update2EmptyBDIDSet = waitUpdateBD.stream().filter(ele -> DealStatus.USED.code.equals(ele.getDealState()) && WTCCollections.isEmpty(ele.getEntryDealList())).map(QTBillDeal::getId).collect(Collectors.toSet());
        QTDealRecordDBService.deleteBDByPK(update2EmptyBDIDSet);
        QTDealRecordDBService.deleteBEDByBDID(update2EmptyBDIDSet);
        waitUpdateBD.removeIf(next -> excludeEmptyBillDeal && DealStatus.USED.code.equals(next.getDealState()) && WTCCollections.isEmpty(next.getEntryDealList()));
        QTDealRecordDBService.updateOrInsertBD(waitUpdateBD);
        QTDealRecordDBService.updateOrInsertBD2Archive(waitUpdateBD);
        List<QTBillEntryDeal> waitUpdateBED = waitUpdateBD.stream().flatMap(billDeal -> billDeal.getEntryDealList().stream()).collect(Collectors.toList());
        for (QTBillEntryDeal bed : waitUpdateBED) {
            for (QTBillEntryDealDetail bedd : bed.getDetailList()) {
                long qtSummaryDetailId = bedd.getQtSummaryDetailId();
                Long originalId = (Long)tmpMap.get(qtSummaryDetailId);
                if (originalId == null || originalId <= 0L) continue;
                bedd.setQtSummaryDetailId(originalId);
            }
        }
        QTDealRecordDBService.updateOrInsertBED(waitUpdateBED);
        QTDealRecordDBService.updateOrInsertBED2Archive(waitUpdateBED);
        HashSet<Long> hashSet = new HashSet<Long>(this.getAllWaitDelLineDetailPK());
        hashSet.removeAll(tmpMap.values());
        QTLineDetailDBService.deleteByPK(hashSet);
        QTLineDetailDBService.saveOrUpdateLineDetail(this.getAllDirtyDetail());
        QTDeductAnchor.afterFlushLineDetail(this);
    }

    public void plusPoolByDetailID(Set<Long> wantCacheDetailIdSet) {
        List<Long> collect = wantCacheDetailIdSet.stream().filter(ele -> !this.detailCache.containsKey(ele)).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            this.plusPool(QTLineDetailDBService.loadLineDetail(collect).values());
        }
    }

    public void plusPoolAndMarkDirty(Collection<QTLineDetail> details) {
        ArrayList<QTLineDetail> needCacheDetailList = new ArrayList<QTLineDetail>(16);
        for (QTLineDetail detail : details) {
            if (this.detailCache.containsKey(detail.getId()) || this.waitDelLineDetailPK.contains(detail.getId())) continue;
            this.detailCache.put(detail.getId(), detail);
            needCacheDetailList.add(detail);
        }
        for (QTLineDetail detail : needCacheDetailList) {
            QTLineDetail ext;
            AffluentQTLineDetail affluentQTDetail = new AffluentQTLineDetail(detail);
            if (!this.extraDetailMap.isEmpty() && (ext = this.extraDetailMap.remove(detail.getId())) != null) {
                BigDecimal extraValue = ext.getUsableValue();
                affluentQTDetail.setExtraValue(extraValue);
            }
            this.poolDetailMap.computeIfAbsent(detail.getQtTypeId(), key -> new ArrayList(16)).add(affluentQTDetail);
            this.affluentDetailMap.put(detail.getId(), affluentQTDetail);
            this.newDirtyDetailCache.put(detail.getId(), detail);
        }
        for (QTLineDetail qtLineDetail : needCacheDetailList) {
            this.markDirty(qtLineDetail);
        }
    }

    public void plusPool(Collection<QTLineDetail> details) {
        ArrayList<QTLineDetail> needCacheDetailList = new ArrayList<QTLineDetail>(16);
        for (QTLineDetail detail : details) {
            if (this.detailCache.containsKey(detail.getId()) || this.waitDelLineDetailPK.contains(detail.getId())) continue;
            this.detailCache.put(detail.getId(), detail);
            needCacheDetailList.add(detail);
        }
        for (QTLineDetail detail : needCacheDetailList) {
            QTLineDetail ext;
            AffluentQTLineDetail affluentQTDetail = new AffluentQTLineDetail(detail);
            if (!this.extraDetailMap.isEmpty() && (ext = this.extraDetailMap.remove(detail.getId())) != null) {
                BigDecimal extraValue = ext.getUsableValue();
                affluentQTDetail.setExtraValue(extraValue);
            }
            this.poolDetailMap.computeIfAbsent(detail.getQtTypeId(), key -> new ArrayList(16)).add(affluentQTDetail);
            this.affluentDetailMap.put(detail.getId(), affluentQTDetail);
        }
    }

    public void clearExtraSlotMapEffective() {
        this.extraDetailMap.clear();
        for (AffluentQTLineDetail value : this.affluentDetailMap.values()) {
            value.setExtraValue(BigDecimal.ZERO);
        }
    }

    public void setExtraSlotMap(Map<Long, QTLineDetail> inputExtraSlotMap) {
        this.extraDetailMap.clear();
        for (Map.Entry<Long, QTLineDetail> entry : inputExtraSlotMap.entrySet()) {
            Long detailId = entry.getKey();
            if (this.waitDelLineDetailPK.contains(detailId)) continue;
            QTLineDetail ext = entry.getValue();
            QTLineDetail cache = this.detailCache.get(detailId);
            if (cache == null) {
                this.extraDetailMap.put(detailId, ext);
                continue;
            }
            AffluentQTLineDetail affluentDetail = this.affluentDetailMap.get(detailId);
            affluentDetail.setExtraValue(affluentDetail.getExtraValue().add(ext.getUsableValue()));
        }
    }

    public QTLineDetail getDetail(long qtSummaryDetailId) {
        QTLineDetail detail = this.detailCache.get(qtSummaryDetailId);
        this.markDirty(detail);
        return detail;
    }

    public long lookDetailQTTypeId(long qtSummaryDetailId) {
        QTLineDetail detail = this.detailCache.get(qtSummaryDetailId);
        return detail == null ? 0L : detail.getQtTypeId();
    }

    public void plusDeductRuleMap(Map<Long, QTDeductRule> newDeductRuleMap) {
        for (Map.Entry<Long, QTDeductRule> entry : newDeductRuleMap.entrySet()) {
            this.deductRuleMap.putIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    public List<AffluentQTLineDetail> getUnSortDetailList(Long qtTypeId) {
        return this.poolDetailMap.getOrDefault(qtTypeId, Collections.emptyList());
    }

    public List<AffluentQTLineDetail> getMergedUnSortDetailList(List<Long> qtTypeIdList) {
        ArrayList<AffluentQTLineDetail> res = new ArrayList<AffluentQTLineDetail>(qtTypeIdList.size());
        for (Long qtTypeId : qtTypeIdList) {
            res.addAll(this.getUnSortDetailList(qtTypeId));
        }
        return res;
    }

    public List<AffluentQTLineDetail> getMergedSortDetailList(List<Long> qtTypeIdList, DetailComparatorPackage comparatorPackage) {
        List<AffluentQTLineDetail> res = this.getMergedUnSortDetailList(qtTypeIdList);
        if (comparatorPackage != null) {
            comparatorPackage.sort(res);
        }
        return res;
    }

    @Deprecated
    public List<AffluentQTLineDetail> getSortedDetailList(Long qtTypeId, Comparator<AffluentQTLineDetail> detailComparator) {
        List<AffluentQTLineDetail> res = this.poolDetailMap.getOrDefault(qtTypeId, Collections.emptyList());
        if (detailComparator != null) {
            res.sort(detailComparator);
        }
        return res;
    }

    public QTDeductRule getQTDeductRule(long deductionRuleId) {
        return this.deductRuleMap.get(deductionRuleId);
    }

    public void updateApplyTime(Date date) {
        this.applyTime = date;
    }

    public boolean isWaitDelBillDeal(long billDealPK) {
        return this.waitDelBillDealPk.contains(billDealPK);
    }

    public void addWaitDelBillDealPk(long bdPK) {
        this.waitStoreBillDeal.remove(bdPK);
        this.waitDelBillDealPk.add(bdPK);
    }

    public Set<Long> getWaitDelBillDealPk() {
        return this.waitDelBillDealPk;
    }

    public QTBillDeal getWaitStoreBillDeal(long bdPK) {
        return this.waitStoreBillDeal.get(bdPK);
    }

    public QTBillDeal getWaitStoreBillDealByBillId(long billId) {
        for (QTBillDeal value : this.waitStoreBillDeal.values()) {
            if (billId != value.getBillId()) continue;
            return value;
        }
        return null;
    }

    public Map<Long, QTBillDeal> getWaitStoreBillDealByBillId(Set<Long> billIdSet) {
        HashMap<Long, QTBillDeal> res = new HashMap<Long, QTBillDeal>(billIdSet.size());
        for (QTBillDeal value : this.waitStoreBillDeal.values()) {
            if (!billIdSet.contains(value.getBillId())) continue;
            res.put(value.getBillId(), value);
        }
        return res;
    }

    public void addWaitStoreBillDeal(QTBillDeal billDeal) {
        this.waitStoreBillDeal.put(billDeal.getId(), billDeal);
    }

    public void addWaitUpdateBillDeal(QTBillDeal billDeal) {
        this.waitUpdateBillDeal.put(billDeal.getId(), billDeal);
    }

    public List<QTBillDeal> getWaitStoreBillDeal() {
        return new ArrayList<QTBillDeal>(this.waitStoreBillDeal.values());
    }

    public List<QTBillDeal> getWaitUpdateBillDeal() {
        return new ArrayList<QTBillDeal>(this.waitUpdateBillDeal.values());
    }

    public void delLineDetailByLogicKey(Set<DetailLogicKey> needDelDetailSet) {
        List needDelDetailIdList = this.detailCache.values().stream().filter(detail -> needDelDetailSet.contains(new DetailLogicKey((QTLineDetail)detail))).collect(Collectors.toList());
        for (QTLineDetail qtLineDetail : needDelDetailIdList) {
            if (!"2".equals(qtLineDetail.getInitstatus())) continue;
            this.addWaitDelLineDetailPK(qtLineDetail.getId());
        }
    }

    public void addWaitDelLineDetailPK(long detailPK) {
        boolean notExistOld = this.waitDelLineDetailPK.add(detailPK);
        this.dirtyDetailMap.remove(detailPK);
        if (notExistOld) {
            this.detailCache.remove(detailPK);
            this.extraDetailMap.remove(detailPK);
            AffluentQTLineDetail remove = this.affluentDetailMap.remove(detailPK);
            if (remove != null) {
                long qtTypeId = remove.getSrc().getQtTypeId();
                this.poolDetailMap.get(qtTypeId).removeIf(detail -> detail.getSrc().getId() == detailPK);
            }
        }
    }

    public Set<Long> getAllWaitDelLineDetailPK() {
        return this.waitDelLineDetailPK;
    }

    public Collection<QTLineDetail> getAllDirtyDetail() {
        return this.dirtyDetailMap.values();
    }

    public void markDirty(QTLineDetail detail) {
        if (detail != null) {
            this.dirtyDetailMap.put(detail.getId(), detail);
        }
    }

    public long getAttFileBoId() {
        return this.attFileBoId;
    }

    public Date getApplyTime() {
        return this.applyTime;
    }

    public String getBatchNum() {
        return this.batchNum;
    }

    public Map<Long, QTDeductRule> getDeductRuleMap() {
        return this.deductRuleMap;
    }

    public void setDeductRuleMap(Map<Long, QTDeductRule> deductRuleMap) {
        this.deductRuleMap = deductRuleMap;
    }

    public void logDeductRuntime(Log log) {
        log.info("batchNum={} deductRuntime deductRuleMap={}", (Object)this.batchNum, this.deductRuleMap);
        log.info("batchNum={} deductRuntime poolDetailMap={}", (Object)this.batchNum, this.poolDetailMap);
    }
}

