/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.cumulate.trading.comparator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtp.business.cumulate.calculate.model.QTDeductRule;
import kd.wtc.wtp.business.cumulate.calculate.model.QTType;
import kd.wtc.wtp.business.cumulate.trading.comparator.QTDateAscComparator;
import kd.wtc.wtp.business.cumulate.trading.comparator.QTDefaultComparator;
import kd.wtc.wtp.business.cumulate.trading.comparator.QTLineDetailComparator;
import kd.wtc.wtp.business.cumulate.trading.comparator.QTReversalComparator;
import kd.wtc.wtp.business.cumulate.trading.comparator.QTTypeASCComparator;
import kd.wtc.wtp.business.cumulate.trading.comparator.QTTypeDESCComparator;
import kd.wtc.wtp.business.cumulate.trading.model.AffluentQTLineDetail;

public class DetailComparatorPackage {
    private final List<QTLineDetailComparator> comparatorList;

    public DetailComparatorPackage(QTDeductRule deductRule) {
        this.comparatorList = this.init(deductRule, true);
    }

    @Deprecated
    public DetailComparatorPackage(QTDeductRule deductRule, boolean reversalComparator) {
        this.comparatorList = this.init(deductRule, reversalComparator);
    }

    private List<QTLineDetailComparator> init(QTDeductRule deductRule, boolean reversalComparator) {
        List<QTLineDetailComparator> comparatorList;
        List<Long> qtTypeId = deductRule.getDeductOrder().stream().map(QTType::getId).collect(Collectors.toList());
        List<QTDeductRule.OrderRule> orderRuleList = deductRule.getOrderRuleList();
        if (WTCCollections.isEmpty(orderRuleList)) {
            comparatorList = Collections.singletonList(new QTDefaultComparator());
        } else if (reversalComparator) {
            comparatorList = new ArrayList<QTLineDetailComparator>(orderRuleList.size());
            comparatorList.add(new QTDateAscComparator(ele -> ele.getSrc().getCreateTime()));
            for (int i = orderRuleList.size() - 1; i >= 0; --i) {
                QTDeductRule.OrderRule orderRule2 = orderRuleList.get(i);
                comparatorList.add(DetailComparatorPackage.parse2Comparator(orderRule2, qtTypeId));
            }
        } else {
            comparatorList = orderRuleList.stream().map(orderRule -> DetailComparatorPackage.parse2Comparator(orderRule, qtTypeId)).collect(Collectors.toList());
            comparatorList.add(new QTDateAscComparator(ele -> ele.getSrc().getCreateTime()));
        }
        return comparatorList;
    }

    public void sort(List<AffluentQTLineDetail> list) {
        for (QTLineDetailComparator comparator : this.comparatorList) {
            list.sort(comparator);
        }
    }

    private static QTLineDetailComparator parse2Comparator(QTDeductRule.OrderRule orderRule, List<Long> qtTypeId) {
        QTDateAscComparator comparator;
        String sortField = orderRule.getSortField();
        String sortRule = orderRule.getSortRule();
        if ("A".equals(sortField)) {
            if ("A".equals(sortRule)) {
                return new QTTypeASCComparator(qtTypeId);
            }
            return new QTTypeDESCComparator(qtTypeId);
        }
        if ("B".equals(sortField)) {
            comparator = new QTDateAscComparator(ele -> ele.getSrc().getUseStartDate());
        } else if ("C".equals(sortField)) {
            comparator = new QTDateAscComparator(ele -> ele.getSrc().getUseEndDate());
        } else if ("D".equals(sortField)) {
            comparator = new QTDateAscComparator(ele -> ele.getSrc().getGenStartDate());
        } else if ("E".equals(sortField)) {
            comparator = new QTDateAscComparator(ele -> ele.getSrc().getGenEndDate());
        } else {
            throw new KDBizException("illegal deduct rule.entry");
        }
        if ("A".equals(sortRule)) {
            return comparator;
        }
        return new QTReversalComparator(comparator);
    }
}

