/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.cumulate.trading.model;

public enum DealStatus {
    FROZEN("A"),
    USED("B"),
    FROZEN_LOCK("AA"),
    USED_LOCK("BA");

    public final String code;

    private DealStatus(String code) {
        this.code = code;
    }

    public static boolean isLock(String code) {
        return DealStatus.FROZEN_LOCK.code.equals(code) || DealStatus.USED_LOCK.code.equals(code);
    }

    public boolean isLock() {
        return this == FROZEN_LOCK || this == USED_LOCK;
    }

    public DealStatus unLock() {
        if (!this.isLock()) {
            return this;
        }
        if (this == FROZEN_LOCK) {
            return FROZEN;
        }
        return USED;
    }

    public DealStatus toLock() {
        if (this.isLock()) {
            return this;
        }
        if (this == FROZEN) {
            return FROZEN_LOCK;
        }
        return USED_LOCK;
    }

    public static boolean isFrozen(String code) {
        return DealStatus.FROZEN.code.equals(code) || DealStatus.FROZEN_LOCK.code.equals(code);
    }

    public static DealStatus get(String code) {
        DealStatus[] values;
        for (DealStatus value : values = DealStatus.values()) {
            if (!value.code.equals(code)) continue;
            return value;
        }
        throw new IllegalArgumentException("Argument:code can not be " + code);
    }
}

