/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.cumulate.trading.model;

import java.util.Objects;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class DetailLogicKey {
    private final long attFileBoId;
    private final long qtTypeId;
    private final long cycleId;
    private final int cycleIndex;

    public DetailLogicKey(QTLineDetail detail) {
        this.attFileBoId = detail.getAttFileBoId();
        this.qtTypeId = detail.getQtTypeId();
        this.cycleId = detail.getpCycleId();
        this.cycleIndex = detail.getPeriodNum();
    }

    public DetailLogicKey(long attFileBoId, long qtTypeId, long cycleId, int cycleIndex) {
        this.attFileBoId = attFileBoId;
        this.qtTypeId = qtTypeId;
        this.cycleId = cycleId;
        this.cycleIndex = cycleIndex;
    }

    public QFilter toQFilter() {
        QFilter qFilter = new QFilter("attfilebo", "=", (Object)this.attFileBoId).and("qttype", "=", (Object)this.qtTypeId);
        if (this.cycleId != 0L && (long)this.cycleIndex != 0L) {
            qFilter.and("periodcircleid", "=", (Object)this.cycleId).and("periodnum", "=", (Object)this.cycleIndex);
        }
        return qFilter;
    }

    public long getAttFileBoId() {
        return this.attFileBoId;
    }

    public long getQtTypeId() {
        return this.qtTypeId;
    }

    public long getCycleId() {
        return this.cycleId;
    }

    public int getCycleIndex() {
        return this.cycleIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetailLogicKey that = (DetailLogicKey)o;
        return this.attFileBoId == that.attFileBoId && this.qtTypeId == that.qtTypeId && this.cycleId == that.cycleId && this.cycleIndex == that.cycleIndex;
    }

    public String getIndexKey() {
        return this.attFileBoId + "_" + this.qtTypeId + "_" + this.cycleId + "_" + this.cycleIndex;
    }

    @Deprecated
    public static String getIndexKey(long attFileBoId, long qtTypeId, long cycleId, long cycleIndex) {
        return attFileBoId + "_" + qtTypeId + "_" + cycleId + "_" + cycleIndex;
    }

    public int hashCode() {
        return Objects.hash(this.attFileBoId, this.qtTypeId, this.cycleId, this.cycleIndex);
    }
}

