/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.cumulate.trading.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.wtc.wtbs.common.deduction.QTLineDetailDeductInfo;
import kd.wtc.wtp.business.cumulate.trading.QTRuntime;
import kd.wtc.wtp.business.cumulate.trading.model.DeductSource;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillEntryDealDetail;
import kd.wtc.wtp.business.cumulate.trading.model.QTDealRecordDebris;

public class QTDRDebrisAccumulator {
    List<QTDealRecordDebris> arr = new ArrayList<QTDealRecordDebris>(16);

    public int getNextSeq() {
        return this.arr.size() + 1;
    }

    private void add(QTDealRecordDebris debris) {
        this.arr.add(debris);
    }

    private void addDebris(DeductSource deductSource, long entryId, long lineDetailId, Date deductDate, BigDecimal dateApplyValue) {
        QTDealRecordDebris drd = new QTDealRecordDebris();
        drd.setBillEntryId(entryId);
        drd.setDeductSource(deductSource.name());
        drd.setSeq(this.getNextSeq());
        drd.setQtSummaryDetailId(lineDetailId);
        drd.setDeductDate(deductDate);
        drd.setApplyValue(dateApplyValue);
        this.add(drd);
    }

    public void addEmptyDebris(long entryId, long lineDetailId, Date deductDate, BigDecimal dateApplyValue) {
        this.addDebris(DeductSource.empty, entryId, lineDetailId, deductDate, dateApplyValue);
    }

    public void addPoolDebris(long entryId, long lineDetailId, Date deductDate, BigDecimal dateApplyValue) {
        this.addDebris(DeductSource.pool, entryId, lineDetailId, deductDate, dateApplyValue);
    }

    public void addPoolInvalidDebris(long entryId, long lineDetailId, Date deductDate, BigDecimal dateApplyValue) {
        this.addDebris(DeductSource.pool_ivd, entryId, lineDetailId, deductDate, dateApplyValue);
    }

    public void addParentDebris(long entryId, long lineDetailId, Date deductDate, BigDecimal dateApplyValue) {
        this.addDebris(DeductSource.parent, entryId, lineDetailId, deductDate, dateApplyValue);
    }

    public List<QTLineDetailDeductInfo> mergeDebris2DeductInfo(QTRuntime runtime) {
        HashMap<Long, QTLineDetailDeductInfo> infoMap = new HashMap<Long, QTLineDetailDeductInfo>(16);
        for (QTDealRecordDebris debris : this.arr) {
            if (!debris.getDeductSource().equals(DeductSource.parent.name()) && !DeductSource.fromPool(debris.getDeductSource())) continue;
            BigDecimal debrisValue = debris.getApplyValue();
            long lineDetailId = debris.getQtSummaryDetailId();
            long qtTypeId = runtime.lookDetailQTTypeId(lineDetailId);
            QTLineDetailDeductInfo info = (QTLineDetailDeductInfo)infoMap.get(lineDetailId);
            if (info == null) {
                info = new QTLineDetailDeductInfo();
                info.setQtLineDetailId(lineDetailId);
                info.setQtTypeId(qtTypeId);
                infoMap.put(lineDetailId, info);
            }
            info.setApplyTotalValue(info.getApplyTotalValue().add(debrisValue));
            if (debris.getDeductSource().equals(DeductSource.pool_ivd.name())) {
                info.setApplyFromPoolIvd(info.getApplyFromPoolIvd().add(debrisValue));
                continue;
            }
            if (debris.getDeductSource().equals(DeductSource.pool.name())) {
                info.setApplyFromPool(info.getApplyFromPool().add(debrisValue));
                continue;
            }
            info.setApplyFromParent(info.getApplyFromParent().add(debrisValue));
        }
        return new ArrayList<QTLineDetailDeductInfo>(infoMap.values());
    }

    public List<QTBillEntryDealDetail> mergeDebris() {
        Function<QTDealRecordDebris, String> keyGenerator = debris -> debris.getDeductSource() + "_" + this.getQTDetailId((QTDealRecordDebris)debris);
        LinkedHashMap<String, QTBillEntryDealDetail> detailMap = new LinkedHashMap<String, QTBillEntryDealDetail>(16);
        for (QTDealRecordDebris debris2 : this.arr) {
            if (!debris2.getDeductSource().equals(DeductSource.parent.name()) && !DeductSource.fromPool(debris2.getDeductSource())) continue;
            String key = keyGenerator.apply(debris2);
            QTBillEntryDealDetail bedDetail = (QTBillEntryDealDetail)detailMap.get(key);
            if (bedDetail == null) {
                bedDetail = new QTBillEntryDealDetail();
                bedDetail.setDeductSource(debris2.getDeductSource());
                bedDetail.setSeq(detailMap.size() + 1);
                bedDetail.setQtSummaryDetailId(this.getQTDetailId(debris2));
                bedDetail.setApplyValue(BigDecimal.ZERO);
                detailMap.put(key, bedDetail);
            }
            bedDetail.setApplyValue(bedDetail.getApplyValue().add(debris2.getApplyValue()));
        }
        return new ArrayList<QTBillEntryDealDetail>(detailMap.values());
    }

    public Set<Long> getTouchedQTDetailIdSet() {
        return this.arr.stream().map(QTDealRecordDebris::getQtSummaryDetailId).collect(Collectors.toSet());
    }

    private long getQTDetailId(QTDealRecordDebris debris) {
        if (DeductSource.parent.name().equals(debris.getDeductSource())) {
            return 0L;
        }
        return debris.getQtSummaryDetailId();
    }

    public String toString() {
        return "QTDRDebrisAccumulator{arr=" + this.arr + '}';
    }
}

