/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.ex;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.personfilter.enums.RuleOperatorEnum;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;

public class ExConditionFilterService {
    private ExConditionFilterService() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean showCondition() {
        return true;
    }

    public static String getUnLimitStr() {
        return ExKDStringHelper.unLimitStr();
    }

    public static String getStrOfSettingCondition(String conditions) {
        String conditionExpressStr;
        if (HRStringUtils.isEmpty((String)conditions)) {
            return ExConditionFilterService.getUnLimitStr();
        }
        RuleConditionInfo accessDto = (RuleConditionInfo)WTCSerializationUtils.fromJsonString((String)conditions, RuleConditionInfo.class);
        List conditionList = accessDto.getConditionList();
        if (conditionList == null || conditionList.isEmpty()) {
            return ExConditionFilterService.getUnLimitStr();
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)conditionList.size());
        for (ConditionInfo dto : conditionList) {
            String part1 = "\u3010" + dto.getDisplayParam() + "\u3011";
            String part2 = RuleOperatorEnum.getEnum((String)dto.getOperators()).getName();
            String part3 = " \"" + dto.getDisplayValue() + "\"";
            String str = "";
            str = ExConditionFilterService.isNoNeedSetValue(dto.getOperators()) ? part1 + part2 : part1 + part2 + part3;
            map.put(dto.getName(), str);
        }
        if (map.isEmpty()) {
            return ExConditionFilterService.getUnLimitStr();
        }
        String result = conditionExpressStr = accessDto.getConditionExpressStr();
        result = result.replace("and", ExKDStringHelper.getAndStr());
        result = result.replace("or", ExKDStringHelper.getPerhapsStr());
        for (Map.Entry entry : map.entrySet()) {
            result = result.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return result;
    }

    public static boolean isNoNeedSetValue(String operators) {
        return RuleOperatorEnum.IS_NULL.getValue().equals(operators) || RuleOperatorEnum.IS_NOT_NULL.getValue().equals(operators) || RuleOperatorEnum.TODAY.getValue().equals(operators) || RuleOperatorEnum.LESS_OR_EQUALS_TODAY.getValue().equals(operators) || RuleOperatorEnum.GREATER_OR_EQUALS_TODAY.getValue().equals(operators) || RuleOperatorEnum.YESTERDAY.getValue().equals(operators) || RuleOperatorEnum.TOMORROW.getValue().equals(operators) || RuleOperatorEnum.THIS_WEEK.getValue().equals(operators) || RuleOperatorEnum.LAST_WEEK.getValue().equals(operators) || RuleOperatorEnum.NEXT_WEEK.getValue().equals(operators) || RuleOperatorEnum.THIS_MONTH.getValue().equals(operators) || RuleOperatorEnum.LAST_MONTH.getValue().equals(operators) || RuleOperatorEnum.NEXT_MONTH.getValue().equals(operators) || RuleOperatorEnum.LAST3MONTH.getValue().equals(operators) || RuleOperatorEnum.NEXT3MONTH.getValue().equals(operators) || RuleOperatorEnum.THIS_QUARTER.getValue().equals(operators) || RuleOperatorEnum.LAST_QUARTER.getValue().equals(operators) || RuleOperatorEnum.NEXT_QUARTER.getValue().equals(operators) || RuleOperatorEnum.THIS_YEAR.getValue().equals(operators) || RuleOperatorEnum.LAST_YEAR.getValue().equals(operators) || RuleOperatorEnum.NEXT_YEAR.getValue().equals(operators);
    }

    public static boolean checkConditionJson(String conditions, IFormView view, String errorMsg, String typeErrorMsg) {
        if (HRStringUtils.isEmpty((String)conditions)) {
            return true;
        }
        if (conditions.contains("is_or_isSub")) {
            view.showTipNotification(typeErrorMsg);
            return false;
        }
        RuleConditionInfo accessDto = (RuleConditionInfo)WTCSerializationUtils.fromJsonString((String)conditions, RuleConditionInfo.class);
        if (accessDto == null) {
            return true;
        }
        List conditionList = accessDto.getConditionList();
        if (conditionList.size() > 10) {
            view.showTipNotification(ExKDStringHelper.getMaxConditionNum());
            return false;
        }
        RuleValidateInfo info = RuleValidateUtil.validCondition((String)conditions, (boolean)true);
        if (!info.isSuccess()) {
            view.showTipNotification(errorMsg + String.join((CharSequence)",", info.getMsgList()));
            return false;
        }
        return true;
    }

    public static boolean emptyConditionJsonDeal(String conditions) {
        if (HRStringUtils.isEmpty((String)conditions)) {
            return true;
        }
        RuleConditionInfo accessDto = null;
        accessDto = (RuleConditionInfo)WTCSerializationUtils.fromJsonString((String)conditions, RuleConditionInfo.class);
        if (accessDto == null) {
            return true;
        }
        List conditionList = accessDto.getConditionList();
        if (conditionList == null) {
            return true;
        }
        List emptyConditions = conditionList.stream().filter(conditionDto -> HRStringUtils.isEmpty((String)conditionDto.getValue()) && HRStringUtils.isEmpty((String)conditionDto.getParam()) && HRStringUtils.isEmpty((String)conditionDto.getOperators())).collect(Collectors.toList());
        return emptyConditions.size() != conditionList.size();
    }
}

