/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.ex;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.predata.wtbd.PreDataExAttribute;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.ex.ExCommonService;
import kd.wtc.wtp.business.ex.ExConditionFilterService;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;
import kd.wtc.wtp.common.ex.rule.vo.ExEntryEntityAttItemVo;

public class ExConfigService {
    private static final String ACTIONID = "exconfigentryaction";
    private static final String ABS_ACTIONID = "absexconfigentryaction";
    private static final String EDIT_ACTIONID = "editexconfiguredetail";
    private static final Set<Long> NO_CATEGORYA_EX = Sets.newHashSetWithExpectedSize((int)4);

    private ExConfigService() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isCategoryA(Long ex) {
        return !NO_CATEGORYA_EX.contains(ex);
    }

    public static boolean isCategoryB(Long ex) {
        return Objects.equals(PreDataExAttribute.PD_1050_S, ex) || Objects.equals(PreDataExAttribute.PD_1060_S, ex);
    }

    public static boolean isCategoryC(Long ex) {
        return Objects.equals(ex, PreDataExAttribute.PD_1030_S);
    }

    public static String getEditActionId(int idx) {
        return EDIT_ACTIONID + idx;
    }

    public static int editEntryIndex(String actionId) {
        if (actionId.startsWith(EDIT_ACTIONID)) {
            return Integer.parseInt(actionId.substring(EDIT_ACTIONID.length()));
        }
        return -1;
    }

    public static String getActionId(int idx) {
        return ACTIONID + idx;
    }

    public static String getAbsActionId(int idx) {
        return ABS_ACTIONID + idx;
    }

    public static int entryIndex(String actionId) {
        if (actionId != null && actionId.startsWith(ACTIONID)) {
            return Integer.parseInt(actionId.substring(ACTIONID.length()));
        }
        return -1;
    }

    public static int entryAbsIndex(String actionId) {
        if (actionId != null && actionId.startsWith(ABS_ACTIONID)) {
            return Integer.parseInt(actionId.substring(ABS_ACTIONID.length()));
        }
        return -1;
    }

    public static long getExAttributeId(IDataModel dataModel) {
        DynamicObject exAttribute = dataModel.getDataEntity().getDynamicObject("exattribute");
        return exAttribute != null ? exAttribute.getLong("id") : 0L;
    }

    public static boolean dataCheckCategoryA(IFormView view, DynamicObjectCollection entryData, boolean isStep, boolean isBeforeSave, String punchCardName) {
        boolean showCondition = ExConditionFilterService.showCondition();
        if (isStep || showCondition) {
            if (isStep && !showCondition) {
                String errorMsg = punchCardName == null ? ExKDStringHelper.noConditionError() : String.format(Locale.ROOT, ExKDStringHelper.noConditionWithCardError(), punchCardName);
                return ExConfigService.dataCheckCategoryB(view, entryData, true, isBeforeSave, errorMsg);
            }
            if (!isStep) {
                return ExConfigService.checkCount(view, entryData, isBeforeSave);
            }
            String errorMsg = punchCardName == null ? ExKDStringHelper.conditionError() : String.format(Locale.ROOT, ExKDStringHelper.conditionWithCardError(), punchCardName);
            return ExConfigService.sectionCheck(view, true, entryData, isBeforeSave, errorMsg);
        }
        ExConfigService.checkNoConditionAndNotStep(view, entryData, isBeforeSave);
        return true;
    }

    private static boolean checkNoConditionAndNotStep(IFormView view, DynamicObjectCollection entryData, boolean isBeforeSave) {
        if (entryData == null) {
            return true;
        }
        if (entryData.size() > 1) {
            view.showTipNotification(ExKDStringHelper.oneDataError());
            return false;
        }
        for (DynamicObject dy : entryData) {
            Object culValue = dy.get("culvalue");
            if (culValue != null || !isBeforeSave) continue;
            view.showTipNotification(ExKDStringHelper.conditionCheckError());
            return false;
        }
        return true;
    }

    private static boolean checkCount(IFormView view, DynamicObjectCollection entryData, boolean isBeforeSave) {
        boolean haveUnLimit = false;
        for (DynamicObject dy : entryData) {
            Object culValue;
            String conditionShow = dy.getString("conditionfiltershow");
            if (HRStringUtils.equals((String)conditionShow, (String)ExConditionFilterService.getUnLimitStr())) {
                haveUnLimit = true;
            }
            if (!isBeforeSave || (culValue = dy.get("culvalue")) != null) continue;
            view.showTipNotification(ExKDStringHelper.conditionCheckError());
            return false;
        }
        if (haveUnLimit && entryData.size() > 1) {
            view.showTipNotification(ExKDStringHelper.oneDataWithConditionError());
            return false;
        }
        return true;
    }

    public static boolean dataCheckCategoryB(IFormView view, DynamicObjectCollection entryData, boolean isStep, boolean isBeforeSave, String errorMsg) {
        if (!isStep) {
            if (isBeforeSave) {
                for (DynamicObject curDy : entryData) {
                    Object culValue = curDy.get("culvalue");
                    if (culValue != null) continue;
                    view.showTipNotification(ExKDStringHelper.conditionCheckError());
                    return false;
                }
            }
            return true;
        }
        return ExConfigService.sectionCheck(view, false, entryData, isBeforeSave, errorMsg);
    }

    public static boolean sectionCheck(IFormView view, boolean isNeed, DynamicObjectCollection entryData, boolean isBeforeSave, String errorMsg) {
        boolean add = false;
        if (isNeed) {
            for (DynamicObject dy : entryData) {
                String conditionShow = dy.getString("conditionfiltershow");
                boolean isUnLimit = HRStringUtils.equals((String)conditionShow, (String)ExConditionFilterService.getUnLimitStr());
                if (!isUnLimit) continue;
                add = true;
                break;
            }
        } else {
            add = true;
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)entryData.size());
        for (DynamicObject dy : entryData) {
            boolean isNull;
            boolean checkValueResult = ExConfigService.checkValue(view, dy, isBeforeSave);
            if (!checkValueResult) {
                return false;
            }
            String are = dy.getString("are");
            BigDecimal curValue = dy.getBigDecimal("culvalue");
            String curUnit = dy.getString("culunit");
            String bre = dy.getString("bre");
            BigDecimal maxValue = dy.getBigDecimal("maxvalue");
            String maxUnit = dy.getString("maxunit");
            boolean bl = isNull = curValue == null || maxValue == null;
            if (isBeforeSave && isNull) {
                view.showTipNotification(ExKDStringHelper.conditionCheckError());
                return false;
            }
            ExEntryEntityAttItemVo vo = new ExEntryEntityAttItemVo(Long.valueOf(0L), are, curValue, curUnit, bre, maxValue, maxUnit);
            boolean result = ExCommonService.checkAttItem(list, vo);
            if (!result) {
                view.showTipNotification(errorMsg);
                return false;
            }
            if (!add) continue;
            list.add(vo);
        }
        return true;
    }

    public static boolean checkValue(IFormView view, DynamicObject curDy, boolean isBeforeSave) {
        boolean re;
        boolean isNull;
        Object culValueObj = curDy.get("culvalue");
        Object maxValueObj = curDy.get("maxvalue");
        boolean bl = isNull = culValueObj == null || maxValueObj == null;
        if (isBeforeSave && isNull) {
            view.showTipNotification(ExKDStringHelper.conditionCheckError());
            return false;
        }
        int culValue = curDy.getInt("culvalue");
        String unit = curDy.getString("culunit");
        int maxValue = curDy.getInt("maxvalue");
        String maxUnit = curDy.getString("maxunit");
        culValue = "second".equals(unit) ? culValue : culValue * 60;
        maxValue = "second".equals(maxUnit) ? maxValue : maxValue * 60;
        boolean bl2 = re = HRStringUtils.equals((String)">=", (String)curDy.getString("are")) && HRStringUtils.equals((String)"<=", (String)curDy.getString("bre"));
        if (re && maxValue == culValue) {
            return true;
        }
        if (maxValue <= culValue) {
            view.showTipNotification(ExKDStringHelper.compareValue());
            return false;
        }
        return true;
    }

    public static boolean durationDataCheck(IFormView view) {
        DynamicObjectCollection entryData = view.getModel().getEntryEntity("entryentity");
        for (DynamicObject curDy : entryData) {
            String dealMethod = curDy.getString("dealmethod");
            BigDecimal appointValue = curDy.getBigDecimal("appointvalue");
            if (!HRStringUtils.equals((String)"B", (String)dealMethod) || appointValue.compareTo(BigDecimal.ZERO) >= 0) continue;
            view.showTipNotification(ExKDStringHelper.appointError());
            return false;
        }
        return true;
    }

    public static boolean durationDataCheck(IFormView view, IFormView subView) {
        DynamicObjectCollection entryData = subView.getModel().getEntryEntity("entryentity");
        for (DynamicObject curDy : entryData) {
            BigDecimal appointValue = curDy.getBigDecimal("appointvalue");
            String dealMethod = curDy.getString("dealmethod");
            if (!HRStringUtils.equals((String)"B", (String)dealMethod) || appointValue.compareTo(BigDecimal.ZERO) >= 0) continue;
            view.showTipNotification(ExKDStringHelper.appointError());
            return false;
        }
        return true;
    }

    public static boolean checkOriginalItemShowTwo(IFormView view, IFormView dataView) {
        DynamicObject oriDy = dataView.getModel().getDataEntity().getDynamicObject("originalitemshowtwo");
        if (oriDy == null) {
            view.showTipNotification(ExKDStringHelper.orgItemCheck());
            return false;
        }
        return true;
    }

    public static String getStepRuleStr(DynamicObject dy) {
        String dealType = dy.getString("dealtype");
        if (HRStringUtils.isEmpty((String)dealType)) {
            return null;
        }
        boolean noStep = HRStringUtils.equals((String)"A", (String)dealType);
        if (noStep) {
            return null;
        }
        DynamicObject originalItem = dy.getDynamicObject("originalitem");
        String name = originalItem.getString("name");
        String aRe = HRStringUtils.equals((String)">=", (String)dy.getString("are")) ? ExKDStringHelper.getGreaterEqualStr() : ExKDStringHelper.getGreaterStr();
        int culValue = dy.getInt("culvalue");
        String culUnit = HRStringUtils.equals((String)"minute", (String)dy.getString("culunit")) ? ExKDStringHelper.getMinuteStr() : ExKDStringHelper.getSecondStr();
        boolean isNull = ExConfigService.maxValueIsNull(dy);
        if (isNull) {
            return ExKDStringHelper.showRuleNotMaxValue(name, aRe, culValue, culUnit);
        }
        String bre = HRStringUtils.equals((String)"<", (String)dy.getString("bre")) ? ExKDStringHelper.getLessStr() : ExKDStringHelper.getLessEqualStr();
        int maxValue = dy.getInt("maxvalue");
        String maxUnit = HRStringUtils.equals((String)"minute", (String)dy.getString("maxunit")) ? ExKDStringHelper.getMinuteStr() : ExKDStringHelper.getSecondStr();
        String format = ExKDStringHelper.getStepRuleStr();
        return String.format(Locale.ROOT, format, name, aRe, culValue, culUnit, bre, maxValue, maxUnit);
    }

    private static boolean maxValueIsNull(DynamicObject dy) {
        Object maxValueObj = dy.get("maxvalue");
        if (maxValueObj == null) {
            return true;
        }
        return dy.getInt("maxvalue") > 86400;
    }

    public static String getStepResultStr(DynamicObject dy) {
        String appointUnitStr;
        String appointValueStr;
        String dealType = dy.getString("dealtype");
        if (HRStringUtils.isEmpty((String)dealType)) {
            return null;
        }
        boolean noStep = HRStringUtils.equals((String)"A", (String)dealType);
        if (noStep) {
            return null;
        }
        String resultItem = ExConfigService.resultItem(dy);
        String dealMethod = dy.getString("dealmethod");
        DynamicObject roundRule = dy.getDynamicObject("roundrule");
        if (HRStringUtils.equals((String)"A", (String)dealMethod)) {
            if (roundRule != null) {
                return String.format(Locale.ROOT, ExKDStringHelper.getNoStepResultStr(), roundRule.getLocaleString("name"), resultItem);
            }
            return String.format(Locale.ROOT, ExKDStringHelper.getStepResultAStr(), resultItem);
        }
        String appointUnit = dy.getString("appointunit");
        BigDecimal appointValue = dy.getBigDecimal("appointvalue");
        if (HRStringUtils.equals((String)"day", (String)appointUnit)) {
            appointValueStr = String.valueOf(appointValue.setScale(2));
            appointUnitStr = ExKDStringHelper.getDayStr();
        } else if (HRStringUtils.equals((String)"hour", (String)appointUnit)) {
            appointValueStr = appointValue.stripTrailingZeros().toPlainString();
            appointUnitStr = ExKDStringHelper.getHourStr();
        } else {
            appointValueStr = appointValue.stripTrailingZeros().toPlainString();
            appointUnitStr = ExKDStringHelper.getMinuteStr();
        }
        if (roundRule != null) {
            return String.format(Locale.ROOT, ExKDStringHelper.getRoundFixV2(), roundRule.getLocaleString("name"), resultItem, appointValueStr, appointUnitStr);
        }
        return String.format(Locale.ROOT, ExKDStringHelper.getStepResultBStr(), resultItem, appointValueStr, appointUnitStr);
    }

    private static String resultItem(DynamicObject dy) {
        DynamicObjectCollection list = dy.getDynamicObjectCollection("attitems");
        List collect = list.stream().map(dd -> ((OrmLocaleValue)dd.get("fbasedataid.name")).getLocaleValue()).collect(Collectors.toList());
        return StringUtils.join(collect, (String)"\u3001");
    }

    public static String getNoStepRuleStr(DynamicObject dy) {
        String dealType = dy.getString("dealtype");
        if (HRStringUtils.isEmpty((String)dealType)) {
            return null;
        }
        boolean isStep = HRStringUtils.equals((String)"B", (String)dealType);
        if (isStep) {
            return null;
        }
        String format = "%s %s %s %s";
        DynamicObject originalItem = dy.getDynamicObject("originalitem");
        String name = originalItem.getString("name");
        int culValue = dy.getInt("culvalue");
        String aRe = HRStringUtils.equals((String)">=", (String)dy.getString("are")) ? ExKDStringHelper.getGreaterEqualStr() : ExKDStringHelper.getGreaterStr();
        String culUnit = HRStringUtils.equals((String)"minute", (String)dy.getString("culunit")) ? ExKDStringHelper.getMinuteStr() : ExKDStringHelper.getSecondStr();
        return String.format(Locale.ROOT, format, name, aRe, culValue, culUnit);
    }

    public static String getNoStepResultStr(DynamicObject dy) {
        String dealType = dy.getString("dealtype");
        if (HRStringUtils.isEmpty((String)dealType)) {
            return null;
        }
        String resultItem = ExConfigService.resultItem(dy);
        DynamicObject roundRule = dy.getDynamicObject("roundrule");
        if (roundRule != null) {
            String format = ExKDStringHelper.getNoStepResultStr();
            return String.format(Locale.ROOT, format, roundRule.getString("name"), resultItem);
        }
        return String.format(Locale.ROOT, ExKDStringHelper.getNoStepResultNotRoundRuleStr(), resultItem);
    }

    public static Map<String, Object> getMapOfAbs(DynamicObject dy) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        map.put("punchcardshow", dy.get("punchcard"));
        map.put("originalitem", dy.get("originalitem"));
        map.put("attitems", dy.get("attitems"));
        return map;
    }

    static {
        NO_CATEGORYA_EX.add(0L);
        NO_CATEGORYA_EX.add(PreDataExAttribute.PD_1050_S);
        NO_CATEGORYA_EX.add(PreDataExAttribute.PD_1060_S);
        NO_CATEGORYA_EX.add(PreDataExAttribute.PD_1030_S);
    }
}

