/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.ex;

import com.kingdee.bos.qing.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.daterange.DateRangeServiceImpl;
import kd.wtc.wtbs.business.daterange.IDateRangeService;
import kd.wtc.wtbs.common.model.ex.ExAtteItemVo;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.ex.ExCommonService;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;
import kd.wtc.wtp.common.ex.rule.vo.ExEntryEntityAttItemVo;

public class ExRuleService {
    private static final String CONDITION = "conditions";
    private static final BigDecimal DAY_TO_HOUR = new BigDecimal("24");
    private static final BigDecimal SIXTY = new BigDecimal("60");
    private static final IDateRangeService DATE_RANGE_SERVICE = new DateRangeServiceImpl();

    private ExRuleService() {
        throw new IllegalStateException("Utility class");
    }

    public static void makeExAtteItemVoListByEntryCollection(List<ExAtteItemVo> list, DynamicObject rule) {
        DynamicObjectCollection aEntryCollection = rule.getDynamicObjectCollection("exconfigid.entryentity");
        String attributeName = rule.getString("exconfigid.exattribute.name");
        String propertyName = rule.getString("exconfigid.name");
        if (CollectionUtils.isNotEmpty((Collection)aEntryCollection)) {
            for (DynamicObject dynamicObject : aEntryCollection) {
                long orgItemId;
                DynamicObjectCollection attItemsCollection = dynamicObject.getDynamicObjectCollection("attitems");
                if (CollectionUtils.isNotEmpty((Collection)attItemsCollection)) {
                    for (DynamicObject attItems : attItemsCollection) {
                        Long attItemsId = attItems.getLong("fbasedataid.id");
                        ExAtteItemVo itemsVo = new ExAtteItemVo(attItemsId, propertyName, attributeName);
                        list.add(itemsVo);
                    }
                }
                if ((orgItemId = dynamicObject.getLong("originalitem.id")) == 0L) continue;
                ExAtteItemVo itemVo = new ExAtteItemVo(Long.valueOf(orgItemId), propertyName, attributeName);
                list.add(itemVo);
            }
        }
    }

    public static boolean timeCheck(Map<Long, List<Long>> map) {
        if (map.isEmpty()) {
            return true;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_daterange");
        for (Map.Entry<Long, List<Long>> entry : map.entrySet()) {
            boolean result;
            Long key = entry.getKey();
            List<Long> exConfigIdList = entry.getValue();
            if (key == null || exConfigIdList == null || exConfigIdList.size() <= 1 || (result = ExRuleService.checkCondition(exConfigIdList, serviceHelper))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkCondition(List<Long> exConfigIdList, HRBaseServiceHelper serviceHelper) {
        QFilter numberQFilter = new QFilter("metanumber", "=", (Object)"wtp_exconfig");
        QFilter idQFilter = new QFilter("basedataid", "in", exConfigIdList);
        DynamicObject[] conditionArr = serviceHelper.query(CONDITION, new QFilter[]{numberQFilter, idQFilter});
        for (int ii = 0; ii < conditionArr.length - 1; ++ii) {
            for (int jj = ii + 1; jj < conditionArr.length; ++jj) {
                ArrayList list = Lists.newArrayListWithExpectedSize((int)1);
                list.add(conditionArr[ii].getString(CONDITION));
                String conditions = conditionArr[jj].getString(CONDITION);
                Boolean contentDateRange = DATE_RANGE_SERVICE.isContentDateRange((List)list, conditions);
                if (!Boolean.TRUE.equals(contentDateRange)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean checkAttItems(IFormView view, DynamicObject exEntryEntity, Map<Long, List<ExEntryEntityAttItemVo>> map, boolean isBeforeSave) {
        DynamicObjectCollection attItemList = exEntryEntity.getDynamicObjectCollection("attitem");
        ArrayList attItemIdList = Lists.newArrayListWithExpectedSize((int)attItemList.size());
        HashSet unitSet = Sets.newHashSetWithExpectedSize((int)attItemList.size());
        for (DynamicObject dy : attItemList) {
            if (dy == null) continue;
            unitSet.add(((DynamicObject)dy.get("fbasedataid")).getString("unit"));
            attItemIdList.add(dy.getLong("fbasedataid.id"));
        }
        if (isBeforeSave && unitSet.size() > 1) {
            view.showTipNotification(ExKDStringHelper.unitError());
            return false;
        }
        for (Long attItemId : attItemIdList) {
            ArrayList voList = map.get(attItemId);
            if (voList == null) {
                voList = Lists.newArrayListWithExpectedSize((int)16);
            }
            String rel = exEntryEntity.getString("rela");
            BigDecimal value = exEntryEntity.getBigDecimal("value");
            String vUnit = exEntryEntity.getString("vunit");
            String maxValueRel = exEntryEntity.getString("relas");
            BigDecimal maxValue = exEntryEntity.getBigDecimal("values");
            String maxValueUnit = exEntryEntity.getString("vunits");
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{rel, vUnit, maxValueRel, maxValueUnit})) {
                return true;
            }
            ExEntryEntityAttItemVo vo = new ExEntryEntityAttItemVo(attItemId, rel, value, vUnit, maxValueRel, maxValue, maxValueUnit);
            boolean result = ExCommonService.checkAttItem(voList, vo);
            if (!result) {
                view.showTipNotification(ExKDStringHelper.repeatValue());
                return false;
            }
            voList.add(vo);
            map.put(attItemId, voList);
        }
        return true;
    }

    public static BigDecimal getUnitValue(BigDecimal value, String unit) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        switch (unit) {
            case "minute": {
                value = value.multiply(SIXTY);
                break;
            }
            case "hour": {
                value = value.multiply(SIXTY).multiply(SIXTY);
                break;
            }
            case "day": {
                value = value.multiply(DAY_TO_HOUR).multiply(SIXTY).multiply(SIXTY);
                break;
            }
        }
        return value;
    }

    public static void addDetailClosedCallBack(Map<String, Object> returnData, IDataModel model, IFormView view) {
        if (returnData == null) {
            return;
        }
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        int row = 0;
        if (entryEntity != null) {
            row = entryEntity.size();
        }
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", 1);
        ExRuleService.setValue(returnData, model, row);
        model.endInit();
        view.updateView("entryentity");
    }

    public static int editEntryIndex(String actionId) {
        if (actionId.startsWith("exruledetail_edit")) {
            return Integer.parseInt(actionId.substring("exruledetail_edit".length()));
        }
        return -1;
    }

    public static void editDetailClosedCallBack(Map<String, Object> returnData, IDataModel model, IFormView view, int row) {
        if (returnData == null) {
            return;
        }
        model.beginInit();
        ExRuleService.setValue(returnData, model, row);
        model.endInit();
        view.updateView("entryentity");
    }

    private static void setValue(Map<String, Object> returnData, IDataModel model, int row) {
        model.setValue("ruleshow", returnData.get("ruleshow"), row);
        model.setValue("resultshow", returnData.get("resultshow"), row);
        model.setValue("attitem", returnData.get("attitem"), row);
        model.setValue("rela", returnData.get("rela"), row);
        model.setValue("value", returnData.get("value"), row);
        model.setValue("vunit", returnData.get("vunit"), row);
        model.setValue("relas", returnData.get("relas"), row);
        model.setValue("values", returnData.get("values"), row);
        model.setValue("vunits", returnData.get("vunits"), row);
        model.setValue("dealtype", returnData.get("dealtype"), row);
        model.setValue("appointvalue", returnData.get("appointvalue"), row);
        model.setValue("appointunit", returnData.get("appointunit"), row);
        model.setValue("exattribute", returnData.get("exattribute"), row);
        model.setValue("resattitem", returnData.get("resattitem"), row);
    }

    public static String getRuleShow(DynamicObject dy) {
        boolean isEmpty;
        DynamicObjectCollection list = dy.getDynamicObjectCollection("attitem");
        int max = 86401;
        boolean bl = isEmpty = dy.get("values") == null || max == dy.getInt("values");
        if (list == null || list.isEmpty()) {
            return null;
        }
        String format = list.size() == 1 ? (isEmpty ? ExKDStringHelper.ruleShowOneNotMaxValue() : ExKDStringHelper.ruleShowOne()) : (list.size() == 2 ? (isEmpty ? ExKDStringHelper.ruleShowTwoNotMaxValue() : ExKDStringHelper.ruleShowTwo()) : (isEmpty ? ExKDStringHelper.ruleShowThreeNotMaxValue() : ExKDStringHelper.ruleShowThree()));
        String attItem = ExRuleService.resultItem(list);
        String aRe = HRStringUtils.equals((String)">=", (String)dy.getString("rela")) ? ExKDStringHelper.getGreaterEqualStr() : ExKDStringHelper.getGreaterStr();
        String bre = HRStringUtils.equals((String)"<", (String)dy.getString("relas")) ? ExKDStringHelper.getLessStr() : ExKDStringHelper.getLessEqualStr();
        return String.format(Locale.ROOT, format, attItem, aRe, dy.get("value"), ExRuleService.getUnitStr(dy.getString("vunit")), bre, dy.get("values"), ExRuleService.getUnitStr(dy.getString("vunits")));
    }

    private static String getUnitStr(String unit) {
        String result;
        switch (unit) {
            case "minute": {
                result = ExKDStringHelper.getMinuteStr();
                break;
            }
            case "hour": {
                result = ExKDStringHelper.getHourStr();
                break;
            }
            case "day": {
                result = ExKDStringHelper.getDayStr();
                break;
            }
            default: {
                result = ExKDStringHelper.getSecondStr();
            }
        }
        return result;
    }

    public static String getResultShow(DynamicObject dy) {
        String dealType = dy.getString("dealtype");
        boolean isAppoint = HRStringUtils.equals((String)"B", (String)dealType);
        DynamicObject exAttribute = dy.getDynamicObject("exattribute");
        String exAttributeName = exAttribute.getString("name");
        DynamicObject reAttItem = dy.getDynamicObject("resattitem");
        String reAttItemName = reAttItem.getString("name");
        if (isAppoint) {
            String appointUnitStr;
            String appointValueStr;
            String appointUnit = dy.getString("appointunit");
            BigDecimal appointValue = dy.getBigDecimal("appointvalue");
            if (HRStringUtils.equals((String)"day", (String)appointUnit)) {
                appointValueStr = String.valueOf(appointValue.setScale(2));
                appointUnitStr = ExKDStringHelper.getDayStr();
            } else if (HRStringUtils.equals((String)"hour", (String)appointUnit)) {
                appointValueStr = appointValue.stripTrailingZeros().toPlainString();
                appointUnitStr = ExKDStringHelper.getHourStr();
            } else {
                appointValueStr = appointValue.stripTrailingZeros().toPlainString();
                appointUnitStr = ExKDStringHelper.getMinuteStr();
            }
            return String.format(Locale.ROOT, ExKDStringHelper.resultShow(), reAttItemName, exAttributeName, appointValueStr, appointUnitStr);
        }
        return String.format(Locale.ROOT, ExKDStringHelper.resultShowNoAppoint(), reAttItemName, exAttributeName);
    }

    private static String resultItem(DynamicObjectCollection list) {
        if (list.size() == 1) {
            return ((OrmLocaleValue)((DynamicObject)list.get(0)).get("fbasedataid.name")).getLocaleValue();
        }
        ArrayList collect = Lists.newArrayListWithExpectedSize((int)2);
        for (int index = 0; index < 2; ++index) {
            collect.add(((OrmLocaleValue)((DynamicObject)list.get(index)).get("fbasedataid.name")).getLocaleValue());
        }
        return StringUtils.join((Iterable)collect, (String)"\u3001");
    }
}

