/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class FormulaRuleService {
    private static final HRBaseServiceHelper ACCOUNTPLAN_HELPER = new HRBaseServiceHelper("wtp_accountplan");
    private static final HRBaseServiceHelper ACCOUNTSTEP_HELPER = new HRBaseServiceHelper("wtp_accountsteps");
    private static final HRBaseServiceHelper FORMULASET_HELPER = new HRBaseServiceHelper("wtp_formulaset");
    private static final HRBaseServiceHelper ATTITEM_HELPER = new HRBaseServiceHelper("wtbd_attitem");

    public List<QFilter> getAccountPlanFilter(Date ruleEffectDate, String scene) {
        if (ruleEffectDate == null) {
            return Lists.newArrayList((Object[])new QFilter[]{new QFilter("id", "=", (Object)0L)});
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("firstbsed", "<=", (Object)ruleEffectDate));
        if (HRStringUtils.equals((String)"1", (String)scene)) {
            qFilters.add(new QFilter("accounttype", "=", (Object)"A"));
        } else if (HRStringUtils.equals((String)"2", (String)scene)) {
            qFilters.add(new QFilter("accounttype", "=", (Object)"C"));
            qFilters.add(new QFilter("accountmode", "=", (Object)"C"));
        }
        return qFilters;
    }

    public Map<String, LocaleString> getRelatedAndFilteredAndSortedAccountSteps(Long accountPlanId) {
        DynamicObject accountPlan = ACCOUNTPLAN_HELPER.loadDynamicObject(new QFilter("id", "=", (Object)accountPlanId));
        if (null == accountPlan) {
            return Collections.emptyMap();
        }
        DynamicObjectCollection phases = accountPlan.getDynamicObjectCollection("entryentity");
        HashSet stepIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject phase : phases) {
            DynamicObjectCollection dynCollect = phase.getDynamicObjectCollection("subentryentity");
            if (CollectionUtils.isEmpty((Collection)dynCollect)) continue;
            stepIdSet.addAll(dynCollect.stream().map(ob -> ob.getLong("stepid.id")).collect(Collectors.toSet()));
        }
        DynamicObject[] steps = ACCOUNTSTEP_HELPER.loadDynamicObjectArray(stepIdSet.toArray());
        if (steps == null || steps.length == 0) {
            return Collections.emptyMap();
        }
        List filteredSteps = Arrays.stream(steps).filter(step -> "1".equals(step.getString("calrule"))).collect(Collectors.toList());
        TreeMap<String, LocaleString> options = new TreeMap<String, LocaleString>();
        for (DynamicObject filteredStep : filteredSteps) {
            LocaleString localeString = new LocaleString(filteredStep.getString("name"));
            options.put(filteredStep.getString("id"), localeString);
        }
        return options;
    }

    public List<QFilter> getAccountStepF7Filter(Date ruleEffectDate, Long accountPlanId) {
        return this.getAccountStepF7Filter(ruleEffectDate, accountPlanId, "1");
    }

    public List<QFilter> getAccountStepF7Filter(Date ruleEffectDate, Long accountPlanId, String scene) {
        if (ruleEffectDate == null) {
            return Lists.newArrayList((Object[])new QFilter[]{new QFilter("id", "=", (Object)0L)});
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("firstbsed", "<=", (Object)ruleEffectDate));
        qFilters.add(new QFilter("calrule", "=", (Object)"1"));
        if (HRStringUtils.equals((String)"1", (String)scene)) {
            qFilters.add(new QFilter("accounttype", "like", (Object)"%A%"));
        } else if (HRStringUtils.equals((String)"2", (String)scene)) {
            qFilters.add(new QFilter("accounttype", "like", (Object)"%C%"));
        }
        if (null != accountPlanId) {
            Map<String, LocaleString> map = this.getRelatedAndFilteredAndSortedAccountSteps(accountPlanId);
            qFilters.add(new QFilter("id", "in", map.keySet().stream().map(Long::parseLong).collect(Collectors.toList())));
        }
        return qFilters;
    }

    public List<QFilter> getFormulaConfigFilter(Date ruleEffectDate) {
        if (ruleEffectDate == null) {
            return Lists.newArrayList((Object[])new QFilter[]{new QFilter("id", "=", (Object)0L)});
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("firstbsed", "<=", (Object)ruleEffectDate));
        return qFilters;
    }

    public Map<Long, DynamicObject> getFormulaConfigResultItemMap(Object[] configIds) {
        DynamicObject[] configDys = FORMULASET_HELPER.queryOriginalArray("id,resultitem.id", new QFilter[]{new QFilter("id", "in", (Object)configIds)});
        HashMap<Long, Long> config2ResultItemIdMap = new HashMap<Long, Long>(16);
        Arrays.stream(configDys).forEach(configDy -> config2ResultItemIdMap.put(configDy.getLong("id"), configDy.getLong("resultitem.id")));
        DynamicObject[] attDys = ATTITEM_HELPER.queryOriginalArray("id,name", new QFilter[]{new QFilter("id", "in", (Object)config2ResultItemIdMap.values().toArray())});
        HashMap resultItemId2DyMap = new HashMap(16);
        Arrays.stream(attDys).forEach(attDy -> resultItemId2DyMap.put(attDy.getLong("id"), attDy));
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(16);
        config2ResultItemIdMap.forEach((configId, resultItemId) -> {
            if (resultItemId2DyMap.containsKey(resultItemId)) {
                result.put((Long)configId, (DynamicObject)resultItemId2DyMap.get(resultItemId));
            }
        });
        return result;
    }
}

