/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.service.formula.entity.item.CalItem;
import kd.hr.hbp.business.service.formula.entity.item.ResultItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.wtbd.common.enums.constparam.ConstParamTypeEnum;
import kd.wtc.wtp.constants.formula.FormulaConstants;

public class FormulaSetService
implements FormulaConstants {
    private static final FormulaSetService INSTANCE = (FormulaSetService)WTCAppContextHelper.getBean(FormulaSetService.class);
    private static final HRBaseServiceHelper CALELEMENTHELPER = new HRBaseServiceHelper("wtp_calelement");

    public static FormulaSetService getInstance() {
        return INSTANCE;
    }

    public DynamicObjectCollection getCalElementDyList(QFilter filter) {
        return CALELEMENTHELPER.queryOriginalCollection("id,name,longnumber,uniquecode,number,parent,datatype", new QFilter[]{filter});
    }

    public DynamicObjectCollection getAttItemDyList(String selectFields, QFilter ... otherFilters) {
        ArrayList filterList = Lists.newArrayListWithExpectedSize((int)4);
        if (otherFilters != null && otherFilters.length > 0) {
            filterList.addAll(Arrays.asList(otherFilters));
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_attitem");
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
        filterList.add(filter);
        return helper.queryOriginalCollection(selectFields, filterList.toArray(new QFilter[0]));
    }

    public DynamicObjectCollection getConstParamDyList(String selectFields, QFilter ... otherFilters) {
        ArrayList filterList = Lists.newArrayListWithExpectedSize((int)4);
        if (otherFilters != null && otherFilters.length > 0) {
            filterList.addAll(Arrays.asList(otherFilters));
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_constparam");
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filterList.add(filter);
        return helper.queryOriginalCollection(selectFields, filterList.toArray(new QFilter[0]));
    }

    public List<DynamicObject> excludeWithoutChildrenCategory(List<DynamicObject> allEleCategoryList) {
        List idList = allEleCategoryList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection calElementDyList = FormulaSetService.getInstance().getCalElementDyList(new QFilter("parent", "in", idList));
        if (WTCCollections.isEmpty((Collection)calElementDyList)) {
            return allEleCategoryList;
        }
        Set hasChildrenCategoryIdSet = calElementDyList.stream().map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"parent")).collect(Collectors.toSet());
        hasChildrenCategoryIdSet.add(CALELEMENT_OF_ATTRESULT);
        Iterator<DynamicObject> iterator = allEleCategoryList.iterator();
        while (iterator.hasNext()) {
            long id = iterator.next().getLong("id");
            if (hasChildrenCategoryIdSet.contains(id)) continue;
            iterator.remove();
        }
        return allEleCategoryList;
    }

    public Optional<List<TreeNodeItem>> getCalItemList(String scene, DynamicObject dataEntity) {
        if (HRStringUtils.isEmpty((String)scene)) {
            return Optional.of(new ArrayList(0));
        }
        List<TreeNodeItem> treeNodeItems = this.buildCalItemByScene(scene, dataEntity);
        return Optional.of(treeNodeItems);
    }

    public List<TreeNodeItem> initItemTree(String scene, DynamicObject dataEntity) {
        return this.buildCalItemByScene(scene, dataEntity);
    }

    private List<TreeNodeItem> buildCalItemByScene(String scene, DynamicObject dataEntity) {
        Long sceneId = HRStringUtils.equals((String)"1", (String)scene) ? PRESET_RETRIEVALRULE_AE_1070_S : PRESET_RETRIEVALRULE_QE_1080_S;
        QFilter filter = new QFilter("id", "=", (Object)sceneId);
        DynamicObject rule = new HRBaseServiceHelper("wtbd_scenerulecfg").loadDynamicObject(new QFilter[]{filter});
        DynamicObjectCollection entries = rule.getDynamicObjectCollection("entryentity");
        Set<Long> categoryIds = entries.stream().map(entry -> entry.getLong("inputobject.id")).collect(Collectors.toSet());
        HashSet<Long> itemIds = new HashSet<Long>(16);
        ArrayList<Long> sortedItemIds = new ArrayList<Long>(16);
        HashMap<Long, String> idToDisplayNameMap = new HashMap<Long, String>(16);
        for (DynamicObject entry2 : entries) {
            DynamicObjectCollection subEntries = entry2.getDynamicObjectCollection("subentryentity");
            subEntries.forEach(subEntry -> {
                long fieldId = subEntry.getLong("fieldid.id");
                if (fieldId != 0L) {
                    itemIds.add(fieldId);
                    sortedItemIds.add(fieldId);
                    if (HRStringUtils.isNotEmpty((String)subEntry.getString("fielddisplayname"))) {
                        idToDisplayNameMap.put(fieldId, subEntry.getString("fielddisplayname"));
                    }
                }
            });
        }
        DynamicObject[] allItems = new HRBaseServiceHelper("wtbd_scenefieldcfg").loadDynamicObjectArray(new QFilter[0]);
        LinkedList<TreeNodeItem> treeNodeItems = new LinkedList<TreeNodeItem>();
        this.buildCalItem(allItems, categoryIds, itemIds, treeNodeItems, scene, sortedItemIds, idToDisplayNameMap);
        if (HRStringUtils.equals((String)"1", (String)scene)) {
            this.buildCalItemForAttItem(treeNodeItems, dataEntity);
            this.buildCalItemForConstParam(treeNodeItems, dataEntity);
        }
        return treeNodeItems;
    }

    private void buildCalItemForConstParam(List<TreeNodeItem> treeNodeItems, DynamicObject dataEntity) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"wtbd_constparam", (Long)WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntity, (String)"createorg"));
        DynamicObjectCollection constParamList = FormulaSetService.getInstance().getConstParamDyList("id,name,number,type,description", baseDataFilter);
        List<Long> nameRepeatIdList = this.getNameRepeatAttItem(constParamList);
        for (DynamicObject dy : constParamList) {
            CalItem calItem = new CalItem();
            calItem.setItemCategory("AE");
            calItem.setId(String.valueOf(dy.getLong("id")));
            calItem.setParentId(String.valueOf(CALELEMENT_CATEGORY_OF_CONSTPARAM));
            String type = dy.getString("type");
            String name = this.getConstParamName(type, dy.getString("name"));
            String number = dy.getString("number");
            calItem.setName(nameRepeatIdList.contains(dy.getLong("id")) ? name + "_" + number : name);
            calItem.setUniqueCode("FM$B$wtbd_constparam$" + dy.getLong("id"));
            calItem.setDataType("BOOLEAN".equals(type) ? DataTypeEnum.TEXT : DataTypeEnum.getDataType((String)type));
            treeNodeItems.add((TreeNodeItem)calItem);
        }
    }

    private String getConstParamName(String type, String name) {
        if (ConstParamTypeEnum.STRING.getCode().equalsIgnoreCase(type)) {
            name = ResManager.loadKDString((String)"%1$s_\u6587\u672c", (String)"FormulaSetService_1", (String)"wtc-wtp-business", (Object[])new Object[]{name});
        } else if (ConstParamTypeEnum.NUMBER.getCode().equalsIgnoreCase(type)) {
            name = ResManager.loadKDString((String)"%1$s_\u6570\u503c", (String)"FormulaSetService_2", (String)"wtc-wtp-business", (Object[])new Object[]{name});
        } else if (ConstParamTypeEnum.DATE.getCode().equalsIgnoreCase(type)) {
            name = ResManager.loadKDString((String)"%1$s_\u65e5\u671f", (String)"FormulaSetService_3", (String)"wtc-wtp-business", (Object[])new Object[]{name});
        } else if (ConstParamTypeEnum.BOOLEAN.getCode().equalsIgnoreCase(type)) {
            name = ResManager.loadKDString((String)"%1$s_\u5e03\u5c14", (String)"FormulaSetService_4", (String)"wtc-wtp-business", (Object[])new Object[]{name});
        }
        return name;
    }

    private void buildCalItemForAttItem(List<TreeNodeItem> treeNodeItems, DynamicObject dataEntity) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"wtbd_attitem", (Long)WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntity, (String)"createorg"));
        DynamicObjectCollection attItemList = FormulaSetService.getInstance().getAttItemDyList("id,name,number,isorginattitem,issyspreset,description", baseDataFilter);
        List<Long> attItemIdList = this.getNameRepeatAttItem(attItemList);
        for (DynamicObject dy : attItemList) {
            CalItem calItem = new CalItem();
            calItem.setItemCategory("AE");
            calItem.setId(String.valueOf(dy.getLong("id")));
            if (dy.getBoolean("issyspreset") && !dy.getBoolean("isorginattitem")) {
                calItem.setParentId(String.valueOf(CALELEMENT_CATEGORY_OF_PRESET_ITEM));
            } else if (!dy.getBoolean("issyspreset")) {
                calItem.setParentId(String.valueOf(CALELEMENT_CATEGORY_OF_CUSTOM_ITEM));
            } else if (dy.getBoolean("isorginattitem")) {
                calItem.setParentId(String.valueOf(CALELEMENT_CATEGORY_OF_ORIGINAL_ITEM));
            }
            String name = dy.getString("name");
            String number = dy.getString("number");
            calItem.setName(attItemIdList.contains(dy.getLong("id")) ? name + "_" + number : name);
            calItem.setUniqueCode("FM$B$wtbd_attitem$" + dy.getLong("id"));
            calItem.setDataType(DataTypeEnum.NUM);
            treeNodeItems.add((TreeNodeItem)calItem);
        }
    }

    private void buildCalItem(DynamicObject[] allItems, Set<Long> categoryIds, Set<Long> itemIds, List<TreeNodeItem> treeNodeItems, String scene, List<Long> sortedItemIds, Map<Long, String> idToDisplayNameMap) {
        HashMap<Long, DynamicObject> idToDyMap = new HashMap<Long, DynamicObject>();
        Arrays.stream(allItems).forEach(item -> idToDyMap.put(item.getLong("id"), (DynamicObject)item));
        if (HRStringUtils.equals((String)"1", (String)scene)) {
            categoryIds.add(CALELEMENT_OF_ATTRESULT);
            categoryIds.add(CALELEMENT_CATEGORY_OF_ORIGINAL_ITEM);
            categoryIds.add(CALELEMENT_CATEGORY_OF_PRESET_ITEM);
            categoryIds.add(CALELEMENT_CATEGORY_OF_CUSTOM_ITEM);
            categoryIds.add(CALELEMENT_CATEGORY_OF_CONSTPARAM);
        }
        ArrayList<Long> categoryIdsWithParent = new ArrayList<Long>(categoryIds);
        this.buildCalItemForCategory(categoryIds, treeNodeItems, idToDyMap, categoryIdsWithParent);
        this.buildCalItem(itemIds, treeNodeItems, idToDyMap, idToDisplayNameMap);
        this.sortCalItem(categoryIdsWithParent, sortedItemIds, treeNodeItems, idToDyMap);
    }

    private void sortCalItem(List<Long> categoryIdsWithParent, List<Long> sortedItemIds, List<TreeNodeItem> treeNodeItems, Map<Long, DynamicObject> idToDyMap) {
        ArrayList<Object> allSortIds = new ArrayList<Object>(10);
        List sortedCategoryIds = categoryIdsWithParent.stream().sorted(Comparator.comparingInt(categoryId -> idToDyMap.containsKey(categoryId) ? ((DynamicObject)idToDyMap.get(categoryId)).getInt("index") : 0)).collect(Collectors.toList());
        allSortIds.addAll(sortedCategoryIds);
        allSortIds.addAll(sortedItemIds);
        HashMap<String, Integer> idToIndexMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < allSortIds.size(); ++i) {
            idToIndexMap.put(String.valueOf(allSortIds.get(i)), i);
        }
        treeNodeItems.sort(Comparator.comparingInt(node -> idToIndexMap.getOrDefault(node.getId(), 0)));
    }

    private void buildCalItemForCategory(Set<Long> categoryIds, List<TreeNodeItem> treeNodeItems, Map<Long, DynamicObject> idToDyMap, List<Long> categoryIdsWithParent) {
        HashSet<Long> parentCategoryIds = new HashSet<Long>();
        for (Long categoryId : categoryIds) {
            DynamicObject dy = idToDyMap.get(categoryId);
            long parentId = dy.getLong("parent.id");
            TreeNodeItem treeNodeItem = new TreeNodeItem();
            treeNodeItem.setId(String.valueOf(dy.getLong("id")));
            treeNodeItem.setName(dy.getString("name"));
            treeNodeItem.setUniqueCode(dy.getString("numberx"));
            if (parentId != 0L) {
                DynamicObject parent = idToDyMap.get(parentId);
                treeNodeItem.setItemCategory(parent != null ? parent.getString("numberx") : "");
                treeNodeItem.setParentId(String.valueOf(parentId));
                parentCategoryIds.add(parentId);
            }
            treeNodeItems.add(treeNodeItem);
        }
        if (!parentCategoryIds.isEmpty()) {
            categoryIdsWithParent.addAll(parentCategoryIds);
            this.buildCalItemForCategory(parentCategoryIds, treeNodeItems, idToDyMap, categoryIdsWithParent);
        }
    }

    private void buildCalItem(Set<Long> itemIds, List<TreeNodeItem> treeNodeItems, Map<Long, DynamicObject> idToDyMap, Map<Long, String> idToDisplayNameMap) {
        for (Long itemId : itemIds) {
            DynamicObject dy = idToDyMap.get(itemId);
            long parentId = dy.getLong("parent.id");
            CalItem calItem = new CalItem();
            if (parentId != 0L) {
                DynamicObject parent = idToDyMap.get(parentId);
                calItem.setItemCategory(parent.getString("longnumber").split("\\.")[0]);
            }
            long id = dy.getLong("id");
            calItem.setId(String.valueOf(id));
            calItem.setParentId(String.valueOf(parentId));
            calItem.setName(idToDisplayNameMap.containsKey(id) ? idToDisplayNameMap.get(id) : dy.getString("name"));
            calItem.setUniqueCode(dy.getString("uniquecode"));
            calItem.setDataType(this.retrievalItemTypeToCalItemType(dy.getString("type")));
            if (DataTypeEnum.DATE.equals((Object)calItem.getDataType())) {
                calItem.setCheckHourMinSec(true);
            }
            treeNodeItems.add((TreeNodeItem)calItem);
        }
    }

    private DataTypeEnum retrievalItemTypeToCalItemType(String type) {
        switch (type) {
            case "string": 
            case "enum": 
            case "boolean": {
                return DataTypeEnum.TEXT;
            }
            case "dynamicObject": 
            case "number": {
                return DataTypeEnum.NUM;
            }
            case "date": {
                return DataTypeEnum.DATE;
            }
            case "array": {
                return DataTypeEnum.ARRAY_OBJECT;
            }
        }
        return DataTypeEnum.OBJECT;
    }

    public List<Long> getNameRepeatAttItem(DynamicObjectCollection attItemList) {
        ArrayList attItemIdList = Lists.newArrayListWithExpectedSize((int)10);
        HashSet set = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject attItem : attItemList) {
            String name = attItem.getString("name");
            if (set.contains(name)) {
                attItemIdList.add(attItem.getLong("id"));
            }
            set.add(name);
        }
        return attItemIdList;
    }

    public Optional<List<ResultItem>> getSlResultItemList(String scene) {
        if (HRStringUtils.equals((String)"1", (String)scene)) {
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            DynamicObjectCollection slDyList = FormulaSetService.getInstance().getAttItemDyList("id,name,number,isorginattitem,issyspreset,description", filter);
            if (Objects.nonNull(slDyList)) {
                ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>(slDyList.size());
                for (DynamicObject item : slDyList) {
                    ResultItem resultItem = new ResultItem();
                    resultItem.setItemCategory("wtbd_attitem");
                    resultItem.setId(String.valueOf(item.getLong("id")));
                    resultItem.setName(item.getString("name"));
                    resultItem.setUniqueCode("FM$B$wtbd_attitem$" + item.getLong("id"));
                    resultItem.setDataType(DataTypeEnum.NUM);
                    resultItem.setEntityNumber("wtbd_attitem");
                    resultItem.setDataLength(Integer.valueOf(19));
                    resultItem.setScale(Integer.valueOf(6));
                    resultItems.add(resultItem);
                }
                return Optional.of(resultItems);
            }
        } else if (HRStringUtils.equals((String)"2", (String)scene)) {
            QFilter filter = new QFilter("boid", "in", (Object)Lists.newArrayList((Object[])new Long[]{PRESET_QT_RESULTITEM_ID}));
            ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>(1);
            DynamicObjectCollection slDyList = FormulaSetService.getInstance().getAttItemDyList("id,name,number,isorginattitem,issyspreset,description", filter);
            if (WTCCollections.isNotEmpty((Collection)slDyList)) {
                DynamicObject qtAttItem = (DynamicObject)slDyList.get(0);
                ResultItem resultItem = new ResultItem();
                resultItem.setItemCategory("wtbd_attitem");
                resultItem.setId(String.valueOf(PRESET_QT_RESULTITEM_ID));
                resultItem.setName(qtAttItem.getString("name"));
                resultItem.setUniqueCode("FM$A$A$3101_S");
                resultItem.setDataType(DataTypeEnum.ARRAY_OBJECT);
                resultItems.add(resultItem);
            }
            return Optional.of(resultItems);
        }
        return Optional.empty();
    }
}

