/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.formula.adapt;

import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.common.constants.retrieval.WTCDataTypeEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.formula.FormulaCalcUtils;
import kd.wtc.wtp.common.formula.AttCalItem;
import kd.wtc.wtp.common.formula.AttFormula;
import kd.wtc.wtp.common.formula.AttFunction;
import kd.wtc.wtp.common.formula.AttResultItem;

public class FormulaInitHelper {
    private static final HRBaseServiceHelper FORMULASET_HELPER = new HRBaseServiceHelper("wtp_formulaset");
    private static final HRBaseServiceHelper ITEM_HELPER = new HRBaseServiceHelper("wtbd_scenefieldcfg");
    private static final HRBaseServiceHelper ATTITEM_HELPER = new HRBaseServiceHelper("wtbd_attitem");
    private static final HRBaseServiceHelper CONSTPARAM_HELPER = new HRBaseServiceHelper("wtbd_constparam");
    private static final HRBaseServiceHelper HRCSFUNCTION_HELPER = new HRBaseServiceHelper("hrcs_function");
    private static final int DATA_LENGTH = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtp.business.formula.adapt.formulaDataLength", 19);
    private static final int SCALE = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtp.business.formula.adapt.formulaScale", 6);

    public static Map<Long, AttResultItem> initResultItem(Set<Long> resultItemUnicodeSet) {
        HashSet<Long> resultItemIdSet = new HashSet<Long>(resultItemUnicodeSet);
        HashMap<Long, AttResultItem> itemMap = new HashMap<Long, AttResultItem>(16);
        DynamicObject[] attDys = ATTITEM_HELPER.queryOriginalArray("id,name,number,description", new QFilter[]{new QFilter("id", "in", resultItemIdSet)});
        String prefix = "FM$B$wtbd_attitem$";
        for (DynamicObject dy : attDys) {
            AttResultItem item = new AttResultItem();
            Long id = dy.getLong("id");
            item.setId(id);
            item.setName(dy.getString("name"));
            item.setUniqueCode(prefix + id);
            item.setDataType(WTCDataTypeEnum.NUM);
            item.setDataLength(Integer.valueOf(DATA_LENGTH));
            item.setScale(Integer.valueOf(SCALE));
            item.setRoundingMode(RoundingMode.HALF_UP);
            itemMap.put(id, item);
        }
        return itemMap;
    }

    public static Map<String, AttFunction> initFunction(Set<String> functionUnicodeSet) {
        DynamicObject[] attDys;
        Set functionIdSet = functionUnicodeSet.stream().map(Long::parseLong).collect(Collectors.toSet());
        HashMap<String, AttFunction> itemMap = new HashMap<String, AttFunction>(16);
        for (DynamicObject dy : attDys = HRCSFUNCTION_HELPER.query("id,name,funcexp,importentry.importcode", new QFilter[]{new QFilter("id", "in", functionIdSet)})) {
            AttFunction item = new AttFunction();
            item.setName(dy.getString("name"));
            item.setExecuteCode(dy.getString("funcexp"));
            item.setImportPackages(FormulaInitHelper.getImportPackages(dy.getDynamicObjectCollection("importentry")));
            itemMap.put(String.valueOf(dy.getLong("id")), item);
        }
        return itemMap;
    }

    public static Map<String, AttCalItem> initCalItem(Map<String, WTCDataTypeEnum> unicodeDataType, Set<String> calItemUnicodeSet) {
        String unicode2;
        Long id;
        AttCalItem item;
        DynamicObject[] attDys;
        HashMap<String, AttCalItem> itemMap = new HashMap<String, AttCalItem>(16);
        HashMap attId2UnicodeMap = new HashMap(16);
        Set attItemIds = calItemUnicodeSet.stream().filter(FormulaCalcUtils::isAttItemCode).map(unicode -> {
            Long id = FormulaCalcUtils.getAttItemBoIdByCode(unicode);
            attId2UnicodeMap.put(id, unicode);
            return id;
        }).collect(Collectors.toSet());
        HashMap constParamId2UnicodeMap = new HashMap(16);
        Set constParamIds = calItemUnicodeSet.stream().filter(FormulaCalcUtils::isConstParamCode).map(unicode -> {
            Long id = FormulaCalcUtils.getConstParamBoIdByCode(unicode);
            constParamId2UnicodeMap.put(id, unicode);
            return id;
        }).collect(Collectors.toSet());
        for (DynamicObject dy : attDys = ITEM_HELPER.query("id,name,number,uniquecode,type,scale,tailprocessing", new QFilter[]{new QFilter("uniquecode", "in", calItemUnicodeSet)})) {
            AttCalItem item2 = new AttCalItem();
            Long id2 = dy.getLong("id");
            item2.setId(id2);
            item2.setName(dy.getString("name"));
            String unicode3 = dy.getString("uniquecode");
            item2.setUniqueCode(unicode3);
            if ("dynamicObject".equals(dy.getString("type"))) {
                item2.setDataType(WTCDataTypeEnum.NUM);
                item2.setDataLength(Integer.valueOf(DATA_LENGTH));
                item2.setScale(Integer.valueOf(SCALE));
                item2.setRoundingMode(RoundingMode.HALF_UP);
            } else {
                WTCDataTypeEnum wtcDataTypeEnum = WTCDataTypeEnum.ofItemType((String)dy.getString("type"));
                if (wtcDataTypeEnum == WTCDataTypeEnum.NUM) {
                    item2.setDataType(wtcDataTypeEnum);
                    item2.setDataLength(Integer.valueOf(DATA_LENGTH));
                    String scaleStr = dy.getString("scale");
                    if (WTCStringUtils.isEmpty((String)scaleStr)) {
                        item2.setScale(Integer.valueOf(SCALE));
                    }
                    item2.setScale(Integer.valueOf(Integer.parseInt(scaleStr)));
                    String roundModeStr = dy.getString("tailprocessing");
                    if (WTCStringUtils.equals((String)"2", (String)roundModeStr)) {
                        item2.setRoundingMode(RoundingMode.DOWN);
                    } else if (WTCStringUtils.equals((String)"3", (String)roundModeStr)) {
                        item2.setRoundingMode(RoundingMode.UP);
                    } else {
                        item2.setRoundingMode(RoundingMode.HALF_UP);
                    }
                } else if (wtcDataTypeEnum == WTCDataTypeEnum.BOOLEAN) {
                    item2.setDataType(WTCDataTypeEnum.TEXT);
                } else {
                    item2.setDataType(wtcDataTypeEnum);
                    item2.setDataLength(Integer.valueOf(DATA_LENGTH));
                    item2.setScale(Integer.valueOf(SCALE));
                    item2.setRoundingMode(RoundingMode.HALF_UP);
                }
            }
            itemMap.put(unicode3, item2);
        }
        if (attItemIds.size() > 0) {
            DynamicObject[] attItemDys;
            for (DynamicObject dy : attItemDys = ATTITEM_HELPER.queryOriginalArray("id,name", new QFilter[]{new QFilter("id", "in", attItemIds)})) {
                item = new AttCalItem();
                id = dy.getLong("id");
                unicode2 = (String)attId2UnicodeMap.get(id);
                item.setId(id);
                item.setName(dy.getString("name"));
                item.setUniqueCode(unicode2);
                item.setDataType(WTCDataTypeEnum.NUM);
                item.setDataLength(Integer.valueOf(DATA_LENGTH));
                item.setScale(Integer.valueOf(SCALE));
                item.setRoundingMode(RoundingMode.HALF_UP);
                itemMap.put(unicode2, item);
            }
        }
        if (constParamId2UnicodeMap.size() > 0) {
            DynamicObject[] constParamDys;
            for (DynamicObject dy : constParamDys = CONSTPARAM_HELPER.queryOriginalArray("id,name,type", new QFilter[]{new QFilter("id", "in", constParamIds)})) {
                item = new AttCalItem();
                id = dy.getLong("id");
                unicode2 = (String)constParamId2UnicodeMap.get(id);
                item.setId(id);
                item.setName(dy.getString("name"));
                item.setUniqueCode(unicode2);
                String type = dy.getString("type");
                item.setDataType(WTCDataTypeEnum.of((DataTypeEnum)DataTypeEnum.getDataType((String)type)));
                if ("NUM".equalsIgnoreCase(type)) {
                    item.setDataLength(Integer.valueOf(DATA_LENGTH));
                    item.setScale(Integer.valueOf(SCALE));
                    item.setRoundingMode(RoundingMode.HALF_UP);
                }
                itemMap.put(unicode2, item);
            }
        }
        return itemMap;
    }

    public static Map<Long, AttFormula> initFormula(Set<Long> formulaIdList, Map<String, Object> needInitMap) {
        DynamicObject[] configDys;
        HashMap<Long, AttFormula> resultMap = new HashMap<Long, AttFormula>(16);
        HashSet<Long> resultItemUnicodeSet = new HashSet<Long>(16);
        HashSet calItemUnicodeSet = new HashSet(16);
        HashSet functionUnicodeSet = new HashSet(16);
        for (DynamicObject configDy : configDys = FORMULASET_HELPER.queryOriginalArray("id,name,executeexp,resultitem.id as resultitemid,dependentcalitem,dependentcustitem,dependentcalitemforfunc,dependentfunc,exportitem", new QFilter[]{new QFilter("id", "in", formulaIdList)})) {
            AttFormula formula = new AttFormula();
            long id = configDy.getLong("id");
            HashSet<String> calItemSet = new HashSet<String>();
            HashSet<String> funcSet = new HashSet<String>();
            Long resultItem = configDy.getLong("resultitemid");
            String dependentCalItem = configDy.getString("dependentcalitem");
            String dependentCustItem = configDy.getString("dependentcustitem");
            String dependentCalItemForFunc = configDy.getString("dependentcalitemforfunc");
            String dependentFunc = configDy.getString("dependentfunc");
            if (HRStringUtils.isNotEmpty((String)dependentCalItem)) {
                calItemSet.addAll(Arrays.asList(dependentCalItem.split(",")));
            }
            if (HRStringUtils.isNotEmpty((String)dependentCustItem)) {
                calItemSet.addAll(Arrays.asList(dependentCustItem.split(",")));
            }
            if (HRStringUtils.isNotEmpty((String)dependentCalItemForFunc)) {
                calItemSet.addAll(Arrays.asList(dependentCalItemForFunc.split(",")));
            }
            if (HRStringUtils.isNotEmpty((String)dependentFunc)) {
                funcSet.addAll(Arrays.asList(dependentFunc.split(",")));
            }
            formula.setName(configDy.getString("name"));
            formula.setId(Long.valueOf(configDy.getLong("id")));
            formula.setExecuteCode(configDy.getString("executeexp"));
            formula.setDependedResultItemIdSet(Stream.of(resultItem).collect(Collectors.toSet()));
            formula.setDependedCalItemUnicodeSet(calItemSet);
            formula.setDependedFuncUnicodeSet(funcSet);
            String exportItem = configDy.getString("exportitem");
            if (StringUtils.isNotEmpty((CharSequence)exportItem)) {
                String[] exportItemArr = exportItem.split(",");
                HashSet exportItemIdSet = new HashSet(exportItemArr.length);
                Arrays.stream(exportItemArr).forEach(itemUniqueCode -> exportItemIdSet.add(FormulaCalcUtils.getAttItemBoIdByCode(itemUniqueCode)));
                if (CollectionUtils.isNotEmpty(exportItemIdSet)) {
                    formula.setExportItemIdSet(exportItemIdSet);
                }
            }
            resultMap.put(id, formula);
            resultItemUnicodeSet.add(resultItem);
            calItemUnicodeSet.addAll(calItemSet);
            functionUnicodeSet.addAll(funcSet);
        }
        needInitMap.put("resultItemUnicodeSet", resultItemUnicodeSet);
        needInitMap.put("calItemUnicodeSet", calItemUnicodeSet);
        needInitMap.put("functionUnicodeSet", functionUnicodeSet);
        return resultMap;
    }

    private static Set<String> getImportPackages(DynamicObjectCollection importentry) {
        HashSet importPackages = Sets.newHashSetWithExpectedSize((int)importentry.size());
        for (DynamicObject dynamicObject : importentry) {
            String importPackage = dynamicObject.getString("importcode");
            importPackages.add(importPackage);
        }
        return importPackages;
    }
}

