/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.formula.adapt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.business.service.formula.cal.vo.CalItemVO;
import kd.hr.hbp.business.service.formula.cal.vo.FormulaVO;
import kd.hr.hbp.business.service.formula.cal.vo.FunctionVO;
import kd.sdk.wtc.wtp.business.formula.FormulaDataProvideExtPlugin;
import kd.wtc.wtbd.business.retrieval.service.RetrievalAttFileDateDimension;
import kd.wtc.wtbd.common.constants.retrieval.WTCDataTypeEnum;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtp.business.formula.FormulaCalcUtils;
import kd.wtc.wtp.business.formula.adapt.provider.DataProvider;
import kd.wtc.wtp.business.formula.adapt.provider.DataProviderUtil;
import kd.wtc.wtp.common.formula.AttCalItem;
import kd.wtc.wtp.common.formula.AttFormula;
import kd.wtc.wtp.common.formula.AttFunction;
import kd.wtc.wtp.common.formula.AttResultItem;

public class FormulaParamUtil {
    public static Map<String, Map<String, Object>> getParamIdToParamMap(Map<String, Object> contextMap, List<AttFormula> formulaList, List<String> paramIdList, Map<String, AttCalItem> calItemInitMap, Map<String, DataProvider> dataProviderMap, WTCPluginProxy<FormulaDataProvideExtPlugin> extPlugin) {
        return FormulaParamUtil.getParamIdToParamMap(contextMap, formulaList, null, null, paramIdList, calItemInitMap, dataProviderMap, extPlugin);
    }

    public static Map<String, Map<String, Object>> getParamIdToParamMap(Map<String, Object> contextMap, List<AttFormula> formulaList, RetrievalAttFileDateDimension dimension, Map<String, WTCDataTypeEnum> unicodeDataType, List<String> paramIdList, Map<String, AttCalItem> calItemInitMap, Map<String, DataProvider> dataProviderMap, WTCPluginProxy<FormulaDataProvideExtPlugin> extPlugin) {
        HashMap paramIdToParamMap = Maps.newHashMapWithExpectedSize((int)paramIdList.size());
        for (String paramId : paramIdList) {
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
            paramIdToParamMap.put(paramId, paramMap);
            for (AttFormula attFormula : formulaList) {
                Set dependedCalItemUnicodeSet = attFormula.getDependedCalItemUnicodeSet();
                for (String calItemUnicode : dependedCalItemUnicodeSet) {
                    AttCalItem attCalItem = calItemInitMap.get(calItemUnicode);
                    if (attCalItem == null) {
                        String message = ResManager.loadKDString((String)"\u516c\u5f0f\u4e2d\u6240\u4f7f\u7528\u552f\u4e00\u6807\u8bc6\u201c{0}\u201d\uff0c\u53d6\u6570\u9879\u76ee\u4e2d\u672a\u627e\u5230\u3002", (String)"FormulaParamUtil_0", (String)"wtc-wtp-business", (Object[])new Object[]{calItemUnicode});
                        throw new KDBizException(message);
                    }
                    String uniqueCode = attCalItem.getUniqueCode();
                    Object data = DataProviderUtil.getData(uniqueCode, contextMap, dimension, unicodeDataType, dataProviderMap, extPlugin);
                    paramMap.put(uniqueCode, data);
                }
            }
        }
        return paramIdToParamMap;
    }

    public static Map<Long, Set<Long>> getUsedAttItemId(List<AttFormula> formulaList, Map<String, AttCalItem> calItemInitMap) {
        HashMap formulaId2UsedAttItemIdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (AttFormula attFormula : formulaList) {
            Set dependedCalItemUnicodeSet = attFormula.getDependedCalItemUnicodeSet();
            HashSet usedAttItemIdSet = Sets.newHashSetWithExpectedSize((int)16);
            formulaId2UsedAttItemIdMap.put(attFormula.getId(), usedAttItemIdSet);
            for (String calItemUnicode : dependedCalItemUnicodeSet) {
                AttCalItem attCalItem = calItemInitMap.get(calItemUnicode);
                String uniqueCode = attCalItem.getUniqueCode();
                Long attItemBoId = FormulaCalcUtils.getAttItemBoIdByCode(uniqueCode);
                if (attItemBoId == -1L) continue;
                usedAttItemIdSet.add(attItemBoId);
            }
        }
        return formulaId2UsedAttItemIdMap;
    }

    private static String getBizKey(String uniqueCode) {
        Long attItemBoId = FormulaCalcUtils.getAttItemBoIdByCode(uniqueCode);
        return String.valueOf(attItemBoId);
    }

    public static List<FunctionVO> genFunctionVOList(Map<String, AttFunction> functionInitMap, List<AttFormula> formulaList) {
        ArrayList<FunctionVO> list = new ArrayList<FunctionVO>();
        for (AttFormula attFormula : formulaList) {
            Set dependedFuncUnicodeSet = attFormula.getDependedFuncUnicodeSet();
            for (String funcUnicode : dependedFuncUnicodeSet) {
                AttFunction attFunction = functionInitMap.get(funcUnicode);
                FunctionVO functionVO = new FunctionVO();
                functionVO.setName(attFunction.getName());
                functionVO.setExecuteCode(attFunction.getExecuteCode());
                functionVO.setImportPackages(attFunction.getImportPackages());
                list.add(functionVO);
            }
        }
        return list;
    }

    public static Map<String, CalItemVO> genUniqueCodeCalItemMap(Map<String, AttCalItem> calItemInitMap, Map<Long, AttResultItem> resultItemInitMap, List<AttFormula> formulaList) {
        HashMap uniqueCodeCalItemMap = Maps.newHashMapWithExpectedSize((int)16);
        FormulaParamUtil.setCalItemVO(calItemInitMap, formulaList, uniqueCodeCalItemMap);
        FormulaParamUtil.setResultItemVo(resultItemInitMap, formulaList, uniqueCodeCalItemMap);
        return uniqueCodeCalItemMap;
    }

    private static void setResultItemVo(Map<Long, AttResultItem> resultItemInitMap, List<AttFormula> formulaList, Map<String, CalItemVO> uniqueCodeCalItemMap) {
        for (AttFormula attFormula : formulaList) {
            Set dependedResultItemIdSet = attFormula.getDependedResultItemIdSet();
            for (Long resultItemId : dependedResultItemIdSet) {
                AttResultItem resultItem = resultItemInitMap.get(resultItemId);
                CalItemVO resultItemVO = new CalItemVO();
                resultItemVO.setUniqueCode(resultItem.getUniqueCode());
                resultItemVO.setName(resultItem.getName());
                resultItemVO.setDataType(resultItem.getDataType().getType());
                resultItemVO.setScale(resultItem.getScale());
                resultItemVO.setDataLength(resultItem.getDataLength());
                resultItemVO.setRoundingMode(resultItem.getRoundingMode());
                uniqueCodeCalItemMap.put(resultItem.getUniqueCode(), resultItemVO);
            }
        }
    }

    private static void setCalItemVO(Map<String, AttCalItem> calItemInitMap, List<AttFormula> formulaList, Map<String, CalItemVO> uniqueCodeCalItemMap) {
        for (AttFormula attFormula : formulaList) {
            Set dependedCalItemUnicodeSet = attFormula.getDependedCalItemUnicodeSet();
            for (String calItemUnicode : dependedCalItemUnicodeSet) {
                AttCalItem attCalItem = calItemInitMap.get(calItemUnicode);
                CalItemVO calItemVO = new CalItemVO();
                calItemVO.setUniqueCode(attCalItem.getUniqueCode());
                calItemVO.setName(attCalItem.getName());
                calItemVO.setDataType(attCalItem.getDataType().getType());
                calItemVO.setScale(attCalItem.getScale());
                calItemVO.setDataLength(attCalItem.getDataLength());
                calItemVO.setRoundingMode(attCalItem.getRoundingMode());
                uniqueCodeCalItemMap.put(calItemUnicode, calItemVO);
            }
        }
    }

    public static List<FormulaVO> genFormulaVOList(List<AttFormula> formulaList) {
        ArrayList<FormulaVO> list = new ArrayList<FormulaVO>(10);
        for (AttFormula attFormula : formulaList) {
            FormulaVO formulaVO = new FormulaVO();
            formulaVO.setName(attFormula.getName());
            formulaVO.setId(String.valueOf(attFormula.getId()));
            formulaVO.setExecuteCode(attFormula.getExecuteCode());
            list.add(formulaVO);
        }
        return list;
    }

    public static Set<Long> getUsedResultItemId(List<AttFormula> formulaList) {
        HashSet usedResultItemIdList = Sets.newHashSetWithExpectedSize((int)16);
        for (AttFormula attFormula : formulaList) {
            Set dependedResultItemIdSet = attFormula.getDependedResultItemIdSet();
            usedResultItemIdList.addAll(dependedResultItemIdSet);
        }
        return usedResultItemIdList;
    }

    public static Map<Long, Long> getResultAttItemId2FormulaIdMap(List<AttFormula> formulaIdList, Map<Long, AttResultItem> resultItemInitMap) {
        HashMap resultAttItemId2FormulaIdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (AttFormula attFormula : formulaIdList) {
            Set dependedResultItemIdSet = attFormula.getDependedResultItemIdSet();
            for (Long resultItemId : dependedResultItemIdSet) {
                resultAttItemId2FormulaIdMap.put(resultItemId, attFormula.getId());
            }
            Set exportItemIdSet = attFormula.getExportItemIdSet();
            if (!CollectionUtils.isNotEmpty((Collection)exportItemIdSet)) continue;
            exportItemIdSet.forEach(exportItemId -> resultAttItemId2FormulaIdMap.put(exportItemId, attFormula.getId()));
        }
        return resultAttItemId2FormulaIdMap;
    }
}

