/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.formula.adapt;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.formula.cal.service.DefaultHRMPCalcService;
import kd.hr.hbp.business.service.formula.cal.template.FormulaParse;
import kd.hr.hbp.business.service.formula.cal.vo.CalAllParamVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalResultDetailVO;
import kd.sdk.wtc.wtp.business.formula.FormulaDataProvideExtPlugin;
import kd.wtc.wtbd.business.retrieval.service.RetrievalAttFileDateDimension;
import kd.wtc.wtbd.business.retrieval.service.RetrievalService;
import kd.wtc.wtbd.common.constants.retrieval.WTCDataTypeEnum;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.formula.adapt.FormulaConfig;
import kd.wtc.wtp.business.formula.adapt.FormulaInitHelper;
import kd.wtc.wtp.business.formula.adapt.FormulaParamUtil;
import kd.wtc.wtp.business.formula.adapt.provider.DataProvider;
import kd.wtc.wtp.business.formula.adapt.result.WTCCalResultDetailVO;
import kd.wtc.wtp.common.formula.AttCalItem;
import kd.wtc.wtp.common.formula.AttFormula;
import kd.wtc.wtp.common.formula.AttFunction;
import kd.wtc.wtp.common.formula.AttResultItem;

public class FormulaService {
    private static final Log LOG = LogFactory.getLog(FormulaService.class);
    private Map<Long, AttFormula> formulaInitMap = new HashMap<Long, AttFormula>(16);
    private Map<String, AttCalItem> calItemInitMap = new HashMap<String, AttCalItem>(16);
    private Map<String, AttFunction> functionInitMap = new HashMap<String, AttFunction>(16);
    private Map<Long, AttResultItem> resultItemInitMap = new HashMap<Long, AttResultItem>(16);
    private Map<String, Tuples.Tuple2<FormulaParse, FormulaParse>> formulaParser = new HashMap<String, Tuples.Tuple2<FormulaParse, FormulaParse>>();
    private Map<Long, Set<Long>> formulaId2UsedAttItemIdMap = new HashMap<Long, Set<Long>>(16);
    private FormulaConfig formulaConfig = FormulaConfig.defaultConfig();
    private Map<String, DataProvider> dataProviderMap;
    private WTCPluginProxy<FormulaDataProvideExtPlugin> extPlugin;
    private final List<RetrievalAttFileDateDimension> attfileDateDimensions = new ArrayList<RetrievalAttFileDateDimension>();
    private final Map<Long, Map<Date, RetrievalAttFileDateDimension>> attfileDateDimensionMap = new HashMap<Long, Map<Date, RetrievalAttFileDateDimension>>();
    private final Map<String, WTCDataTypeEnum> unicodeDataType = new HashMap<String, WTCDataTypeEnum>();

    public FormulaService() {
        this.extPlugin = WTCPluginProxyFactory.create(FormulaDataProvideExtPlugin.class, (String)"kd.sdk.wtc.wtp.business.formula.FormulaDataProvideExtPlugin");
    }

    public void addFormulaIds(Set<Long> formulaIdList) {
        try {
            this.initFormula(formulaIdList);
        }
        catch (KDException e) {
            LOG.warn("initFormula error:", (Throwable)e);
            String message = ResManager.loadKDString((String)"\u516c\u5f0f\u521d\u59cb\u5316\u5f02\u5e38\uff1a{0}", (String)"FormulaService_1", (String)"wtc-wtp-business", (Object[])new Object[]{e.getMessage()});
            throw new KDBizException((Throwable)e, e.getErrorCode(), new Object[]{message});
        }
        catch (Exception e1) {
            LOG.warn("initFormula error1:", (Throwable)e1);
            String message = ResManager.loadKDString((String)"\u516c\u5f0f\u521d\u59cb\u5316\u5f02\u5e38\uff1a{0}", (String)"FormulaService_1", (String)"wtc-wtp-business", (Object[])new Object[]{String.valueOf(formulaIdList)});
            throw new KDBizException(message);
        }
    }

    public Map<String, DataProvider> getDataProviderMap() {
        return this.dataProviderMap;
    }

    public void setDataProviderMap(Map<String, DataProvider> dataProviderMap) {
        this.dataProviderMap = dataProviderMap;
    }

    public FormulaService(Set<Long> formulaIdList) {
        this.initFormula(formulaIdList);
    }

    private void initFormula(Set<Long> formulaIdList) {
        HashMap needInitMap = Maps.newHashMapWithExpectedSize((int)3);
        Set<Long> notInitFormulaIds = formulaIdList.stream().filter(e -> !this.formulaInitMap.containsKey(e)).collect(Collectors.toSet());
        if (LOG.isDebugEnabled()) {
            LOG.debug("initFormula formulaIdList={},notInitFormulaIds={},formulaInitMap={}", new Object[]{formulaIdList, notInitFormulaIds, this.formulaInitMap});
        }
        this.formulaInitMap.putAll(FormulaInitHelper.initFormula(notInitFormulaIds, needInitMap));
        Set calItemUnicodeSet = (Set)needInitMap.get("calItemUnicodeSet");
        Set functionUnicodeSet = (Set)needInitMap.get("functionUnicodeSet");
        Set resultItemUnicodeSet = (Set)needInitMap.get("resultItemUnicodeSet");
        if (WTCCollections.isNotEmpty(notInitFormulaIds)) {
            RetrievalService rs = (RetrievalService)WTCAppContextHelper.getBean(RetrievalService.class);
            rs.addRetrievalDimension(this.attfileDateDimensions);
            rs.addRetrievalUnicode(new HashSet(calItemUnicodeSet));
            rs.retrievalData();
            this.unicodeDataType.putAll(rs.getUnicodeTypes());
        }
        this.calItemInitMap.putAll(FormulaInitHelper.initCalItem(this.unicodeDataType, calItemUnicodeSet));
        this.functionInitMap.putAll(FormulaInitHelper.initFunction(functionUnicodeSet));
        this.resultItemInitMap.putAll(FormulaInitHelper.initResultItem(resultItemUnicodeSet));
        if (LOG.isDebugEnabled()) {
            LOG.debug("initFormula result: formulaInitMap={},calItemInitMap={},functionInitMap={},resultItemInitMap={}", new Object[]{this.formulaInitMap, this.calItemInitMap, this.functionInitMap, this.resultItemInitMap});
        }
    }

    protected Tuples.Tuple2<FormulaParse, FormulaParse> getFormulaParser(List<Long> formulaIdList, CalAllParamVO paramVO) throws Exception {
        List strList = formulaIdList.stream().map(String::valueOf).collect(Collectors.toList());
        String key = String.join((CharSequence)"-", strList);
        Tuples.Tuple2 tuple = this.formulaParser.get(key);
        if (tuple == null) {
            DefaultHRMPCalcService instance = DefaultHRMPCalcService.getInstance();
            FormulaParse parse1 = instance.createBizClassImpl(null, paramVO);
            FormulaParse parse2 = instance.createBizProportionClassImpl(null, paramVO);
            tuple = new Tuples.Tuple2((Object)parse1, (Object)parse2);
            this.formulaParser.put(key, (Tuples.Tuple2<FormulaParse, FormulaParse>)tuple);
        }
        return tuple;
    }

    public Map<String, WTCCalResultDetailVO> invokeFormula(List<Long> formulaIdList, Map<String, Object> contextMap, long attfileBoid, LocalDate chainDate) throws Exception {
        ArrayList<String> paramIdList = new ArrayList<String>();
        paramIdList.add(String.valueOf(attfileBoid));
        Date date = WTCDateUtils.toDate((LocalDate)chainDate);
        RetrievalAttFileDateDimension dimension = (RetrievalAttFileDateDimension)((Map)this.attfileDateDimensionMap.getOrDefault(attfileBoid, new HashMap())).get(date);
        if (LOG.isDebugEnabled()) {
            LOG.debug("invokeFormula formulaIdList={},paramIdList={},chainDate={}", new Object[]{formulaIdList, paramIdList, chainDate});
        }
        CalAllParamVO calAllParamVO = this.genParamVo(formulaIdList, contextMap, dimension, paramIdList, chainDate);
        if (LOG.isDebugEnabled()) {
            LOG.debug("invokeFormula calAllParamVO={},chainDate={}", (Object)JSON.toJSONString((Object)calAllParamVO), (Object)chainDate);
        }
        Map<String, CalResultDetailVO> result = this._invokeFormula(formulaIdList, calAllParamVO, paramIdList);
        if (LOG.isDebugEnabled()) {
            LOG.debug("invokeFormula result={},chainDate={}", (Object)JSON.toJSONString(result), (Object)chainDate);
        }
        HashMap<String, WTCCalResultDetailVO> wtcResultMap = new HashMap<String, WTCCalResultDetailVO>(result.size());
        for (Map.Entry<String, CalResultDetailVO> entry : result.entrySet()) {
            wtcResultMap.put(entry.getKey(), WTCCalResultDetailVO.of(entry.getValue()));
        }
        return wtcResultMap;
    }

    @Deprecated
    public Map<String, WTCCalResultDetailVO> invokeFormula(List<Long> formulaIdList, Map<String, Object> contextMap, List<String> paramIdList, LocalDate chainDate) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("invokeFormula formulaIdList={},paramIdList={},chainDate={}", new Object[]{formulaIdList, paramIdList, chainDate});
        }
        CalAllParamVO calAllParamVO = this.genParamVo(formulaIdList, contextMap, null, paramIdList, chainDate);
        if (LOG.isDebugEnabled()) {
            LOG.debug("invokeFormula calAllParamVO={},chainDate={}", (Object)JSON.toJSONString((Object)calAllParamVO), (Object)chainDate);
        }
        Map<String, CalResultDetailVO> result = this._invokeFormula(formulaIdList, calAllParamVO, paramIdList);
        if (LOG.isDebugEnabled()) {
            LOG.debug("invokeFormula result={},chainDate={}", (Object)JSON.toJSONString(result), (Object)chainDate);
        }
        HashMap<String, WTCCalResultDetailVO> wtcResultMap = new HashMap<String, WTCCalResultDetailVO>(result.size());
        for (Map.Entry<String, CalResultDetailVO> entry : result.entrySet()) {
            wtcResultMap.put(entry.getKey(), WTCCalResultDetailVO.of(entry.getValue()));
        }
        return wtcResultMap;
    }

    public void addRetrievalDimension(List<RetrievalAttFileDateDimension> dims) {
        this.attfileDateDimensions.addAll(dims);
        for (RetrievalAttFileDateDimension dim : dims) {
            Map dateMap = this.attfileDateDimensionMap.computeIfAbsent(dim.getAttFileBoId(), id -> new HashMap());
            RetrievalAttFileDateDimension old = (RetrievalAttFileDateDimension)dateMap.get(dim.getOwnDate());
            if (old != null) {
                this.attfileDateDimensions.remove(old);
            }
            dateMap.put(dim.getOwnDate(), dim);
        }
    }

    protected Map<String, CalResultDetailVO> _invokeFormula(List<Long> formulaIdList, CalAllParamVO paramVO, List<String> paramIdList) throws Exception {
        Tuples.Tuple2<FormulaParse, FormulaParse> tuple = this.getFormulaParser(formulaIdList, paramVO);
        return DefaultHRMPCalcService.getInstance().calc((FormulaParse)tuple.item1, (FormulaParse)tuple.item2, paramVO, paramIdList);
    }

    public Map<Long, Set<Long>> getUsedAttItemId(List<Long> formulaIdList) {
        List noCacheFormulaIdList = formulaIdList.stream().filter(e -> !this.formulaId2UsedAttItemIdMap.containsKey(e)).collect(Collectors.toList());
        if (!noCacheFormulaIdList.isEmpty()) {
            List<AttFormula> formulaList = noCacheFormulaIdList.stream().map(this.formulaInitMap::get).collect(Collectors.toList());
            this.formulaId2UsedAttItemIdMap.putAll(FormulaParamUtil.getUsedAttItemId(formulaList, this.calItemInitMap));
        }
        return this.formulaId2UsedAttItemIdMap;
    }

    public Map<Long, Long> getResultAttItemId2FormulaIdMap(List<Long> formulaIdList) {
        List<AttFormula> formulaList = formulaIdList.stream().map(this.formulaInitMap::get).collect(Collectors.toList());
        return FormulaParamUtil.getResultAttItemId2FormulaIdMap(formulaList, this.resultItemInitMap);
    }

    public Set<Long> getUsedResultItemId(List<Long> formulaIdList) {
        List<AttFormula> formulaList = formulaIdList.stream().map(this.formulaInitMap::get).collect(Collectors.toList());
        return FormulaParamUtil.getUsedResultItemId(formulaList);
    }

    public CalAllParamVO genParamVo(List<Long> formulaIdList, Map<String, Object> contextMap, List<String> paramIdList, LocalDate chainDate) {
        return this.genParamVo(formulaIdList, contextMap, null, paramIdList, chainDate);
    }

    public CalAllParamVO genParamVo(List<Long> formulaIdList, Map<String, Object> contextMap, RetrievalAttFileDateDimension dimension, List<String> paramIdList, LocalDate chainDate) {
        CalAllParamVO paramVO = new CalAllParamVO();
        List<AttFormula> formulaList = formulaIdList.stream().map(this.formulaInitMap::get).collect(Collectors.toList());
        Map<String, Map<String, Object>> paramIdToParamMap = FormulaParamUtil.getParamIdToParamMap(contextMap, formulaList, dimension, this.unicodeDataType, paramIdList, this.calItemInitMap, this.dataProviderMap, this.extPlugin);
        paramVO.setParamIdToParamMap(paramIdToParamMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug("invokeFormula paramMap={},chainDate={}", (Object)JSON.toJSONString(paramIdToParamMap), (Object)chainDate);
        }
        paramVO.setFormulaVOList(FormulaParamUtil.genFormulaVOList(formulaList));
        paramVO.setFunctionVOList(FormulaParamUtil.genFunctionVOList(this.functionInitMap, formulaList));
        paramVO.setUniqueCodeCalItemMap(FormulaParamUtil.genUniqueCodeCalItemMap(this.calItemInitMap, this.resultItemInitMap, formulaList));
        return paramVO;
    }

    public Map<Long, AttFormula> getFormulaInitMap() {
        return this.formulaInitMap;
    }

    public Map<String, AttCalItem> getCalItemInitMap() {
        return this.calItemInitMap;
    }

    public Map<String, AttFunction> getFunctionInitMap() {
        return this.functionInitMap;
    }

    public Map<Long, AttResultItem> getResultItemInitMap() {
        return this.resultItemInitMap;
    }

    public FormulaConfig getFormulaConfig() {
        return this.formulaConfig;
    }

    public String toString() {
        return "FormulaService{formulaInitMap=" + this.formulaInitMap + ", calItemInitMap=" + this.calItemInitMap + ", functionInitMap=" + this.functionInitMap + ", resultItemInitMap=" + this.resultItemInitMap + ", formulaConfig=" + this.formulaConfig + '}';
    }
}

