/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.formula.adapt.provider;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import kd.bos.util.CollectionUtils;
import kd.sdk.wtc.wtp.business.formula.FormulaDataProvideExtPlugin;
import kd.sdk.wtc.wtp.business.formula.OnDataProvideEvent;
import kd.wtc.wtbd.business.retrieval.service.RetrievalAttFileDateDimension;
import kd.wtc.wtbd.common.constants.retrieval.WTCDataTypeEnum;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtp.business.formula.FormulaCalcUtils;
import kd.wtc.wtp.business.formula.adapt.provider.DataProvider;

public class DataProviderUtil {
    public static Object getData(String dataProviderKey, Map<String, Object> paramMap, Map<String, DataProvider> dataProviderMap, WTCPluginProxy<FormulaDataProvideExtPlugin> extPlugin) {
        return DataProviderUtil.getData(dataProviderKey, paramMap, null, null, dataProviderMap, extPlugin);
    }

    public static Object getData(String dataProviderKey, Map<String, Object> paramMap, RetrievalAttFileDateDimension dimension, Map<String, WTCDataTypeEnum> unicodeDataType, Map<String, DataProvider> dataProviderMap, WTCPluginProxy<FormulaDataProvideExtPlugin> extPlugin) {
        String sceneCode = (String)paramMap.get("sceneCode");
        if (dimension != null && unicodeDataType != null && unicodeDataType.containsKey(dataProviderKey)) {
            WTCDataTypeEnum wtcDataTypeEnum = unicodeDataType.get(dataProviderKey);
            if (wtcDataTypeEnum.equals((Object)WTCDataTypeEnum.BOOLEAN)) {
                Object value = dimension.getValue(dataProviderKey);
                if (value instanceof Boolean) {
                    value = ((Boolean)value).booleanValue() ? "Y" : "N";
                } else if (value instanceof Number) {
                    int iv = ((Number)value).intValue();
                    value = iv != 0 ? "Y" : "N";
                } else if (value instanceof String) {
                    String str = (String)value;
                    value = "1".equals(str) || "Y".equals(str) || "y".equals(str) || "true".equals(str) ? "Y" : "N";
                }
                return value;
            }
            if (wtcDataTypeEnum.equals((Object)WTCDataTypeEnum.TEXT)) {
                Object enumValue = dimension.getValue(dataProviderKey + "combo_tag");
                if (enumValue != null) {
                    return enumValue;
                }
                return dimension.getValue(dataProviderKey);
            }
            if (wtcDataTypeEnum.equals((Object)WTCDataTypeEnum.NUM)) {
                Object value = dimension.getValue(dataProviderKey);
                if (value instanceof Integer) {
                    return BigDecimal.valueOf(((Integer)value).longValue());
                }
                if (value instanceof Byte) {
                    return BigDecimal.valueOf(((Byte)value).longValue());
                }
                if (value instanceof Short) {
                    return BigDecimal.valueOf(((Short)value).longValue());
                }
                if (value instanceof Long) {
                    return BigDecimal.valueOf((Long)value);
                }
                if (value instanceof Double) {
                    return BigDecimal.valueOf((Double)value);
                }
                if (value instanceof Float) {
                    return BigDecimal.valueOf(((Float)value).doubleValue());
                }
                if (value instanceof BigInteger) {
                    return new BigDecimal(value.toString());
                }
                return value;
            }
            return dimension.getValue(dataProviderKey);
        }
        DataProvider dataProvider = dataProviderMap.get(DataProviderUtil.getKey(dataProviderKey, sceneCode));
        if (dataProvider == null) {
            if (CollectionUtils.isNotEmpty((Collection)extPlugin.getPlugins())) {
                OnDataProvideEvent onDataProvideEvent = new OnDataProvideEvent(dataProviderKey, paramMap);
                extPlugin.invokeReplace(service -> service.onDataProvide(onDataProvideEvent));
                if (onDataProvideEvent.getResult() != null) {
                    return onDataProvideEvent.getResult();
                }
            }
            return null;
        }
        DataProviderUtil.dealProviderKey(dataProviderKey, paramMap);
        return dataProvider.getDataCustom(paramMap);
    }

    public static String getKey(String dataProviderKey, String sceneCode) {
        if (FormulaCalcUtils.isAttItemCode(dataProviderKey)) {
            return sceneCode + '$' + "attItem";
        }
        if (FormulaCalcUtils.isConstParamCode(dataProviderKey)) {
            return sceneCode + '$' + "constParam";
        }
        return sceneCode + '$' + dataProviderKey;
    }

    private static void dealProviderKey(String dataProviderKey, Map<String, Object> paramMap) {
        if (FormulaCalcUtils.isConstParamCode(dataProviderKey)) {
            Long constParamBoId = FormulaCalcUtils.getConstParamBoIdByCode(dataProviderKey);
            paramMap.put("constParam", constParamBoId);
        } else {
            Long attItemBoId = FormulaCalcUtils.getAttItemBoIdByCode(dataProviderKey);
            paramMap.put("attItemId", attItemBoId);
        }
    }
}

