/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.incrdecrrules;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.wtp.constants.incdec.IncDecConfigConstants;
import kd.wtc.wtp.business.incrdecrrules.IncDecConfKDStringHelper;

public class IncDecConfCommonService
implements IncDecConfigConstants {
    public static IncDecConfCommonService getInstance() {
        return Instance.INSTANCE;
    }

    public boolean beforeCopy(IFormView view, String pageKey) {
        IFormView parentView = view.getParentView();
        if (parentView != null) {
            WTCPageCache pageCache = new WTCPageCache(parentView);
            Map cacheMap = (Map)pageCache.get(pageKey, Map.class);
            if (cacheMap == null) {
                return false;
            }
            if (cacheMap.size() >= 10) {
                view.showTipNotification(IncDecConfKDStringHelper.resultMax());
                return false;
            }
            return true;
        }
        return false;
    }

    public void closeOneSubView(IFormView view, String pageKey, String actionId, String parentKey) {
        WTCPageCache pageCache = new WTCPageCache(view);
        Map regularTimeCache = (Map)pageCache.get(pageKey, Map.class);
        if (regularTimeCache == null) {
            return;
        }
        Container flexPanel = (Container)view.getControl(parentKey);
        flexPanel.deleteControls(new String[]{actionId});
        regularTimeCache.remove(actionId);
        pageCache.put(pageKey, (Object)regularTimeCache);
    }

    public void beforeBindData(IFormView subView, IDataModel subModel, String cacheKey, boolean isTime) {
        HashMap oldData;
        String createOrg;
        String newJson;
        IFormView parentView = subView.getParentView();
        if (parentView != null) {
            boolean lock = WTCHisService.isLock((IFormView)parentView);
            subView.setVisible(Boolean.valueOf(!lock), new String[]{"delete", "copy"});
            subView.setEnable(Boolean.valueOf(!lock), new String[]{"indecrvalue", "curattitem", "indecrrel"});
            if (isTime) {
                subView.setEnable(Boolean.valueOf(!lock), new String[]{"regulartime"});
            }
        }
        if ((newJson = (String)subView.getFormShowParameter().getCustomParam("new")) != null) {
            subView.setVisible(Boolean.FALSE, new String[]{"delete"});
        }
        if (HRStringUtils.isNotEmpty((String)(createOrg = (String)subView.getFormShowParameter().getCustomParam("createorg")))) {
            subModel.setValue("createorg", (Object)Long.parseLong(createOrg));
        }
        JSONObject json = (JSONObject)subView.getFormShowParameter().getCustomParam(cacheKey);
        this.setValue(json, subModel, isTime);
        JSONObject data = (JSONObject)subView.getFormShowParameter().getCustomParam("data");
        if (data != null) {
            subModel.beginInit();
            if (isTime) {
                subModel.setValue("regulartime", data.get((Object)"regulartime"));
            }
            subModel.setValue("curattitem", data.get((Object)"curattitem"));
            subModel.setValue("indecrvalue", data.get((Object)"indecrvalue"));
            subModel.setValue("indecrrel", data.get((Object)"indecrrel"));
            subModel.endInit();
        }
        if ((oldData = (HashMap)subView.getFormShowParameter().getCustomParam("refreshdata")) != null) {
            subModel.beginInit();
            if (isTime) {
                subModel.setValue("regulartime", oldData.get("regulartime"));
            }
            subModel.setValue("indecrvalue", oldData.get("indecrvalue"));
            subModel.setValue("curattitem", oldData.get("curattitem"));
            subModel.setValue("indecrrel", oldData.get("indecrrel"));
            subModel.endInit();
        }
    }

    private void setValue(JSONObject json, IDataModel subModel, boolean isTime) {
        if (json != null) {
            JSONObject attItem;
            subModel.beginInit();
            if (isTime) {
                subModel.setValue("regulartime", json.get((Object)"regulartime"));
            }
            if ((attItem = (JSONObject)json.get((Object)"curattitem")) != null) {
                subModel.setValue("curattitem", attItem.get((Object)"id"));
            }
            subModel.setValue("indecrvalue", json.get((Object)"indecrvalue"));
            subModel.setValue("indecrrel", json.get((Object)"indecrrel"));
            subModel.endInit();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        IFormView parentView = view.getParentView();
        if (parentView != null) {
            Date beSd = (Date)parentView.getModel().getValue("bsed");
            if (beSd == null) {
                view.showErrorNotification(IncDecConfKDStringHelper.bsed());
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter qFilter = this.getQFilter(false, beSd);
            qFilter.and(new QFilter("firstbsed", "<=", (Object)beSd));
            beforeF7SelectEvent.addCustomQFilter(qFilter);
        }
    }

    public void beforeF7SelectOfResult(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        IFormView confView;
        IFormView parentView = view.getParentView();
        if (parentView != null && (confView = parentView.getParentView()) != null) {
            Date beSd = (Date)confView.getModel().getValue("bsed");
            if (beSd == null) {
                view.showErrorNotification(IncDecConfKDStringHelper.bsed());
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            String triggerType = (String)parentView.getModel().getValue("triggertype");
            boolean isProid = HRStringUtils.equals((String)"D", (String)triggerType);
            QFilter qFilter = this.getQFilter(isProid, beSd);
            qFilter.and(new QFilter("firstbsed", "<=", (Object)beSd));
            beforeF7SelectEvent.addCustomQFilter(qFilter);
        }
    }

    public QFilter getQFilterOfCond(boolean isProid, Date bsEd) {
        ArrayList itemTypeList = Lists.newArrayListWithExpectedSize((int)2);
        if (isProid) {
            itemTypeList.add("3");
            itemTypeList.add("2");
        } else {
            itemTypeList.add("1");
            itemTypeList.add("2");
        }
        return this.getQFilter(itemTypeList, bsEd);
    }

    public QFilter getQFilter(boolean isProid, Date bsEd) {
        ArrayList itemTypeList = Lists.newArrayListWithExpectedSize((int)2);
        if (isProid) {
            itemTypeList.add("3");
        } else {
            itemTypeList.add("1");
            itemTypeList.add("2");
        }
        return this.getQFilter(itemTypeList, bsEd);
    }

    public QFilter getQFilter(List<String> itemTypeList, Date bsEd) {
        QFilter qFilter = new QFilter("itemtype", "in", itemTypeList);
        qFilter.and(new QFilter("issave", "=", (Object)Boolean.TRUE));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and("isorginattitem", "=", (Object)Boolean.FALSE);
        qFilter.and(new QFilter("firstbsed", "<=", (Object)bsEd));
        return qFilter;
    }

    public String dynamicFlex(String key, IFormView view, int index, String sourceFlex, boolean isSpecial) {
        Container flexPanel = (Container)view.getControl(sourceFlex);
        FlexPanelAp childFlex = new FlexPanelAp();
        childFlex.setKey(key);
        Margin margin = new Margin();
        if (isSpecial) {
            margin.setTop("-20px");
        }
        margin.setBottom("0px");
        Style style = new Style();
        style.setMargin(margin);
        childFlex.setStyle(style);
        flexPanel.insertControls(index, Collections.singletonList(childFlex.createControl()));
        return key;
    }

    public void clearCache(IFormView view, String cacheKey, String flexKey) {
        WTCPageCache pageCache = new WTCPageCache(view);
        Map regularTimeCache = (Map)pageCache.get(cacheKey, Map.class);
        if (regularTimeCache == null) {
            return;
        }
        Set entries = regularTimeCache.entrySet();
        for (Map.Entry next : entries) {
            String pageId = (String)next.getValue();
            if (!HRStringUtils.isNotEmpty((String)pageId)) continue;
            Container flexPanel = (Container)view.getControl(flexKey);
            flexPanel.deleteControls(new String[]{(String)next.getKey()});
        }
        view.updateView(flexKey);
        pageCache.put(cacheKey, null);
    }

    public List<String> getCacheList(IFormView view, String cacheKey) {
        WTCPageCache pageCache = new WTCPageCache(view);
        Map regularTimeCache = (Map)pageCache.get(cacheKey, Map.class);
        if (regularTimeCache == null) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList pageIdList = Lists.newArrayListWithCapacity((int)regularTimeCache.size());
        Set entries = regularTimeCache.entrySet();
        for (Map.Entry next : entries) {
            String pageId = (String)next.getValue();
            if (!HRStringUtils.isNotEmpty((String)pageId)) continue;
            pageIdList.add(pageId);
        }
        return pageIdList;
    }

    private static class Instance {
        private static IncDecConfCommonService INSTANCE = new IncDecConfCommonService();

        private Instance() {
        }
    }
}

