/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.incrdecrrules;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.wtp.constants.incdec.IncDecConfigConstants;
import kd.wtc.wtp.business.incrdecrrules.IncDecConfCommonService;
import kd.wtc.wtp.business.incrdecrrules.IncDecConfKDStringHelper;
import kd.wtc.wtp.utils.WTCSheetUtil;

public class IncDecConfCondService
implements IncDecConfigConstants {
    private static final Log logger = LogFactory.getLog(IncDecConfCondService.class);
    private Map<String, String> serialPeriodMap;
    private Map<String, String> dayTypeMap;
    private Map<String, String> shiftTypeMap;
    private Map<String, String> inDecrRelMap;
    private Map<String, String> triggerCompMap;
    private Map<String, String> triggerSignMap;
    private Map<String, String> unitMap;

    public static IncDecConfCondService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public IncDecConfCondService() {
        this.initComboData();
    }

    public void openResultPage(IFormView view, boolean isFirst, IFormPlugin plugin, Map<String, Object> resultMap) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        DynamicObject createOrg = dataEntity.getDynamicObject("createorg");
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        if (HRObjectUtils.isEmpty((Object)createOrg)) {
            view.showErrorNotification(IncDecConfKDStringHelper.createOrg());
            return;
        }
        map.put("createorg", String.valueOf(createOrg.getLong("id")));
        map.put("triggertype", dataEntity.getString("triggertype"));
        boolean isPriod = HRStringUtils.equals((String)"D", (String)dataEntity.getString("triggertype"));
        WTCPageCache pageCache = new WTCPageCache(view);
        Map regularTimeCache = (Map)pageCache.get("resultcache", Map.class);
        if (regularTimeCache == null) {
            regularTimeCache = Maps.newHashMapWithExpectedSize((int)1);
        }
        String actionId = "resultactionid" + regularTimeCache.size();
        if (resultMap != null) {
            map.put("data", resultMap);
        }
        boolean isSpecial = false;
        if (isFirst) {
            isSpecial = !isPriod;
            map.put("new", "new");
        }
        IncDecConfCommonService.getInstance().dynamicFlex(actionId, view, regularTimeCache.size(), "resultaddflex", isSpecial);
        FormShowParameter parameter = WTCSheetUtil.showFormParameter((ShowType)ShowType.InContainer, (String)actionId, (String)"wtp_incdecresult", (CloseCallBack)new CloseCallBack(plugin, actionId), (HashMap)map, (OperationStatus)view.getFormShowParameter().getStatus());
        view.showForm(parameter);
        view.updateView("resultaddflex");
        regularTimeCache.put(actionId, parameter.getPageId());
        pageCache.put("resultcache", (Object)regularTimeCache);
    }

    public void moveData(IFormView view, String copyActionId, IFormPlugin plugin) {
        int index;
        String copyIndexStr = copyActionId.substring("resultactionid".length());
        int copyIndex = Integer.parseInt(copyIndexStr);
        WTCPageCache pageCache = new WTCPageCache(view);
        Map regularTimeCache = (Map)pageCache.get("resultcache", Map.class);
        if (regularTimeCache == null) {
            regularTimeCache = Maps.newHashMapWithExpectedSize((int)1);
        }
        DynamicObject dataEntity = view.getModel().getDataEntity();
        DynamicObject createOrg = dataEntity.getDynamicObject("createorg");
        ArrayList list = Lists.newArrayListWithExpectedSize((int)(regularTimeCache.size() + 1));
        for (index = 0; index < regularTimeCache.size(); ++index) {
            IFormView subView;
            String actionId = "resultactionid" + index;
            String pageId = (String)regularTimeCache.get(actionId);
            HashMap map = Maps.newHashMapWithExpectedSize((int)4);
            map.put("createorg", String.valueOf(createOrg.getLong("id")));
            map.put("triggertype", dataEntity.getString("triggertype"));
            if (HRStringUtils.isNotEmpty((String)pageId) && (subView = view.getView(pageId)) != null) {
                HashMap<String, Object> oldData = new HashMap<String, Object>();
                DynamicObject subDy = subView.getModel().getDataEntity(true);
                DynamicObject item = subDy.getDynamicObject("resultitem");
                if (!HRObjectUtils.isEmpty((Object)item)) {
                    oldData.put("resultitem", item.getLong("id"));
                }
                oldData.put("resultrel", subDy.get("resultrel"));
                oldData.put("resultvalue", subDy.get("resultvalue"));
                map.put("data", oldData);
                if (index == copyIndex) {
                    HashMap copyMap = Maps.newHashMapWithExpectedSize((int)4);
                    copyMap.putAll(map);
                    list.add(copyMap);
                }
            }
            list.add(map);
            Container flexPanel = (Container)view.getControl("resultaddflex");
            flexPanel.deleteControls(new String[]{actionId});
        }
        pageCache.put("resultcache", null);
        regularTimeCache = Maps.newHashMapWithExpectedSize((int)1);
        index = 0;
        for (HashMap map : list) {
            String actionId = "resultactionid" + index;
            boolean isPriod = HRStringUtils.equals((String)"D", (String)((String)map.get("triggertype")));
            boolean isSpecial = false;
            if (index == 0) {
                isSpecial = !isPriod;
                map.put("new", "new");
            }
            IncDecConfCommonService.getInstance().dynamicFlex(actionId, view, index, "resultaddflex", isSpecial);
            FormShowParameter parameter = WTCSheetUtil.showFormParameter((ShowType)ShowType.InContainer, (String)actionId, (String)"wtp_incdecresult", (CloseCallBack)new CloseCallBack(plugin, actionId), (HashMap)map, (OperationStatus)view.getFormShowParameter().getStatus());
            view.showForm(parameter);
            view.updateView("resultaddflex");
            regularTimeCache.put(actionId, parameter.getPageId());
            ++index;
        }
        pageCache.put("resultcache", (Object)regularTimeCache);
    }

    public String condShow(int time) {
        int hour = time / 3600;
        int minute = time % 3600 / 60;
        int second = time % 60;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStr(hour)).append(':').append(this.getStr(minute)).append(':').append(this.getStr(second));
        return IncDecConfKDStringHelper.condShowOfTime(sb.toString());
    }

    private String getStr(int num) {
        StringBuilder sb = new StringBuilder();
        if (num > 9) {
            sb.append(num);
        } else {
            sb.append('0').append(num);
        }
        return sb.toString();
    }

    public String resultShowOfTime(DynamicObject item, String rel, BigDecimal value) {
        String name = item.getString("name");
        String unit = this.unitTran(item.getString("unit"));
        char empty = ' ';
        return name + empty + this.relTran(rel) + empty + value.stripTrailingZeros().toPlainString() + empty + unit;
    }

    public String resultShow(DynamicObject dataEntity) {
        DynamicObject curAttItem = dataEntity.getDynamicObject("curattitem");
        DynamicObject triggerItem = dataEntity.getDynamicObject("triggeritem");
        boolean isTriggerItem = dataEntity.getBoolean("istriggeritem");
        String isTriggerItemStr = !isTriggerItem ? "" : ResManager.loadKDString((String)"\u5f53\u8fde\u7eed\u9879\u76ee\u503c {0} {1} {2}\u65f6\uff0c\u5219 {3} {4} {5} {6}\u3002", (String)"IncDecConfCondService_0", (String)"wtc-wtp-business", (Object[])new Object[]{this.triggerCompMap.get(dataEntity.getString("triggercomp")), dataEntity.getInt("triggerval"), this.unitMap.get(curAttItem.getString("unit")), triggerItem.getString("name"), this.triggerSignMap.get(dataEntity.getString("triggersign")), dataEntity.getBigDecimal("triggerresult"), this.unitMap.get(triggerItem.getString("unit"))});
        String dayType = dataEntity.getString("daytype");
        String shiftType = dataEntity.getString("shifttype");
        String dayTypeStr = "D".equals(dayType) ? "" : " / " + this.dayTypeMap.get(dayType);
        String shiftTypeStr = "0".equals(shiftType) ? "" : " / " + this.shiftTypeMap.get(shiftType);
        return ResManager.loadKDString((String)"\u8fde\u7eed\u589e\u51cf\uff1a{0} {1} {2} {3}\u3002{4}\uff08{5}{6}\uff09", (String)"IncDecConfCondService_1", (String)"wtc-wtp-business", (Object[])new Object[]{curAttItem.getString("name"), this.inDecrRelMap.get(dataEntity.getString("indecrrel")), dataEntity.getBigDecimal("indecrvalue"), this.unitMap.get(curAttItem.getString("unit")), isTriggerItemStr, this.serialPeriodMap.get(dataEntity.getString("serialperiod")), dayTypeStr + shiftTypeStr});
    }

    private String unitTran(String unit) {
        String itemUnitStr = "";
        if (HRStringUtils.isEmpty((String)unit)) {
            return itemUnitStr;
        }
        switch (unit) {
            case "day": {
                itemUnitStr = IncDecConfKDStringHelper.day();
                break;
            }
            case "hour": {
                itemUnitStr = IncDecConfKDStringHelper.hour();
                break;
            }
            case "minute": {
                itemUnitStr = IncDecConfKDStringHelper.minute();
                break;
            }
            case "second": {
                itemUnitStr = IncDecConfKDStringHelper.second();
                break;
            }
            case "time": {
                itemUnitStr = IncDecConfKDStringHelper.time();
                break;
            }
        }
        return itemUnitStr;
    }

    private String relTran(String rel) {
        String relStr = HRStringUtils.equals((String)"C", (String)rel) ? IncDecConfKDStringHelper.reSet() : (HRStringUtils.equals((String)"B", (String)rel) ? IncDecConfKDStringHelper.reduce() : IncDecConfKDStringHelper.add());
        return relStr;
    }

    public String resultShow(IFormView view) {
        List<String> cacheList = IncDecConfCommonService.getInstance().getCacheList(view, "resultcache");
        ArrayList resultList = Lists.newArrayListWithCapacity((int)cacheList.size());
        for (String pageId : cacheList) {
            IFormView subView = view.getView(pageId);
            if (subView == null) continue;
            DynamicObject result = subView.getModel().getDataEntity();
            resultList.add(this.getOneResultStr(result));
        }
        return String.join((CharSequence)"\uff1b", resultList);
    }

    public String getOneResultStr(DynamicObject result) {
        DynamicObject resultItem = result.getDynamicObject("resultitem");
        if (HRObjectUtils.isEmpty((Object)resultItem)) {
            return "";
        }
        String rel = result.getString("resultrel");
        String relStr = this.relTran(rel);
        String unit = this.unitTran(result.getDynamicObject("resultitem").getString("unit"));
        char empty = ' ';
        return result.getDynamicObject("resultitem").getString("name") + empty + relStr + empty + result.getBigDecimal("resultvalue").stripTrailingZeros().toPlainString() + empty + unit;
    }

    public String condShow(DynamicObjectCollection limitCollect, String logicStr, String logicType) {
        if (HRStringUtils.equals((String)"2", (String)logicType)) {
            logicStr = logicStr.replace('\uff08', '{');
            logicStr = logicStr.replace('\uff09', '}');
        }
        char empty = ' ';
        for (DynamicObject dy : limitCollect) {
            String itemStr = this.itemStr(dy.getDynamicObjectCollection("condattitem"));
            String rel = this.tranRel(dy.getString("condrel"));
            BigDecimal value = dy.getBigDecimal("condvalue");
            DynamicObjectCollection condAttItem = dy.getDynamicObjectCollection("condattitem");
            if (!WTCCollections.isNotEmpty((Collection)condAttItem)) continue;
            String unit = ((DynamicObject)condAttItem.get(0)).getString("fbasedataid.unit");
            logicStr = logicStr.replace(dy.getString("limitno"), itemStr + empty + rel + empty + value.stripTrailingZeros().toPlainString() + empty + this.unitTran(unit));
        }
        return logicStr;
    }

    private String tranRel(String rel) {
        if (HRStringUtils.equals((String)">=", (String)rel)) {
            return "\u2265";
        }
        if (HRStringUtils.equals((String)"<=", (String)rel)) {
            return "\u2264";
        }
        if (HRStringUtils.equals((String)"==", (String)rel)) {
            return "=";
        }
        return rel;
    }

    private String itemStr(DynamicObjectCollection condItem) {
        List collect = condItem.stream().map(dd -> dd.getString("fbasedataid.name")).collect(Collectors.toList());
        if (collect.size() == 1) {
            return (String)collect.get(0);
        }
        return String.format(Locale.ROOT, "\uff08%s\uff09", String.join((CharSequence)" + ", collect));
    }

    public boolean isValidCondition(IFormView view, DynamicObjectCollection limitCollect, String logicStr) {
        String pattern = "^\\(*T[0-9]+\\)*((and|or)\\(*T[0-9]+\\)*)*$";
        String expressStr = this.parseToCulCondition(logicStr);
        if (!Pattern.matches(pattern, expressStr.replaceAll(" ", ""))) {
            view.showTipNotification(IncDecConfKDStringHelper.condError());
            return false;
        }
        String[] str = expressStr.split(" ");
        int leftBracket = 0;
        int rightBracket = 0;
        Set expressNameSet = limitCollect.stream().map(row -> row.getString("limitno")).collect(Collectors.toSet());
        for (int i = 0; i < str.length; ++i) {
            if (StringUtils.isEmpty((CharSequence)str[i])) continue;
            if ("(".equals(str[i])) {
                ++leftBracket;
                continue;
            }
            if (")".equals(str[i])) {
                ++rightBracket;
                continue;
            }
            if ("and".equals(str[i]) || "or".equals(str[i])) continue;
            if (Pattern.matches("^T\\d{2,}$", str[i])) {
                if (expressNameSet.contains(str[i])) continue;
                view.showTipNotification(IncDecConfKDStringHelper.notCond(str[i]));
                return false;
            }
            view.showTipNotification(IncDecConfKDStringHelper.notEff(str[i]));
            return false;
        }
        if (leftBracket != rightBracket) {
            view.showTipNotification(IncDecConfKDStringHelper.notMatch());
            return false;
        }
        return true;
    }

    private String parseToCulCondition(String condition) {
        return condition.replaceAll("\uff08", "\\(").replaceAll("\uff09", ")").replaceAll(IncDecConfKDStringHelper.or(), "or").replaceAll(IncDecConfKDStringHelper.and(), "and").replaceAll("\u00a0", " ");
    }

    private Map<String, String> getComboNames(String formId, String comboKey) {
        return ((ComboProp)EntityMetadataCache.getDataEntityType((String)formId).getFields().get(comboKey)).getComboItems().stream().collect(Collectors.toMap(ValueMapItem::getValue, item -> item.getName().getLocaleValue(), (v1, v2) -> v1));
    }

    public final void initComboData() {
        this.serialPeriodMap = this.getComboNames("wtp_incdeccond", "serialperiod");
        this.dayTypeMap = this.getComboNames("wtp_incdeccond", "daytype");
        this.shiftTypeMap = this.getComboNames("wtp_incdeccond", "shifttype");
        this.inDecrRelMap = this.getComboNames("wtp_incdeccond", "indecrrel");
        this.triggerCompMap = this.getComboNames("wtp_incdeccond", "triggercomp");
        this.triggerSignMap = this.getComboNames("wtp_incdeccond", "triggersign");
        this.unitMap = this.getComboNames("wtbd_attitem", "unit");
    }

    private static class InstanceHolder {
        private static final IncDecConfCondService INSTANCE = new IncDecConfCondService();

        private InstanceHolder() {
        }
    }
}

