/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.incrdecrrules;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.wtp.constants.incdec.IncDecConfigConstants;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;
import kd.wtc.wtp.business.incrdecrrules.IncDecConfCondService;
import kd.wtc.wtp.business.incrdecrrules.IncDecConfKDStringHelper;
import kd.wtc.wtp.utils.WTCSheetUtil;

public class IncDecConfService
implements IncDecConfigConstants {
    private static final String CALLBACK_CLASSNAME = "kd.wtc.wtp.formplugin.web.incrdecrrules.IncDecConfEdit";

    public static IncDecConfService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public void setOpColumnShow(IFormView view) {
        if (view == null) {
            return;
        }
        boolean lock = WTCHisService.isLock((IFormView)view);
        view.setVisible(Boolean.valueOf(lock), new String[]{"operationcolumnapsee"});
        view.setVisible(Boolean.valueOf(!lock), new String[]{"operationcolumnap"});
    }

    public void refreshSubView(IFormView view, String cacheKey, boolean isTime) {
        WTCPageCache pageCache = new WTCPageCache(view);
        Map regularTimeCache = (Map)pageCache.get(cacheKey, Map.class);
        if (regularTimeCache == null) {
            return;
        }
        Set entries = regularTimeCache.entrySet();
        for (Map.Entry next : entries) {
            IFormView subView;
            String pageId = (String)next.getValue();
            if (!HRStringUtils.isNotEmpty((String)pageId) || (subView = view.getView(pageId)) == null) continue;
            HashMap<String, Object> oldData = new HashMap<String, Object>(4);
            DynamicObject subDy = subView.getModel().getDataEntity(true);
            DynamicObject item = subDy.getDynamicObject("curattitem");
            if (!HRObjectUtils.isEmpty((Object)item)) {
                oldData.put("curattitem", item.getLong("id"));
            }
            oldData.put("indecrvalue", subDy.get("indecrvalue"));
            oldData.put("indecrrel", subDy.get("indecrrel"));
            if (isTime) {
                oldData.put("regulartime", subDy.get("regulartime"));
            }
            subView.getFormShowParameter().setCustomParam("refreshdata", oldData);
            subView.invokeOperation("refresh");
            view.sendFormAction(subView);
        }
    }

    public void setFormStatus(IFormView view) {
        TargetCondition control = (TargetCondition)view.getControl("targetconditionap");
        if (control == null) {
            return;
        }
        boolean isView = WTCHisService.isLock((IFormView)view);
        if (isView) {
            control.setPageState("VIEW");
        }
    }

    public void setFormStatusOfEdit(IFormView view) {
        TargetCondition control = (TargetCondition)view.getControl("targetconditionap");
        if (control == null) {
            return;
        }
        boolean isView = WTCHisService.isLock((IFormView)view);
        if (!isView) {
            control.setPageState("EDIT");
        }
    }

    public void openItemPage(IFormView view, boolean isAdd, String opKey) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        DynamicObject createOrg = dataEntity.getDynamicObject("createorg");
        if (HRObjectUtils.isEmpty((Object)createOrg)) {
            view.showErrorNotification(IncDecConfKDStringHelper.createOrg());
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("createorg", String.valueOf(createOrg.getLong("id")));
        String suitType = dataEntity.getString("suittype");
        String triggerType = HRStringUtils.equals((String)"2", (String)suitType) ? "D" : "A";
        map.put("triggertype", triggerType);
        map.put("isAdd", isAdd);
        String actionId = "wtp_incdeccond";
        if (!isAdd) {
            int row = view.getModel().getEntryCurrentRowIndex("entryentity");
            actionId = "wtp_incdeccond" + row;
            DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
            DynamicObject parentDy = (DynamicObject)entryEntity.get(row);
            map.put("logictype", parentDy.get("logictype"));
            map.put("logicstr", parentDy.get("logicstr"));
            DynamicObjectCollection condCollect = parentDy.getDynamicObjectCollection("condsubentryentity");
            map.put("load_cond_sub_view", condCollect);
            if (HRStringUtils.equals((String)"D", (String)triggerType)) {
                DynamicObjectCollection resultCollect = parentDy.getDynamicObjectCollection("resultsubentryentity");
                map.put("load_result_sub_view", resultCollect);
            } else {
                boolean serialLimit = parentDy.getBoolean("seriallimit");
                map.put("seriallimit", parentDy.get("seriallimit"));
                if (serialLimit) {
                    map.put("load_item_sub_view", parentDy);
                } else {
                    DynamicObjectCollection resultCollect = parentDy.getDynamicObjectCollection("resultsubentryentity");
                    map.put("load_result_sub_view", resultCollect);
                }
            }
        }
        OperationStatus status = HRStringUtils.equals((String)"condsee", (String)opKey) ? OperationStatus.VIEW : OperationStatus.EDIT;
        FormShowParameter parameter = WTCSheetUtil.showFormParameter((ShowType)ShowType.Modal, null, (String)"wtp_incdeccond", (CloseCallBack)new CloseCallBack(CALLBACK_CLASSNAME, actionId), map, (OperationStatus)status);
        view.showForm(parameter);
    }

    private void setConEntry(Map<String, Object> resultMap, DynamicObject entryDyn) {
        DynamicObjectCollection limitSubColl = entryDyn.getDynamicObjectCollection("condsubentryentity");
        limitSubColl.clear();
        DynamicObjectCollection condCollect = (DynamicObjectCollection)resultMap.get("conddata");
        if (condCollect != null) {
            int seq = 0;
            for (DynamicObject dy : condCollect) {
                DynamicObject limitSubDy = limitSubColl.addNew();
                limitSubDy.set("seq", (Object)seq++);
                limitSubDy.set("limitno", dy.get("limitno"));
                limitSubDy.set("condattitem", (Object)dy.getDynamicObjectCollection("condattitem"));
                limitSubDy.set("condrel", dy.get("condrel"));
                limitSubDy.set("condvalue", dy.get("condvalue"));
            }
        }
    }

    private void setResultEntry(Map<String, Object> resultMap, DynamicObject entryDyn) {
        DynamicObjectCollection resultSubColl = entryDyn.getDynamicObjectCollection("resultsubentryentity");
        resultSubColl.clear();
        List resultList = (List)resultMap.get("resultdata");
        if (resultList != null) {
            int seq = 0;
            for (DynamicObject dy : resultList) {
                DynamicObject resultSubDy = resultSubColl.addNew();
                resultSubDy.set("seq", (Object)seq++);
                resultSubDy.set("resultitem", (Object)dy.getDynamicObject("resultitem"));
                resultSubDy.set("resultrel", dy.get("resultrel"));
                resultSubDy.set("resultvalue", dy.get("resultvalue"));
            }
        }
    }

    public void closedCallBackOfAdd(Map<String, Object> resultMap, IDataModel model, IFormView view) {
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        int parentRow = 0;
        if (entryEntity != null) {
            parentRow = entryEntity.size();
        }
        IDataModel entryOperate = view.getModel();
        entryOperate.setEntryCurrentRowIndex("entryentity", parentRow);
        DynamicObject entryDyn = model.getDataEntity(true).getDynamicObjectCollection("entryentity").addNew();
        this.setEntryValue(resultMap, model, view, entryDyn, parentRow);
    }

    public void closedCallBackOfEdit(Map<String, Object> resultMap, IDataModel model, IFormView view, String actionId) {
        String substring = actionId.substring("wtp_incdeccond".length());
        int parentRow = Integer.parseInt(substring);
        DynamicObject entryDyn = (DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("entryentity").get(parentRow);
        this.setEntryValue(resultMap, model, view, entryDyn, parentRow);
    }

    private void setEntryValue(Map<String, Object> resultMap, IDataModel model, IFormView view, DynamicObject entryDyn, int parentRow) {
        String triggerType = (String)resultMap.get("triggertype");
        model.beginInit();
        entryDyn.set("conditionstr", resultMap.get("conditionstr"));
        entryDyn.set("resultstr", resultMap.get("resultstr"));
        entryDyn.set("logictype", resultMap.get("logictype"));
        entryDyn.set("logicstr", resultMap.get("logicstr"));
        if (HRStringUtils.equals((String)"D", (String)triggerType)) {
            entryDyn.set("indecrvalue", (Object)BigDecimal.ZERO);
            this.setResultEntry(resultMap, entryDyn);
        } else {
            boolean serialLimit = (Boolean)resultMap.get("seriallimit");
            model.setValue("seriallimit", resultMap.get("seriallimit"), parentRow);
            entryDyn.set("curattitem", resultMap.get("curattitem"));
            if (serialLimit) {
                entryDyn.set("serialperiod", resultMap.get("serialperiod"));
                entryDyn.set("shifttype", resultMap.get("shifttype"));
                entryDyn.set("daytype", resultMap.get("daytype"));
                entryDyn.set("battitem", resultMap.get("battitem"));
                entryDyn.set("indecrrel", resultMap.get("indecrrel"));
                entryDyn.set("indecrvalue", resultMap.get("indecrvalue"));
                entryDyn.set("istriggeritem", resultMap.get("istriggeritem"));
                this.clearResultSubEntry(entryDyn);
            } else {
                entryDyn.set("indecrvalue", (Object)BigDecimal.ZERO);
                this.setResultEntry(resultMap, entryDyn);
            }
        }
        entryDyn.set("triggercomp", resultMap.get("triggercomp"));
        entryDyn.set("triggerval", this.getValueOrDefault(resultMap.get("triggerval"), BigDecimal.ONE));
        entryDyn.set("triggeritem", resultMap.get("triggeritem"));
        entryDyn.set("triggersign", resultMap.get("triggersign"));
        entryDyn.set("triggerresult", this.getValueOrDefault(resultMap.get("triggerresult"), BigDecimal.ONE));
        this.setConEntry(resultMap, entryDyn);
        model.endInit();
        view.updateView("entryentity");
        view.updateView("condsubentryentity");
        view.updateView("resultsubentryentity");
    }

    public void openRegularTimePage(IFormView view, boolean isFirst) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        DynamicObject dataEntity = view.getModel().getDataEntity();
        DynamicObject createOrg = dataEntity.getDynamicObject("createorg");
        if (HRObjectUtils.isEmpty((Object)createOrg)) {
            view.showErrorNotification(IncDecConfKDStringHelper.createOrg());
            return;
        }
        WTCPageCache pageCache = new WTCPageCache(view);
        Map regularTimeCache = (Map)pageCache.get("regulartimecache", Map.class);
        if (regularTimeCache == null) {
            regularTimeCache = Maps.newHashMapWithExpectedSize((int)1);
        }
        if (regularTimeCache.size() > 9) {
            view.showTipNotification(IncDecConfKDStringHelper.resultMax());
            return;
        }
        String actionId = "regulartimeactionid" + regularTimeCache.size();
        map.put("actionid", actionId);
        if (isFirst) {
            map.put("new", "new");
        }
        this.dynamicFlex(actionId, view, regularTimeCache.size(), "regulartimeaddflex");
        map.put("createorg", String.valueOf(createOrg.getLong("id")));
        FormShowParameter parameter = WTCSheetUtil.showFormParameter((ShowType)ShowType.InContainer, (String)actionId, (String)"wtp_incdecconftime", (CloseCallBack)new CloseCallBack(CALLBACK_CLASSNAME, actionId), (HashMap)map, (OperationStatus)view.getFormShowParameter().getStatus());
        view.showForm(parameter);
        view.updateView("regulartimeflex");
        regularTimeCache.put(actionId, parameter.getPageId());
        pageCache.put("regulartimecache", (Object)regularTimeCache);
    }

    public void moveData(IFormView view, String copyActionId, IFormPlugin plugin, String preAction, String cacheKey, String sourceKey, String sourcePage, boolean isTime) {
        WTCPageCache pageCache = new WTCPageCache(view);
        Map regularTimeCache = (Map)pageCache.get(cacheKey, Map.class);
        if (regularTimeCache == null) {
            return;
        }
        List<HashMap<String, Object>> list = this.getListAndDeleteOldFlex(view, copyActionId, regularTimeCache, preAction, sourceKey, isTime);
        pageCache.put(cacheKey, null);
        regularTimeCache = Maps.newHashMapWithExpectedSize((int)1);
        int index = 0;
        for (HashMap<String, Object> map : list) {
            String actionId = preAction + index;
            if (index == 0) {
                map.put("new", "new");
            }
            this.dynamicFlex(actionId, view, index, sourceKey);
            FormShowParameter parameter = WTCSheetUtil.showFormParameter((ShowType)ShowType.InContainer, (String)actionId, (String)sourcePage, (CloseCallBack)new CloseCallBack(plugin, actionId), map, (OperationStatus)view.getFormShowParameter().getStatus());
            view.showForm(parameter);
            view.updateView(sourceKey);
            regularTimeCache.put(actionId, parameter.getPageId());
            ++index;
        }
        pageCache.put(cacheKey, (Object)regularTimeCache);
    }

    private List<HashMap<String, Object>> getListAndDeleteOldFlex(IFormView view, String copyActionId, Map<String, String> regularTimeCache, String preAction, String sourceKey, boolean isTime) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        DynamicObject createOrg = dataEntity.getDynamicObject("createorg");
        String copyIndexStr = copyActionId.substring(preAction.length());
        ArrayList list = Lists.newArrayListWithExpectedSize((int)(regularTimeCache.size() + 1));
        Integer copyIndex = Integer.valueOf(copyIndexStr);
        for (int index = 0; index < regularTimeCache.size(); ++index) {
            IFormView subView;
            String actionId = preAction + index;
            String pageId = regularTimeCache.get(actionId);
            HashMap map = Maps.newHashMapWithExpectedSize((int)4);
            map.put("createorg", String.valueOf(createOrg.getLong("id")));
            if (HRStringUtils.isNotEmpty((String)pageId) && (subView = view.getView(pageId)) != null) {
                HashMap<String, Object> oldData = new HashMap<String, Object>(4);
                DynamicObject subDy = subView.getModel().getDataEntity(true);
                DynamicObject item = subDy.getDynamicObject("curattitem");
                if (!HRObjectUtils.isEmpty((Object)item)) {
                    oldData.put("curattitem", item.getLong("id"));
                }
                oldData.put("indecrrel", subDy.get("indecrrel"));
                oldData.put("indecrvalue", subDy.get("indecrvalue"));
                if (isTime) {
                    oldData.put("regulartime", subDy.get("regulartime"));
                }
                map.put("data", oldData);
                if (index == copyIndex) {
                    HashMap copyMap = Maps.newHashMapWithExpectedSize((int)4);
                    copyMap.putAll(map);
                    list.add(copyMap);
                }
            }
            list.add(map);
            Container flexPanel = (Container)view.getControl(sourceKey);
            flexPanel.deleteControls(new String[]{actionId});
        }
        return list;
    }

    public void clearRegularTimeCache(IFormView view, String cacheKey, String flexKey) {
        WTCPageCache pageCache = new WTCPageCache(view);
        Map regularTimeCache = (Map)pageCache.get(cacheKey, Map.class);
        if (regularTimeCache == null) {
            return;
        }
        Set entries = regularTimeCache.entrySet();
        for (Map.Entry next : entries) {
            String pageId = (String)next.getValue();
            if (!HRStringUtils.isNotEmpty((String)pageId)) continue;
            Container flexPanel = (Container)view.getControl(flexKey);
            flexPanel.deleteControls(new String[]{(String)next.getKey()});
        }
        pageCache.put(cacheKey, null);
    }

    public boolean checkAndSave(IFormView view, String cacheKey, boolean isTime) {
        WTCPageCache pageCache = new WTCPageCache(view);
        Map regularTimeCache = (Map)pageCache.get(cacheKey, Map.class);
        if (regularTimeCache == null) {
            return false;
        }
        boolean check = this.check(view, regularTimeCache, isTime);
        if (!check) {
            return false;
        }
        IDataModel model = view.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", regularTimeCache.size());
        int index = 0;
        Set entries = regularTimeCache.entrySet();
        for (Map.Entry next : entries) {
            IFormView subView;
            String pageId = (String)next.getValue();
            if (!HRStringUtils.isNotEmpty((String)pageId) || (subView = view.getView(pageId)) == null) continue;
            DynamicObject dataEntity = subView.getModel().getDataEntity();
            if (isTime) {
                model.setValue("regulartime", (Object)dataEntity.getInt("regulartime"), index);
                model.setValue("conditionstr", (Object)IncDecConfCondService.getInstance().condShow(dataEntity.getInt("regulartime")), index);
            } else {
                model.setValue("conditionstr", (Object)IncDecConfKDStringHelper.empty(), index);
            }
            model.setValue("resultstr", (Object)IncDecConfCondService.getInstance().resultShowOfTime(dataEntity.getDynamicObject("curattitem"), dataEntity.getString("indecrrel"), dataEntity.getBigDecimal("indecrvalue")), index);
            model.setValue("curattitem", dataEntity.get("curattitem"), index);
            model.setValue("indecrrel", dataEntity.get("indecrrel"), index);
            model.setValue("indecrvalue", dataEntity.get("indecrvalue"), index);
            ++index;
        }
        model.endInit();
        view.updateView("entryentity");
        return true;
    }

    private boolean check(IFormView view, Map<String, String> regularTimeCache, boolean isTime) {
        Date beSd = view.getModel().getDataEntity(true).getDate("bsed");
        Set<Map.Entry<String, String>> entries = regularTimeCache.entrySet();
        for (Map.Entry<String, String> next : entries) {
            Date beSdDate;
            int regularTime;
            IFormView subView;
            String pageId = next.getValue();
            if (!HRStringUtils.isNotEmpty((String)pageId) || (subView = view.getView(pageId)) == null) continue;
            DynamicObject dataEntity = subView.getModel().getDataEntity();
            if (isTime && (regularTime = dataEntity.getInt("regulartime")) < 0) {
                view.showErrorNotification(IncDecConfKDStringHelper.regularTime());
                return false;
            }
            DynamicObject attItem = dataEntity.getDynamicObject("curattitem");
            if (HRObjectUtils.isEmpty((Object)attItem)) {
                view.showErrorNotification(IncDecConfKDStringHelper.item());
                return false;
            }
            Date date = beSdDate = attItem.containsProperty("firstbsed") ? attItem.getDate("firstbsed") : attItem.getDate("bsed");
            if (beSdDate.after(beSd)) {
                view.showErrorNotification(IncDecConfKDStringHelper.itemBsEd(attItem.getString("name")));
                return false;
            }
            String rel = dataEntity.getString("indecrrel");
            if (HRStringUtils.isEmpty((String)rel)) {
                view.showErrorNotification(IncDecConfKDStringHelper.rel());
                return false;
            }
            BigDecimal inDeCrValue = dataEntity.getBigDecimal("indecrvalue");
            if (inDeCrValue == null) {
                view.showErrorNotification(IncDecConfKDStringHelper.value());
                return false;
            }
            if (inDeCrValue.compareTo(BigDecimal.ZERO) >= 0 && inDeCrValue.compareTo(new BigDecimal("9999999999.99")) <= 0) continue;
            view.showErrorNotification(IncDecConfKDStringHelper.incValue());
            return false;
        }
        return true;
    }

    public void loadTimeSub(IFormPlugin plugin, IFormView view) {
        WTCPageCache pageCache = new WTCPageCache(view);
        Maps maps = (Maps)pageCache.get("regulartimecache", Maps.class);
        if (maps != null) {
            return;
        }
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
        DynamicObject createOrg = view.getModel().getDataEntity().getDynamicObject("createorg");
        int idx = 0;
        HashMap regularTimeCache = Maps.newHashMapWithExpectedSize((int)entryEntity.size());
        for (DynamicObject dy : entryEntity) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            if (idx == 0) {
                map.put("new", "new");
            }
            map.put("load_time_sub_view", (String)dy);
            String actionId = "regulartimeactionid" + idx;
            map.put("actionid", actionId);
            map.put("createorg", String.valueOf(createOrg.getLong("id")));
            this.dynamicFlex(actionId, view, idx, "regulartimeaddflex");
            FormShowParameter parameter = WTCSheetUtil.showFormParameter((ShowType)ShowType.InContainer, (String)actionId, (String)"wtp_incdecconftime", (CloseCallBack)new CloseCallBack(plugin, actionId), map, (OperationStatus)view.getFormShowParameter().getStatus());
            view.showForm(parameter);
            view.updateView("regulartimeflex");
            regularTimeCache.put(actionId, parameter.getPageId());
            ++idx;
        }
        pageCache.put("regulartimecache", (Object)regularTimeCache);
    }

    public void openNotCondPage(IFormView view, boolean isFirst) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        DynamicObject createOrg = dataEntity.getDynamicObject("createorg");
        if (HRObjectUtils.isEmpty((Object)createOrg)) {
            view.showErrorNotification(IncDecConfKDStringHelper.createOrg());
            return;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        WTCPageCache pageCache = new WTCPageCache(view);
        Map notCondCache = (Map)pageCache.get("notcondcache", Map.class);
        if (notCondCache == null) {
            notCondCache = Maps.newHashMapWithExpectedSize((int)1);
        }
        if (notCondCache.size() > 9) {
            view.showTipNotification(IncDecConfKDStringHelper.resultMax());
            return;
        }
        String actionId = "notcondactionid" + notCondCache.size();
        map.put("actionid", actionId);
        this.dynamicFlex(actionId, view, notCondCache.size(), "notaddflex");
        if (isFirst) {
            map.put("new", "new");
        }
        map.put("createorg", String.valueOf(createOrg.getLong("id")));
        FormShowParameter parameter = WTCSheetUtil.showFormParameter((ShowType)ShowType.InContainer, (String)actionId, (String)"wtp_incdecconfno", (CloseCallBack)new CloseCallBack(CALLBACK_CLASSNAME, actionId), (HashMap)map, (OperationStatus)view.getFormShowParameter().getStatus());
        view.showForm(parameter);
        view.updateView("notflex");
        notCondCache.put(actionId, parameter.getPageId());
        pageCache.put("notcondcache", (Object)notCondCache);
    }

    public void loadNotCondSub(IFormPlugin plugin, IFormView view) {
        WTCPageCache pageCache = new WTCPageCache(view);
        Maps maps = (Maps)pageCache.get("notcondcache", Maps.class);
        if (maps != null) {
            return;
        }
        DynamicObject createOrg = view.getModel().getDataEntity().getDynamicObject("createorg");
        int idx = 0;
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
        HashMap regularTimeCache = Maps.newHashMapWithExpectedSize((int)entryEntity.size());
        for (DynamicObject dy : entryEntity) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            if (idx == 0) {
                map.put("new", "new");
            }
            map.put("load_notcond_sub_view", (String)dy);
            String actionId = "notcondactionid" + idx;
            map.put("createorg", String.valueOf(createOrg.getLong("id")));
            map.put("actionid", actionId);
            this.dynamicFlex(actionId, view, idx, "notaddflex");
            FormShowParameter parameter = WTCSheetUtil.showFormParameter((ShowType)ShowType.InContainer, (String)actionId, (String)"wtp_incdecconfno", (CloseCallBack)new CloseCallBack(plugin, actionId), map, (OperationStatus)view.getFormShowParameter().getStatus());
            view.showForm(parameter);
            view.updateView("notflex");
            regularTimeCache.put(actionId, parameter.getPageId());
            ++idx;
        }
        pageCache.put("notcondcache", (Object)regularTimeCache);
    }

    private String dynamicFlex(String key, IFormView view, int index, String sourceFlex) {
        Container flexPanel = (Container)view.getControl(sourceFlex);
        FlexPanelAp childFlex = new FlexPanelAp();
        childFlex.setKey(key);
        Margin margin = new Margin();
        margin.setBottom("0px");
        margin.setTop("0px");
        Style style = new Style();
        style.setMargin(margin);
        childFlex.setStyle(style);
        flexPanel.insertControls(index, Collections.singletonList(childFlex.createControl()));
        return key;
    }

    public boolean checkDataTime(IFormView view, String conditions) {
        if (HRStringUtils.isEmpty((String)conditions)) {
            return true;
        }
        if (conditions.contains("is_or_isSub")) {
            view.showTipNotification(ExKDStringHelper.gradeError());
            return false;
        }
        RuleConditionInfo accessDto = (RuleConditionInfo)WTCSerializationUtils.fromJsonString((String)conditions, RuleConditionInfo.class);
        if (accessDto == null) {
            return true;
        }
        List conditionList = accessDto.getConditionList();
        if (conditionList.size() > 10) {
            view.showTipNotification(IncDecConfKDStringHelper.condMax());
            return false;
        }
        RuleValidateInfo info = RuleValidateUtil.validCondition((String)conditions, (boolean)true);
        if (!info.isSuccess()) {
            view.showTipNotification(IncDecConfKDStringHelper.rangeDateError() + String.join((CharSequence)",", info.getMsgList()));
            return false;
        }
        return true;
    }

    public boolean haveDataTime(String conditions) {
        if (HRStringUtils.isEmpty((String)conditions)) {
            return false;
        }
        RuleConditionInfo accessDto = null;
        accessDto = (RuleConditionInfo)WTCSerializationUtils.fromJsonString((String)conditions, RuleConditionInfo.class);
        if (accessDto == null) {
            return false;
        }
        List conditionList = accessDto.getConditionList();
        return conditionList != null && !conditionList.isEmpty();
    }

    public boolean serialLimit(long boId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_incdecconf");
        QFilter boIdQFilter = new QFilter("boid", "=", (Object)boId);
        boIdQFilter.and(this.getDataStatus());
        boIdQFilter.and(new QFilter("entryentity.seriallimit", "=", (Object)"1"));
        DynamicObject[] dynamicObjects = helper.loadDynamicObjectArray(new QFilter[]{boIdQFilter});
        return dynamicObjects != null && dynamicObjects.length > 0;
    }

    private QFilter getDataStatus() {
        ArrayList dataStatusList = Lists.newArrayListWithExpectedSize((int)3);
        dataStatusList.add("0");
        dataStatusList.add("1");
        dataStatusList.add("2");
        return new QFilter("datastatus", "in", (Object)dataStatusList);
    }

    private Object getValueOrDefault(Object value, Object defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        return value;
    }

    private void clearResultSubEntry(DynamicObject entryDyn) {
        DynamicObjectCollection resultSubColl = entryDyn.getDynamicObjectCollection("resultsubentryentity");
        resultSubColl.clear();
    }

    public void replaceResultStrAndCondStr(DynamicObject dataEntity) {
        DynamicObjectCollection entities = dataEntity.getDynamicObjectCollection("entryentity");
        if (entities != null && entities.size() > 0) {
            IncDecConfCondService.getInstance().initComboData();
            for (DynamicObject entity : entities) {
                String resultStr;
                String triggerType = dataEntity.getString("triggertype");
                if (HRStringUtils.equals((String)"D", (String)triggerType)) {
                    DynamicObjectCollection collection = entity.getDynamicObjectCollection("resultsubentryentity");
                    ArrayList resultList = Lists.newArrayListWithCapacity((int)collection.size());
                    collection.forEach(r -> resultList.add(IncDecConfCondService.getInstance().getOneResultStr((DynamicObject)r)));
                    resultStr = String.join((CharSequence)"\uff1b", resultList);
                } else {
                    boolean serialLimit = entity.getBoolean("seriallimit");
                    if (serialLimit) {
                        resultStr = IncDecConfCondService.getInstance().resultShow(entity);
                    } else {
                        DynamicObjectCollection collection = entity.getDynamicObjectCollection("resultsubentryentity");
                        ArrayList resultList = Lists.newArrayListWithCapacity((int)collection.size());
                        collection.forEach(r -> resultList.add(IncDecConfCondService.getInstance().getOneResultStr((DynamicObject)r)));
                        resultStr = String.join((CharSequence)"\uff1b", resultList);
                    }
                }
                entity.set("resultstr", (Object)resultStr);
                String conditionStr = IncDecConfCondService.getInstance().condShow(entity.getDynamicObjectCollection("condsubentryentity"), entity.getString("logicstr"), entity.getString("logictype"));
                entity.set("conditionstr", (Object)conditionStr);
            }
        }
    }

    public void setInitValue(DynamicObject dataEntity) {
        DynamicObjectCollection entities = dataEntity.getDynamicObjectCollection("entryentity");
        if (WTCCollections.isEmpty((Collection)entities)) {
            return;
        }
        Iterator iterator = entities.iterator();
        while (iterator.hasNext()) {
            DynamicObject entity;
            BigDecimal triggerVal = (entity = (DynamicObject)iterator.next()).getBigDecimal("triggerval");
            entity.set("triggerval", (Object)(BigDecimal.ZERO.compareTo(triggerVal) == 0 ? BigDecimal.ONE : triggerVal));
            BigDecimal triggerResult = entity.getBigDecimal("triggerresult");
            entity.set("triggerresult", (Object)(BigDecimal.ZERO.compareTo(triggerResult) == 0 ? BigDecimal.ONE : triggerResult));
        }
    }

    private static class InstanceHolder {
        private static final IncDecConfService INSTANCE = new IncDecConfService();

        private InstanceHolder() {
        }
    }
}

