/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.mobile;

import kd.bos.bill.BillShowParameter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtp.constants.mobile.MobileConfConstants;

public class MobileSchemaHelper {
    private MobileSchemaHelper() {
    }

    public static MobileSchemaHelper getInstance() {
        return Instance.INSTANCE;
    }

    public void setDataToSelectBill(IFormView view) {
        StringBuilder result = new StringBuilder(10);
        for (String field : MobileConfConstants.SELECT_BILLS) {
            boolean value = (Boolean)view.getModel().getValue(field);
            if (!value) continue;
            result.append(field.toUpperCase()).append(',');
        }
        if (result.length() > 0) {
            String data = "," + result;
            view.getModel().setValue("selectedbill", (Object)data);
            view.setVisible(Boolean.FALSE, new String[]{"selectedbill"});
        } else {
            view.getModel().setValue("selectedbill", null);
            view.setVisible(Boolean.TRUE, new String[]{"selectedbill"});
        }
    }

    public void setSelectBillToData(IFormView view) {
        String[] bills;
        String selectBills = (String)view.getModel().getValue("selectedbill");
        if (HRStringUtils.isEmpty((String)selectBills)) {
            return;
        }
        for (String bill : bills = selectBills.split(",")) {
            if (!HRStringUtils.isNotEmpty((String)bill)) continue;
            view.getModel().setValue(bill.toLowerCase(), (Object)Boolean.TRUE);
        }
    }

    public void cacheAttItemPageId(long attItemId, BillShowParameter showParameter, IFormView view) {
        WTCPageCache wtcPageCache = new WTCPageCache(view);
        String pageId = (String)wtcPageCache.get(String.valueOf(attItemId), String.class);
        if (HRStringUtils.isNotEmpty((String)pageId)) {
            showParameter.setPageId(pageId);
        }
        view.showForm((FormShowParameter)showParameter);
        if (HRStringUtils.isEmpty((String)pageId)) {
            wtcPageCache.put(String.valueOf(attItemId), (Object)showParameter.getPageId());
        }
    }

    private static class Instance {
        private static MobileSchemaHelper INSTANCE = new MobileSchemaHelper();

        private Instance() {
        }
    }
}

