/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.mobile;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class TeamHomeHelper {
    private static HRBaseServiceHelper schemeServiceHelper = new HRBaseServiceHelper("wtp_mobilescheme");
    private static HRBaseServiceHelper ruleServiceHelper = new HRBaseServiceHelper("wtp_mobilerule");
    public static final String PLAN_DY_SQL_FILED = "id,name,teammobilerule,adminorgentry.adminorgname";

    private static DynamicObject[] getAllTeamMobileScheme() {
        QFilter filter = WTCHisServiceHelper.statusValidQFilter();
        filter.and(new QFilter("workspace", "=", (Object)"B"));
        DynamicObject[] schemes = schemeServiceHelper.query("attfilebaserange", filter.toArray());
        return schemes;
    }

    public static DynamicObject[] queryTeamMobileSchemeByAdminOrgId(Set<Long> adminOrgIds, String selectProperties) {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        QFilter adminOrgIdFilter = new QFilter("adminorgentry.adminorgname", "in", adminOrgIds);
        QFilter teamFilter = new QFilter("workspace", "=", (Object)"B");
        return schemeServiceHelper.query(selectProperties, new QFilter[]{filter, adminOrgIdFilter, teamFilter}, "modifytime desc");
    }

    public static DynamicObject queryTeamMobileSchemeByAdminOrgIdList(List<Long> adminOrgIdList, String selectProperties) {
        DynamicObject[] dynamicObjects = TeamHomeHelper.queryTeamMobileSchemeByAdminOrgId(new HashSet<Long>(adminOrgIdList), selectProperties);
        return dynamicObjects == null || dynamicObjects.length == 0 ? null : dynamicObjects[0];
    }

    public static DynamicObject queryTeamMobileRule(long ruleId) {
        String selectProperties = "id,number,workspace";
        return ruleServiceHelper.queryOne(selectProperties, (Object)ruleId);
    }

    public static long queryTeamSchemeIdByAdminOrgIdList(List<Long> adminOrgIdList) {
        if (CollectionUtils.isEmpty(adminOrgIdList)) {
            return 0L;
        }
        DynamicObject planDy = TeamHomeHelper.queryTeamMobileSchemeByAdminOrgIdList(adminOrgIdList, PLAN_DY_SQL_FILED);
        if (planDy == null) {
            return 0L;
        }
        return WTCDynamicObjectUtils.getBaseDataId((DynamicObject)planDy, (String)"id");
    }

    public static boolean isShowBoardByPkid(Long pkId) {
        DynamicObject dynamicObjects = ruleServiceHelper.queryOne("showboard", (Object)pkId);
        return TeamHomeHelper.isShowBoard(dynamicObjects);
    }

    public static boolean isShowBoard(DynamicObject dynamicObject) {
        return dynamicObject != null && dynamicObject.getBoolean("showboard");
    }

    public static Date addMonth(Date date, int value) {
        return WTCDateUtils.add((Date)date, (int)2, (int)value);
    }

    public static Date getSysPreDate() {
        return WTCDateUtils.addDays((Date)WTCHisServiceHelper.getNowDate(), (int)-1);
    }

    public static String checkDisplay(DynamicObjectCollection entryEntity, String type) {
        switch (type) {
            case "entryentity": {
                ArrayList pcDisplayList = Lists.newArrayListWithExpectedSize((int)10);
                List<String> mobileDisplayList = TeamHomeHelper.getDisplayList(entryEntity, pcDisplayList);
                if (mobileDisplayList.size() > 9) {
                    return ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u8003\u52e4\u7edf\u8ba1\u6700\u591a\u663e\u793a9\u4e2a\u3002", (String)"DaiPerStaConfigEdit_0", (String)"wtc-wtp-business", (Object[])new Object[0]);
                }
                if (pcDisplayList.size() <= 12) break;
                return ResManager.loadKDString((String)"\u7f51\u9875\u7aef\u8003\u52e4\u7edf\u8ba1\u6700\u591a\u663e\u793a12\u4e2a\u3002", (String)"DaiPerStaConfigEdit_5", (String)"wtc-wtp-business", (Object[])new Object[0]);
            }
            case "rankentryentity": {
                ArrayList pcRankDisplayList = Lists.newArrayListWithExpectedSize((int)10);
                List<String> mobileRankDisplayList = TeamHomeHelper.getRankDisplayList(entryEntity, pcRankDisplayList);
                if (mobileRankDisplayList.size() > 6) {
                    return ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u6392\u884c\u699c\u6700\u591a\u663e\u793a6\u4e2a\u3002", (String)"DaiPerStaConfigEdit_1", (String)"wtc-wtp-business", (Object[])new Object[0]);
                }
                if (pcRankDisplayList.size() <= 6) break;
                return ResManager.loadKDString((String)"\u7f51\u9875\u7aef\u6392\u884c\u699c\u6700\u591a\u663e\u793a6\u4e2a\u3002", (String)"DaiPerStaConfigEdit_2", (String)"wtc-wtp-business", (Object[])new Object[0]);
            }
            case "chartentryentity": {
                ArrayList pcChartDisplayList = Lists.newArrayListWithExpectedSize((int)10);
                List<String> mobileChartDisplayList = TeamHomeHelper.getChartDisplayList(entryEntity, pcChartDisplayList);
                if (mobileChartDisplayList.size() > 6) {
                    return ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u7edf\u8ba1\u56fe\u8868\u6700\u591a\u663e\u793a6\u4e2a\u3002", (String)"DaiPerStaConfigEdit_3", (String)"wtc-wtp-business", (Object[])new Object[0]);
                }
                if (pcChartDisplayList.size() <= 6) break;
                return ResManager.loadKDString((String)"\u7f51\u9875\u7aef\u7edf\u8ba1\u56fe\u8868\u6700\u591a\u663e\u793a6\u4e2a\u3002", (String)"DaiPerStaConfigEdit_4", (String)"wtc-wtp-business", (Object[])new Object[0]);
            }
            default: {
                return "";
            }
        }
        return "";
    }

    private static List<String> getChartDisplayList(DynamicObjectCollection entryEntity, List<String> pcChartDisplayList) {
        ArrayList mobileChartDisplayList = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject obj : entryEntity) {
            String display = obj.getString("chartdisplay");
            String terminal = obj.getString("chartterminal");
            TeamHomeHelper.fill(pcChartDisplayList, mobileChartDisplayList, display, terminal);
        }
        return mobileChartDisplayList;
    }

    private static List<String> getRankDisplayList(DynamicObjectCollection entryEntity, List<String> pcRankDisplayList) {
        ArrayList mobileRankDisplayList = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject obj : entryEntity) {
            String display = obj.getString("rankdisplay");
            String terminal = obj.getString("rankterminal");
            TeamHomeHelper.fill(pcRankDisplayList, mobileRankDisplayList, display, terminal);
        }
        return mobileRankDisplayList;
    }

    private static List<String> getDisplayList(DynamicObjectCollection entryEntity, List<String> pcDisplayList) {
        ArrayList mobileDisplayList = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject obj : entryEntity) {
            String display = obj.getString("display");
            String terminal = obj.getString("terminal");
            TeamHomeHelper.fill(pcDisplayList, mobileDisplayList, display, terminal);
        }
        return mobileDisplayList;
    }

    private static void fill(List<String> pcDisplayList, ArrayList<String> mobileDisplayList, String display, String terminal) {
        if ("true".equals(display)) {
            if ("2".equals(terminal)) {
                mobileDisplayList.add(display);
                pcDisplayList.add(display);
            } else if ("1".equals(terminal)) {
                mobileDisplayList.add(display);
            } else if ("0".equals(terminal)) {
                pcDisplayList.add(display);
            }
        }
    }
}

