/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.overtime;

import com.alibaba.fastjson.JSON;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtp.common.ot.ChildInfo;

public class OtRuleCalculCacheService {
    private static final Log LOG = LogFactory.getLog(OtRuleCalculCacheService.class);
    private DLock lock;
    String CACHE_CHILD_ATTITEM = "CACHE_CHILD_ATTITEM";
    private final IFormView calCulView;
    private final String pageId;
    private final String tip;

    public OtRuleCalculCacheService(IFormView calCulView) {
        this.calCulView = calCulView;
        this.pageId = calCulView.getPageId();
        this.tip = ResManager.loadKDString((String)"\u64cd\u4f5c\u8fc7\u5feb\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"OtRuleCalculCacheService_0", (String)"wtc-wtp-business", (Object[])new Object[0]);
        this.lock = DLock.create((String)this.pageId, (String)"otRuleCalAttItemLock");
    }

    public List<ChildInfo> getChildInfoListWithLock() {
        try {
            String childInfoJson = this.calCulView.getPageCache().get(this.CACHE_CHILD_ATTITEM);
            return JSON.parseArray((String)childInfoJson, ChildInfo.class);
        }
        catch (Exception ex) {
            LOG.warn("get lock error", (Throwable)ex);
            DLock.forceUnlock((String[])new String[]{this.pageId});
            throw new KDBizException(this.tip);
        }
    }

    public void setChildInfoWithLock(List<ChildInfo> childInfos) {
        try {
            this.calCulView.getPageCache().put(this.CACHE_CHILD_ATTITEM, JSON.toJSONString(childInfos));
        }
        catch (Exception ex) {
            LOG.warn("get lock error", (Throwable)ex);
            DLock.forceUnlock((String[])new String[]{this.pageId});
            throw new KDBizException(this.tip);
        }
    }

    public boolean getLock() {
        return this.lock.tryLock(3000L);
    }

    public void unLock() {
        DLock.forceUnlock((String[])new String[]{this.pageId});
    }

    public String getTip() {
        return this.tip;
    }
}

