/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.overtime;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseView;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.common.predata.wtbd.PreBrmScene;
import kd.wtc.wtbs.common.predata.wtbd.PreDataAttItem;
import kd.wtc.wtbs.common.predata.wtbd.PreDataOtType;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.ruleenging.RuleEngingHelper;
import kd.wtc.wtp.common.ot.ChildInfo;

public class OverworkRuleUtil {
    private static final Log LOG = LogFactory.getLog(OverworkRuleUtil.class);
    private static Map<Long, Map<String, Long>> otTypeMapping;
    private static Set<String> mustInputAttItem;

    public static void listenF7(Set<String> propertySet, IFormView iFormView, BeforeF7SelectListener beforeF7SelectListener) {
        propertySet.forEach(object -> {
            BasedataEdit fieldEdit = (BasedataEdit)iFormView.getControl(object);
            fieldEdit.addBeforeF7SelectListener(beforeF7SelectListener);
        });
    }

    public static void setFilter(Set<String> propertySet, IFormView iFormView, BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (propertySet.contains(fieldKey)) {
            if (iFormView.getModel().getValue("bsed") == null) {
                iFormView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"OverworkRuleUtil_0", (String)"wtc-wtp-business", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("firstbsed", "<=", iFormView.getModel().getValue("bsed")));
        }
    }

    public static Map<String, Long> getOtTypeMapping(Long otTypeId) {
        if (PreDataOtType.PRESET_ARR.contains(otTypeId)) {
            return otTypeMapping.get(otTypeId);
        }
        return Collections.emptyMap();
    }

    public static void setDefaultVal(IFormView formView, Long otTypeId) {
        IDataModel model = formView.getModel();
        Map<String, Long> attendItem = OverworkRuleUtil.getOtTypeMapping(otTypeId);
        model.setValue("originalprj", (Object)attendItem.get("originalprj"));
        model.setValue("originalcalprj", (Object)attendItem.get("originalcalprj"));
        model.setValue("subprj", (Object)attendItem.get("subprj"));
        model.setValue("resultprj", (Object)attendItem.get("resultprj"));
    }

    public static String getMutiLangInfo(String name) {
        String mutiLangInfo = null;
        switch (name) {
            case "originalprj": {
                mutiLangInfo = ResManager.loadKDString((String)"\u539f\u59cb\u65f6\u957f", (String)"OverworkRuleUtil_1", (String)"wtc-wtp-business", (Object[])new Object[0]);
                break;
            }
            case "originalcalprj": {
                mutiLangInfo = ResManager.loadKDString((String)"\u8d77\u7b97\u65f6\u957f", (String)"OverworkRuleUtil_2", (String)"wtc-wtp-business", (Object[])new Object[0]);
                break;
            }
            case "subprj": {
                mutiLangInfo = ResManager.loadKDString((String)"\u6263\u51cf\u65f6\u957f", (String)"OverworkRuleUtil_3", (String)"wtc-wtp-business", (Object[])new Object[0]);
                break;
            }
            case "resultprj": {
                mutiLangInfo = ResManager.loadKDString((String)"\u7ed3\u679c\u65f6\u957f", (String)"OverworkRuleUtil_4", (String)"wtc-wtp-business", (Object[])new Object[0]);
                break;
            }
            case "otcompenmode": {
                mutiLangInfo = ResManager.loadKDString((String)"\u8865\u507f\u65b9\u5f0f", (String)"OverworkRuleUtil_6", (String)"wtc-wtp-business", (Object[])new Object[0]);
                break;
            }
            case "otbaseset": {
                mutiLangInfo = ResManager.loadKDString((String)"\u52a0\u73ed\u57fa\u7840\u914d\u7f6e", (String)"OverworkRuleUtil_7", (String)"wtc-wtp-business", (Object[])new Object[0]);
                break;
            }
            case "overtimesub": {
                mutiLangInfo = ResManager.loadKDString((String)"\u6263\u51cf\u914d\u7f6e", (String)"OverworkRuleUtil_8", (String)"wtc-wtp-business", (Object[])new Object[0]);
                break;
            }
            case "bfroundingrule": {
                mutiLangInfo = ResManager.loadKDString((String)"\u820d\u5165\u89c4\u5219", (String)"OverworkRuleUtil_9", (String)"wtc-wtp-business", (Object[])new Object[0]);
                break;
            }
        }
        return mutiLangInfo;
    }

    public static boolean vailMustInputAttItem(String fix, IFormView formView, Set<String> otherMustInput) {
        if (formView == null) {
            LOG.warn("OverworkRuleUtil_vailMustInputAttItem form view can not be null");
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\u518d\u64cd\u4f5c\u3002", (String)"OverworkRuleUtil_10", (String)"wtc-wtp-business", (Object[])new Object[0]));
        }
        IDataModel model = formView.getModel();
        HashSet validate = Sets.newHashSet(mustInputAttItem);
        if (!CollectionUtils.isEmpty(otherMustInput)) {
            validate.addAll(otherMustInput);
        }
        for (String item : validate) {
            Object value = model.getValue(item);
            if (value != null) continue;
            String end = ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OverworkRuleUtil_5", (String)"wtc-wtp-business", (Object[])new Object[0]);
            formView.showTipNotification(fix + OverworkRuleUtil.getMutiLangInfo(item) + end);
            return false;
        }
        return true;
    }

    public static void synViewValToChildInfo(IFormView formView, ChildInfo childInfo) {
        IDataModel model = formView.getModel();
        childInfo.setoTCompenMode(OverworkRuleUtil.getBaseIdByMode(model, "otcompenmode"));
        childInfo.setOriginalPrj(OverworkRuleUtil.getBaseIdByMode(model, "originalprj"));
        childInfo.setOriginalConf((BigDecimal)model.getValue("originalconf"));
        childInfo.setOriginalCalPrj(OverworkRuleUtil.getBaseIdByMode(model, "originalcalprj"));
        childInfo.setOverTimeSub(OverworkRuleUtil.getBaseIdByMode(model, "overtimesub"));
        childInfo.setSubPrj(OverworkRuleUtil.getBaseIdByMode(model, "subprj"));
        childInfo.setBfRoundingRule(OverworkRuleUtil.getBaseIdByMode(model, "bfroundingrule"));
        childInfo.setResultPrj(OverworkRuleUtil.getBaseIdByMode(model, "resultprj"));
    }

    public static void synChildInfoToView(IDataModel model, ChildInfo childInfo) {
        model.setValue("otcompenmode", (Object)childInfo.getoTCompenMode());
        model.setValue("originalprj", (Object)childInfo.getOriginalPrj());
        BigDecimal originalConf = childInfo.getOriginalConf();
        if (originalConf == null || originalConf.compareTo(BigDecimal.ZERO) == 0) {
            model.setValue("originalconf", null);
        } else {
            model.setValue("originalconf", (Object)originalConf);
        }
        model.setValue("overtimesub", (Object)childInfo.getOverTimeSub());
        model.setValue("subprj", (Object)childInfo.getSubPrj());
        model.setValue("bfroundingrule", (Object)childInfo.getBfRoundingRule());
        model.setValue("resultprj", (Object)childInfo.getResultPrj());
        model.setValue("originalcalprj", (Object)childInfo.getOriginalCalPrj());
    }

    private static long getBaseIdByMode(IDataModel model, String baseKey) {
        Object value = model.getValue(baseKey);
        if (value == null) {
            return 0L;
        }
        return ((DynamicObject)value).getLong("id");
    }

    public static boolean otPlanIsEdit(IFormView view) {
        boolean isEdit = false;
        if (view instanceof BillView && (OperationStatus.ADDNEW == ((BillView)view).getStatus() || OperationStatus.EDIT == ((BillView)view).getStatus())) {
            isEdit = true;
        }
        if (view instanceof BaseView) {
            BaseView ba = (BaseView)view;
            BaseShowParameter bas = (BaseShowParameter)ba.getFormShowParameter();
            isEdit = BillOperationStatus.ADDNEW == bas.getBillStatus() || BillOperationStatus.EDIT == bas.getBillStatus();
        }
        return isEdit;
    }

    public static boolean policyidIsOt3(Object policyid) {
        DynamicObject policyDy = RuleEngingHelper.queryRuleEngingByPlanId(policyid);
        return policyDy == null || PreBrmScene.PD_WTC_SCENE_OTP_V3.equals(policyDy.get("scene.id"));
    }

    public static boolean otPlanDisPlay(IFormView view) {
        boolean isEdit;
        boolean bl = isEdit = !WTCHisService.isLock((IFormView)view);
        if ("1".equals(view.getModel().getValue("setruleway"))) {
            boolean hasTimeCut;
            boolean hasOtscene = view.getModel().getValue("otscene") != null;
            boolean bl2 = hasTimeCut = view.getModel().getValue("timecut") != null;
            return !hasOtscene || hasTimeCut || isEdit;
        }
        return true;
    }

    public static String checkTimeCutIdFirstBsed(Long timeCutId, Date beSd) {
        if (timeCutId == null) {
            return null;
        }
        if (beSd == null) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_timecut");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)timeCutId)};
        DynamicObject[] result = serviceHelper.query("id,timecutentry.datetypetime,timecutentry.cutattitem,timecutentry.iscutattitem", qFilters);
        if (result == null || result.length == 0) {
            return null;
        }
        for (DynamicObject timeCutDy : result) {
            DynamicObjectCollection entry = timeCutDy.getDynamicObjectCollection("timecutentry");
            for (DynamicObject dy : entry) {
                Date cutAttItemBsEd;
                Date dateTypeTimeBsEd;
                DynamicObject dateTypeTimeDy = dy.getDynamicObject("datetypetime");
                if (dateTypeTimeDy != null && (dateTypeTimeBsEd = dateTypeTimeDy.getDate("firstbsed")) != null && dateTypeTimeBsEd.compareTo(beSd) > 0) {
                    return ResManager.loadKDString((String)"\u52a0\u73ed\u65b9\u6848\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6240\u9009\u5de5\u65f6\u5207\u5206\u914d\u7f6e\u7684\u201c\u65e5\u671f\u7c7b\u578b\u65f6\u6bb5\u201d\u751f\u6548\u65e5\u671f\u3002", (String)"OverworkRuleUtil_11", (String)"wtc-wtp-business", (Object[])new Object[0]);
                }
                DynamicObject cutAttItemDy = dy.getDynamicObject("cutattitem");
                if (cutAttItemDy == null || !dy.getBoolean("iscutattitem") || (cutAttItemBsEd = cutAttItemDy.getDate("firstbsed")) == null || cutAttItemBsEd.compareTo(beSd) <= 0) continue;
                return ResManager.loadKDString((String)"\u52a0\u73ed\u65b9\u6848\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u6240\u9009\u5de5\u65f6\u5207\u5206\u914d\u7f6e\u7684\u201c\u73ed\u6b21\u5185\u65f6\u957f\u201d\u8003\u52e4\u9879\u76ee\u7684\u751f\u6548\u65e5\u671f\u3002", (String)"OverworkRuleUtil_12", (String)"wtc-wtp-business", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static boolean isNewTimeCut(IFormView view) {
        DynamicObject pageDy = view.getModel().getDataEntity();
        Object policyId = pageDy.get("policyid");
        if ("2".equals(pageDy.getString("setruleway"))) {
            return OverworkRuleUtil.policyidIsOt3(policyId);
        }
        return WTCStringUtils.isEmpty((String)pageDy.getString("otscene"));
    }

    static {
        mustInputAttItem = Sets.newHashSet((Object[])new String[]{"originalprj", "originalcalprj", "subprj", "resultprj"});
        otTypeMapping = Maps.newHashMapWithExpectedSize((int)3);
        HashMap<String, Long> workDay = new HashMap<String, Long>(16);
        workDay.put("originalprj", PreDataAttItem.PD_OT_1010_S);
        workDay.put("originalcalprj", PreDataAttItem.PD_OT_1020_S);
        workDay.put("subprj", PreDataAttItem.PD_OT_1030_S);
        workDay.put("resultprj", PreDataAttItem.PD_OT_1100_S);
        HashMap<String, Long> restDay = new HashMap<String, Long>(16);
        restDay.put("originalprj", PreDataAttItem.PD_OT_1040_S);
        restDay.put("originalcalprj", PreDataAttItem.PD_OT_1050_S);
        restDay.put("subprj", PreDataAttItem.PD_OT_1060_S);
        restDay.put("resultprj", PreDataAttItem.PD_OT_1110_S);
        HashMap<String, Long> offDay = new HashMap<String, Long>(16);
        offDay.put("originalprj", PreDataAttItem.PD_OT_1070_S);
        offDay.put("originalcalprj", PreDataAttItem.PD_OT_1080_S);
        offDay.put("subprj", PreDataAttItem.PD_OT_1090_S);
        offDay.put("resultprj", PreDataAttItem.PD_OT_1150_S);
        otTypeMapping.put(PreDataOtType.PD_1010_S, workDay);
        otTypeMapping.put(PreDataOtType.PD_1020_S, restDay);
        otTypeMapping.put(PreDataOtType.PD_1030_S, offDay);
    }
}

