/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.quota;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.wtc.wtp.constants.quota.QTInConversionConstants;
import kd.wtc.wtp.enums.quota.ConverMethodEnum;

public class QTInConversionHelper
implements QTInConversionConstants {
    private static final QTInConversionHelper QTINCONVERSIONHELPER = new QTInConversionHelper();

    public static QTInConversionHelper getInstance() {
        return QTINCONVERSIONHELPER;
    }

    public List<String> entryOverlapValidator(DynamicObject dynamicObject) {
        if (!dynamicObject.containsProperty("qtinconverentry")) {
            return Collections.emptyList();
        }
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("qtinconverentry");
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return Collections.emptyList();
        }
        List dynamicObjects = dynamicObjectCollection.stream().sorted(Comparator.comparing(dy -> dy.getInt("seq"))).collect(Collectors.toList());
        ArrayList<String> errorMsg = new ArrayList<String>(dynamicObjects.size());
        int firstBeginTime = ((DynamicObject)dynamicObjects.get(0)).getInt("begintime");
        if (firstBeginTime != 1) {
            errorMsg.add(ResManager.loadKDString((String)"\u9996\u884c\u5206\u5f55\u7684\u5f00\u59cb\u65e5\u671f\u9700\u5f55\u5165\u53c2\u6570[1]\u3002", (String)"QTInConversionHelper_0", (String)"wtc-wtp-business", (Object[])new Object[0]));
        }
        List list = dynamicObjects.stream().sorted(Comparator.comparing(dy -> dy.getInt("begintime"))).collect(Collectors.toList());
        for (int index = 0; index < list.size(); ++index) {
            int nextIndex;
            int endTime = ((DynamicObject)list.get(index)).getInt("endtime");
            int beginTime = ((DynamicObject)list.get(index)).getInt("begintime");
            int seq = ((DynamicObject)list.get(index)).getInt("seq");
            if (beginTime > endTime) {
                errorMsg.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u4e2d\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"QTInConversionHelper_1", (String)"wtc-wtp-business", (Object[])new Object[0]), seq));
            }
            if ((nextIndex = index + 1) >= list.size()) continue;
            int nextSeq = ((DynamicObject)list.get(nextIndex)).getInt("seq");
            int nextBeginTime = ((DynamicObject)list.get(nextIndex)).getInt("begintime");
            if (endTime < nextBeginTime) continue;
            errorMsg.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7ed3\u675f\u65e5\u671f\u548c\u7b2c%2$s\u884c\u5206\u5f55\u7684\u5f00\u59cb\u65e5\u671f\u6709\u91cd\u53e0\u3002", (String)"QTInConversionHelper_2", (String)"wtc-wtp-business", (Object[])new Object[0]), seq, nextSeq));
        }
        return errorMsg;
    }

    public String entryEmptyValidator(DynamicObject dynamicObject) {
        String msg = "";
        boolean isMonthOrPeriod = ConverMethodEnum.CONVER_MONTH.getCode().equals(dynamicObject.getString("convermethod")) || ConverMethodEnum.CONVER_PERIOD.getCode().equals(dynamicObject.getString("convermethod"));
        boolean isPart = "B".equals(dynamicObject.getString("convertype"));
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("qtinconverentry");
        if (isMonthOrPeriod && isPart && CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            msg = ResManager.loadKDString((String)"\u5206\u5f55\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QTInConversionHelper_4", (String)"wtc-wtp-business", (Object[])new Object[0]);
        }
        return msg;
    }
}

